/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import lotr.client.gui.LOTRGuiSlider;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.tileentity.LOTRTileEntityMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class LOTRGuiMobSpawner
extends GuiScreen {
    private static ResourceLocation guiTexture = new ResourceLocation("lotr:gui/mob_spawner.png");
    private World worldObj;
    private int posX;
    private int posY;
    private int posZ;
    private LOTRTileEntityMobSpawner tileEntity;
    private int xSize = 256;
    private int ySize = 256;
    private int guiLeft;
    private int guiTop;
    private ArrayList pageControls = new ArrayList();
    private ArrayList spawnerControls = new ArrayList();
    private ArrayList mobControls = new ArrayList();
    private int page;
    private String[] pageNames = new String[]{"Spawner Properties", "Entity Properties"};
    private int active;
    private int minSpawnDelay;
    private int maxSpawnDelay;
    private int nearbyMobLimit;
    private int nearbyMobCheckRange;
    private int requiredPlayerRange;
    private int maxSpawnCount;
    private int maxSpawnRange;
    private int maxSpawnRangeVertical;
    private boolean spawnsPersistentNPCs;
    private int maxHealth;
    private int navigatorRange;
    private float moveSpeed;
    private int attackDamage;
    private boolean needsUpdate;
    private Class mobClass;
    private String mobName;

    public LOTRGuiMobSpawner(World world, int i, int j, int k) {
        this.worldObj = world;
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        this.tileEntity = (LOTRTileEntityMobSpawner)this.worldObj.func_147438_o(this.posX, this.posY, this.posZ);
        this.syncTileEntityDataToGui();
    }

    private void syncTileEntityDataToGui() {
        this.active = this.tileEntity.active;
        this.spawnsPersistentNPCs = this.tileEntity.spawnsPersistentNPCs;
        this.minSpawnDelay = this.tileEntity.minSpawnDelay;
        this.maxSpawnDelay = this.tileEntity.maxSpawnDelay;
        this.nearbyMobLimit = this.tileEntity.nearbyMobLimit;
        this.nearbyMobCheckRange = this.tileEntity.nearbyMobCheckRange;
        this.requiredPlayerRange = this.tileEntity.requiredPlayerRange;
        this.maxSpawnCount = this.tileEntity.maxSpawnCount;
        this.maxSpawnRange = this.tileEntity.maxSpawnRange;
        this.maxSpawnRangeVertical = this.tileEntity.maxSpawnRangeVertical;
        this.maxHealth = this.tileEntity.maxHealth + 256 & 0xFF;
        this.navigatorRange = this.tileEntity.navigatorRange;
        this.moveSpeed = this.tileEntity.moveSpeed;
        this.attackDamage = this.tileEntity.attackDamage;
        this.mobClass = LOTREntities.getClassFromString(this.tileEntity.getMobID());
        this.mobName = this.tileEntity.getMobID();
    }

    private void sendGuiDataToClientTileEntity() {
        this.tileEntity.active = this.active;
        this.tileEntity.spawnsPersistentNPCs = this.spawnsPersistentNPCs;
        this.tileEntity.minSpawnDelay = this.minSpawnDelay;
        this.tileEntity.maxSpawnDelay = this.maxSpawnDelay;
        this.tileEntity.nearbyMobLimit = this.nearbyMobLimit;
        this.tileEntity.nearbyMobCheckRange = this.nearbyMobCheckRange;
        this.tileEntity.requiredPlayerRange = this.requiredPlayerRange;
        this.tileEntity.maxSpawnCount = this.maxSpawnCount;
        this.tileEntity.maxSpawnRange = this.maxSpawnRange;
        this.tileEntity.maxSpawnRangeVertical = this.maxSpawnRangeVertical;
        this.tileEntity.maxHealth = this.maxHealth;
        this.tileEntity.navigatorRange = this.navigatorRange;
        this.tileEntity.moveSpeed = this.moveSpeed;
        this.tileEntity.attackDamage = this.attackDamage;
    }

    private void sendGuiDataToServerTileEntity() {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
        data.writeByte((int)((byte)this.active));
        data.writeByte(this.spawnsPersistentNPCs ? 1 : 0);
        data.writeInt(this.minSpawnDelay);
        data.writeInt(this.maxSpawnDelay);
        data.writeByte((int)((byte)this.nearbyMobLimit));
        data.writeByte((int)((byte)this.nearbyMobCheckRange));
        data.writeByte((int)((byte)this.requiredPlayerRange));
        data.writeByte((int)((byte)this.maxSpawnCount));
        data.writeByte((int)((byte)this.maxSpawnRange));
        data.writeByte((int)((byte)this.maxSpawnRangeVertical));
        data.writeByte((int)((byte)this.maxHealth));
        data.writeByte((int)((byte)this.navigatorRange));
        data.writeFloat(this.moveSpeed);
        data.writeByte((int)((byte)this.attackDamage));
        C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.mobSpawner", data);
        this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
        this.needsUpdate = false;
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.pageControls.add(new GuiButton(1, this.guiLeft + this.xSize / 2 + 2, this.guiTop + 52, 110, 20, this.pageNames[this.page]));
        this.spawnerControls.add(new GuiButton(0, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 52, 110, 20, this.active == 2 ? "Redstone Activated" : (this.active == 1 ? "Active" : "Inactive")));
        this.spawnerControls.add(new LOTRGuiSlider(1, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 76, 224, 20, "Min Spawn Delay: " + this.ticksToSeconds(this.minSpawnDelay), (float)this.minSpawnDelay / 1200.0f));
        this.spawnerControls.add(new LOTRGuiSlider(2, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 100, 224, 20, "Max Spawn Delay: " + this.ticksToSeconds(this.maxSpawnDelay), (float)this.maxSpawnDelay / 1200.0f));
        this.spawnerControls.add(new LOTRGuiSlider(3, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 124, 224, 20, "Nearby Mob Limit: " + this.nearbyMobLimit, (float)(this.nearbyMobLimit - 1) / 31.0f));
        this.spawnerControls.add(new LOTRGuiSlider(4, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 148, 224, 20, "Nearby Mob Check Range: " + this.nearbyMobCheckRange, (float)(this.nearbyMobCheckRange - 1) / 63.0f));
        this.spawnerControls.add(new LOTRGuiSlider(5, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 172, 224, 20, "Required Player Range: " + this.requiredPlayerRange, (float)(this.requiredPlayerRange - 1) / 99.0f));
        this.spawnerControls.add(new LOTRGuiSlider(6, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 196, 224, 20, "Max Spawn Count: " + this.maxSpawnCount, (float)(this.maxSpawnCount - 1) / 15.0f));
        this.spawnerControls.add(new LOTRGuiSlider(7, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 220, 110, 20, "Horizontal Range: " + this.maxSpawnRange, (float)(this.maxSpawnRange - 1) / 63.0f));
        this.spawnerControls.add(new LOTRGuiSlider(8, this.guiLeft + this.xSize / 2 + 2, this.guiTop + 220, 110, 20, "Vertical Range: " + this.maxSpawnRangeVertical, (float)(this.maxSpawnRangeVertical - 1) / 15.0f));
        this.mobControls.add(new GuiButton(0, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 52, 110, 20, this.spawnsPersistentNPCs ? "Persistent NPCs" : "Normal NPCs"));
        ((GuiButton)this.mobControls.get((int)0)).field_146124_l = LOTREntityNPC.class.isAssignableFrom(this.mobClass);
        this.mobControls.add(new LOTRGuiSlider(1, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 76, 224, 20, "Max Health: " + this.maxHealth, (float)(this.maxHealth - 1) / 199.0f));
        this.mobControls.add(new LOTRGuiSlider(2, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 100, 224, 20, "Navigator Range: " + this.navigatorRange, (float)(this.navigatorRange - 1) / 99.0f));
        this.mobControls.add(new LOTRGuiSlider(3, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 124, 224, 20, "Movement Speed: " + this.trim(this.moveSpeed), (this.moveSpeed - 0.01f) / 0.99f));
        this.mobControls.add(new LOTRGuiSlider(4, this.guiLeft + this.xSize / 2 - 112, this.guiTop + 148, 224, 20, "Attack Damage: " + this.attackDamage, (float)(this.attackDamage - 1) / 19.0f));
    }

    public void func_146280_a(Minecraft mc, int i, int j) {
        this.pageControls.clear();
        this.spawnerControls.clear();
        this.mobControls.clear();
        super.func_146280_a(mc, i, j);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.getClass() == GuiButton.class) {
            if (button.field_146127_k == 0) {
                if (this.page == 0) {
                    ++this.active;
                    if (this.active > 2) {
                        this.active = 0;
                    }
                    switch (this.active) {
                        case 0: {
                            button.field_146126_j = "Inactive";
                            break;
                        }
                        case 1: {
                            button.field_146126_j = "Active";
                            break;
                        }
                        case 2: {
                            button.field_146126_j = "Redstone Activated";
                        }
                    }
                } else if (this.page == 1) {
                    this.spawnsPersistentNPCs = !this.spawnsPersistentNPCs;
                    button.field_146126_j = this.spawnsPersistentNPCs ? "Persistent NPCs" : "Normal NPCs";
                }
                this.needsUpdate = true;
            }
            if (button.field_146127_k == 1) {
                this.page = 1 - this.page;
                button.field_146126_j = this.pageNames[this.page];
            }
        }
    }

    public void func_73863_a(int i, int j, float f) {
        block4: {
            int k;
            block3: {
                this.func_146276_q_();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
                this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
                this.field_146289_q.func_78276_b("Mob Spawner", this.guiLeft + 127 - this.field_146289_q.func_78256_a("Mob Spawner") / 2, this.guiTop + 11, 0x373737);
                this.field_146289_q.func_78276_b(this.mobName, this.guiLeft + 127 - this.field_146289_q.func_78256_a(this.mobName) / 2, this.guiTop + 26, 0x373737);
                super.func_73863_a(i, j, f);
                for (k = 0; k < this.pageControls.size(); ++k) {
                    ((GuiButton)this.pageControls.get(k)).func_146112_a(this.field_146297_k, i, j);
                }
                if (this.page != 0) break block3;
                for (k = 0; k < this.spawnerControls.size(); ++k) {
                    ((GuiButton)this.spawnerControls.get(k)).func_146112_a(this.field_146297_k, i, j);
                }
                break block4;
            }
            if (this.page != 1) break block4;
            for (k = 0; k < this.mobControls.size(); ++k) {
                ((GuiButton)this.mobControls.get(k)).func_146112_a(this.field_146297_k, i, j);
            }
        }
    }

    public void func_73876_c() {
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L || this.tileEntity == null || this.worldObj.func_147439_a(this.posX, this.posY, this.posZ) != LOTRMod.mobSpawner || this.field_146297_k.field_71439_g.func_70092_e((double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5) > 64.0) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.page == 0) {
            LOTRGuiSlider slider_minSpawnDelay = (LOTRGuiSlider)((Object)this.spawnerControls.get(1));
            if (slider_minSpawnDelay.dragging) {
                this.minSpawnDelay = Math.round(slider_minSpawnDelay.sliderValue * 1200.0f);
                slider_minSpawnDelay.field_146126_j = "Min Spawn Delay: " + this.ticksToSeconds(this.minSpawnDelay);
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_maxSpawnDelay = (LOTRGuiSlider)((Object)this.spawnerControls.get(2));
            if (slider_maxSpawnDelay.dragging) {
                this.maxSpawnDelay = Math.round(slider_maxSpawnDelay.sliderValue * 1200.0f);
                slider_maxSpawnDelay.field_146126_j = "Max Spawn Delay: " + this.ticksToSeconds(this.maxSpawnDelay);
                this.needsUpdate = true;
            }
            if (this.minSpawnDelay > this.maxSpawnDelay) {
                if (slider_minSpawnDelay.dragging) {
                    slider_maxSpawnDelay.sliderValue = slider_minSpawnDelay.sliderValue;
                    this.maxSpawnDelay = this.minSpawnDelay;
                    slider_maxSpawnDelay.field_146126_j = "Max Spawn Delay: " + this.ticksToSeconds(this.maxSpawnDelay);
                    this.needsUpdate = true;
                } else if (slider_maxSpawnDelay.dragging) {
                    slider_minSpawnDelay.sliderValue = slider_maxSpawnDelay.sliderValue;
                    this.minSpawnDelay = this.maxSpawnDelay;
                    slider_minSpawnDelay.field_146126_j = "Min Spawn Delay: " + this.ticksToSeconds(this.minSpawnDelay);
                    this.needsUpdate = true;
                }
            }
            LOTRGuiSlider slider_mobLimit = (LOTRGuiSlider)((Object)this.spawnerControls.get(3));
            if (slider_mobLimit.dragging) {
                this.nearbyMobLimit = Math.round(slider_mobLimit.sliderValue * 31.0f) + 1;
                slider_mobLimit.field_146126_j = "Nearby Mob Limit: " + this.nearbyMobLimit;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_mobCheckRange = (LOTRGuiSlider)((Object)this.spawnerControls.get(4));
            if (slider_mobCheckRange.dragging) {
                this.nearbyMobCheckRange = Math.round(slider_mobCheckRange.sliderValue * 63.0f) + 1;
                slider_mobCheckRange.field_146126_j = "Nearby Mob Check Range: " + this.nearbyMobCheckRange;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_playerRange = (LOTRGuiSlider)((Object)this.spawnerControls.get(5));
            if (slider_playerRange.dragging) {
                this.requiredPlayerRange = Math.round(slider_playerRange.sliderValue * 99.0f) + 1;
                slider_playerRange.field_146126_j = "Required Player Range: " + this.requiredPlayerRange;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_maxSpawnCount = (LOTRGuiSlider)((Object)this.spawnerControls.get(6));
            if (slider_maxSpawnCount.dragging) {
                this.maxSpawnCount = Math.round(slider_maxSpawnCount.sliderValue * 15.0f) + 1;
                slider_maxSpawnCount.field_146126_j = "Max Spawn Count: " + this.maxSpawnCount;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_maxSpawnRange = (LOTRGuiSlider)((Object)this.spawnerControls.get(7));
            if (slider_maxSpawnRange.dragging) {
                this.maxSpawnRange = Math.round(slider_maxSpawnRange.sliderValue * 63.0f) + 1;
                slider_maxSpawnRange.field_146126_j = "Horizontal Range: " + this.maxSpawnRange;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_maxSpawnRangeVertical = (LOTRGuiSlider)((Object)this.spawnerControls.get(8));
            if (slider_maxSpawnRangeVertical.dragging) {
                this.maxSpawnRangeVertical = Math.round(slider_maxSpawnRangeVertical.sliderValue * 15.0f) + 1;
                slider_maxSpawnRangeVertical.field_146126_j = "Vertical Range: " + this.maxSpawnRangeVertical;
                this.needsUpdate = true;
            }
        } else if (this.page == 1) {
            LOTRGuiSlider slider_maxHealth = (LOTRGuiSlider)((Object)this.mobControls.get(1));
            if (slider_maxHealth.dragging) {
                this.maxHealth = Math.round(slider_maxHealth.sliderValue * 199.0f) + 1;
                slider_maxHealth.field_146126_j = "Max Health: " + this.maxHealth;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_navigatorRange = (LOTRGuiSlider)((Object)this.mobControls.get(2));
            if (slider_navigatorRange.dragging) {
                this.navigatorRange = Math.round(slider_navigatorRange.sliderValue * 99.0f) + 1;
                slider_navigatorRange.field_146126_j = "Navigator Range: " + this.navigatorRange;
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_moveSpeed = (LOTRGuiSlider)((Object)this.mobControls.get(3));
            if (slider_moveSpeed.dragging) {
                this.moveSpeed = slider_moveSpeed.sliderValue * 0.99f + 0.01f;
                slider_moveSpeed.field_146126_j = "Movement Speed: " + this.trim(this.moveSpeed);
                this.needsUpdate = true;
            }
            LOTRGuiSlider slider_attackDamage = (LOTRGuiSlider)((Object)this.mobControls.get(4));
            if (slider_attackDamage.dragging) {
                this.attackDamage = Math.round(slider_attackDamage.sliderValue * 19.0f) + 1;
                slider_attackDamage.field_146126_j = "Attack Damage: " + this.attackDamage;
                this.needsUpdate = true;
            }
        }
        if (this.needsUpdate) {
            this.sendGuiDataToClientTileEntity();
            this.sendGuiDataToServerTileEntity();
        }
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        this.field_146292_n.addAll(this.pageControls);
        if (this.page == 0) {
            this.field_146292_n.addAll(this.spawnerControls);
        } else if (this.page == 1) {
            this.field_146292_n.addAll(this.mobControls);
        }
        super.func_73864_a(i, j, k);
        this.field_146292_n.clear();
    }

    public boolean func_73868_f() {
        return false;
    }

    private String trim(float f) {
        return String.format("%.2f", f);
    }

    private String ticksToSeconds(int ticks) {
        return this.trim((float)ticks / 20.0f) + "s";
    }
}

