/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.Unpooled;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRCommonProxy;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRReflection;
import lotr.common.LOTRWaypoint;
import lotr.common.block.LOTRBlockFlowerPot;
import lotr.common.block.LOTRBlockSaplingBase;
import lotr.common.entity.LOTREntityRegistry;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.animal.LOTREntityButterfly;
import lotr.common.entity.animal.LOTREntityZebra;
import lotr.common.entity.item.LOTREntityTraderRespawn;
import lotr.common.entity.item.LOTREntityWargskinRug;
import lotr.common.entity.npc.LOTREntityEnt;
import lotr.common.entity.npc.LOTREntityHobbitShirriff;
import lotr.common.entity.npc.LOTREntityHuornBase;
import lotr.common.entity.npc.LOTREntityMarshWraith;
import lotr.common.entity.npc.LOTREntityMirkwoodSpider;
import lotr.common.entity.npc.LOTREntityMordorSpider;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOlogHai;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntityRanger;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTREntityTree;
import lotr.common.entity.npc.LOTREntityWargBombardier;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.entity.projectile.LOTREntityCrossbowBolt;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.entity.projectile.LOTREntityThrowingAxe;
import lotr.common.inventory.LOTRContainerAngmarTable;
import lotr.common.inventory.LOTRContainerBlueDwarvenTable;
import lotr.common.inventory.LOTRContainerDunlendingTable;
import lotr.common.inventory.LOTRContainerDwarvenTable;
import lotr.common.inventory.LOTRContainerElvenTable;
import lotr.common.inventory.LOTRContainerGondorianTable;
import lotr.common.inventory.LOTRContainerHighElvenTable;
import lotr.common.inventory.LOTRContainerMorgulTable;
import lotr.common.inventory.LOTRContainerNearHaradTable;
import lotr.common.inventory.LOTRContainerRohirricTable;
import lotr.common.inventory.LOTRContainerUrukTable;
import lotr.common.inventory.LOTRContainerWoodElvenTable;
import lotr.common.item.LOTRItemPouch;
import lotr.common.world.biome.LOTRBiomeGenDeadMarshes;
import lotr.common.world.biome.LOTRBiomeGenFangorn;
import lotr.common.world.biome.LOTRBiomeGenForodwaith;
import lotr.common.world.biome.LOTRBiomeGenMirkwood;
import lotr.common.world.biome.LOTRBiomeGenNearHarad;
import lotr.common.world.biome.LOTRBiomeGenShire;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class LOTREventHandler
implements IFuelHandler {
    public LOTREventHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer entityplayer = event.player;
        ItemStack itemstack = event.crafting;
        IInventory craftingInventory = event.craftMatrix;
        if (!entityplayer.field_70170_p.field_72995_K) {
            if (itemstack.func_77973_b() == LOTRMod.pouch && craftingInventory instanceof InventoryCrafting) {
                ItemStack[] stackList = LOTRReflection.getStackList((InventoryCrafting)craftingInventory);
                for (int i = 0; i < stackList.length; ++i) {
                    stackList[i] = null;
                }
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerElvenTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useElvenTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerUrukTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useUrukTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerRohirricTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useRohirricTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerGondorianTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useGondorianTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerWoodElvenTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useWoodElvenTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerDwarvenTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useDwarvenTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerMorgulTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useMorgulTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerDunlendingTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useDunlendingTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerAngmarTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useAngmarTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerNearHaradTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useNearHaradTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerHighElvenTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useHighElvenTable);
            }
            if (entityplayer.field_71070_bA instanceof LOTRContainerBlueDwarvenTable) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useBlueDwarvenTable);
            }
            if (itemstack.func_77973_b() == Items.field_151141_av) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftSaddle);
            }
            if (itemstack.func_77973_b() == LOTRMod.bronze) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftBronze);
            }
            if (itemstack.func_77973_b() == LOTRMod.appleCrumbleItem) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftAppleCrumble);
            }
            if (itemstack.func_77973_b() == LOTRMod.rabbitStew) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftRabbitStew);
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.brick) && itemstack.func_77960_j() == 10) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftMithrilDwarvenBrick);
            }
            if (itemstack.func_77973_b() == LOTRMod.ancientItem) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftAncientItem);
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.orcBomb)) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.craftOrcBomb);
            }
        }
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        EntityPlayer entityplayer = event.player;
        ItemStack itemstack = event.smelting;
        if (!entityplayer.field_70170_p.field_72995_K) {
            if (itemstack.func_77973_b() == LOTRMod.blueDwarfSteel) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.smeltBlueDwarfSteel);
            }
            if (itemstack.func_77973_b() == LOTRMod.dwarfSteel) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.smeltDwarfSteel);
            }
            if (itemstack.func_77973_b() == LOTRMod.urukSteel) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.smeltUrukSteel);
            }
            if (itemstack.func_77973_b() == LOTRMod.orcSteel) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.smeltOrcSteel);
            }
        }
    }

    public int getBurnTime(ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemstack.func_77973_b()).field_150939_a instanceof LOTRBlockSaplingBase) {
            return 100;
        }
        if (itemstack.func_77973_b() == LOTRMod.nauriteGem) {
            return 600;
        }
        if (itemstack.func_77973_b() == LOTRMod.mallornStick) {
            return 100;
        }
        if (itemstack.func_77973_b() instanceof ItemTool && ((ItemTool)itemstack.func_77973_b()).func_77861_e().equals("LOTR_MALLORN")) {
            return 200;
        }
        if (itemstack.func_77973_b() instanceof ItemSword && ((ItemSword)itemstack.func_77973_b()).func_150932_j().equals("LOTR_MALLORN")) {
            return 200;
        }
        if (itemstack.func_77973_b() instanceof ItemHoe && ((ItemHoe)itemstack.func_77973_b()).func_77842_f().equals("LOTR_MALLORN")) {
            return 200;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entityplayer = event.player;
        if (!entityplayer.field_70170_p.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityplayer;
            Packet loginPacket = LOTRLevelData.getLoginPacket(entityplayer);
            entityplayermp.field_71135_a.func_147359_a(loginPacket);
            LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
            LOTRLevelData.sendAllAlignmentsInWorldToPlayer(entityplayer, entityplayer.field_70170_p);
            Packet achievementPacket = LOTRLevelData.getLoginAchievementsPacket(entityplayer);
            if (achievementPacket != null) {
                entityplayermp.field_71135_a.func_147359_a(achievementPacket);
            }
            LOTRLevelData.selectDefaultCapeForPlayer(entityplayer);
            LOTRLevelData.sendCapeToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
            LOTRLevelData.sendAllCapesInWorldToPlayer(entityplayer, entityplayer.field_70170_p);
            Packet waypointsPacket = LOTRWaypoint.getLoginWaypointsPacket(entityplayer);
            if (waypointsPacket != null) {
                entityplayermp.field_71135_a.func_147359_a(waypointsPacket);
            }
            LOTRWaypoint.Custom.sendLoginCustomWaypointsPackets((EntityPlayer)entityplayermp);
            LOTRLevelData.sendTakenAlignmentRewardsToPlayer((EntityPlayer)entityplayermp);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer entityplayer = event.player;
        if (!entityplayer.field_70170_p.field_72995_K) {
            LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
            LOTRLevelData.sendAllAlignmentsInWorldToPlayer(entityplayer, entityplayer.field_70170_p);
            LOTRLevelData.sendCapeToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
            LOTRLevelData.sendAllCapesInWorldToPlayer(entityplayer, entityplayer.field_70170_p);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer entityplayer = event.player;
        World world = entityplayer.field_70170_p;
        if (!world.field_72995_K && entityplayer instanceof EntityPlayerMP && world instanceof WorldServer) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityplayer;
            WorldServer worldserver = (WorldServer)world;
            if (entityplayermp.field_71093_bK == LOTRMod.idDimension && worldserver.func_82736_K().func_82766_b("enableMiddleEarthRespawning")) {
                boolean hasBed;
                ChunkCoordinates bedLocation = entityplayermp.getBedLocation(entityplayermp.field_71093_bK);
                boolean bl = hasBed = bedLocation != null;
                if (hasBed) {
                    hasBed = EntityPlayerMP.func_71056_a((World)worldserver, (ChunkCoordinates)bedLocation, (boolean)entityplayermp.isSpawnForced(entityplayermp.field_71093_bK)) != null;
                }
                Object obj = LOTRLevelData.playerDeathPoints.get(entityplayermp.func_110124_au());
                if (!hasBed && obj instanceof ChunkCoordinates) {
                    boolean flag;
                    ChunkCoordinates deathPoint = (ChunkCoordinates)obj;
                    float respawnThreshold = 4000000.0f;
                    boolean bl2 = flag = deathPoint.func_82371_e(worldserver.func_72861_E()) > respawnThreshold;
                    if (flag) {
                        double randomDistance = 500.0 + worldserver.field_73012_v.nextDouble() * 1500.0;
                        float angle = worldserver.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                        int i = deathPoint.field_71574_a + (int)(randomDistance * (double)MathHelper.func_76126_a((float)angle));
                        int k = deathPoint.field_71573_c + (int)(randomDistance * (double)MathHelper.func_76134_b((float)angle));
                        worldserver.field_73059_b.func_73158_c(i >> 4, k >> 4);
                        int j = worldserver.func_72976_f(i, k);
                        entityplayermp.func_70012_b((double)i + 0.5, (double)j, (double)k + 0.5, entityplayermp.field_70177_z, entityplayermp.field_70125_A);
                        entityplayermp.field_71135_a.func_147364_a((double)i + 0.5, (double)j, (double)k + 0.5, entityplayermp.field_70177_z, entityplayermp.field_70125_A);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityCreature entitycreature;
        String s;
        Object obj;
        Entity entity = event.entity;
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity instanceof EntityCreature && (obj = LOTREntityRegistry.registeredNPCs.get(s = EntityList.func_75621_b((Entity)(entitycreature = (EntityCreature)entity)))) != null) {
            LOTREntityRegistry.RegistryInfo info = (LOTREntityRegistry.RegistryInfo)obj;
            if (info.shouldTargetEnemies) {
                LOTREntityNPC.addTargetTasks(entitycreature, 100, LOTREntityAINearestAttackableTargetBasic.class);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttackedByPlayer(AttackEntityEvent event) {
        LOTREntityTraderRespawn traderRespawn;
        Entity entity = event.target;
        World world = entity.field_70170_p;
        EntityPlayer entityplayer = event.entityPlayer;
        if (!world.field_72995_K && entity instanceof LOTREntityWargskinRug) {
            ((LOTREntityWargskinRug)entity).dropRugAsItem(entityplayer.field_71075_bZ.field_75098_d);
        }
        if (!world.field_72995_K && entity instanceof LOTREntityTraderRespawn && entityplayer.field_71075_bZ.field_75098_d && (traderRespawn = (LOTREntityTraderRespawn)entity).getScale() >= 40) {
            traderRespawn.onBreak();
        }
    }

    @SubscribeEvent
    public void onUseBonemeal(BonemealEvent event) {
        World world = event.world;
        int i = event.x;
        int j = event.y;
        int k = event.z;
        if (!world.field_72995_K && event.block instanceof LOTRBlockSaplingBase) {
            LOTRBlockSaplingBase blockSapling = (LOTRBlockSaplingBase)event.block;
            if ((double)world.field_73012_v.nextFloat() < 0.45) {
                blockSapling.incrementGrowth(world, i, j, k, world.field_73012_v);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent event) {
        EntityPlayer entityplayer = event.entityPlayer;
        World world = entityplayer.field_70170_p;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        int i = event.x;
        int j = event.y;
        int k = event.z;
        int side = event.face;
        if (!world.func_72962_a(entityplayer, i, j, k)) {
            return;
        }
        if (!entityplayer.func_82247_a(i, j, k, side, itemstack)) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            if (world.func_147439_a(i, j, k) == Blocks.field_150457_bL && world.func_72805_g(i, j, k) == 0 && itemstack != null && LOTRBlockFlowerPot.canAcceptPlant(itemstack)) {
                LOTRMod.proxy.placeFlowerInPot(world, i, j, k, side, itemstack);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                event.setCanceled(true);
                return;
            }
            if (itemstack != null && itemstack.func_77973_b() == LOTRMod.mug && world.func_147439_a(i, j, k) == Blocks.field_150383_bp && world.func_72805_g(i, j, k) > 0) {
                LOTRMod.proxy.fillMugFromCauldron(world, i, j, k, side, itemstack);
                if (--itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, new ItemStack(LOTRMod.mugWater));
                } else if (!entityplayer.field_71071_by.func_70441_a(new ItemStack(LOTRMod.mugWater))) {
                    entityplayer.func_71019_a(new ItemStack(LOTRMod.mugWater), false);
                }
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        List trees;
        EntityPlayer entityplayer = event.getPlayer();
        Block block = event.block;
        World world = event.world;
        int i = event.x;
        int j = event.y;
        int k = event.z;
        if (!world.field_72995_K && entityplayer != null && !entityplayer.field_71075_bZ.field_75098_d && block.isWood((IBlockAccess)world, i, j, k) && !(trees = world.func_72872_a(LOTREntityTree.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)).func_72314_b(16.0, 16.0, 16.0))).isEmpty()) {
            boolean sentMessage = false;
            boolean penalty = false;
            for (int l = 0; l < trees.size(); ++l) {
                LOTREntityTree tree = (LOTREntityTree)((Object)trees.get(l));
                if (tree.hiredNPCInfo.isActive && tree.hiredNPCInfo.getHiringPlayer() == entityplayer) continue;
                tree.func_70624_b((EntityLivingBase)entityplayer);
                if (tree instanceof LOTREntityEnt && !sentMessage) {
                    entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)tree, "ent_defendTrees", entityplayer));
                    tree.markNPCSpoken();
                    sentMessage = true;
                }
                if (!(world.func_72807_a(i, k) instanceof LOTRBiomeGenFangorn) || penalty) continue;
                LOTRLevelData.addAlignment(entityplayer, LOTRAlignmentValues.FANGORN_TREE_PENALTY, LOTRFaction.FANGORN, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                penalty = true;
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer entityplayer = event.entityPlayer;
        ItemStack itemstack = event.item.func_92059_d();
        if (!entityplayer.field_70170_p.field_72995_K) {
            if (itemstack.field_77994_a > 0) {
                for (int i = 0; i < entityplayer.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack itemInSlot = entityplayer.field_71071_by.func_70301_a(i);
                    if (itemInSlot == null || itemInSlot.func_77973_b() != LOTRMod.pouch) continue;
                    LOTRItemPouch.tryAddItemToPouch(itemInSlot, itemstack);
                    if (itemstack.field_77994_a <= 0) break;
                }
                if (itemstack.field_77994_a <= 0) {
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.athelas)) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.findAthelas);
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.clover) && itemstack.func_77960_j() == 1) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.findFourLeafClover);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        BiomeGenBase biome;
        int k;
        int i;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobSpawning") && entity.func_70089_S() && entity.func_70090_H() && entity.field_70154_o == null) {
            boolean flag = true;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                flag = false;
            }
            if (entity instanceof EntityWaterMob || entity instanceof LOTREntityMarshWraith) {
                flag = false;
            }
            if (flag) {
                i = MathHelper.func_76128_c((double)entity.field_70165_t);
                k = MathHelper.func_76128_c((double)entity.field_70161_v);
                int j = world.func_72825_h(i, k);
                while (world.func_147439_a(i, j + 1, k).func_149688_o().func_76224_d() || world.func_147439_a(i, j + 1, k).func_149688_o().func_76220_a()) {
                    ++j;
                }
                if ((double)j - entity.field_70121_D.field_72338_b < 2.0 && world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h && world.func_72807_a(i, k) instanceof LOTRBiomeGenDeadMarshes) {
                    List nearbyWraiths = world.func_72872_a(LOTREntityMarshWraith.class, entity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
                    boolean anyNearbyWraiths = false;
                    for (int l = 0; l < nearbyWraiths.size(); ++l) {
                        LOTREntityMarshWraith wraith = (LOTREntityMarshWraith)((Object)nearbyWraiths.get(l));
                        if (wraith.func_70638_az() != entity || wraith.getDeathFadeTime() != 0) continue;
                        anyNearbyWraiths = true;
                        break;
                    }
                    if (!anyNearbyWraiths) {
                        LOTREntityMarshWraith wraith = new LOTREntityMarshWraith(world);
                        double d = (double)i + 0.5 - 3.0 + (double)world.field_73012_v.nextInt(7);
                        double d2 = (double)k + 0.5 - 3.0 + (double)world.field_73012_v.nextInt(7);
                        double d1 = world.func_72825_h(MathHelper.func_76128_c((double)d), MathHelper.func_76128_c((double)d2));
                        wraith.func_70012_b(d, d1, d2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)wraith);
                        wraith.func_70624_b(entity);
                        wraith.attackTargetUUID = entity.getPersistentID();
                        world.func_72956_a((Entity)wraith, "lotr:wraith.spawn", 1.0f, 0.7f + world.field_73012_v.nextFloat() * 0.6f);
                    }
                }
            }
        }
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doMobSpawning") && entity.func_70089_S()) {
            int i2;
            float f = 0.0f;
            int shirriffs = 0;
            if (LOTRMod.getNPCFaction((Entity)entity).isEnemy(LOTRFaction.HOBBIT)) {
                float health = entity.func_110138_aP() + (float)entity.func_70658_aO();
                f = health * 2.5f;
                i2 = (int)(health / 15.0f);
                shirriffs = 2 + world.field_73012_v.nextInt(i2 + 1);
            } else if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                int alignment = LOTRLevelData.getAlignment(entityplayer, LOTRFaction.HOBBIT);
                if (!entityplayer.field_71075_bZ.field_75098_d && alignment < 0) {
                    f = (float)alignment * -1.0f;
                    int i3 = (int)(f / 50.0f);
                    shirriffs = 2 + world.field_73012_v.nextInt(i3 + 1);
                }
            }
            if (f > 0.0f) {
                List nearbyShirriffs;
                if (f > 500.0f) {
                    f = 500.0f;
                }
                int chance = (int)(1000000.0f / f);
                if (shirriffs > 5) {
                    shirriffs = 5;
                }
                i2 = MathHelper.func_76128_c((double)entity.field_70165_t);
                int k2 = MathHelper.func_76128_c((double)entity.field_70161_v);
                int j = world.func_72825_h(i2, k2);
                if (world.field_73012_v.nextInt(chance) == 0 && world.func_72807_a(i2, k2) instanceof LOTRBiomeGenShire && (nearbyShirriffs = world.func_72872_a(LOTREntityHobbitShirriff.class, entity.field_70121_D.func_72314_b(12.0, 6.0, 12.0))).isEmpty()) {
                    boolean sentMessage = false;
                    boolean playedHorn = false;
                    block2: for (int l = 0; l < shirriffs; ++l) {
                        LOTREntityHobbitShirriff shirriff = new LOTREntityHobbitShirriff(world);
                        for (int l1 = 0; l1 < 16; ++l1) {
                            int k1;
                            int j1;
                            int i1 = i2 - 8 + world.field_73012_v.nextInt(17);
                            if (!world.func_147439_a(i1, (j1 = world.func_72825_h(i1, k1 = k2 - 8 + world.field_73012_v.nextInt(17))) - 1, k1).isSideSolid((IBlockAccess)world, i1, j1 - 1, k1, ForgeDirection.UP) || world.func_147439_a(i1, j1, k1).func_149721_r() || world.func_147439_a(i1, j1 + 1, k1).func_149721_r()) continue;
                            shirriff.func_70012_b((double)i1 + 0.5, j1, (double)k1 + 0.5, 0.0f, 0.0f);
                            if (!shirriff.func_70601_bi()) continue;
                            shirriff.func_110161_a(null);
                            world.func_72838_d((Entity)shirriff);
                            shirriff.func_70624_b(entity);
                            if (!sentMessage && entity instanceof EntityPlayer) {
                                EntityPlayer entityplayer = (EntityPlayer)entity;
                                entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)shirriff, "hobbitShirriff_hostile", entityplayer));
                                shirriff.markNPCSpoken();
                                sentMessage = true;
                            }
                            if (playedHorn) continue block2;
                            world.func_72956_a((Entity)shirriff, "lotr:item.horn", 2.0f, 2.0f);
                            playedHorn = true;
                            continue block2;
                        }
                    }
                }
            }
        }
        if (!world.field_72995_K && entity.func_70089_S() && entity.func_70090_H() && entity.field_70154_o == null && world.func_72820_D() % 10L == 0L) {
            BiomeGenBase biome2;
            boolean flag = true;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                flag = false;
            }
            if (entity instanceof LOTREntityMirkwoodSpider) {
                flag = false;
            }
            if (flag && (biome2 = world.func_72807_a(i = MathHelper.func_76128_c((double)entity.field_70165_t), k = MathHelper.func_76128_c((double)entity.field_70161_v))) instanceof LOTRBiomeGenMirkwood && ((LOTRBiomeGenMirkwood)biome2).corrupted) {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 600, 1));
                entity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600, 1));
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 600));
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 600));
            }
        }
        if (!world.field_72995_K && entity.func_70089_S() && world.func_72820_D() % 10L == 0L) {
            boolean wearingAllWoodElvenScout = true;
            for (i = 0; i < 4; ++i) {
                ItemStack armour = entity.func_71124_b(i + 1);
                if (armour != null && armour.func_77973_b() instanceof ItemArmor && ((ItemArmor)armour.func_77973_b()).func_82812_d() == LOTRMod.armorWoodElvenScout) continue;
                wearingAllWoodElvenScout = false;
                break;
            }
            if (wearingAllWoodElvenScout) {
                entity.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 100, 1));
            }
        }
        if (!world.field_72995_K && entity.func_70089_S() && world.func_72820_D() % 20L == 0L) {
            boolean flag = true;
            if (entity instanceof LOTREntityNPC) {
                flag = ((LOTREntityNPC)entity).isImmuneToFrost;
            }
            if (entity instanceof EntityPlayer) {
                boolean bl = flag = !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            }
            if (flag) {
                i = MathHelper.func_76128_c((double)entity.field_70165_t);
                int j = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
                int k3 = MathHelper.func_76128_c((double)entity.field_70161_v);
                biome = world.func_72807_a(i, k3);
                if (biome instanceof LOTRBiomeGenForodwaith && (world.func_72937_j(i, j, k3) || entity.func_70090_H()) && world.func_72972_b(EnumSkyBlock.Block, i, j, k3) < 10) {
                    int frostChance = 50;
                    int frostProtection = 0;
                    for (int l = 0; l < 4; ++l) {
                        ItemStack armour = entity.func_71124_b(l + 1);
                        if (armour == null || !(armour.func_77973_b() instanceof ItemArmor)) continue;
                        ItemArmor.ArmorMaterial material = ((ItemArmor)armour.func_77973_b()).func_82812_d();
                        if (material.customCraftingMaterial == Items.field_151116_aA) {
                            frostProtection += 50;
                            continue;
                        }
                        if (material.customCraftingMaterial != LOTRMod.wargFur) continue;
                        frostProtection += 100;
                    }
                    frostChance += frostProtection;
                    if (world.func_72896_J()) {
                        frostChance /= 3;
                    }
                    if (entity.func_70090_H()) {
                        frostChance /= 20;
                    }
                    if (frostChance < 1) {
                        frostChance = 1;
                    }
                    if (world.field_73012_v.nextInt(frostChance) == 0) {
                        boolean attacked = entity.func_70097_a(LOTRBiomeGenForodwaith.frost, 1.0f);
                        if (flag && entity instanceof EntityPlayer) {
                            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.frost", Unpooled.buffer((int)0)));
                        }
                    }
                }
            }
        }
        if (!world.field_72995_K && entity.func_70089_S() && world.func_72820_D() % 20L == 0L) {
            boolean flag = true;
            if (entity instanceof LOTREntityNPC) {
                flag = true;
            }
            if (entity instanceof EntityPlayer) {
                boolean bl = flag = !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            }
            if (entity instanceof LOTRBiomeGenNearHarad.ImmuneToHeat) {
                flag = false;
            }
            if (flag) {
                i = MathHelper.func_76128_c((double)entity.field_70165_t);
                int j = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
                int k4 = MathHelper.func_76128_c((double)entity.field_70161_v);
                biome = world.func_72807_a(i, k4);
                if (biome instanceof LOTRBiomeGenNearHarad && !entity.func_70090_H() && world.func_72937_j(i, j, k4) && world.func_72935_r()) {
                    int burnChance = 100;
                    int burnProtection = 0;
                    for (int l = 0; l < 4; ++l) {
                        ItemStack armour = entity.func_71124_b(l + 1);
                        if (armour == null || !(armour.func_77973_b() instanceof ItemArmor)) continue;
                        ItemArmor.ArmorMaterial material = ((ItemArmor)armour.func_77973_b()).func_82812_d();
                        if (material.customCraftingMaterial != Items.field_151116_aA) continue;
                        burnProtection += 80;
                    }
                    if ((burnChance += burnProtection) < 1) {
                        burnChance = 1;
                    }
                    if (world.field_73012_v.nextInt(burnChance) == 0) {
                        boolean attacked = entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
                        if (flag && entity instanceof EntityPlayer) {
                            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.burn", Unpooled.buffer((int)0)));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer entityplayer = event.entityPlayer;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        Entity entity = event.target;
        if ((entity instanceof EntityCow || entity instanceof LOTREntityZebra) && itemstack != null && itemstack.func_77973_b() == LOTRMod.mug && !entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 1) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, new ItemStack(LOTRMod.mugMilk));
            } else if (!entityplayer.field_71071_by.func_70441_a(new ItemStack(LOTRMod.mugMilk))) {
                entityplayer.func_71019_a(new ItemStack(LOTRMod.mugMilk), false);
            }
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTREntityOrc) {
            ItemStack heldItem;
            LOTREntityOrc orc = (LOTREntityOrc)entity;
            if (orc.isBombardier && orc.hiredNPCInfo.getHiringPlayer() == entityplayer && ((heldItem = orc.func_71124_b(0)) == null || heldItem.func_77973_b() != LOTRMod.orcTorchItem) && itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.orcBomb)) {
                orc.func_70062_b(0, new ItemStack(LOTRMod.orcTorchItem));
                int meta = itemstack.func_77960_j();
                orc.setBombStrength(meta);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                    }
                }
                event.setCanceled(true);
                return;
            }
        }
        if (entity instanceof LOTRTradeable && ((LOTRTradeable)entity).canTradeWith(entityplayer)) {
            if (entity instanceof LOTRUnitTradeable) {
                entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_TRADE_UNIT_TRADE_INTERACT, entityplayer.field_70170_p, entity.func_145782_y(), 0, 0);
            } else {
                entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_TRADE_INTERACT, entityplayer.field_70170_p, entity.func_145782_y(), 0, 0);
            }
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTRUnitTradeable && ((LOTRUnitTradeable)entity).canTradeWith(entityplayer)) {
            entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_UNIT_TRADE_INTERACT, entityplayer.field_70170_p, entity.func_145782_y(), 0, 0);
            event.setCanceled(true);
            return;
        }
        if (entity instanceof LOTREntityNPC && ((LOTREntityNPC)entity).hiredNPCInfo.getHiringPlayer() == entityplayer) {
            entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_HIRED_INTERACT, entityplayer.field_70170_p, entity.func_145782_y(), 0, 0);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntitySetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.entityLiving instanceof EntityLiving && event.target instanceof LOTREntityRanger && ((LOTREntityRanger)event.target).isRangerSneaking()) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
        if (event.entityLiving instanceof EntityLiving && event.target instanceof LOTREntityHuornBase && !((LOTREntityHuornBase)event.target).isHuornActive()) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        ItemStack weapon;
        ItemStack armour;
        int i;
        EntityLivingBase entity = event.entityLiving;
        EntityLivingBase attacker = event.source.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)event.source.func_76346_g() : null;
        World world = entity.field_70170_p;
        if (attacker instanceof EntityPlayer && !LOTRMod.canPlayerAttackEntity((EntityPlayer)attacker, entity, true)) {
            event.setCanceled(true);
            return;
        }
        if (attacker instanceof EntityCreature && !LOTRMod.canNPCAttackEntity((EntityCreature)attacker, entity)) {
            event.setCanceled(true);
            return;
        }
        if (event.source instanceof EntityDamageSourceIndirect) {
            ItemStack chestplate;
            LOTREntitySpear spear;
            boolean wearingAllGalvorn = true;
            for (i = 0; i < 4; ++i) {
                armour = entity.func_71124_b(i + 1);
                if (armour != null && armour.func_77973_b() instanceof ItemArmor && ((ItemArmor)armour.func_77973_b()).func_82812_d() == LOTRMod.armorGalvorn) continue;
                wearingAllGalvorn = false;
                break;
            }
            if (wearingAllGalvorn) {
                event.setCanceled(true);
                if (!world.field_72995_K && entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).field_71071_by.func_70449_g(event.ammount + 1.0f);
                    LOTRLevelData.addAchievement((EntityPlayer)entity, LOTRAchievement.wearFullGalvorn);
                }
                return;
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && event.source.func_76364_f() instanceof LOTREntitySpear && (spear = (LOTREntitySpear)event.source.func_76364_f()).getItemID() == Item.func_150891_b((Item)LOTRMod.spearOrc) && (chestplate = entity.func_71124_b(3)) != null && chestplate.func_77973_b() == LOTRMod.bodyMithril) {
                LOTRLevelData.addAchievement((EntityPlayer)entity, LOTRAchievement.hitByOrcSpear);
            }
        }
        if (attacker != null && event.source.func_76364_f() == attacker) {
            boolean wearingAllMorgul = true;
            for (i = 0; i < 4; ++i) {
                armour = entity.func_71124_b(i + 1);
                if (armour != null && armour.func_77973_b() instanceof ItemArmor && ((ItemArmor)armour.func_77973_b()).func_82812_d() == LOTRMod.armorMorgul) continue;
                wearingAllMorgul = false;
                break;
            }
            if (wearingAllMorgul && !world.field_72995_K) {
                attacker.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 80));
                if (entity instanceof EntityPlayer) {
                    LOTRLevelData.addAchievement((EntityPlayer)entity, LOTRAchievement.wearFullMorgul);
                }
            }
        }
        if (attacker != null && event.source.func_76364_f() == attacker && (weapon = attacker.func_70694_bm()) != null) {
            String materialName = null;
            if (weapon.func_77973_b() instanceof ItemTool) {
                materialName = ((ItemTool)weapon.func_77973_b()).func_77861_e();
            } else if (weapon.func_77973_b() instanceof ItemSword) {
                materialName = ((ItemSword)weapon.func_77973_b()).func_150932_j();
            }
            if (materialName != null && materialName.equals(LOTRMod.toolMorgul.toString()) && !world.field_72995_K) {
                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 160));
                ItemStack[] equipment = entity.func_70035_c();
                for (int i2 = 0; i2 < equipment.length; ++i2) {
                    ItemStack itemstack = equipment[i2];
                    if (itemstack == null) continue;
                    itemstack.func_77972_a(4, entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityPlayer entityplayer;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        DamageSource source = event.source;
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)entity;
            int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
            int j = MathHelper.func_76128_c((double)entityplayer.field_70163_u);
            int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
            LOTRLevelData.playerDeathPoints.put(entityplayer.func_110124_au(), new ChunkCoordinates(i, j, k));
        }
        if (!world.field_72995_K) {
            entityplayer = null;
            if (source.func_76346_g() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)source.func_76346_g();
            } else if (entity.func_94060_bK() instanceof EntityPlayer) {
                entityplayer = (EntityPlayer)entity.func_94060_bK();
            }
            if (entityplayer != null) {
                LOTRAlignmentValues.Bonus alignmentBonus = null;
                if (entity instanceof LOTREntityNPC) {
                    LOTREntityNPC npc = (LOTREntityNPC)entity;
                    alignmentBonus = new LOTRAlignmentValues.Bonus(npc.getAlignmentBonus(), npc.getEntityClassName());
                    alignmentBonus.needsTranslation = true;
                } else {
                    String s = EntityList.func_75621_b((Entity)entity);
                    Object obj = LOTREntityRegistry.registeredNPCs.get(s);
                    if (obj != null) {
                        LOTREntityRegistry.RegistryInfo info = (LOTREntityRegistry.RegistryInfo)obj;
                        alignmentBonus = info.alignmentBonus;
                    }
                }
                if (alignmentBonus != null) {
                    alignmentBonus.isKill = true;
                    LOTRLevelData.addAlignment(entityplayer, alignmentBonus, LOTRMod.getNPCFaction((Entity)entity), (Entity)entity);
                }
                if (!entityplayer.field_71075_bZ.field_75098_d && LOTRMod.getNPCFaction((Entity)entity) != LOTRFaction.UNALIGNED) {
                    List nearbyAlliedNPCs = world.func_72872_a(EntityLiving.class, entity.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
                    for (int i = 0; i < nearbyAlliedNPCs.size(); ++i) {
                        EntityLiving npc = (EntityLiving)nearbyAlliedNPCs.get(i);
                        if (npc instanceof LOTREntityNPC && ((LOTREntityNPC)npc).hiredNPCInfo.isActive || !LOTRMod.getNPCFaction((Entity)entity).isAllied(LOTRMod.getNPCFaction((Entity)npc))) continue;
                        npc.func_70624_b((EntityLivingBase)entityplayer);
                    }
                }
            }
        }
        if (!world.field_72995_K && source.func_76346_g() instanceof EntityPlayer && source.func_76364_f() != null && source.func_76364_f().getClass() == LOTREntitySpear.class && entity != (entityplayer = (EntityPlayer)source.func_76346_g()) && entityplayer.func_70068_e((Entity)entity) >= 2500.0) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.useSpearFromFar);
        }
        if (!world.field_72995_K && entity instanceof LOTREntityButterfly && source.func_76346_g() instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)source.func_76346_g();
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.killButterfly);
        }
        if (!world.field_72995_K && entity instanceof EntityHorse && source.func_76346_g() instanceof EntityPlayer) {
            List rohirrimList;
            entityplayer = (EntityPlayer)source.func_76346_g();
            if (!entityplayer.field_71075_bZ.field_75098_d && !(rohirrimList = world.func_72872_a(LOTREntityRohirrim.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0))).isEmpty()) {
                boolean sentMessage = false;
                boolean penalty = false;
                for (int l = 0; l < rohirrimList.size(); ++l) {
                    LOTREntityRohirrim rohirrim = (LOTREntityRohirrim)((Object)rohirrimList.get(l));
                    if (rohirrim.hiredNPCInfo.isActive && rohirrim.hiredNPCInfo.getHiringPlayer() == entityplayer) continue;
                    rohirrim.func_70624_b((EntityLivingBase)entityplayer);
                    if (!sentMessage) {
                        entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)rohirrim, "rohirrim_avengeHorse", entityplayer));
                        rohirrim.markNPCSpoken();
                        sentMessage = true;
                    }
                    if (penalty) continue;
                    LOTRLevelData.addAlignment(entityplayer, LOTRAlignmentValues.ROHAN_HORSE_PENALTY, LOTRFaction.ROHAN, (Entity)entity);
                    penalty = true;
                }
            }
        }
        if (!world.field_72995_K) {
            EntityPlayer attackingPlayer = null;
            LOTREntityNPC attackingHiredUnit = null;
            if (source.func_76346_g() instanceof EntityPlayer) {
                attackingPlayer = (EntityPlayer)source.func_76346_g();
            } else if (source.func_76346_g() instanceof LOTREntityNPC) {
                LOTREntityNPC npc = (LOTREntityNPC)source.func_76346_g();
                if (npc.hiredNPCInfo.isActive && npc.hiredNPCInfo.getHiringPlayer() != null) {
                    attackingPlayer = npc.hiredNPCInfo.getHiringPlayer();
                    attackingHiredUnit = npc;
                }
            }
            if (attackingPlayer != null) {
                boolean isFoe;
                boolean bl = isFoe = LOTRLevelData.getAlignment(attackingPlayer, LOTRMod.getNPCFaction((Entity)entity)) < 0;
                if (isFoe) {
                    if (attackingHiredUnit != null) {
                        if (attackingHiredUnit instanceof LOTREntityMordorSpider && entity instanceof LOTREntityMirkwoodSpider) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.killMirkwoodSpiderMordorSpider);
                        }
                        if (attackingHiredUnit instanceof LOTREntityWargBombardier) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.hireWargBombardier);
                        }
                        if (attackingHiredUnit instanceof LOTREntityOlogHai) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.hireOlogHai);
                        }
                    } else {
                        LOTREntityThrowingAxe axe;
                        if (attackingPlayer.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.killWhileDrunk);
                        }
                        if (entity instanceof LOTREntityOrc) {
                            LOTREntityOrc orc = (LOTREntityOrc)entity;
                            if (orc.isBombardier && orc.func_71124_b(0) != null && orc.func_71124_b(0).func_77973_b() == LOTRMod.orcTorchItem) {
                                LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.killBombardier);
                            }
                        }
                        if (source.func_76364_f() instanceof LOTREntityCrossbowBolt) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.useCrossbow);
                        }
                        if (source.func_76364_f() instanceof LOTREntityThrowingAxe && (axe = (LOTREntityThrowingAxe)source.func_76364_f()).getItemID() == Item.func_150891_b((Item)LOTRMod.throwingAxeDwarven)) {
                            LOTRLevelData.addAchievement(attackingPlayer, LOTRAchievement.useDwarvenThrowingAxe);
                        }
                    }
                }
            }
        }
    }
}

