/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.util.StatCollector;

public enum LOTRGuiMessageTypes {
    FRIENDLY_FIRE("friendlyFire");

    private String message;
    public Set playersRecievedMessage = new HashSet();

    private LOTRGuiMessageTypes(String s) {
        this.message = s;
    }

    public String getMessage() {
        return StatCollector.func_74838_a((String)("lotr.gui.message." + this.message));
    }

    public void sendMessageIfNotReceived(EntityPlayer entityplayer) {
        if (entityplayer.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.playersRecievedMessage.contains(entityplayer.func_110124_au())) {
            this.playersRecievedMessage.add(entityplayer.func_110124_au());
            ByteBuf data = Unpooled.buffer();
            data.writeByte((int)((byte)this.ordinal()));
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.message", data));
        }
    }

    public static void saveAll(NBTTagCompound levelData) {
        NBTTagList tags = new NBTTagList();
        for (LOTRGuiMessageTypes type : LOTRGuiMessageTypes.values()) {
            NBTTagCompound typeData = new NBTTagCompound();
            typeData.func_74778_a("Type", type.name());
            NBTTagList playerList = new NBTTagList();
            for (Object obj : type.playersRecievedMessage) {
                if (!(obj instanceof UUID)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                playerList.func_74742_a((NBTBase)nbt);
            }
            typeData.func_74782_a("Players", (NBTBase)playerList);
            tags.func_74742_a((NBTBase)typeData);
        }
        levelData.func_74782_a("Messages", (NBTBase)tags);
    }

    public static void loadAll(NBTTagCompound levelData) {
        for (LOTRGuiMessageTypes type : LOTRGuiMessageTypes.values()) {
            type.playersRecievedMessage.clear();
        }
        NBTTagList tags = levelData.func_150295_c("Messages", (int)new NBTTagCompound().func_74732_a());
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagList playerList;
                NBTTagCompound typeData = tags.func_150305_b(i);
                String name = typeData.func_74779_i("Type");
                LOTRGuiMessageTypes type = null;
                for (LOTRGuiMessageTypes t : LOTRGuiMessageTypes.values()) {
                    if (!t.name().equals(name)) continue;
                    type = t;
                    break;
                }
                if (type == null || (playerList = typeData.func_150295_c("Players", (int)new NBTTagCompound().func_74732_a())) == null) continue;
                for (int j = 0; j < playerList.func_74745_c(); ++j) {
                    NBTTagCompound nbt = playerList.func_150305_b(j);
                    type.playersRecievedMessage.add(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")));
                }
            }
        }
    }
}

