/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Level;

public class LOTRReflection {
    private static void logFailure(Exception e) {
        System.out.println("LOTRReflection failed");
        throw new RuntimeException(e);
    }

    private static String[] remapMethodNames(String className, String ... methodNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[methodNames.length];
        int i = 0;
        for (String mName : methodNames) {
            mappedNames[i++] = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, mName, null);
        }
        return mappedNames;
    }

    public static <E> Method getPrivateMethod(Class<? super E> classToAccess, E instance, Class[] methodClasses, String ... methodNames) {
        try {
            return ReflectionHelper.findMethod(classToAccess, instance, (String[])LOTRReflection.remapMethodNames(classToAccess.getName(), methodNames), (Class[])methodClasses);
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to locate any method %s on type %s", (Object[])new Object[]{Arrays.toString(methodNames), classToAccess.getName()});
            throw e;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to access any method %s on type %s", (Object[])new Object[]{Arrays.toString(methodNames), classToAccess.getName()});
            throw e;
        }
    }

    public static void testAll() {
        LOTRReflection.getHorseJumpStrength();
        LOTRReflection.isBadEffect(Potion.field_76440_q);
        LOTRReflection.getStackList(new InventoryCrafting((Container)new ContainerChest((IInventory)new InventoryBasic("test", false, 1), (IInventory)new InventoryBasic("test", false, 1)), 1, 1));
        LOTRReflection.getStemFruitBlock((BlockStem)Blocks.field_150394_bc);
        LOTRReflection.getCropItem((BlockCrops)Blocks.field_150469_bN);
    }

    public static void setWorldInfo(World world, WorldInfo newWorldInfo) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)world, (Object)newWorldInfo, (String[])new String[]{"worldInfo", "field_72986_A"});
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
        }
    }

    public static IAttribute getHorseJumpStrength() {
        try {
            return (IAttribute)ObfuscationReflectionHelper.getPrivateValue(EntityHorse.class, null, (String[])new String[]{"horseJumpStrength", "field_110271_bv"});
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
            return null;
        }
    }

    public static boolean isBadEffect(Potion potion) {
        try {
            return (Boolean)ObfuscationReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])new String[]{"isBadEffect", "field_76418_K"});
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
            return false;
        }
    }

    public static ItemStack[] getStackList(InventoryCrafting inv) {
        try {
            return (ItemStack[])ObfuscationReflectionHelper.getPrivateValue(InventoryCrafting.class, (Object)inv, (String[])new String[]{"stackList", "field_70466_a"});
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
            return null;
        }
    }

    public static Block getStemFruitBlock(BlockStem block) {
        try {
            return (Block)ObfuscationReflectionHelper.getPrivateValue(BlockStem.class, (Object)block, (String[])new String[]{"field_149877_a"});
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
            return null;
        }
    }

    public static Item getCropItem(BlockCrops block) {
        try {
            Method method = LOTRReflection.getPrivateMethod(BlockCrops.class, block, new Class[0], "func_149865_P");
            return (Item)method.invoke((Object)block, new Object[0]);
        }
        catch (Exception e) {
            LOTRReflection.logFailure(e);
            return null;
        }
    }
}

