/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lotr.common.LOTRAbstractWaypoint;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.world.genlayer.LOTRGenLayerWorld;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public enum LOTRWaypoint implements LOTRAbstractWaypoint
{
    HIMLING(Region.OCEAN, LOTRFaction.UNALIGNED, 485, 523),
    TOL_FUIN(Region.OCEAN, LOTRFaction.UNALIGNED, 357, 542),
    TOL_MORWEN(Region.OCEAN, LOTRFaction.UNALIGNED, 87, 698),
    HOBBITON(Region.SHIRE, LOTRFaction.HOBBIT, 815, 730),
    BRANDYWINE_BRIDGE(Region.SHIRE, LOTRFaction.HOBBIT, 850, 723),
    SARN_FORD(Region.SHIRE, LOTRFaction.HOBBIT, 882, 801),
    WITHYWINDLE_VALLEY(Region.OLD_FOREST, LOTRFaction.UNALIGNED, 881, 749),
    FORLOND(Region.LINDON, LOTRFaction.HIGH_ELF, 526, 718),
    HARLOND(Region.LINDON, LOTRFaction.HIGH_ELF, 605, 783),
    MITHLOND(Region.LINDON, LOTRFaction.HIGH_ELF, 679, 729),
    FORLINDON(Region.LINDON, LOTRFaction.HIGH_ELF, 493, 688),
    HARLINDON(Region.LINDON, LOTRFaction.HIGH_ELF, 611, 878),
    BELEGOST(Region.BLUE_MOUNTAINS, LOTRFaction.UNALIGNED, 622, 600),
    NOGROD(Region.BLUE_MOUNTAINS, LOTRFaction.UNALIGNED, 626, 636),
    NORTH_DOWNS(Region.ERIADOR, LOTRFaction.UNALIGNED, 930, 626),
    FAR_DOWNS(Region.ERIADOR, LOTRFaction.UNALIGNED, 756, 745),
    SOUTH_DOWNS(Region.ERIADOR, LOTRFaction.UNALIGNED, 960, 768),
    ERYN_VORN(Region.ERIADOR, LOTRFaction.UNALIGNED, 747, 957),
    THARBAD(Region.ERIADOR, LOTRFaction.UNALIGNED, 979, 878),
    FORNOST(Region.ERIADOR, LOTRFaction.UNALIGNED, 897, 652),
    ANNUMINAS(Region.ERIADOR, LOTRFaction.UNALIGNED, 814, 661),
    TOWER_HILLS(Region.ERIADOR, LOTRFaction.UNALIGNED, 722, 742),
    BREE(Region.BREE_LAND, LOTRFaction.UNALIGNED, 920, 737),
    CHETWOOD(Region.BREE_LAND, LOTRFaction.UNALIGNED, 929, 724),
    MIDGEWATER_MARSHES(Region.MIDGEWATER, LOTRFaction.UNALIGNED, 951, 719),
    WEATHERTOP(Region.LONE_LANDS, LOTRFaction.UNALIGNED, 998, 723),
    LAST_BRIDGE(Region.LONE_LANDS, LOTRFaction.UNALIGNED, 1086, 715),
    RIVENDELL(Region.LONE_LANDS, LOTRFaction.HIGH_ELF, 1174, 717),
    THE_TROLLSHAWS(Region.TROLLSHAWS, LOTRFaction.UNALIGNED, 1130, 709),
    CARN_DUM(Region.ANGMAR, LOTRFaction.ANGMAR, 1000, 510),
    WEST_GATE(Region.EREGION, LOTRFaction.UNALIGNED, 1131, 869),
    NORTH_DUNLAND(Region.DUNLAND, LOTRFaction.DUNLAND, 1073, 946),
    SOUTH_DUNLAND(Region.DUNLAND, LOTRFaction.DUNLAND, 1070, 1027),
    LOND_DAER(Region.ENEDWAITH, LOTRFaction.UNALIGNED, 867, 1004),
    DRUWAITH_IAUR(Region.ENEDWAITH, LOTRFaction.UNALIGNED, 880, 1204),
    ISENGARD(Region.ENEDWAITH, LOTRFaction.UNALIGNED, 1102, 1058),
    CAPE_OF_FOROCHEL(Region.FORODWAITH, LOTRFaction.UNALIGNED, 786, 390),
    SOUTH_FOROCHEL(Region.FORODWAITH, LOTRFaction.UNALIGNED, 825, 459),
    WITHERED_HEATH(Region.FORODWAITH, LOTRFaction.UNALIGNED, 1441, 556),
    MOUNT_GUNDABAD(Region.MISTY_MOUNTAINS, LOTRFaction.GUNDABAD, 1195, 592),
    MOUNT_GRAM(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1106, 589),
    HIGH_PASS(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1222, 706),
    MOUNT_CARADHRAS(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1175, 840),
    MOUNT_CELEBDIL(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1162, 849),
    MOUNT_FANUIDHOL(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1188, 850),
    MOUNT_METHEDRAS(Region.MISTY_MOUNTAINS, LOTRFaction.UNALIGNED, 1111, 1031),
    CARROCK(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1295, 675),
    OLD_FORD(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1283, 702),
    GLADDEN_FIELDS(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1292, 792),
    DIMRILL_DALE(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1177, 864),
    FIELD_OF_CELEBRANT(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1281, 960),
    NORTH_UNDEEP(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1319, 988),
    SOUTH_UNDEEP(Region.VALES_OF_ANDUIN, LOTRFaction.UNALIGNED, 1335, 1024),
    WOODLAND_REALM(Region.MIRKWOOD, LOTRFaction.WOOD_ELF, 1415, 640),
    DOL_GULDUR(Region.MIRKWOOD_CORRUPTED, LOTRFaction.DOL_GULDUR, 1339, 894),
    MIRKWOOD_MOUNTAINS(Region.MIRKWOOD_CORRUPTED, LOTRFaction.UNALIGNED, 1430, 672),
    EREBOR(Region.WILDERLAND, LOTRFaction.UNALIGNED, 1464, 606),
    LONG_LAKE(Region.WILDERLAND, LOTRFaction.UNALIGNED, 1470, 637),
    EAST_BIGHT(Region.WILDERLAND, LOTRFaction.UNALIGNED, 1437, 824),
    EMYN_RHUNEN(Region.WILDERLAND, LOTRFaction.UNALIGNED, 1733, 950),
    WEST_PEAK(Region.IRON_HILLS, LOTRFaction.UNALIGNED, 1588, 608),
    EAST_PEAK(Region.IRON_HILLS, LOTRFaction.UNALIGNED, 1729, 610),
    CARAS_GALADHON(Region.LOTHLORIEN, LOTRFaction.GALADHRIM, 1242, 902),
    DERNDINGLE(Region.FANGORN, LOTRFaction.FANGORN, 1163, 1030),
    WOLD(Region.ROHAN, LOTRFaction.UNALIGNED, 1285, 1020),
    EDORAS(Region.ROHAN, LOTRFaction.ROHAN, 1190, 1148),
    HELMS_DEEP(Region.ROHAN, LOTRFaction.UNALIGNED, 1130, 1112),
    URUK_HIGHLANDS(Region.ROHAN, LOTRFaction.URUK_HAI, 1131, 1057),
    FORDS_OF_ISEN(Region.ROHAN, LOTRFaction.UNALIGNED, 1107, 1087),
    MERING_STREAM(Region.ROHAN, LOTRFaction.UNALIGNED, 1297, 1202),
    MINAS_TIRITH(Region.GONDOR, LOTRFaction.GONDOR, 1420, 1247),
    OSGILIATH(Region.GONDOR, LOTRFaction.UNALIGNED, 1437, 1245),
    CAIR_ANDROS(Region.GONDOR, LOTRFaction.GONDOR, 1427, 1207),
    EMYN_ARNEN(Region.GONDOR, LOTRFaction.UNALIGNED, 1437, 1267),
    DOL_AMROTH(Region.GONDOR, LOTRFaction.GONDOR, 1162, 1333),
    ERECH(Region.GONDOR, LOTRFaction.UNALIGNED, 1188, 1204),
    PINNATH_GELIN(Region.GONDOR, LOTRFaction.UNALIGNED, 1045, 1273),
    ANDUIN_MOUTH(Region.GONDOR, LOTRFaction.UNALIGNED, 1273, 1369),
    EDHELLOND(Region.GONDOR, LOTRFaction.UNALIGNED, 1191, 1291),
    PELARGIR(Region.GONDOR, LOTRFaction.UNALIGNED, 1390, 1348),
    TOLFALAS_ISLAND(Region.TOLFALAS, LOTRFaction.UNALIGNED, 1240, 1414),
    RAUROS(Region.EMYN_MUIL, LOTRFaction.UNALIGNED, 1357, 1135),
    MORANNON(Region.DAGORLAD, LOTRFaction.UNALIGNED, 1465, 1131),
    UDUN(Region.MORDOR, LOTRFaction.MORDOR, 1483, 1150),
    MOUNT_DOOM(Region.MORDOR, LOTRFaction.MORDOR, 1533, 1204),
    BARAD_DUR(Region.MORDOR, LOTRFaction.MORDOR, 1573, 1196),
    MINAS_MORGUL(Region.MORDOR, LOTRFaction.MORDOR, 1463, 1238),
    NURNEN_NORTHERN_SHORE(Region.NURN, LOTRFaction.MORDOR, 1696, 1324),
    NURNEN_SOUTHERN_SHORE(Region.NURN, LOTRFaction.MORDOR, 1726, 1369),
    NURNEN_WESTERN_SHORE(Region.NURN, LOTRFaction.MORDOR, 1650, 1363),
    NURNEN_EASTERN_SHORE(Region.NURN, LOTRFaction.MORDOR, 1758, 1316),
    VALLEY_OF_SPIDERS(Region.NAN_UNGOL, LOTRFaction.MORDOR, 1512, 1400),
    CROSSINGS_OF_POROS(Region.HARONDOR, LOTRFaction.UNALIGNED, 1443, 1372),
    CROSSINGS_OF_HARAD(Region.NEAR_HARAD, LOTRFaction.UNALIGNED, 1504, 1546),
    GULF_OF_HARAD(Region.NEAR_HARAD_FERTILE, LOTRFaction.UNALIGNED, 1634, 1915),
    ISLAND_THREE_RIVERS(Region.NEAR_HARAD_FERTILE, LOTRFaction.UNALIGNED, 1362, 1770),
    FERTILE_VALLEY(Region.NEAR_HARAD_FERTILE, LOTRFaction.UNALIGNED, 1530, 1811),
    UMBAR_WAYPOINT(Region.UMBAR, LOTRFaction.UNALIGNED, 1183, 1679),
    MOUNT_SAND(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 959, 1899),
    MOUNT_GREEN(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 884, 2372),
    MOUNT_THUNDER(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1019, 2590),
    GREAT_PLAINS_NORTH(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1387, 1984),
    GREAT_PLAINS_SOUTH(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1462, 2497),
    GREAT_PLAINS_WEST(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1048, 2205),
    GREAT_PLAINS_EAST(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1637, 2176),
    GREEN_VALLEY(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1613, 2588),
    HARAD_LAKES(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1774, 2310),
    LAKE_HARAD(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1100, 2592),
    HARADUIN_MOUTH(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1858, 2847),
    ISLE_MIST(Region.FAR_HARAD, LOTRFaction.UNALIGNED, 1533, 3573),
    TROLL_ISLAND(Region.PERTOROGWAITH, LOTRFaction.UNALIGNED, 1966, 2342),
    BLACK_COAST(Region.PERTOROGWAITH, LOTRFaction.UNALIGNED, 1936, 2496),
    BLOOD_RIVER(Region.PERTOROGWAITH, LOTRFaction.UNALIGNED, 1897, 2605),
    SHADOW_POINT(Region.PERTOROGWAITH, LOTRFaction.UNALIGNED, 1952, 2863);

    private Region region;
    public LOTRFaction faction;
    private int x;
    private int y;
    private int xCoord;
    private int zCoord;

    private LOTRWaypoint(Region r, LOTRFaction f, int i, int j) {
        this.region = r;
        this.region.waypoints.add(this);
        this.faction = f;
        this.x = i;
        this.y = j;
        this.xCoord = (int)(((double)(this.x - LOTRGenLayerWorld.originX) + 0.5) * (double)LOTRGenLayerWorld.scale);
        this.zCoord = (int)(((double)(this.y - LOTRGenLayerWorld.originZ) + 0.5) * (double)LOTRGenLayerWorld.scale);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getXCoord() {
        return this.xCoord;
    }

    @Override
    public int getZCoord() {
        return this.zCoord;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)("lotr.waypoint." + this.name()));
    }

    @Override
    public boolean hasPlayerUnlocked(EntityPlayer entityplayer) {
        return this.region.hasPlayerUnlocked(entityplayer) && this.isUnlockable(entityplayer);
    }

    @Override
    public boolean isUnlockable(EntityPlayer entityplayer) {
        return this.faction == LOTRFaction.UNALIGNED || LOTRLevelData.getAlignment(entityplayer, this.faction) >= 0;
    }

    @Override
    public int getID() {
        return this.ordinal();
    }

    public static Packet getLoginWaypointsPacket(EntityPlayer entityplayer) {
        ArrayList<Region> regionsUnlocked = new ArrayList<Region>();
        for (Region region : Region.values()) {
            if (!region.hasPlayerUnlocked(entityplayer)) continue;
            regionsUnlocked.add(region);
        }
        if (regionsUnlocked.isEmpty()) {
            return null;
        }
        ByteBuf data = Unpooled.buffer();
        for (int i = 0; i < regionsUnlocked.size(); ++i) {
            data.writeByte((int)((byte)((Region)((Object)regionsUnlocked.get(i))).ordinal()));
        }
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.loginWP", data);
        return packet;
    }

    public static void clearAllWaypoints() {
        for (Region region : Region.values()) {
            region.playersUnlocked.clear();
        }
    }

    public static Region regionForName(String name) {
        for (Region region : Region.values()) {
            if (!region.name().equals(name)) continue;
            return region;
        }
        return null;
    }

    public static Region regionForID(int id) {
        for (Region region : Region.values()) {
            if (region.ordinal() != id) continue;
            return region;
        }
        return null;
    }

    public static void save(NBTTagCompound levelData) {
        NBTTagList waypointData = new NBTTagList();
        for (Region region : Region.values()) {
            if (region.playersUnlocked.isEmpty()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Name", region.name());
            NBTTagList players = new NBTTagList();
            for (Object obj : region.playersUnlocked) {
                if (!(obj instanceof UUID)) continue;
                NBTTagCompound playerData = new NBTTagCompound();
                playerData.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                playerData.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                players.func_74742_a((NBTBase)playerData);
            }
            nbt.func_74782_a("Players", (NBTBase)players);
            waypointData.func_74742_a((NBTBase)nbt);
        }
        levelData.func_74782_a("Waypoints", (NBTBase)waypointData);
        Custom.save(levelData);
    }

    public static void load(NBTTagCompound levelData) {
        LOTRWaypoint.clearAllWaypoints();
        NBTTagList waypointData = levelData.func_150295_c("Waypoints", (int)new NBTTagCompound().func_74732_a());
        if (waypointData != null) {
            for (int i = 0; i < waypointData.func_74745_c(); ++i) {
                NBTTagList players;
                NBTTagCompound nbt = waypointData.func_150305_b(i);
                String name = nbt.func_74779_i("Name");
                Region region = LOTRWaypoint.regionForName(name);
                if (region == null || (players = nbt.func_150295_c("Players", (int)new NBTTagCompound().func_74732_a())) == null) continue;
                for (int j = 0; j < players.func_74745_c(); ++j) {
                    NBTTagCompound playerData = players.func_150305_b(j);
                    UUID player = new UUID(playerData.func_74763_f("UUIDMost"), playerData.func_74763_f("UUIDLeast"));
                    region.playersUnlocked.add(player);
                }
            }
        }
        Custom.load(levelData);
    }

    public static List getListOfAllWaypoints(EntityPlayer entityplayer) {
        ArrayList<LOTRWaypoint> waypoints = new ArrayList<LOTRWaypoint>();
        for (LOTRWaypoint waypoint : LOTRWaypoint.values()) {
            waypoints.add(waypoint);
        }
        waypoints.addAll(Custom.getWaypointList(entityplayer));
        return waypoints;
    }

    public static class Custom
    implements LOTRAbstractWaypoint {
        public static int MAX_CUSTOM = 20;
        public static Map playerCustomWaypoints = new HashMap();
        private static int nextWaypointID = 0;
        private String name;
        private int x;
        private int y;
        private int xCoord;
        private int zCoord;
        private int ID;

        public Custom(String s, double posX, double posZ) {
            this.name = s;
            this.xCoord = MathHelper.func_76128_c((double)posX);
            this.zCoord = MathHelper.func_76128_c((double)posZ);
            this.x = (int)Math.round((double)this.xCoord / (double)LOTRGenLayerWorld.scale - 0.5 + (double)LOTRGenLayerWorld.originX);
            this.y = (int)Math.round((double)this.zCoord / (double)LOTRGenLayerWorld.scale - 0.5 + (double)LOTRGenLayerWorld.originZ);
            this.ID = nextWaypointID++;
        }

        public Custom(String s, int i, int j, int i1, int j1, int k) {
            this.name = s;
            this.x = i;
            this.y = j;
            this.xCoord = i1;
            this.zCoord = j1;
            this.ID = k;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getXCoord() {
            return this.xCoord;
        }

        @Override
        public int getZCoord() {
            return this.zCoord;
        }

        @Override
        public String getDisplayName() {
            return StatCollector.func_74837_a((String)"lotr.waypoint.custom", (Object[])new Object[]{this.name});
        }

        @Override
        public boolean hasPlayerUnlocked(EntityPlayer entityplayer) {
            return true;
        }

        @Override
        public boolean isUnlockable(EntityPlayer entityplayer) {
            return true;
        }

        @Override
        public int getID() {
            return this.ID;
        }

        public static List getWaypointList(EntityPlayer entityplayer) {
            ArrayList waypoints = (ArrayList)playerCustomWaypoints.get(entityplayer.func_110124_au());
            if (waypoints == null) {
                waypoints = new ArrayList();
                playerCustomWaypoints.put(entityplayer.func_110124_au(), waypoints);
            }
            return waypoints;
        }

        public static void addCustomWaypoint(EntityPlayer entityplayer, Custom waypoint) {
            Custom.getWaypointList(entityplayer).add(waypoint);
            if (!entityplayer.field_70170_p.field_72995_K) {
                LOTRLevelData.needsSave = true;
                Custom.sendWaypointPacket(entityplayer, waypoint);
            }
        }

        public static void removeCustomWaypoint(EntityPlayer entityplayer, Custom waypoint) {
            if (Custom.getWaypointList(entityplayer).remove(waypoint) && !entityplayer.field_70170_p.field_72995_K) {
                LOTRLevelData.needsSave = true;
                ByteBuf data = Unpooled.buffer();
                data.writeInt(waypoint.ID);
                S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.removeCWP", data);
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
            }
        }

        public static void clearCustomWaypoints(EntityPlayer entityplayer) {
            Custom.getWaypointList(entityplayer).clear();
        }

        private static void sendWaypointPacket(EntityPlayer entityplayer, Custom waypoint) {
            ByteBuf data = Unpooled.buffer();
            data.writeInt(waypoint.x);
            data.writeInt(waypoint.y);
            data.writeInt(waypoint.xCoord);
            data.writeInt(waypoint.zCoord);
            data.writeInt(waypoint.ID);
            byte[] bytes = waypoint.name.getBytes(Charsets.UTF_8);
            data.writeShort(bytes.length);
            data.writeBytes(bytes);
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.CWP", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }

        public static void sendLoginCustomWaypointsPackets(EntityPlayer entityplayer) {
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.clearCWP", Unpooled.buffer());
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
            List waypoints = Custom.getWaypointList(entityplayer);
            for (int i = 0; i < waypoints.size(); ++i) {
                Custom waypoint = (Custom)waypoints.get(i);
                Custom.sendWaypointPacket(entityplayer, waypoint);
            }
        }

        public static Custom waypointForPlayerForID(EntityPlayer entityplayer, int ID) {
            List list = Custom.getWaypointList(entityplayer);
            for (int l = 0; l < list.size(); ++l) {
                Custom waypoint = (Custom)list.get(l);
                if (waypoint.getID() != ID) continue;
                return waypoint;
            }
            return null;
        }

        public static void save(NBTTagCompound levelData) {
            levelData.func_74768_a("NextCustomWaypointID", nextWaypointID);
            NBTTagList waypointData = new NBTTagList();
            for (UUID player : playerCustomWaypoints.keySet()) {
                NBTTagCompound playerData = new NBTTagCompound();
                playerData.func_74772_a("UUIDMost", player.getMostSignificantBits());
                playerData.func_74772_a("UUIDLeast", player.getLeastSignificantBits());
                NBTTagList waypointList = new NBTTagList();
                List waypoints = (List)playerCustomWaypoints.get(player);
                for (int i = 0; i < waypoints.size(); ++i) {
                    Custom waypoint = (Custom)waypoints.get(i);
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("Name", waypoint.name);
                    nbt.func_74768_a("X", waypoint.x);
                    nbt.func_74768_a("Y", waypoint.y);
                    nbt.func_74768_a("XCoord", waypoint.xCoord);
                    nbt.func_74768_a("ZCoord", waypoint.zCoord);
                    nbt.func_74768_a("ID", waypoint.ID);
                    waypointList.func_74742_a((NBTBase)nbt);
                }
                playerData.func_74782_a("Waypoints", (NBTBase)waypointList);
                waypointData.func_74742_a((NBTBase)playerData);
            }
            levelData.func_74782_a("CustomWaypoints", (NBTBase)waypointData);
        }

        public static void load(NBTTagCompound levelData) {
            nextWaypointID = levelData.func_74762_e("NextCustomWaypointID");
            playerCustomWaypoints.clear();
            NBTTagList waypointData = levelData.func_150295_c("CustomWaypoints", (int)new NBTTagCompound().func_74732_a());
            if (waypointData != null) {
                for (int i = 0; i < waypointData.func_74745_c(); ++i) {
                    NBTTagCompound playerData = waypointData.func_150305_b(i);
                    UUID player = new UUID(playerData.func_74763_f("UUIDMost"), playerData.func_74763_f("UUIDLeast"));
                    ArrayList<Custom> waypoints = new ArrayList<Custom>();
                    NBTTagList waypointList = playerData.func_150295_c("Waypoints", (int)new NBTTagCompound().func_74732_a());
                    if (waypointList != null) {
                        for (int j = 0; j < waypointList.func_74745_c(); ++j) {
                            NBTTagCompound nbt = waypointList.func_150305_b(j);
                            String name = nbt.func_74779_i("Name");
                            int x = nbt.func_74762_e("X");
                            int y = nbt.func_74762_e("Y");
                            int xCoord = nbt.func_74762_e("XCoord");
                            int zCoord = nbt.func_74762_e("ZCoord");
                            int ID = nbt.func_74762_e("ID");
                            Custom waypoint = new Custom(name, x, y, xCoord, zCoord, ID);
                            waypoints.add(waypoint);
                        }
                    }
                    playerCustomWaypoints.put(player, waypoints);
                }
            }
        }
    }

    public static enum Region {
        OCEAN,
        SHIRE,
        OLD_FOREST,
        LINDON,
        BLUE_MOUNTAINS,
        ERIADOR,
        BREE_LAND,
        MIDGEWATER,
        LONE_LANDS,
        TROLLSHAWS,
        COLDFELLS,
        ETTENMOORS,
        ANGMAR,
        EREGION,
        DUNLAND,
        ENEDWAITH,
        FORODWAITH,
        MISTY_MOUNTAINS,
        GREY_MOUNTAINS,
        VALES_OF_ANDUIN,
        MIRKWOOD,
        MIRKWOOD_CORRUPTED,
        WILDERLAND,
        IRON_HILLS,
        LOTHLORIEN,
        FANGORN,
        ROHAN,
        GONDOR,
        TOLFALAS,
        EMYN_MUIL,
        NINDALF,
        BROWN_LANDS,
        DAGORLAD,
        MORDOR,
        NURN,
        NAN_UNGOL,
        HARONDOR,
        NEAR_HARAD,
        NEAR_HARAD_FERTILE,
        UMBAR,
        FAR_HARAD,
        PERTOROGWAITH,
        RHUN,
        RED_MOUNTAINS;

        public List waypoints = new ArrayList();
        public List playersUnlocked = new ArrayList();

        public void unlockForPlayer(EntityPlayer entityplayer) {
            if (!this.playersUnlocked.contains(entityplayer.func_110124_au())) {
                this.playersUnlocked.add(entityplayer.func_110124_au());
                if (!entityplayer.field_70170_p.field_72995_K) {
                    LOTRLevelData.needsSave = true;
                    ByteBuf data = Unpooled.buffer();
                    data.writeByte((int)((byte)this.ordinal()));
                    S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.WP", data);
                    ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
                }
            }
        }

        public boolean hasPlayerUnlocked(EntityPlayer entityplayer) {
            return this.playersUnlocked.contains(entityplayer.func_110124_au());
        }
    }
}

