/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.item.LOTRItemSpear;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityAIAttackOnCollide
extends EntityAIBase {
    private World worldObj;
    private EntityCreature theOwner;
    private EntityLivingBase entityTarget;
    private int attackTick = 0;
    private double moveSpeed;
    private boolean sightNotRequired;
    private PathEntity entityPathEntity;
    private int pathCheckTimer;
    private float rangeFactor;
    private boolean avoidsWater;
    private Item spearReplacement;

    public LOTREntityAIAttackOnCollide(EntityCreature entity, double speed, boolean flag) {
        this(entity, speed, flag, 1.0f);
    }

    public LOTREntityAIAttackOnCollide(EntityCreature entity, double speed, boolean flag, float f) {
        this.theOwner = entity;
        this.worldObj = entity.field_70170_p;
        this.moveSpeed = speed;
        this.sightNotRequired = flag;
        this.rangeFactor = f;
        this.avoidsWater = entity.func_70661_as().func_75486_a();
        this.func_75248_a(3);
    }

    public LOTREntityAIAttackOnCollide setSpearReplacement(Item item) {
        this.spearReplacement = item;
        return this;
    }

    public boolean func_75250_a() {
        if (this.theOwner instanceof LOTREntityNPC && ((LOTREntityNPC)this.theOwner).isPassive) {
            return false;
        }
        EntityLivingBase entity = this.theOwner.func_70638_az();
        if (entity == null) {
            return false;
        }
        this.entityTarget = entity;
        this.theOwner.func_70661_as().func_75491_a(false);
        this.entityPathEntity = this.getPathEntity();
        if (this.entityPathEntity != null) {
            return true;
        }
        this.theOwner.func_70661_as().func_75491_a(this.avoidsWater);
        return false;
    }

    public boolean func_75253_b() {
        EntityLivingBase entity = this.theOwner.func_70638_az();
        if (entity == null) {
            return false;
        }
        if (!this.entityTarget.func_70089_S()) {
            return false;
        }
        if (this.sightNotRequired) {
            return this.theOwner.func_110176_b(MathHelper.func_76128_c((double)this.entityTarget.field_70165_t), MathHelper.func_76128_c((double)this.entityTarget.field_70163_u), MathHelper.func_76128_c((double)this.entityTarget.field_70161_v));
        }
        return !this.theOwner.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.theOwner.func_70661_as().func_75484_a(this.entityPathEntity, this.moveSpeed);
        this.pathCheckTimer = 0;
    }

    public void func_75251_c() {
        this.entityTarget = null;
        this.theOwner.func_70661_as().func_75499_g();
        this.theOwner.func_70661_as().func_75491_a(this.avoidsWater);
    }

    public void func_75246_d() {
        AxisAlignedBB aabb;
        ItemStack heldItem;
        this.theOwner.func_70671_ap().func_75651_a((Entity)this.entityTarget, 30.0f, 30.0f);
        if (this.theOwner.field_70153_n != null && this.theOwner.field_70153_n instanceof EntityLiving) {
            ((EntityLiving)this.theOwner.field_70153_n).field_70177_z = this.theOwner.field_70177_z;
            ((EntityLiving)this.theOwner.field_70153_n).field_70759_as = this.theOwner.field_70759_as;
        }
        if ((this.sightNotRequired || this.theOwner.func_70635_at().func_75522_a((Entity)this.entityTarget)) && --this.pathCheckTimer <= 0) {
            this.pathCheckTimer = 10 + this.theOwner.func_70681_au().nextInt(10);
            PathEntity path = this.getPathEntity();
            if (path != null) {
                this.theOwner.func_70661_as().func_75484_a(path, this.moveSpeed);
            }
        }
        if ((heldItem = this.theOwner.func_71124_b(0)) != null && heldItem.func_77973_b() instanceof LOTRItemSpear) {
            double d = this.theOwner.func_70032_d((Entity)this.entityTarget);
            double range = this.theOwner.func_70661_as().func_111269_d();
            if (d > 4.0 && d < range * 0.75) {
                LOTREntitySpear spear = new LOTREntitySpear(this.worldObj, (EntityLivingBase)this.theOwner, this.entityTarget, heldItem.func_77973_b(), 0, 0.75f + (float)d * 0.025f, 0.5f);
                this.worldObj.func_72956_a((Entity)this.theOwner, "random.bow", 1.0f, 1.0f / (this.worldObj.field_73012_v.nextFloat() * 0.4f + 1.2f) + 0.25f);
                this.theOwner.func_70062_b(0, new ItemStack(this.spearReplacement));
                this.worldObj.func_72838_d((Entity)spear);
                return;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        float f = this.rangeFactor;
        if (this.theOwner.field_70154_o != null) {
            f *= 1.5f;
        }
        if ((aabb = this.theOwner.field_70121_D.func_72329_c().func_72314_b((double)f, (double)f, (double)f)).func_72326_a(this.entityTarget.field_70121_D) && this.attackTick <= 0) {
            this.attackTick = 20;
            this.theOwner.func_70652_k((Entity)this.entityTarget);
            this.theOwner.func_71038_i();
        }
    }

    private PathEntity getPathEntity() {
        if (this.theOwner.field_70154_o != null) {
            return this.worldObj.func_72865_a((Entity)this.theOwner, (Entity)this.entityTarget, this.theOwner.func_70661_as().func_111269_d(), true, this.theOwner.func_70661_as().func_75507_c(), this.theOwner.func_70661_as().func_75486_a(), false);
        }
        return this.theOwner.func_70661_as().func_75494_a((Entity)this.entityTarget);
    }
}

