/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.ArrayList;
import java.util.Random;
import lotr.common.LOTRReflection;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class LOTREntityAIFarm
extends EntityAIBase {
    private static int HOEING = 0;
    private static int PLANTING = 1;
    private static int HARVESTING = 2;
    private LOTREntityNPC theEntity;
    private World theWorld;
    private double moveSpeed;
    public IPlantable defaultSeedsItem;
    private int action;
    private double xPos;
    private double yPos;
    private double zPos;
    private int pathingTick;
    private int rePathDelay;
    private boolean harvestingSolidBlock;

    public LOTREntityAIFarm(LOTREntityNPC npc, double d, IPlantable item) {
        this.theEntity = npc;
        this.theWorld = npc.field_70170_p;
        this.moveSpeed = d;
        this.defaultSeedsItem = item;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.theEntity.hiredNPCInfo.isActive && !this.theEntity.hiredNPCInfo.isGuardMode()) {
            return false;
        }
        if (this.theEntity.func_70681_au().nextInt(20) == 0) {
            Vec3 hoeTarget = this.findTarget(HOEING);
            if (hoeTarget != null) {
                this.xPos = hoeTarget.field_72450_a;
                this.yPos = hoeTarget.field_72448_b;
                this.zPos = hoeTarget.field_72449_c;
                this.action = HOEING;
                return true;
            }
            if (!this.theEntity.hiredNPCInfo.isActive || this.hasSeeds()) {
                Vec3 harvestTarget;
                Vec3 plantTarget = this.findTarget(PLANTING);
                if (plantTarget != null) {
                    this.xPos = plantTarget.field_72450_a;
                    this.yPos = plantTarget.field_72448_b;
                    this.zPos = plantTarget.field_72449_c;
                    this.action = PLANTING;
                    return true;
                }
                if (this.theEntity.hiredNPCInfo.isActive && this.hasSpaceForCrops() && this.getCropForSeed(this.getSeedsToPlant()) != null && (harvestTarget = this.findTarget(HARVESTING)) != null) {
                    this.xPos = harvestTarget.field_72450_a;
                    this.yPos = harvestTarget.field_72448_b;
                    this.zPos = harvestTarget.field_72449_c;
                    this.action = HARVESTING;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSeeds() {
        if (this.theEntity.hiredNPCInfo.getHiredInventory() == null) {
            return false;
        }
        ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
        return itemstack != null && itemstack.func_77973_b() instanceof IPlantable && ((IPlantable)itemstack.func_77973_b()).getPlantType((IBlockAccess)this.theWorld, -1, -1, -1) == EnumPlantType.Crop;
    }

    private IPlantable getSeedsToPlant() {
        if (this.hasSeeds()) {
            return (IPlantable)this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0).func_77973_b();
        }
        return this.defaultSeedsItem;
    }

    private boolean hasSpaceForCrops() {
        if (this.theEntity.hiredNPCInfo.getHiredInventory() == null) {
            return false;
        }
        for (int l = 1; l <= 2; ++l) {
            ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
            if (itemstack != null && (itemstack.field_77994_a >= itemstack.func_77976_d() || !itemstack.func_77969_a(this.getCropForSeed(this.getSeedsToPlant())))) continue;
            return true;
        }
        return false;
    }

    private ItemStack getCropForSeed(IPlantable seed) {
        Block block = seed.getPlant((IBlockAccess)this.theWorld, -1, -1, -1);
        if (block instanceof BlockCrops) {
            return new ItemStack(LOTRReflection.getCropItem((BlockCrops)block));
        }
        if (block instanceof BlockStem) {
            return new ItemStack(LOTRReflection.getStemFruitBlock((BlockStem)block).func_149650_a(0, this.theWorld.field_73012_v, 0), 1, 0);
        }
        return null;
    }

    public boolean func_75253_b() {
        if (this.theEntity.hiredNPCInfo.isActive && !this.theEntity.hiredNPCInfo.isGuardMode()) {
            return false;
        }
        if (this.pathingTick < 200) {
            int i = MathHelper.func_76128_c((double)this.xPos);
            int j = MathHelper.func_76128_c((double)this.yPos);
            int k = MathHelper.func_76128_c((double)this.zPos);
            if (this.action == HOEING) {
                return this.isSuitableForHoeing(i, j, k);
            }
            if (this.action == PLANTING && (!this.theEntity.hiredNPCInfo.isActive || this.hasSeeds())) {
                return this.isSuitableForPlanting(i, j, k);
            }
            if (this.action == HARVESTING && this.theEntity.hiredNPCInfo.isActive && this.hasSeeds() && this.hasSpaceForCrops() && this.getCropForSeed(this.getSeedsToPlant()) != null) {
                return this.isSuitableForHarvesting(i, j, k);
            }
        }
        return false;
    }

    public void func_75251_c() {
        this.pathingTick = 0;
        this.rePathDelay = 0;
        this.action = -1;
        this.harvestingSolidBlock = false;
    }

    public void func_75246_d() {
        if (this.theEntity.func_70092_e(this.xPos, this.yPos, this.zPos) > 4.0) {
            if (this.harvestingSolidBlock) {
                this.theEntity.func_70671_ap().func_75650_a(this.xPos, this.yPos + 0.5, this.zPos, 10.0f, (float)this.theEntity.func_70646_bf());
            } else {
                this.theEntity.func_70671_ap().func_75650_a(this.xPos, this.yPos - 0.5, this.zPos, 10.0f, (float)this.theEntity.func_70646_bf());
            }
            --this.rePathDelay;
            if (this.rePathDelay <= 0) {
                this.rePathDelay = 10;
                if (this.harvestingSolidBlock) {
                    if (!this.theEntity.func_70661_as().func_75492_a(this.xPos, this.yPos + 1.0, this.zPos, this.moveSpeed)) {
                        this.func_75251_c();
                        return;
                    }
                } else if (!this.theEntity.func_70661_as().func_75492_a(this.xPos, this.yPos, this.zPos, this.moveSpeed)) {
                    this.func_75251_c();
                    return;
                }
            }
            ++this.pathingTick;
        } else {
            int i = MathHelper.func_76128_c((double)this.xPos);
            int j = MathHelper.func_76128_c((double)this.yPos);
            int k = MathHelper.func_76128_c((double)this.zPos);
            if (this.action == HOEING && this.isSuitableForHoeing(i, j, k)) {
                this.theEntity.func_71038_i();
                if (this.isReplaceable(i, j + 1, k)) {
                    this.theWorld.func_147468_f(i, j + 1, k);
                }
                Block block = Blocks.field_150458_ak;
                this.theWorld.func_147465_d(i, j, k, block, 0, 3);
                this.theWorld.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            } else if (this.action == PLANTING && this.isSuitableForPlanting(i, j, k)) {
                this.theEntity.func_71038_i();
                IPlantable seed = this.getSeedsToPlant();
                Block plant = seed.getPlant((IBlockAccess)this.theWorld, i, j + 1, k);
                int meta = seed.getPlantMetadata((IBlockAccess)this.theWorld, i, j + 1, k);
                this.theWorld.func_147465_d(i, j + 1, k, plant, meta, 3);
                if (this.theEntity.hiredNPCInfo.isActive) {
                    this.theEntity.hiredNPCInfo.getHiredInventory().func_70298_a(0, 1);
                }
            } else if (this.action == HARVESTING && this.isSuitableForHarvesting(i, j, k)) {
                this.theEntity.func_71038_i();
                Block block = this.theWorld.func_147439_a(i, j + 1, k);
                ArrayList drops = block.getDrops(this.theWorld, i, j + 1, k, this.theWorld.func_72805_g(i, j + 1, k), 0);
                this.theWorld.func_147468_f(i, j + 1, k);
                this.theWorld.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                ItemStack seedItem = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
                ItemStack cropItem = this.getCropForSeed(this.getSeedsToPlant());
                boolean addedOneSeed = false;
                block0: for (Object obj : drops) {
                    ItemStack itemstack;
                    ItemStack drop = (ItemStack)obj;
                    if (drop.func_77969_a(cropItem)) {
                        if (drop.func_77969_a(seedItem) && !addedOneSeed) {
                            addedOneSeed = true;
                            ItemStack itemstack2 = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
                            if (itemstack2.field_77994_a + drop.field_77994_a <= itemstack2.func_77976_d()) {
                                ++itemstack2.field_77994_a;
                                this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(0, itemstack2);
                                continue;
                            }
                        }
                        for (int l = 1; l <= 2; ++l) {
                            ItemStack itemstack3 = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                            if (itemstack3 == null) {
                                this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, drop);
                                continue block0;
                            }
                            if (itemstack3.field_77994_a + drop.field_77994_a > itemstack3.func_77976_d() || !itemstack3.func_77969_a(cropItem)) continue;
                            ++itemstack3.field_77994_a;
                            this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, itemstack3);
                            continue block0;
                        }
                        continue;
                    }
                    if (!drop.func_77969_a(seedItem) || itemstack.field_77994_a + drop.field_77994_a > (itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0)).func_77976_d()) continue;
                    ++itemstack.field_77994_a;
                    this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(0, itemstack);
                }
            }
        }
    }

    private Vec3 findTarget(int targetAction) {
        Random random = this.theEntity.func_70681_au();
        for (int l = 0; l < 32; ++l) {
            boolean flag;
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t) - 8 + random.nextInt(17);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70121_D.field_72338_b) - 4 + random.nextInt(9);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v) - 8 + random.nextInt(17);
            boolean bl = flag = targetAction == HOEING && this.isSuitableForHoeing(i, j, k) || targetAction == PLANTING && this.isSuitableForPlanting(i, j, k) || targetAction == HARVESTING && this.isSuitableForHarvesting(i, j, k);
            if (flag && !this.theEntity.func_110176_b(i, j, k)) {
                flag = false;
            }
            if (flag) {
                if (this.harvestingSolidBlock) {
                    if (this.theEntity.func_70661_as().func_75488_a((double)i, (double)(j + 2), (double)k) == null) {
                        flag = false;
                    }
                } else if (this.theEntity.func_70661_as().func_75488_a((double)i, (double)(j + 1), (double)k) == null) {
                    flag = false;
                }
            }
            if (!flag) continue;
            return Vec3.func_72443_a((double)((double)i + 0.5), (double)j, (double)((double)k + 0.5));
        }
        return null;
    }

    private boolean isSuitableForHoeing(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        Block block = this.theWorld.func_147439_a(i, j, k);
        if ((block == Blocks.field_150346_d || block == Blocks.field_150349_c) && this.isReplaceable(i, j + 1, k)) {
            for (int i1 = i - 4; i1 <= i + 4; ++i1) {
                for (int k1 = k - 4; k1 <= k + 4; ++k1) {
                    if (this.theWorld.func_147439_a(i1, j, k1).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSuitableForPlanting(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        return this.theWorld.func_147439_a(i, j, k) == Blocks.field_150458_ak && this.theWorld.func_72805_g(i, j, k) > 0 && this.isReplaceable(i, j + 1, k);
    }

    private boolean isSuitableForHarvesting(int i, int j, int k) {
        if (this.hasSeeds()) {
            IPlantable seed = this.getSeedsToPlant();
            Block block = seed.getPlant((IBlockAccess)this.theWorld, i, j + 1, k);
            if (block instanceof BlockCrops) {
                this.harvestingSolidBlock = false;
                return this.theWorld.func_147439_a(i, j + 1, k) == block && this.theWorld.func_72805_g(i, j + 1, k) >= 7;
            }
            if (block instanceof BlockStem) {
                this.harvestingSolidBlock = true;
                return this.theWorld.func_147439_a(i, j + 1, k) == LOTRReflection.getStemFruitBlock((BlockStem)block);
            }
        }
        return false;
    }

    private boolean isReplaceable(int i, int j, int k) {
        Block block = this.theWorld.func_147439_a(i, j, k);
        return !block.func_149688_o().func_76224_d() && block.isReplaceable((IBlockAccess)this.theWorld, i, j, k);
    }
}

