/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.List;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityAINPCMarry
extends EntityAIBase {
    private LOTREntityNPC theNPC;
    private World theWorld;
    private LOTREntityNPC theSpouse;
    private int marryDelay = 0;
    private double moveSpeed;

    public LOTREntityAINPCMarry(LOTREntityNPC npc, double d) {
        this.theNPC = npc;
        this.theWorld = npc.field_70170_p;
        this.moveSpeed = d;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (((Object)((Object)this.theNPC)).getClass() != this.theNPC.familyInfo.marriageEntityClass || this.theNPC.familyInfo.spouseUniqueID != null || this.theNPC.familyInfo.getNPCAge() != 0 || this.theNPC.func_71124_b(4) != null || this.theNPC.func_71124_b(0) == null) {
            return false;
        }
        List list = this.theNPC.field_70170_p.func_72872_a(this.theNPC.familyInfo.marriageEntityClass, this.theNPC.field_70121_D.func_72314_b(16.0, 4.0, 16.0));
        LOTREntityNPC spouse = null;
        double distanceSq = Double.MAX_VALUE;
        for (LOTREntityNPC candidate : list) {
            double d;
            if (!this.theNPC.familyInfo.canMarryNPC(candidate) || !candidate.familyInfo.canMarryNPC(this.theNPC) || !((d = this.theNPC.func_70068_e((Entity)candidate)) <= distanceSq)) continue;
            distanceSq = d;
            spouse = candidate;
        }
        if (spouse == null) {
            return false;
        }
        this.theSpouse = spouse;
        return true;
    }

    public boolean func_75253_b() {
        return this.theSpouse != null && this.theSpouse.func_70089_S() && this.theNPC.familyInfo.canMarryNPC(this.theSpouse) && this.theSpouse.familyInfo.canMarryNPC(this.theNPC);
    }

    public void func_75251_c() {
        this.theSpouse = null;
        this.marryDelay = 0;
    }

    public void func_75246_d() {
        this.theNPC.func_70671_ap().func_75651_a((Entity)this.theSpouse, 10.0f, (float)this.theNPC.func_70646_bf());
        this.theNPC.func_70661_as().func_75497_a((Entity)this.theSpouse, this.moveSpeed);
        ++this.marryDelay;
        if (this.marryDelay % 5 == 0) {
            this.theNPC.spawnHearts();
        }
        if (this.marryDelay >= 60 && this.theNPC.func_70068_e((Entity)this.theSpouse) < 9.0) {
            this.marry();
        }
    }

    private void marry() {
        int maxChildren;
        this.theNPC.familyInfo.spouseUniqueID = this.theSpouse.getPersistentID();
        this.theSpouse.familyInfo.spouseUniqueID = this.theNPC.getPersistentID();
        this.theNPC.func_70062_b(0, null);
        this.theNPC.func_70062_b(4, new ItemStack(this.theNPC.familyInfo.marriageRing));
        this.theSpouse.func_70062_b(0, null);
        this.theSpouse.func_70062_b(4, new ItemStack(this.theNPC.familyInfo.marriageRing));
        this.theNPC.changeNPCNameForMarriage(this.theSpouse);
        this.theSpouse.changeNPCNameForMarriage(this.theNPC);
        this.theNPC.familyInfo.maxChildren = maxChildren = this.theNPC.familyInfo.getRandomMaxChildren();
        this.theSpouse.familyInfo.maxChildren = maxChildren;
        this.theNPC.familyInfo.setMaxBreedingDelay();
        this.theSpouse.familyInfo.setMaxBreedingDelay();
        for (int i = 0; i < 7; ++i) {
            this.theNPC.spawnHearts();
            this.theSpouse.spawnHearts();
        }
        if (this.theNPC.familyInfo.getRingGivingPlayer() != null) {
            LOTRLevelData.addAlignment(this.theNPC.familyInfo.getRingGivingPlayer(), LOTRAlignmentValues.MARRIAGE_BONUS, this.theNPC.getFaction(), (Entity)this.theNPC);
            if (this.theNPC.familyInfo.marriageAchievement != null) {
                LOTRLevelData.addAchievement(this.theNPC.familyInfo.getRingGivingPlayer(), this.theNPC.familyInfo.marriageAchievement);
            }
        }
        if (this.theSpouse.familyInfo.getRingGivingPlayer() != null) {
            LOTRLevelData.addAlignment(this.theSpouse.familyInfo.getRingGivingPlayer(), LOTRAlignmentValues.MARRIAGE_BONUS, this.theSpouse.getFaction(), (Entity)this.theSpouse);
            if (this.theSpouse.familyInfo.marriageAchievement != null) {
                LOTRLevelData.addAchievement(this.theSpouse.familyInfo.getRingGivingPlayer(), this.theSpouse.familyInfo.marriageAchievement);
            }
        }
        this.theWorld.func_72838_d((Entity)new EntityXPOrb(this.theWorld, this.theNPC.field_70165_t, this.theNPC.field_70163_u, this.theNPC.field_70161_v, this.theNPC.func_70681_au().nextInt(8) + 2));
    }
}

