/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityTraderRespawn
extends Entity {
    private static int MAX_SCALE = 40;
    private int timeUntilSpawn;
    private int prevBobbingTime;
    private int bobbingTime;
    private String traderClassID;
    private boolean traderHasHome;
    private int traderHomeX;
    private int traderHomeY;
    private int traderHomeZ;
    private float traderHomeRadius;
    private String traderLocationName;

    public LOTREntityTraderRespawn(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public int getScale() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setScale(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    public boolean isSpawnImminent() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setSpawnImminent() {
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Scale", this.getScale());
        nbt.func_74768_a("TimeUntilSpawn", this.timeUntilSpawn);
        nbt.func_74778_a("TraderClassID", this.traderClassID);
        nbt.func_74757_a("TraderHasHome", this.traderHasHome);
        nbt.func_74768_a("TraderHomeX", this.traderHomeX);
        nbt.func_74768_a("TraderHomeY", this.traderHomeY);
        nbt.func_74768_a("TraderHomeZ", this.traderHomeZ);
        nbt.func_74776_a("TraderHomeRadius", this.traderHomeRadius);
        if (this.traderLocationName != null) {
            nbt.func_74778_a("TraderLocationName", this.traderLocationName);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.setScale(nbt.func_74762_e("Scale"));
        this.timeUntilSpawn = nbt.func_74762_e("TimeUntilSpawn");
        if (this.timeUntilSpawn <= 1200) {
            this.setSpawnImminent();
        }
        if (nbt.func_150297_b("TraderClassID", 3)) {
            int id = nbt.func_74762_e("TraderClassID");
            this.traderClassID = LOTREntities.getStringFromID(id);
        } else {
            this.traderClassID = nbt.func_74779_i("TraderClassID");
        }
        this.traderHasHome = nbt.func_74767_n("TraderHasHome");
        this.traderHomeX = nbt.func_74762_e("TraderHomeX");
        this.traderHomeY = nbt.func_74762_e("TraderHomeY");
        this.traderHomeZ = nbt.func_74762_e("TraderHomeZ");
        this.traderHomeRadius = nbt.func_74760_g("TraderHomeRadius");
        if (nbt.func_74764_b("TraderLocationName")) {
            this.traderLocationName = nbt.func_74779_i("TraderLocationName");
        }
    }

    public void copyTraderDataFrom(LOTREntityNPC entity) {
        this.traderClassID = LOTREntities.getStringFromClass(((Object)((Object)entity)).getClass());
        this.traderHasHome = entity.func_110175_bO();
        if (this.traderHasHome) {
            ChunkCoordinates home = entity.func_110172_bL();
            this.traderHomeX = home.field_71574_a;
            this.traderHomeY = home.field_71572_b;
            this.traderHomeZ = home.field_71573_c;
            this.traderHomeRadius = entity.func_110174_bM();
        }
        if (entity.getHasSpecificLocationName()) {
            this.traderLocationName = entity.npcLocationName;
        }
    }

    public void onSpawn() {
        this.field_70181_x = 0.25;
        this.timeUntilSpawn = (15 + this.field_70146_Z.nextInt(46)) * 1200;
    }

    public void onBreak() {
        this.field_70170_p.func_72956_a((Entity)this, Blocks.field_150359_w.field_149762_H.func_150495_a(), (Blocks.field_150359_w.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150359_w.field_149762_H.func_150494_d() * 0.8f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 16) {
            for (int l = 0; l < 16; ++l) {
                this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)LOTRMod.silverCoin), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        this.field_70177_z = this.isSpawnImminent() ? (this.field_70177_z += 24.0f) : (this.field_70177_z += 6.0f);
        this.field_70126_B = MathHelper.func_76142_g((float)this.field_70126_B);
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        if (this.getScale() < MAX_SCALE) {
            if (!this.field_70170_p.field_72995_K) {
                this.setScale(this.getScale() + 1);
            }
            this.field_70159_w = 0.0;
            this.field_70181_x *= 0.9;
            this.field_70179_y = 0.0;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isSpawnImminent() && this.timeUntilSpawn <= 1200) {
                this.setSpawnImminent();
            }
            if (this.timeUntilSpawn > 0) {
                --this.timeUntilSpawn;
            } else {
                boolean flag = false;
                Entity entity = EntityList.func_75620_a((String)LOTREntities.getFullEntityName(this.traderClassID), (World)this.field_70170_p);
                if (entity != null && entity instanceof LOTREntityNPC) {
                    LOTREntityNPC trader = (LOTREntityNPC)entity;
                    trader.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    trader.spawnRidingHorse = false;
                    trader.liftSpawnRestrictions = true;
                    this.field_70121_D.func_72317_d(0.0, 100.0, 0.0);
                    if (trader.func_70601_bi()) {
                        trader.liftSpawnRestrictions = false;
                        trader.func_110161_a(null);
                        if (this.traderHasHome) {
                            trader.func_110171_b(this.traderHomeX, this.traderHomeY, this.traderHomeZ, Math.round(this.traderHomeRadius));
                        }
                        if (this.traderLocationName != null) {
                            trader.setSpecificLocationName(this.traderLocationName);
                        }
                        flag = this.field_70170_p.func_72838_d((Entity)trader);
                    }
                    this.field_70121_D.func_72317_d(0.0, -100.0, 0.0);
                }
                if (flag) {
                    this.func_85030_a("random.pop", 1.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
                    this.func_70106_y();
                } else {
                    this.timeUntilSpawn = 60;
                    this.func_70012_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                }
            }
        } else if (this.isSpawnImminent()) {
            this.prevBobbingTime = this.bobbingTime++;
        }
    }

    public float getScaleFloat(float tick) {
        float scale = this.getScale();
        if (scale < (float)MAX_SCALE) {
            scale += tick;
        }
        return scale / (float)MAX_SCALE;
    }

    public float getBobbingOffset(float tick) {
        float f = this.bobbingTime - this.prevBobbingTime;
        return MathHelper.func_76126_a((float)(((float)this.prevBobbingTime + (f *= tick)) / 5.0f)) * 0.25f;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entity) {
    }
}

