/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityBlueDwarf;
import lotr.common.entity.npc.LOTREntityBlueDwarfWarrior;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.entity.npc.LOTRTravellingTraderInfo;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityBlueDwarfMerchant
extends LOTREntityBlueDwarf
implements LOTRTradeable,
LOTRTravellingTrader {
    public LOTRTravellingTraderInfo travellingTraderInfo = new LOTRTravellingTraderInfo(this);

    public LOTREntityBlueDwarfMerchant(World world) {
        super(world);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.BLUE_DWARF_MERCHANT_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.BLUE_DWARF_MERCHANT_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public void startVisiting(EntityPlayer entityplayer) {
        this.travellingTraderInfo.startVisiting(entityplayer);
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return new LOTREntityBlueDwarfWarrior(this.field_70170_p);
    }

    @Override
    public String getDepartureSpeech() {
        return "blueDwarfMerchant_departure";
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.BLUE_DWARF_MERCHANT_BONUS;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.BLUE_DWARF_MERCHANT_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBlueDwarfMerchant);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBlueDwarfMerchant);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return "blueDwarfMerchant_friendly";
        }
        return "blueDwarf_hostile";
    }
}

