/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityBlueDwarf;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityBlueDwarfMiner
extends LOTREntityBlueDwarf
implements LOTRTradeable {
    public LOTREntityBlueDwarfMiner(World world) {
        super(world);
        this.isNPCPersistent = false;
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.BLUE_DWARF_MINER_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.BLUE_DWARF_MINER_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(0, new ItemStack(LOTRMod.pickaxeBlueDwarven));
        return data;
    }

    @Override
    public void onDwarfUpdate() {
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.BLUE_DWARF_MINER_BONUS;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.BLUE_DWARF_MINER_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBlueDwarfMiner);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBlueDwarfMiner);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        if (flag) {
            int rareDropChance = 15 - i * 3;
            if (rareDropChance < 1) {
                rareDropChance = 1;
            }
            if (this.field_70146_Z.nextInt(rareDropChance) == 0) {
                int j = this.field_70146_Z.nextInt(7);
                switch (j) {
                    case 0: {
                        this.func_70099_a(new ItemStack(Blocks.field_150366_p, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                        break;
                    }
                    case 1: {
                        this.func_70099_a(new ItemStack(Blocks.field_150352_o, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                        break;
                    }
                    case 2: {
                        this.func_70099_a(new ItemStack(LOTRMod.oreSilver, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                        break;
                    }
                    case 3: {
                        this.func_70099_a(new ItemStack(Items.field_151100_aR, 3 + this.field_70146_Z.nextInt(7), 4), 0.0f);
                        break;
                    }
                    case 4: {
                        this.func_70099_a(new ItemStack(Items.field_151043_k), 0.0f);
                        break;
                    }
                    case 5: {
                        this.func_70099_a(new ItemStack(LOTRMod.silver), 0.0f);
                        break;
                    }
                    case 6: {
                        this.func_70099_a(new ItemStack(Items.field_151114_aO, 1 + this.field_70146_Z.nextInt(8)), 0.0f);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_70099_a(new ItemStack(LOTRMod.mithrilNugget), 0.0f);
            }
        }
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "blueDwarfMiner_friendly";
            }
            return "blueDwarfMiner_neutral";
        }
        return "blueDwarf_hostile";
    }
}

