/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiomeGenDunland;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityDunlending
extends LOTREntityNPC {
    public LOTREntityDunlending(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.getDunlendingAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.1f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntityRohirrim.class, 0, true));
        this.addTargetTasks(4);
    }

    public EntityAIBase getDunlendingAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.4, false);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)LOTRNames.getRandomRohanName(this.field_70146_Z));
    }

    public String getDunlendingName() {
        return this.field_70180_af.func_75681_e(16);
    }

    public void setDunlendingName(String name) {
        this.field_70180_af.func_75692_b(16, (Object)name);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(8);
        if (i == 0 || i == 1) {
            this.func_70062_b(0, new ItemStack(LOTRMod.dunlendingClub));
        } else if (i == 2 || i == 3) {
            this.func_70062_b(0, new ItemStack(LOTRMod.dunlendingTrident));
        } else if (i == 4) {
            this.func_70062_b(0, new ItemStack(Items.field_151041_m));
        } else if (i == 5) {
            this.func_70062_b(0, new ItemStack(Items.field_151052_q));
        } else if (i == 6) {
            this.func_70062_b(0, new ItemStack(Items.field_151049_t));
        } else if (i == 7) {
            this.func_70062_b(0, new ItemStack(Items.field_151018_J));
        }
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.DUNLAND;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getDunlendingName();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("DunlendingName", this.getDunlendingName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("DunlendingName")) {
            this.setDunlendingName(nbt.func_74779_i("DunlendingName"));
        }
    }

    public boolean func_98052_bS() {
        return true;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        this.dropDunlendingItems(flag, i);
    }

    public void dropDunlendingItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            int j = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
            block9: for (int k = 0; k < j; ++k) {
                int l = this.field_70146_Z.nextInt(9);
                switch (l) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.func_70099_a(LOTRFoods.DUNLENDING.getRandomFood(this.field_70146_Z), 0.0f);
                        continue block9;
                    }
                    case 3: {
                        Item drink = LOTRFoods.DUNLENDING_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                        this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                        continue block9;
                    }
                    case 4: {
                        this.func_70099_a(new ItemStack(Items.field_151116_aA, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                        continue block9;
                    }
                    case 5: {
                        this.func_70099_a(new ItemStack(Items.field_151008_G, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                        continue block9;
                    }
                    case 6: {
                        this.func_70099_a(new ItemStack(Items.field_151145_ak, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                        continue block9;
                    }
                    case 7: {
                        this.func_70099_a(new ItemStack(Items.field_151033_d, 1, this.field_70146_Z.nextInt(40)), 0.0f);
                        continue block9;
                    }
                    case 8: {
                        this.func_70099_a(new ItemStack(Items.field_151055_y, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    }
                }
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killDunlending;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.DUNLENDING_BONUS;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            return biome instanceof LOTRBiomeGenDunland && j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenDunland) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "dunlending_hired";
            }
            return "dunlending_friendly";
        }
        return "dunlending_hostile";
    }
}

