/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.entity.npc.LOTRTravellingTraderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class LOTREntityElvenTrader
extends LOTREntityElf
implements LOTRTradeable,
LOTRTravellingTrader {
    public LOTRTravellingTraderInfo travellingTraderInfo = new LOTRTravellingTraderInfo(this);

    public LOTREntityElvenTrader(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.6, false));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.ELVEN_TRADER_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.ELVEN_TRADER_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public void startVisiting(EntityPlayer entityplayer) {
        this.travellingTraderInfo.startVisiting(entityplayer);
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return new LOTREntityElf(this.field_70170_p);
    }

    @Override
    public String getDepartureSpeech() {
        return "elvenTrader_departure";
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    private int getEatingTick() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setEatingTick(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private int getDrinkingTick() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setDrinkingTick(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    public int func_70658_aO() {
        return 10;
    }

    @Override
    public void onElfUpdate() {
        if (this.func_70089_S()) {
            this.travellingTraderInfo.onUpdate();
            if (!this.field_70170_p.field_72995_K) {
                if (this.travellingTraderInfo.timeUntilDespawn == 0) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)15);
                }
                ItemStack heldItem = this.func_71124_b(0);
                if (this.func_70638_az() != null) {
                    if (heldItem == null || heldItem.func_77973_b() != this.getElfSwordId()) {
                        this.func_70062_b(0, new ItemStack(this.getElfSwordId(), 1, 0));
                        this.setEatingTick(0);
                        this.setDrinkingTick(0);
                        this.weaponChangeCooldown = 20;
                    }
                } else if (heldItem != null && heldItem.func_77973_b() == this.getElfSwordId()) {
                    if (this.weaponChangeCooldown > 0) {
                        --this.weaponChangeCooldown;
                    } else {
                        this.func_70062_b(0, null);
                    }
                }
                if (this.func_110143_aJ() < this.func_110138_aP() && this.func_70638_az() == null && this.field_70146_Z.nextInt(80) == 0 && this.func_71124_b(0) == null) {
                    if (this.field_70146_Z.nextBoolean()) {
                        this.func_70062_b(0, new ItemStack(LOTRMod.lembas));
                        this.setEatingTick(20);
                    } else {
                        this.func_70062_b(0, new ItemStack(LOTRMod.mugMiruvor));
                        this.setDrinkingTick(20);
                    }
                }
            }
            if (this.getEatingTick() > 0) {
                if (this.getEatingTick() % 4 == 0) {
                    ItemStack itemstack = this.func_71124_b(0);
                    if (itemstack != null) {
                        for (int i = 0; i < 5; ++i) {
                            Vec3 vec1 = Vec3.func_72443_a((double)(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1), (double)(Math.random() * 0.1 + 0.1), (double)0.0);
                            vec1.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                            vec1.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                            Vec3 vec2 = Vec3.func_72443_a((double)(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3), (double)((double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3), (double)0.6);
                            vec2.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                            vec2.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                            vec2 = vec2.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                            this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)itemstack.func_77973_b()), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, vec1.field_72450_a, vec1.field_72448_b + 0.05, vec1.field_72449_c);
                        }
                    }
                    this.func_85030_a("random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.setEatingTick(this.getEatingTick() - 1);
                }
                if (this.getEatingTick() == 0) {
                    this.func_70062_b(0, null);
                    this.func_70691_i(10.0f);
                }
            }
            if (this.getDrinkingTick() > 0) {
                if (this.getDrinkingTick() % 4 == 0) {
                    this.func_85030_a("random.drink", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.setDrinkingTick(this.getDrinkingTick() - 1);
                }
                if (this.getDrinkingTick() == 0) {
                    this.func_70062_b(0, null);
                    this.func_70691_i(6.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 200));
                    }
                }
            }
        }
    }

    @Override
    public Item getElfSwordId() {
        return LOTRMod.daggerElven;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.GALADHRIM_TRADER_BONUS;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 5 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        this.travellingTraderInfo.onDeath();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            for (int i = 0; i < 16; ++i) {
                double d = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d3 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                double d4 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                double d5 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                LOTRMod.proxy.spawnParticle("leafGold_" + (30 + this.field_70146_Z.nextInt(30)), d, d1, d2, d3, d4, d5);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.travellingTraderInfo.writeToNBT(nbt);
        nbt.func_74768_a("ElfEating", this.getEatingTick());
        nbt.func_74768_a("ElfDrinking", this.getDrinkingTick());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.travellingTraderInfo.readFromNBT(nbt);
        this.setEatingTick(nbt.func_74762_e("ElfEating"));
        this.setDrinkingTick(nbt.func_74762_e("ElfDrinking"));
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.ELVEN_TRADER_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeElvenTrader);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeElvenTrader);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public boolean shouldRenderHair() {
        return false;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "elvenTrader_friendly";
            }
            return "elvenTrader_neutral";
        }
        return "elvenTrader_hostile";
    }
}

