/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRCommonProxy;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIGollumAvoidEntity;
import lotr.common.entity.ai.LOTREntityAIGollumFishing;
import lotr.common.entity.ai.LOTREntityAIGollumFollowOwner;
import lotr.common.entity.ai.LOTREntityAIGollumPanic;
import lotr.common.entity.ai.LOTREntityAIGollumRemainStill;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.inventory.LOTRInventoryGollum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityGollum
extends LOTREntityNPC {
    private int eatingTick;
    public int prevFishTime = 400;
    public boolean isFishing;
    public LOTRInventoryGollum inventory = new LOTRInventoryGollum(this);
    public static String OWNER_NAME = "CaptainGlobox";

    public LOTREntityGollum(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.2f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIGollumRemainStill(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIGollumPanic(this, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIGollumAvoidEntity(this, LOTREntityOrc.class, 8.0f, 1.2, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIGollumAvoidEntity(this, LOTREntityElf.class, 8.0f, 1.2, 1.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIGollumFishing(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIGollumFollowOwner(this, 1.2, 6.0f, 4.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.1f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.isNPCPersistent = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public String getGollumOwnerName() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setGollumOwnerName(String s) {
        this.field_70180_af.func_75692_b(17, (Object)s);
    }

    public EntityPlayer getGollumOwner() {
        return this.field_70170_p.func_72924_a(this.getGollumOwnerName());
    }

    public boolean isGollumFleeing() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setGollumFleeing(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)(flag ? (byte)1 : 0));
    }

    public boolean isGollumSitting() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public void setGollumSitting(boolean flag) {
        this.field_70180_af.func_75692_b(19, (Object)(flag ? (byte)1 : 0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.inventory.writeToNBT(nbt);
        nbt.func_74778_a("GollumOwnerName", this.getGollumOwnerName());
        nbt.func_74757_a("GollumSitting", this.isGollumSitting());
        nbt.func_74768_a("GollumFishTime", this.prevFishTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.inventory.readFromNBT(nbt);
        this.setGollumOwnerName(nbt.func_74779_i("GollumOwnerName"));
        this.setGollumSitting(nbt.func_74767_n("GollumSitting"));
        this.prevFishTime = nbt.func_74762_e("GollumFishTime");
    }

    @Override
    public void func_70636_d() {
        double d;
        super.func_70636_d();
        if (this.eatingTick > 0) {
            if (this.eatingTick % 4 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            --this.eatingTick;
        }
        if (this.prevFishTime > 0) {
            --this.prevFishTime;
        }
        if (this.isGollumSitting() && !this.field_70170_p.field_72995_K && this.field_70122_E) {
            this.func_70683_ar().func_75660_a();
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) != null && this.getGollumOwner() != null && (d = this.func_70068_e((Entity)this.getGollumOwner())) < 4.0) {
            this.func_70671_ap().func_75651_a((Entity)this.getGollumOwner(), 100.0f, 100.0f);
            this.func_70671_ap().func_75649_a();
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.func_71124_b(0));
            entityitem.field_145804_b = 40;
            float f = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f1 = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w += Math.cos(f1) * (double)(f *= this.field_70146_Z.nextFloat());
            entityitem.field_70181_x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f1) * (double)f;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            this.func_70062_b(0, null);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K && this.getGollumOwner() != null && entityplayer == this.getGollumOwner()) {
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && this.canGollumEat(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a == 0) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                    }
                }
                this.func_70691_i(((ItemFood)itemstack.func_77973_b()).func_150905_g(itemstack));
                this.eatingTick = 20;
                return true;
            }
            if (entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_GOLLUM, this.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
            this.setGollumSitting(!this.isGollumSitting());
            if (this.isGollumSitting()) {
                entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)this, "gollum_stay", this.getGollumOwner()));
            } else {
                entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)this, "gollum_follow", this.getGollumOwner()));
            }
            return true;
        }
        return false;
    }

    private boolean canGollumEat(ItemStack itemstack) {
        if (itemstack.func_77973_b() == Items.field_151115_aP || itemstack.func_77973_b() == Items.field_151101_aQ) {
            return true;
        }
        ItemFood food = (ItemFood)itemstack.func_77973_b();
        return food.func_77845_h();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        if (this.getGollumOwner() != null && damagesource.func_76346_g() == this.getGollumOwner()) {
            f = 0.0f;
            this.getGollumOwner().func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)this, "gollum_hurt", this.getGollumOwner()));
        }
        if (super.func_70097_a(damagesource, f)) {
            this.setGollumSitting(false);
            return true;
        }
        return false;
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K) {
            this.inventory.dropAllItems();
        }
        if (this.getGollumOwner() != null) {
            this.getGollumOwner().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        LOTRLevelData.hasGollum = 0;
        LOTRLevelData.gollumRespawnTime = 12000;
        LOTRLevelData.needsSave = true;
    }

    @Override
    public boolean canDropPouch() {
        return false;
    }

    public String func_70639_aQ() {
        return "lotr:gollum.say";
    }

    public String func_70621_aR() {
        return "lotr:gollum.hurt";
    }

    public String func_70673_aS() {
        return "lotr:gollum.death";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            for (int i = 0; i < 4; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a(this.field_70146_Z.nextBoolean() ? "bubble" : "splash", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
        } else {
            super.func_70103_a(b);
        }
    }
}

