/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIHobbitChildFollowGoodPlayer;
import lotr.common.entity.ai.LOTREntityAINPCAvoidEvilPlayer;
import lotr.common.entity.ai.LOTREntityAINPCFollowParent;
import lotr.common.entity.ai.LOTREntityAINPCFollowSpouse;
import lotr.common.entity.ai.LOTREntityAINPCMarry;
import lotr.common.entity.ai.LOTREntityAINPCMate;
import lotr.common.entity.npc.LOTREntityDarkHuorn;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntitySpiderBase;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.projectile.LOTREntitySmokeRing;
import lotr.common.world.biome.LOTRBiomeGenShire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityHobbit
extends LOTREntityNPC {
    public LOTREntityHobbit(World world) {
        super(world);
        this.func_70105_a(0.45f, 0.9f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityOrc.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityWarg.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityTroll.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntitySpiderBase.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityDarkHuorn.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAINPCAvoidEvilPlayer(this, 8.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIHobbitChildFollowGoodPlayer(this, 12.0f, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAINPCMarry(this, 1.3));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAINPCMate(this, 1.3));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new LOTREntityAINPCFollowParent(this, 1.4));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new LOTREntityAINPCFollowSpouse(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.2f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.familyInfo.marriageEntityClass = LOTREntityHobbit.class;
        this.familyInfo.marriageRing = LOTRMod.hobbitRing;
        this.familyInfo.marriageAlignmentRequired = LOTRAlignmentValues.HOBBIT_MARRY;
        this.familyInfo.marriageAchievement = LOTRAchievement.marryHobbit;
        this.familyInfo.potentialMaxChildren = 4;
        this.familyInfo.timeToMature = 48000;
        this.familyInfo.breedingDelay = 24000;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.familyInfo.setNPCMale(this.field_70146_Z.nextBoolean());
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)LOTRNames.getRandomHobbitName(this.familyInfo.isNPCMale(), this.field_70146_Z));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOBBIT;
    }

    @Override
    public String getNPCName() {
        return this.getHobbitName();
    }

    public boolean func_70650_aV() {
        return true;
    }

    public String getHobbitName() {
        return this.field_70180_af.func_75681_e(19);
    }

    public void setHobbitName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    public int getEatingTick() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setEatingTick(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    public int getDrinkingTick() {
        return this.field_70180_af.func_75683_a(17);
    }

    public void setDrinkingTick(int i) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)i));
    }

    public int getSmokingTick() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setSmokingTick(int i) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)i));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("HobbitEating", (byte)this.getEatingTick());
        nbt.func_74774_a("HobbitDrinking", (byte)this.getDrinkingTick());
        nbt.func_74774_a("HobbitSmoking", (byte)this.getSmokingTick());
        nbt.func_74778_a("HobbitName", this.getHobbitName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setEatingTick(nbt.func_74771_c("HobbitEating"));
        this.setDrinkingTick(nbt.func_74771_c("HobbitDrinking"));
        this.setSmokingTick(nbt.func_74771_c("HobbitSmoking"));
        if (nbt.func_74764_b("HobbitName")) {
            this.setHobbitName(nbt.func_74779_i("HobbitName"));
        }
        if (nbt.func_74764_b("HobbitGender")) {
            this.familyInfo.setNPCMale(nbt.func_74767_n("HobbitGender"));
        }
        if (nbt.func_74764_b("HobbitAge")) {
            this.familyInfo.setNPCAge(nbt.func_74762_e("HobbitAge"));
        }
    }

    @Override
    public void changeNPCNameForMarriage(LOTREntityNPC spouse) {
        if (this.familyInfo.isNPCMale()) {
            LOTRNames.changeHobbitSurnameForMarriage(this, (LOTREntityHobbit)spouse);
        } else if (spouse.familyInfo.isNPCMale()) {
            LOTRNames.changeHobbitSurnameForMarriage((LOTREntityHobbit)spouse, this);
        }
    }

    @Override
    public void createNPCChildName(LOTREntityNPC maleParent, LOTREntityNPC femaleParent) {
        this.setHobbitName(LOTRNames.getRandomHobbitChildNameForParent(this.familyInfo.isNPCMale(), this.field_70146_Z, (LOTREntityHobbit)maleParent));
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.familyInfo.interact(entityplayer)) {
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.onHobbitUpdate();
    }

    public void onHobbitUpdate() {
        if (this.familyInfo.getNPCAge() < 0) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            this.func_70062_b(0, LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z));
            this.setEatingTick(32);
        }
        if (this.getEatingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEatingTick(this.getEatingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getEatingTick() % 4 == 0) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 vec1 = Vec3.func_72443_a((double)(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1), (double)(Math.random() * 0.1 + 0.1), (double)0.0);
                    vec1.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec1.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    Vec3 vec2 = Vec3.func_72443_a((double)(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3), (double)((double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3), (double)0.6);
                    vec2.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec2.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    vec2 = vec2.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)this.func_71124_b(0).func_77973_b()), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, vec1.field_72450_a, vec1.field_72448_b + 0.05, vec1.field_72449_c);
                }
                this.func_85030_a("random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.getEatingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(4.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
            this.func_70062_b(0, new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)));
            this.setDrinkingTick(32);
        }
        if (this.getDrinkingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setDrinkingTick(this.getDrinkingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getDrinkingTick() % 4 == 0) {
                this.func_85030_a("random.drink", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            }
            if (this.getDrinkingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(2.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            this.func_70062_b(0, new ItemStack(LOTRMod.hobbitPipe));
            this.setSmokingTick(32);
        }
        if (this.getSmokingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSmokingTick(this.getSmokingTick() - 1);
            }
            if (this.getSmokingTick() == 0) {
                this.func_70062_b(0, null);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new LOTREntitySmokeRing(this.field_70170_p, (EntityLivingBase)this));
                }
                this.func_85030_a("lotr:item.puff", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_70691_i(2.0f);
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killHobbit;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.HOBBIT_BONUS;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.hobbitBone, 1);
        }
        this.dropHobbitItems(flag, i);
    }

    public void dropHobbitItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block12: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(14);
            switch (j) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.func_70099_a(LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block12;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(Items.field_151007_F, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block12;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(Items.field_151121_aF, 2 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block12;
                }
                case 6: {
                    this.func_70099_a(new ItemStack(Items.field_151122_aG, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block12;
                }
                case 7: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block12;
                }
                case 8: {
                    this.func_70099_a(new ItemStack(Items.field_151017_I, 1, this.field_70146_Z.nextInt(30)), 0.0f);
                    continue block12;
                }
                case 9: {
                    this.func_70099_a(new ItemStack(LOTRMod.hobbitPipe, 1, this.field_70146_Z.nextInt(100)), 0.0f);
                    continue block12;
                }
                case 10: 
                case 11: {
                    this.func_70099_a(new ItemStack(LOTRMod.pipeweed, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block12;
                }
                case 12: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block12;
                }
                case 13: {
                    Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, this.field_70146_Z.nextInt(4)), 0.0f);
                }
            }
        }
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            return biome instanceof LOTRBiomeGenShire && j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenShire) {
            f += 20.0f;
        }
        return f;
    }

    public boolean isConsuming() {
        return this.getEatingTick() > 0 || this.getDrinkingTick() > 0 || this.getSmokingTick() > 0;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return this.func_70631_g_() ? "hobbitChild_friendly" : "hobbit_friendly";
        }
        return this.func_70631_g_() ? "hobbitChild_unfriendly" : "hobbit_unfriendly";
    }

    @Override
    public void onArtificalSpawn() {
        if (((Object)((Object)this)).getClass() == this.familyInfo.marriageEntityClass && this.field_70146_Z.nextInt(10) == 0) {
            this.familyInfo.setChild();
        }
    }
}

