/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityHobbitBartender
extends LOTREntityHobbit
implements LOTRTradeable {
    public LOTREntityHobbitBartender(World world) {
        super(world);
        String name = this.getHobbitName();
        this.npcLocationName = name.endsWith("s") ? name + "' Tavern" : name + "'s Tavern";
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.HOBBIT_BARTENDER_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.HOBBIT_BARTENDER_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public void onHobbitUpdate() {
    }

    @Override
    public void dropHobbitItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block9: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(10);
            switch (j) {
                case 0: 
                case 1: {
                    this.func_70099_a(LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block9;
                }
                case 2: {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl, 2 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block9;
                }
                case 3: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block9;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(LOTRMod.hobbitPipe, 1, this.field_70146_Z.nextInt(100)), 0.0f);
                    continue block9;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(LOTRMod.pipeweed, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block9;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block9;
                }
                case 9: {
                    Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.HOBBIT_BARTENDER_BONUS;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBartender);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeBartender);
        if (itemstack.func_77973_b() == LOTRMod.pipeweedLeaf) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.sellPipeweedLeaf);
        }
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return "hobbitBartender_friendly";
        }
        return "hobbitBartender_unfriendly";
    }
}

