/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.projectile.LOTREntityThrownRock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityMountainTroll
extends LOTREntityTroll
implements IRangedAttackMob {
    public static IAttribute thrownRockDamage = new RangedAttribute("lotr.thrownRockDamage", 5.0, 0.0, 100.0).func_111117_a("LOTR Thrown Rock Damage");
    private EntityAIBase rangedAttackAI = this.getTrollRangedAttackAI();
    private EntityAIBase meleeAttackAI;
    private int weaponChangeCooldown = 0;

    public LOTREntityMountainTroll(World world) {
        super(world);
        this.func_70105_a(2.56f, 5.12f);
    }

    @Override
    public EntityAIBase getTrollAttackAI() {
        this.meleeAttackAI = new LOTREntityAIAttackOnCollide(this, 1.8, false, 0.8f);
        return this.meleeAttackAI;
    }

    protected EntityAIBase getTrollRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.2, 30, 60, 24.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public boolean isThrowingRocks() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setThrowingRocks(boolean flag) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? (byte)1 : 0));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(npcAttackDamage).func_111128_a(7.0);
        this.func_110140_aT().func_111150_b(thrownRockDamage);
    }

    @Override
    protected boolean hasTrollName() {
        return false;
    }

    @Override
    protected boolean canTrollBeTickled(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                if (d < 144.0) {
                    if (this.isThrowingRocks()) {
                        this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                        this.field_70714_bg.func_75776_a(3, this.meleeAttackAI);
                        this.setThrowingRocks(false);
                        this.weaponChangeCooldown = 20;
                    }
                } else if (d < this.getWeaponChangeThresholdRangeSq() && !this.isThrowingRocks()) {
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.field_70714_bg.func_75776_a(3, this.rangedAttackAI);
                    this.setThrowingRocks(true);
                    this.weaponChangeCooldown = 20;
                }
            } else if (this.weaponChangeCooldown > 0) {
                --this.weaponChangeCooldown;
            } else if (this.isThrowingRocks()) {
                this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                this.setThrowingRocks(false);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow template = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, f * 1.5f, 0.5f);
        LOTREntityThrownRock rock = this.getThrownRock();
        rock.func_70012_b(template.field_70165_t, template.field_70163_u, template.field_70161_v, template.field_70177_z, template.field_70125_A);
        rock.field_70159_w = template.field_70159_w;
        rock.field_70181_x = template.field_70181_x + 0.6;
        rock.field_70179_y = template.field_70179_y;
        this.field_70170_p.func_72838_d((Entity)rock);
        this.func_85030_a(this.func_70639_aQ(), this.func_70599_aP(), this.func_70647_i() * 0.75f);
        this.func_71038_i();
    }

    protected LOTREntityThrownRock getThrownRock() {
        LOTREntityThrownRock rock = new LOTREntityThrownRock(this.field_70170_p, (EntityLivingBase)this);
        rock.setDamage((float)this.func_110148_a(thrownRockDamage).func_111126_e());
        return rock;
    }

    @Override
    public void onTrollDeathBySun() {
        this.field_70170_p.func_72956_a((Entity)this, "lotr:troll.transform", this.func_70599_aP(), this.func_70647_i());
        this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        this.func_70106_y();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            super.func_70103_a(b);
            for (int l = 0; l < 64; ++l) {
                LOTRMod.proxy.spawnParticle("largeStone", this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        if (this.field_70146_Z.nextInt(15) == 0) {
            this.func_70099_a(new ItemStack(LOTRMod.trollTotem, 1, this.field_70146_Z.nextInt(3)), 0.0f);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killMountainTroll;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.MOUNTAIN_TROLL_BONUS;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 5 + this.field_70146_Z.nextInt(6);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        return null;
    }
}

