/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIMTCJumpAttack;
import lotr.common.entity.ai.LOTRNPCTargetSelector;
import lotr.common.entity.npc.LOTREntityMountainTroll;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.projectile.LOTREntityThrownRock;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityMountainTrollChieftain
extends LOTREntityMountainTroll
implements IBossDisplayData {
    private static int SPAWN_TIME = 100;
    private int trollDeathTick;
    public boolean jumpAttack;
    private int healAmount;
    private EntityPlayer lastAttackingPlayer;

    public LOTREntityMountainTrollChieftain(World world) {
        super(world);
        this.func_70105_a(3.2f, 6.4f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIMTCJumpAttack(this));
    }

    @Override
    protected EntityAIBase getTrollRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.2, 20, 50, 24.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)-1);
        this.field_70180_af.func_75682_a(24, (Object)2);
    }

    public int getTrollSpawnTick() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setTrollSpawnTick(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public int getHealingEntityID() {
        return this.field_70180_af.func_75679_c(23);
    }

    public void setHealingEntityID(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    public int getTrollArmorLevel() {
        return this.field_70180_af.func_75679_c(24);
    }

    public void setTrollArmorLevel(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    public int func_70658_aO() {
        return 12;
    }

    public float getArmorLevelChanceModifier() {
        int i = 3 - this.getTrollArmorLevel();
        if (i < 1) {
            i = 1;
        }
        return i;
    }

    public float getHealthChanceModifier() {
        float f = 1.0f - this.func_110143_aJ() / this.func_110138_aP();
        return MathHelper.func_76129_c((float)f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(npcAttackDamage).func_111128_a(8.0);
        this.func_110148_a(thrownRockDamage).func_111128_a(8.0);
    }

    public float getSpawningOffset(float f) {
        float f1 = ((float)this.getTrollSpawnTick() + f) / (float)SPAWN_TIME;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        return (1.0f - f1) * -5.0f;
    }

    @Override
    public void func_70636_d() {
        LOTREntityThrownRock rock;
        super.func_70636_d();
        if (this.getTrollSpawnTick() < SPAWN_TIME) {
            if (!this.field_70170_p.field_72995_K) {
                this.setTrollSpawnTick(this.getTrollSpawnTick() + 1);
                if (this.getTrollSpawnTick() == SPAWN_TIME) {
                    this.doJumpAttack();
                }
            } else {
                for (int l = 0; l < 32; ++l) {
                    LOTRMod.proxy.spawnParticle("mtcSpawn", this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + (double)this.getSpawningOffset(0.0f), this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.jumpAttack && this.field_70170_p.func_72820_D() % 5L == 0L && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            int xzRange = MathHelper.func_76123_f((float)(this.field_70130_N / 2.0f * 1.5f));
            int yRange = MathHelper.func_76123_f((float)(this.field_70131_O * 1.5f));
            int xzDist = xzRange * xzRange + xzRange * xzRange;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i1 = i - xzRange; i1 <= i + xzRange; ++i1) {
                for (int j1 = j; j1 <= j + yRange; ++j1) {
                    for (int k1 = k - xzRange; k1 <= k + xzRange; ++k1) {
                        float resistance;
                        Block block;
                        int i2 = i1 - i;
                        int k2 = k1 - k;
                        int dist = i2 * i2 + k2 * k2;
                        if (dist >= xzDist || (block = this.field_70170_p.func_147439_a(i1, j1, k1)) == null || block.func_149688_o().func_76224_d() || !((resistance = block.getExplosionResistance((Entity)this, this.field_70170_p, i1, j1, k1, this.field_70165_t, this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f), this.field_70161_v)) < 2000.0f)) continue;
                        block.func_149690_a(this.field_70170_p, i1, j1, k1, this.field_70170_p.func_72805_g(i1, j1, k1), resistance / 100.0f, 0);
                        this.field_70170_p.func_147468_f(i1, j1, k1);
                    }
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.getTrollArmorLevel() == 0) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.getTrollBurnTime() < 0 && this.trollDeathTick <= 0)) {
            if (this.trollDeathTick == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "lotr:troll.transform", this.func_70599_aP(), this.func_70647_i());
            }
            if (this.trollDeathTick % 5 == 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
            ++this.trollDeathTick;
            this.field_70177_z += 60.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            this.field_70759_as += 60.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            this.field_70125_A += 60.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            this.field_70721_aZ += 60.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            if (this.trollDeathTick >= 200) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() < this.func_110138_aP()) {
            LOTREntityTroll troll;
            List nearbyTrolls;
            float f = this.getHealthChanceModifier();
            f *= 0.02f;
            f *= this.getArmorLevelChanceModifier();
            if (this.field_70146_Z.nextFloat() < f && !(nearbyTrolls = this.field_70170_p.func_72872_a(LOTREntityTroll.class, this.field_70121_D.func_72314_b(24.0, 8.0, 24.0))).isEmpty() && !((troll = (LOTREntityTroll)((Object)nearbyTrolls.get(this.field_70146_Z.nextInt(nearbyTrolls.size())))) instanceof LOTREntityMountainTrollChieftain) && troll.func_70089_S()) {
                this.setHealingEntityID(troll.func_145782_y());
                this.healAmount = 5 + this.field_70146_Z.nextInt(5);
            }
        }
        if (this.getHealingEntityID() != -1) {
            Entity entity = this.field_70170_p.func_73045_a(this.getHealingEntityID());
            if (entity != null && entity instanceof LOTREntityTroll && entity.func_70089_S()) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70170_p.func_72820_D() % 20L == 0L) {
                        this.func_70691_i(5.0f);
                        entity.func_70097_a(DamageSource.field_76377_j, 5.0f);
                        --this.healAmount;
                        if (!entity.func_70089_S() || this.func_110143_aJ() >= this.func_110138_aP() || this.healAmount <= 0) {
                            this.setHealingEntityID(-1);
                        }
                    }
                } else {
                    double d = entity.field_70165_t;
                    double d1 = entity.field_70163_u + (double)entity.field_70131_O / 2.0;
                    double d2 = entity.field_70161_v;
                    double d3 = this.field_70165_t - d;
                    double d4 = this.field_70163_u + (double)this.field_70131_O / 2.0 - d1;
                    double d5 = this.field_70161_v - d2;
                    LOTRMod.proxy.spawnParticle("mtcHeal", d, d1, d2, d3 /= 30.0, d4 /= 30.0, d5 /= 30.0);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.setHealingEntityID(-1);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextInt(50) == 0 && !this.isThrowingRocks() && (rock = this.getThrownRock()).getSpawnsTroll()) {
            rock.func_70012_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 0.0f, 0.0f);
            rock.field_70159_w = 0.0;
            rock.field_70181_x = 1.5;
            rock.field_70179_y = 0.0;
            this.field_70170_p.func_72838_d((Entity)rock);
            this.func_71038_i();
        }
        if (!this.field_70170_p.field_72995_K && this.lastAttackingPlayer != null && (this.lastAttackingPlayer.field_70163_u - this.field_70163_u > 10.0 || this.func_70068_e((Entity)this.lastAttackingPlayer) > 400.0) && this.field_70122_E) {
            float f = this.getHealthChanceModifier();
            f *= 0.05f;
            f *= this.getArmorLevelChanceModifier();
            if (this.field_70146_Z.nextFloat() < f) {
                this.doJumpAttack();
                this.field_70159_w = this.lastAttackingPlayer.field_70165_t - this.field_70165_t;
                this.field_70181_x = this.lastAttackingPlayer.field_70163_u - this.field_70163_u;
                this.field_70179_y = this.lastAttackingPlayer.field_70161_v - this.field_70161_v;
                this.field_70159_w /= 10.0;
                this.field_70181_x /= 10.0;
                this.field_70179_y /= 10.0;
                if (this.field_70181_x < 1.5) {
                    this.field_70181_x = 1.5;
                }
                this.func_70671_ap().func_75651_a((Entity)this.lastAttackingPlayer, 100.0f, 100.0f);
                this.func_70671_ap().func_75649_a();
                this.field_70177_z = this.field_70759_as;
            }
        }
        if (this.lastAttackingPlayer != null && (!this.lastAttackingPlayer.func_70089_S() || this.lastAttackingPlayer.field_71075_bZ.field_75098_d)) {
            this.lastAttackingPlayer = null;
        }
    }

    protected boolean func_70610_aX() {
        if (this.getTrollSpawnTick() < SPAWN_TIME || this.trollDeathTick > 0) {
            return true;
        }
        return super.func_70610_aX();
    }

    public void doJumpAttack() {
        this.jumpAttack = true;
        this.field_70181_x = 1.5;
    }

    protected void func_70069_a(float f) {
        if (this.jumpAttack) {
            f = 0.0f;
            this.jumpAttack = false;
            if (!this.field_70170_p.field_72995_K) {
                List enemies = this.getNearbyEnemies();
                float attackDamage = (float)this.func_110148_a(LOTREntityNPC.npcAttackDamage).func_111126_e();
                for (int i = 0; i < enemies.size(); ++i) {
                    EntityLivingBase entity = (EntityLivingBase)enemies.get(i);
                    float strength = 12.0f - this.func_70032_d((Entity)entity) / 3.0f;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (strength /= 12.0f) * attackDamage * 3.0f);
                    float knockback = strength * 3.0f;
                    entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.25 * (double)knockback, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)20);
                this.func_85030_a("lotr:troll.rockSmash", 1.5f, 0.75f);
            }
        }
        super.func_70069_a(f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 20) {
            for (int i = 0; i < 360; i += 2) {
                float angle = (float)Math.toRadians(i);
                double distance = 2.0;
                double d = distance * (double)MathHelper.func_76126_a((float)angle);
                double d1 = distance * (double)MathHelper.func_76134_b((float)angle);
                LOTRMod.proxy.spawnParticle("largeStone", this.field_70165_t + d, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + d1, d * 0.2, 0.2, d1 * 0.2);
            }
        } else if (b == 21) {
            for (int i = 0; i < 64; ++i) {
                LOTRMod.proxy.spawnParticle("mtcArmor", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    public List getNearbyEnemies() {
        ArrayList<EntityPlayer> enemies = new ArrayList<EntityPlayer>();
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(12.0, 6.0, 12.0));
        for (int i = 0; i < players.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)players.get(i);
            if (entityplayer.field_71075_bZ.field_75098_d || LOTRLevelData.getAlignment(entityplayer, LOTRFaction.ANGMAR) >= 0) continue;
            enemies.add(entityplayer);
        }
        enemies.addAll(this.field_70170_p.func_82733_a(EntityLiving.class, this.field_70121_D.func_72314_b(12.0, 6.0, 12.0), (IEntitySelector)new LOTRNPCTargetSelector((EntityLiving)this)));
        return enemies;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("TrollSpawnTick", this.getTrollSpawnTick());
        nbt.func_74768_a("TrollDeathTick", this.trollDeathTick);
        nbt.func_74757_a("JumpAttack", this.jumpAttack);
        nbt.func_74768_a("TrollArmorLevel", this.getTrollArmorLevel());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTrollSpawnTick(nbt.func_74762_e("TrollSpawnTick"));
        this.trollDeathTick = nbt.func_74762_e("TrollDeathTick");
        this.jumpAttack = nbt.func_74767_n("JumpAttack");
        this.setTrollArmorLevel(nbt.func_74762_e("TrollArmorLevel"));
    }

    @Override
    protected LOTREntityThrownRock getThrownRock() {
        LOTREntityThrownRock rock = super.getThrownRock();
        float f = 0.05f;
        List nearbyTrolls = this.field_70170_p.func_72872_a(LOTREntityTroll.class, this.field_70121_D.func_72314_b(24.0, 8.0, 24.0));
        int i = nearbyTrolls.size();
        i = 5 - i;
        f *= (float)i;
        f *= this.getArmorLevelChanceModifier();
        if (this.field_70146_Z.nextFloat() < f) {
            rock.setSpawnsTroll(true);
        }
        return rock;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean flag;
        if (this.getTrollSpawnTick() < SPAWN_TIME || this.trollDeathTick > 0) {
            return false;
        }
        if (LOTRMod.playerSourceOfDamage(damagesource) == null && f > 1.0f) {
            f = 1.0f;
        }
        if ((flag = super.func_70097_a(damagesource, f)) && damagesource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)damagesource.func_76346_g();
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                this.lastAttackingPlayer = entityplayer;
            }
        }
        return flag;
    }

    protected void func_70665_d(DamageSource damagesource, float f) {
        super.func_70665_d(damagesource, f);
        if (!this.field_70170_p.field_72995_K && this.getTrollArmorLevel() > 0 && this.func_110143_aJ() <= 0.0f) {
            this.setTrollArmorLevel(this.getTrollArmorLevel() - 1);
            if (this.getTrollArmorLevel() == 0) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed *= 1.4);
            }
            double maxHealth = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(maxHealth *= 2.0);
            this.func_70606_j(this.func_110138_aP());
            this.field_70170_p.func_72960_a((Entity)this, (byte)21);
        }
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        EntityPlayer entityplayer;
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K && (entityplayer = LOTRMod.playerSourceOfDamage(damagesource)) != null) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.killMountainTrollChieftain);
        }
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        int drops = 3 + this.field_70146_Z.nextInt(4);
        for (int j = 0; j < drops; ++j) {
            this.dropTrollItems(flag, i);
        }
        int bones = 3 + this.field_70146_Z.nextInt(4);
        for (int j = 0; j < bones; ++j) {
            this.func_145779_a(LOTRMod.trollBone, 1);
        }
        int coins = 3 + this.field_70146_Z.nextInt(4);
        for (int j = 0; j < coins; ++j) {
            this.func_145779_a(LOTRMod.silverCoin, 10);
        }
        int valuables = 12 + this.field_70146_Z.nextInt(8);
        InventoryBasic valuableDrops = new InventoryBasic("temp", true, 100);
        LOTRChestContents.fillInventory((IInventory)valuableDrops, this.field_70146_Z, LOTRChestContents.TROLL_HOARD, valuables);
        for (int j = 0; j < valuableDrops.func_70302_i_(); ++j) {
            ItemStack itemstack = valuableDrops.func_70301_a(j);
            if (itemstack == null) continue;
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.MOUNTAIN_TROLL_CHIEFTAIN_BONUS;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 500;
    }
}

