/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.animal.LOTREntityCamel;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiomeGenHarondor;
import lotr.common.world.biome.LOTRBiomeGenNearHarad;
import lotr.common.world.biome.LOTRBiomeGenNearHaradFertile;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityNearHaradrim
extends LOTREntityNPC
implements LOTRBiomeGenNearHarad.ImmuneToHeat {
    public LOTREntityNearHaradrim(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.createHaradrimAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 10.0f, 0.1f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(2);
    }

    public EntityAIBase createHaradrimAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, true).setSpearReplacement(LOTRMod.scimitarNearHarad);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)1);
        this.field_70180_af.func_75682_a(16, (Object)LOTRNames.getRandomNearHaradName(this.isHaradrimMale(), this.field_70146_Z));
    }

    public boolean isHaradrimMale() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    public void setHaradrimMale(boolean flag) {
        this.field_70180_af.func_75692_b(15, (Object)(flag ? (byte)1 : 0));
    }

    public String getHaradName() {
        return this.field_70180_af.func_75681_e(16);
    }

    public void setHaradName(String name) {
        this.field_70180_af.func_75692_b(16, (Object)name);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        return new LOTREntityCamel(this.field_70170_p);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.NEAR_HARAD;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getHaradName();
    }

    @Override
    public String func_70005_c_() {
        if (this.getClass() == LOTREntityNearHaradrim.class) {
            return StatCollector.func_74837_a((String)"entity.lotr.NearHaradrim.entityName", (Object[])new Object[]{this.getNPCName()});
        }
        return super.func_70005_c_();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("HaradrimGender", this.isHaradrimMale());
        nbt.func_74778_a("HaradrimName", this.getHaradName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHaradrimMale(nbt.func_74767_n("HaradrimGender"));
        if (nbt.func_74764_b("HaradrimName")) {
            this.setHaradName(nbt.func_74779_i("HaradrimName"));
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        this.dropHaradrimItems(flag, i);
    }

    protected void dropHaradrimItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block9: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(10);
            switch (j) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.func_70099_a(LOTRFoods.NEAR_HARAD.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block9;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(Items.field_151007_F, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block9;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(Items.field_151121_aF, 2 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block9;
                }
                case 6: {
                    this.func_70099_a(new ItemStack(Items.field_151122_aG, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block9;
                }
                case 7: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block9;
                }
                case 8: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block9;
                }
                case 9: {
                    this.func_70099_a(new ItemStack(LOTRMod.mugAraq, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killNearHaradrim;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.NEAR_HARADRIM_BONUS;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
            return j > 62 && (block == Blocks.field_150349_c || block == Blocks.field_150354_m);
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenNearHaradFertile || biome instanceof LOTRBiomeGenHarondor) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return "nearHaradrim_friendly";
        }
        return "nearHaradrim_hostile";
    }
}

