/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetOrc;
import lotr.common.entity.ai.LOTREntityAIOrcAvoidGoodPlayer;
import lotr.common.entity.ai.LOTREntityAIOrcSkirmish;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.item.LOTREntityOrcBomb;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenIronHills;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class LOTREntityOrc
extends LOTREntityNPC {
    public boolean isWeakOrc = true;
    public boolean isBombardier = false;
    public boolean hasSkullStaff = false;
    private int orcSkirmishTick;

    public LOTREntityOrc(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.55f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityOrcBomb.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIOrcAvoidGoodPlayer(this, 8.0f, 1.5));
        this.field_70714_bg.func_75776_a(4, this.getOrcAttackAI());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.1f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(4, LOTREntityAINearestAttackableTargetOrc.class);
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new LOTREntityAIOrcSkirmish(this, true));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new LOTREntityAINearestAttackableTargetOrc(this, LOTREntityRabbit.class, 2000, false));
        this.spawnsInDarkness = true;
    }

    public abstract EntityAIBase getOrcAttackAI();

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)LOTRNames.getRandomOrcName(this.field_70146_Z));
    }

    public String getOrcName() {
        return this.field_70180_af.func_75681_e(16);
    }

    public void setOrcName(String name) {
        this.field_70180_af.func_75692_b(16, (Object)name);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        return data;
    }

    public int func_70658_aO() {
        if (this.isWeakOrc) {
            return MathHelper.func_76128_c((double)((double)super.func_70658_aO() * 0.75));
        }
        return super.func_70658_aO();
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getOrcName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWeakOrc) {
            boolean flag;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            boolean bl = flag = this.field_70170_p.func_72935_r() && this.field_70170_p.func_72937_j(i, j, k);
            if (biome instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
                flag = false;
            }
            if (flag && this.field_70170_p.func_72820_D() % 20L == 0L) {
                this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, -1));
                this.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isOrcSkirmishing()) {
            if (!(this.func_70638_az() instanceof LOTREntityOrc)) {
                --this.orcSkirmishTick;
            }
            if (!this.field_70170_p.func_82736_K().func_82766_b("enableOrcSkirmish")) {
                this.orcSkirmishTick = 0;
            }
        }
    }

    public boolean isOrcSkirmishing() {
        return this.orcSkirmishTick > 0;
    }

    public void setOrcSkirmishing() {
        int prevSkirmishTick = this.orcSkirmishTick;
        this.orcSkirmishTick = 160;
        if (!this.field_70170_p.field_72995_K && prevSkirmishTick == 0) {
            List nearbyPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(24.0, 24.0, 24.0));
            for (int i = 0; i < nearbyPlayers.size(); ++i) {
                EntityPlayer entityplayer = (EntityPlayer)nearbyPlayers.get(i);
                entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)this, "orc_skirmish", entityplayer));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("OrcName", this.getOrcName());
        nbt.func_74768_a("OrcSkirmish", this.orcSkirmishTick);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("OrcName")) {
            this.setOrcName(nbt.func_74779_i("OrcName"));
        }
        this.orcSkirmishTick = nbt.func_74762_e("OrcSkirmish");
    }

    protected void orcArrowAttack(EntityLivingBase target, float f) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.5f, 1.0f);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killOrc;
    }

    public boolean func_98052_bS() {
        return !(this instanceof IRangedAttackMob);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int k;
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.orcBone, 1);
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            j = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(LOTRMod.maggotyBread, 1);
            }
        }
        if (flag) {
            int rareDropChance = 20 - i * 4;
            if (rareDropChance < 1) {
                rareDropChance = 1;
            }
            if (this.field_70146_Z.nextInt(rareDropChance) == 0) {
                int drop = this.field_70146_Z.nextInt(2);
                if (drop == 0) {
                    this.func_70099_a(new ItemStack(LOTRMod.mugOrcDraught, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                } else if (drop == 1) {
                    j = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
                    for (int k2 = 0; k2 < j; ++k2) {
                        if (this instanceof LOTREntityUrukHai) {
                            this.func_145779_a(LOTRMod.urukSteel, 1);
                            continue;
                        }
                        this.func_145779_a(LOTRMod.orcSteel, 1);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (!this.liftSpawnRestrictions) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            if (biome instanceof LOTRBiomeGenIronHills && this.field_70170_p.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
                return false;
            }
        }
        return super.func_70601_bi();
    }

    public int getBombStrength() {
        return 0;
    }

    public void setBombStrength(int i) {
    }

    protected String func_70639_aQ() {
        return "lotr:orc.say";
    }

    protected String func_70621_aR() {
        return "lotr:orc.hurt";
    }

    protected String func_70673_aS() {
        return "lotr:orc.death";
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "orc_hired";
            }
            if (LOTRLevelData.getAlignment(entityplayer, this.getFaction()) <= LOTRAlignmentValues.ORC_FRIENDLY) {
                return "orc_friendly";
            }
            return "orc_neutral";
        }
        return "orc_hostile";
    }

    public boolean renderOrcSkullStaff() {
        return this.hasSkullStaff && this.func_71124_b(0) == null;
    }
}

