/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.biome.LOTRBiomeGenFangorn;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeHooks;

public abstract class LOTREntityTree
extends LOTREntityNPC {
    public static Block[] WOOD_BLOCKS = new Block[]{Blocks.field_150364_r, LOTRMod.wood2, Blocks.field_150364_r};
    public static Block[] LEAF_BLOCKS = new Block[]{Blocks.field_150362_t, LOTRMod.leaves2, Blocks.field_150362_t};
    public static int[] WOOD_META = new int[]{0, 1, 2};
    public static int[] LEAF_META = new int[]{0, 1, 2};
    public static String[] TYPES = new String[]{"oak", "beech", "birch"};

    public LOTREntityTree(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        if (this.field_70146_Z.nextInt(9) == 0) {
            this.setTreeType(2);
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.setTreeType(1);
        } else {
            this.setTreeType(0);
        }
    }

    public int getTreeType() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setTreeType(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("EntType", (byte)this.getTreeType());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTreeType(nbt.func_74771_c("EntType"));
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public void func_70624_b(EntityLivingBase entity) {
        if (entity instanceof LOTREntityTree) {
            return;
        }
        super.func_70624_b(entity);
    }

    public void func_70653_a(Entity entity, float f, double d, double d1) {
        super.func_70653_a(entity, f, d, d1);
        this.field_70159_w /= 2.0;
        this.field_70181_x /= 2.0;
        this.field_70179_y /= 2.0;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        ItemStack itemstack;
        if (damagesource.func_76347_k()) {
            f *= 2.0f;
        } else if (damagesource.func_76346_g() instanceof EntityLivingBase && (itemstack = ((EntityLivingBase)damagesource.func_76346_g()).func_70694_bm()) != null && ForgeHooks.canToolHarvestBlock((Block)Blocks.field_150364_r, (int)0, (ItemStack)itemstack)) {
            f *= 2.0f;
        }
        return super.func_70097_a(damagesource, f);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int k;
        int j = 1 + this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(3 * (i + 1));
        for (k = 0; k < j; ++k) {
            int treeType = this.getTreeType();
            if (treeType < 0 || treeType > WOOD_BLOCKS.length) {
                treeType = 0;
            }
            this.func_70099_a(new ItemStack(WOOD_BLOCKS[treeType], 1, WOOD_META[treeType]), 0.0f);
        }
        j = this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(3 * (i + 1));
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151055_y, 1);
        }
    }

    @Override
    public boolean canDropPouch() {
        return false;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c) {
                BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
                return this.isTreeHomeBiome(biome);
            }
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (this.isTreeHomeBiome(biome)) {
            f += 20.0f;
        }
        return f;
    }

    protected boolean isTreeHomeBiome(BiomeGenBase biome) {
        return biome instanceof LOTRBiomeGenFangorn;
    }
}

