/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetWarg;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemWargArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class LOTREntityWarg
extends LOTREntityNPC {
    private int eatingTick;

    public LOTREntityWarg(World world) {
        super(world);
        this.func_70105_a(1.6f, 1.4f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.getWargAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 12.0f, 0.05f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(4, LOTREntityAINearestAttackableTargetWarg.class);
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new LOTREntityAINearestAttackableTargetWarg(this, LOTREntityRabbit.class, 500, false));
        this.isImmuneToFrost = true;
        this.spawnsInDarkness = true;
    }

    public EntityAIBase getWargAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.8, false, 0.7f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        if (this.field_70146_Z.nextInt(500) == 0) {
            this.setWargType(3);
        } else if (this.field_70146_Z.nextInt(20) == 0) {
            this.setWargType(2);
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.setWargType(1);
        } else {
            this.setWargType(0);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(18 + this.field_70146_Z.nextInt(13)));
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(npcAttackDamage).func_111128_a(3.0 + (double)this.field_70146_Z.nextInt(3));
    }

    public boolean getSaddled() {
        return (this.field_70180_af.func_75683_a(17) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.field_70180_af.func_75692_b(17, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(17, (Object)0);
        }
    }

    public int getWargType() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setWargType(int i) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)i));
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public IEntityLivingData initCreatureForHire(IEntityLivingData data) {
        data = super.func_110161_a(data);
        return data;
    }

    public abstract LOTREntityNPC createWargRider();

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        if (!this.field_70170_p.field_72995_K && this.canWargBeRidden() && this.field_70146_Z.nextInt(3) == 0) {
            LOTREntityNPC rider = this.createWargRider();
            rider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            rider.func_110161_a(null);
            rider.isNPCPersistent = this.isNPCPersistent;
            this.field_70170_p.func_72838_d((Entity)rider);
            rider.func_70078_a((Entity)this);
        }
        return data;
    }

    public boolean canWargBeRidden() {
        return true;
    }

    public double func_70042_X() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (double)this.field_70131_O * 0.95;
        }
        if (this.field_70153_n instanceof LOTREntityNPC) {
            return (double)this.field_70131_O * 0.55;
        }
        return super.func_70042_X();
    }

    public void func_70612_e(float f, float f1) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.canWargBeRidden() && this.getSaddled()) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            f = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            f1 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(f, f1);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(f, f1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Saddled", this.getSaddled());
        nbt.func_74774_a("WargType", (byte)this.getWargType());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSaddled(nbt.func_74767_n("Saddled"));
        this.setWargType(nbt.func_74771_c("WargType"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.func_70089_S()) {
                this.func_70691_i(1.0f);
            }
            if (this.field_70153_n instanceof EntityPlayer && LOTRLevelData.getAlignment((EntityPlayer)this.field_70153_n, this.getFaction()) < LOTRAlignmentValues.WARG_RIDE) {
                this.field_70153_n.func_70078_a(null);
            }
        }
        if (this.eatingTick > 0) {
            if (this.eatingTick % 4 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), 0.4f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            --this.eatingTick;
        }
    }

    @Override
    public boolean func_70692_ba() {
        return !this.getSaddled();
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.field_70170_p.field_72995_K || this.hiredNPCInfo.isActive) {
            return false;
        }
        if (this.func_70638_az() != entityplayer) {
            int slot;
            boolean flag = false;
            boolean hasRequiredAlignment = LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.WARG_RIDE;
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (!flag && itemstack != null && itemstack.func_77973_b() instanceof ItemFood && ((ItemFood)itemstack.func_77973_b()).func_77845_h() && this.getSaddled() && this.func_110143_aJ() < this.func_110138_aP()) {
                if (hasRequiredAlignment) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                        if (itemstack.field_77994_a == 0) {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                        }
                    }
                    this.func_70691_i(((ItemFood)itemstack.func_77973_b()).func_150905_g(itemstack));
                    this.eatingTick = 20;
                    return true;
                }
                flag = true;
            }
            if (!flag && itemstack != null && itemstack.func_77973_b() instanceof LOTRItemWargArmor && this.getSaddled() && this.func_71124_b(slot = 4 - ((LOTRItemWargArmor)itemstack.func_77973_b()).armorType) == null) {
                if (hasRequiredAlignment) {
                    this.func_70062_b(slot, itemstack.func_77946_l());
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                    }
                    this.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
                    return true;
                }
                flag = true;
            }
            if (!flag && !this.getSaddled() && this.canWargBeRidden() && this.field_70153_n == null && itemstack != null && itemstack.func_77973_b() == Items.field_151141_av) {
                if (hasRequiredAlignment) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                    }
                    this.setSaddled(true);
                    this.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
                    this.func_70624_b(null);
                    this.func_70661_as().func_75499_g();
                    return true;
                }
                flag = true;
            }
            if (!flag && this.getSaddled() && this.field_70153_n == null) {
                if (hasRequiredAlignment) {
                    entityplayer.func_70078_a((Entity)this);
                    LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.rideWarg);
                    return true;
                }
                flag = true;
            }
            if (flag) {
                LOTRAlignmentValues.notifyAlignmentNotHighEnough(entityplayer, LOTRAlignmentValues.WARG_RIDE, this.getFaction());
                return true;
            }
        }
        return false;
    }

    public int func_70658_aO() {
        int i = 0;
        for (ItemStack itemstack : this.func_70035_c()) {
            if (itemstack == null || !(itemstack.func_77973_b() instanceof LOTRItemWargArmor)) continue;
            int l = ((LOTRItemWargArmor)itemstack.func_77973_b()).damageReduceAmount;
            i += l;
        }
        return i;
    }

    protected void func_70675_k(float f) {
        if ((f /= 4.0f) < 1.0f) {
            f = 1.0f;
        }
        for (int j = 4; j >= 1; --j) {
            if (this.func_71124_b(j) == null || !(this.func_71124_b(j).func_77973_b() instanceof LOTRItemWargArmor)) continue;
            this.func_71124_b(j).func_77972_a((int)f, (EntityLivingBase)this);
            if (this.func_71124_b((int)j).field_77994_a != 0) continue;
            this.func_70062_b(j, null);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int k;
        int j = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.wargFur, 1);
        }
        j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.wargBone, 1);
        }
        if (flag && this.field_70146_Z.nextInt(50) == 0) {
            this.func_70099_a(new ItemStack(LOTRMod.wargskinRug, 1, this.getWargType()), 0.0f);
        }
    }

    @Override
    public boolean canDropPouch() {
        return false;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killWarg;
    }

    public String func_70639_aQ() {
        return "lotr:warg.growl";
    }

    public String func_70621_aR() {
        return "lotr:warg.hurt";
    }

    public String func_70673_aS() {
        return "lotr:warg.death";
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSaddled()) {
                this.setSaddled(false);
                this.func_145779_a(Items.field_151141_av, 1);
            }
            for (int i = 0; i < this.func_70035_c().length; ++i) {
                if (this.func_71124_b(i) == null) continue;
                this.func_70099_a(this.func_71124_b(i), 0.0f);
                this.func_70062_b(i, null);
            }
        }
    }

    public float getTailRotation() {
        float f = (this.func_110138_aP() - this.func_110143_aJ()) / this.func_110138_aP();
        return f * -1.2f;
    }

    @Override
    public boolean func_110164_bC() {
        return this.getSaddled();
    }
}

