/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LOTRFamilyInfo {
    private LOTREntityNPC theEntity;
    public Class marriageEntityClass;
    public Item marriageRing;
    public int marriageAlignmentRequired;
    public LOTRAchievement marriageAchievement;
    public int potentialMaxChildren;
    public int timeToMature;
    public int breedingDelay;
    public UUID spouseUniqueID;
    public int children;
    public int maxChildren;
    public UUID maleParentID;
    public UUID femaleParentID;
    public UUID ringGivingPlayer;

    public LOTRFamilyInfo(LOTREntityNPC npc) {
        this.theEntity = npc;
        this.theEntity.func_70096_w().func_75682_a(25, (Object)0);
        this.theEntity.func_70096_w().func_75682_a(26, (Object)0);
    }

    public int getNPCAge() {
        return this.theEntity.func_70096_w().func_75679_c(25);
    }

    public void setNPCAge(int i) {
        this.theEntity.func_70096_w().func_75692_b(25, (Object)i);
    }

    public boolean isNPCMale() {
        return this.theEntity.func_70096_w().func_75683_a(26) == 1;
    }

    public void setNPCMale(boolean flag) {
        this.theEntity.func_70096_w().func_75692_b(26, (Object)(flag ? (byte)1 : 0));
    }

    public void onUpdate() {
        if (this.getNPCAge() < 0) {
            this.setNPCAge(this.getNPCAge() + 1);
        } else if (this.getNPCAge() > 0) {
            this.setNPCAge(this.getNPCAge() - 1);
        }
    }

    public boolean canMarryNPC(LOTREntityNPC npc) {
        if (((Object)((Object)npc)).getClass() != ((Object)((Object)this.theEntity)).getClass() || npc.familyInfo.spouseUniqueID != null || npc.familyInfo.getNPCAge() != 0 || npc.func_71124_b(4) != null) {
            return false;
        }
        if (npc == this.theEntity || npc.familyInfo.isNPCMale() == this.isNPCMale() || this.maleParentID != null && this.maleParentID == npc.familyInfo.maleParentID || this.femaleParentID != null && this.femaleParentID == npc.familyInfo.femaleParentID) {
            return false;
        }
        ItemStack heldItem = npc.func_71124_b(0);
        return heldItem != null && heldItem.func_77973_b() == this.marriageRing;
    }

    public LOTREntityNPC getSpouse() {
        if (this.spouseUniqueID == null) {
            return null;
        }
        List list = this.theEntity.field_70170_p.func_72872_a(((Object)((Object)this.theEntity)).getClass(), this.theEntity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof LOTREntityNPC) || entity == this.theEntity || !entity.getPersistentID().equals(this.spouseUniqueID)) continue;
            LOTREntityNPC npc = (LOTREntityNPC)entity;
            if (npc.familyInfo.spouseUniqueID == null || !this.theEntity.getPersistentID().equals(npc.familyInfo.spouseUniqueID)) continue;
            return npc;
        }
        return null;
    }

    public LOTREntityNPC getParentToFollow() {
        UUID parentToFollowID = this.isNPCMale() ? this.maleParentID : this.femaleParentID;
        List list = this.theEntity.field_70170_p.func_72872_a(((Object)((Object)this.theEntity)).getClass(), this.theEntity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof LOTREntityNPC) || entity == this.theEntity || parentToFollowID == null || !entity.getPersistentID().equals(parentToFollowID)) continue;
            return (LOTREntityNPC)entity;
        }
        return null;
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.theEntity.hiredNPCInfo.isActive) {
            return false;
        }
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == this.marriageRing && LOTRLevelData.getAlignment(entityplayer, this.theEntity.getFaction()) >= this.marriageAlignmentRequired && ((Object)((Object)this.theEntity)).getClass() == this.marriageEntityClass && this.getNPCAge() == 0 && this.theEntity.func_71124_b(0) == null && this.theEntity.func_71124_b(4) == null && this.spouseUniqueID == null) {
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
            }
            if (!this.theEntity.field_70170_p.field_72995_K) {
                this.theEntity.func_70062_b(0, new ItemStack(this.marriageRing));
                this.ringGivingPlayer = entityplayer.func_110124_au();
            }
            this.theEntity.isNPCPersistent = true;
            return true;
        }
        return false;
    }

    public EntityPlayer getRingGivingPlayer() {
        if (this.ringGivingPlayer != null) {
            for (Object obj : this.theEntity.field_70170_p.field_73010_i) {
                EntityPlayer entityplayer = (EntityPlayer)obj;
                if (!entityplayer.func_110124_au().equals(this.ringGivingPlayer)) continue;
                return entityplayer;
            }
        }
        return null;
    }

    public void setChild() {
        this.setNPCAge(-this.timeToMature);
    }

    public void setMaxBreedingDelay() {
        float f = this.breedingDelay;
        this.setNPCAge((int)(f *= 0.5f + this.theEntity.func_70681_au().nextFloat() * 0.5f));
    }

    public int getRandomMaxChildren() {
        return 1 + this.theEntity.func_70681_au().nextInt(this.potentialMaxChildren);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("NPCAge", this.getNPCAge());
        nbt.func_74757_a("NPCMale", this.isNPCMale());
        if (this.spouseUniqueID != null) {
            nbt.func_74772_a("SpouseUUIDMost", this.spouseUniqueID.getMostSignificantBits());
            nbt.func_74772_a("SpouseUUIDLeast", this.spouseUniqueID.getLeastSignificantBits());
        }
        nbt.func_74768_a("Children", this.children);
        nbt.func_74768_a("MaxChildren", this.maxChildren);
        if (this.maleParentID != null) {
            nbt.func_74772_a("MaleParentUUIDMost", this.maleParentID.getMostSignificantBits());
            nbt.func_74772_a("MaleParentUUIDLeast", this.maleParentID.getLeastSignificantBits());
        }
        if (this.femaleParentID != null) {
            nbt.func_74772_a("FemaleParentUUIDMost", this.femaleParentID.getMostSignificantBits());
            nbt.func_74772_a("FemaleParentUUIDLeast", this.femaleParentID.getLeastSignificantBits());
        }
        if (this.ringGivingPlayer != null) {
            nbt.func_74772_a("RingGivingPlayerUUIDMost", this.ringGivingPlayer.getMostSignificantBits());
            nbt.func_74772_a("RingGivingPlayerUUIDLeast", this.ringGivingPlayer.getLeastSignificantBits());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setNPCAge(nbt.func_74762_e("NPCAge"));
        this.setNPCMale(nbt.func_74767_n("NPCMale"));
        if (nbt.func_74764_b("SpouseUUIDMost") && nbt.func_74764_b("SpouseUUIDLeast")) {
            this.spouseUniqueID = new UUID(nbt.func_74763_f("SpouseUUIDMost"), nbt.func_74763_f("SpouseUUIDLeast"));
        }
        this.children = nbt.func_74762_e("Children");
        this.maxChildren = nbt.func_74762_e("MaxChildren");
        if (nbt.func_74764_b("MaleParentUUIDMost") && nbt.func_74764_b("MaleParentUUIDLeast")) {
            this.maleParentID = new UUID(nbt.func_74763_f("MaleParentUUIDMost"), nbt.func_74763_f("MaleParentUUIDLeast"));
        }
        if (nbt.func_74764_b("FemaleParentUUIDMost") && nbt.func_74764_b("FemaleParentUUIDLeast")) {
            this.femaleParentID = new UUID(nbt.func_74763_f("FemaleParentUUIDMost"), nbt.func_74763_f("FemaleParentUUIDLeast"));
        }
        if (nbt.func_74764_b("RingGivingPlayer")) {
            this.ringGivingPlayer = new UUID(nbt.func_74763_f("RingGivingPlayerUUIDMost"), nbt.func_74763_f("RingGivingPlayerUUIDLeast"));
        }
    }
}

