/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityHobbit;

public class LOTRNames {
    private static Map allNameBanks = new HashMap();

    public static void loadAllNameBanks() {
        HashMap<String, BufferedReader> nameBankNamesAndReaders = new HashMap<String, BufferedReader>();
        ZipFile zip = null;
        try {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)LOTRMod.instance);
            if (mc.getSource().isFile()) {
                zip = new ZipFile(mc.getSource());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    ZipEntry entry = entries.nextElement();
                    String s = entry.getName();
                    if (!s.startsWith(path = "assets/lotr/names/") || !s.endsWith(".txt")) continue;
                    s = s.substring(path.length());
                    int i = s.indexOf(".txt");
                    try {
                        s = s.substring(0, i);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), "utf-8"));
                        nameBankNamesAndReaders.put(s, reader);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load LOTR name bank " + s + "from zip file");
                        e.printStackTrace();
                    }
                }
            } else {
                File nameBankDir = new File(LOTRMod.class.getResource("/assets/lotr/names").toURI());
                for (File file : nameBankDir.listFiles()) {
                    String s = file.getName();
                    int i = s.indexOf(".txt");
                    if (i < 0) {
                        System.out.println("Failed to load LOTR name bank " + s + " from MCP folder; name bank files must be in .txt format");
                        continue;
                    }
                    try {
                        s = s.substring(0, i);
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                        nameBankNamesAndReaders.put(s, reader);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load LOTR name bank " + s + " from MCP folder");
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to load LOTR name banks");
            e.printStackTrace();
        }
        for (String nameBankName : nameBankNamesAndReaders.keySet()) {
            BufferedReader reader = (BufferedReader)nameBankNamesAndReaders.get(nameBankName);
            try {
                String line;
                ArrayList<String> list = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
                reader.close();
                if (list.isEmpty()) {
                    System.out.println("LOTR name bank " + nameBankName + " is empty!");
                    continue;
                }
                String[] nameBank = new String[list.size()];
                for (int j = 0; j < list.size(); ++j) {
                    nameBank[j] = (String)list.get(j);
                }
                allNameBanks.put(nameBankName, nameBank);
                System.out.println("Succesfully loaded LOTR name bank " + nameBankName);
            }
            catch (Exception e) {
                System.out.println("Failed to load LOTR name bank " + nameBankName);
                e.printStackTrace();
            }
        }
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getRandomName(String nameBankName, Random rand) {
        if (allNameBanks.get(nameBankName) != null && allNameBanks.get(nameBankName) instanceof String[]) {
            String[] nameBank = (String[])allNameBanks.get(nameBankName);
            return nameBank[rand.nextInt(nameBank.length)];
        }
        return "Unnamed";
    }

    public static String getRandomHobbitName(boolean male, Random rand) {
        String name = LOTRNames.getRandomName(male ? "hobbit_male" : "hobbit_female", rand);
        String surname = LOTRNames.getRandomName("hobbit_surnames", rand);
        return name + " " + surname;
    }

    public static String[] getRandomHobbitCoupleNames(Random rand) {
        String[] names = new String[2];
        String surname = LOTRNames.getRandomName("hobbit_surnames", rand);
        String maleName = LOTRNames.getRandomName("hobbit_male", rand);
        String femaleName = LOTRNames.getRandomName("hobbit_female", rand);
        names[0] = maleName + " " + surname;
        names[1] = femaleName + " " + surname;
        return names;
    }

    public static String getRandomHobbitChildNameForParent(boolean male, Random rand, LOTREntityHobbit parent) {
        String name = LOTRNames.getRandomName(male ? "hobbit_male" : "hobbit_female", rand);
        String surname = parent.getHobbitName().substring(parent.getHobbitName().indexOf(" ") + 1);
        return name + " " + surname;
    }

    public static void changeHobbitSurnameForMarriage(LOTREntityHobbit maleHobbit, LOTREntityHobbit femaleHobbit) {
        String surname = maleHobbit.getHobbitName().substring(maleHobbit.getHobbitName().indexOf(" ") + 1);
        String femaleFirstName = femaleHobbit.getHobbitName().substring(0, femaleHobbit.getHobbitName().indexOf(" "));
        femaleHobbit.setHobbitName(femaleFirstName + " " + surname);
    }

    public static String[] getRandomHobbitTavernName(Random rand) {
        String prefix = LOTRNames.getRandomName("hobbitTavern_prefixes", rand);
        String suffix = LOTRNames.getRandomName("hobbitTavern_suffixes", rand);
        return new String[]{prefix, suffix};
    }

    public static String getRandomElfName(boolean male, Random rand) {
        String name = LOTRNames.getRandomName(male ? "elf_male" : "elf_female", rand);
        if (rand.nextInt(5) == 0) {
            return name + " " + LOTRNames.getRandomName("elf_titles", rand);
        }
        return name;
    }

    public static String getRandomRohanName(Random rand) {
        String name = LOTRNames.getRandomName("rohan_male", rand);
        return name;
    }

    public static String[] getRandomRohanMeadHallName(Random rand) {
        String prefix = LOTRNames.getRandomName("rohanMeadHall_prefixes", rand);
        String suffix = LOTRNames.getRandomName("rohanMeadHall_suffixes", rand);
        return new String[]{prefix, suffix};
    }

    public static String getRandomEntName(Random rand) {
        String prefix = LOTRNames.getRandomName("ent_prefixes", rand);
        String suffix = LOTRNames.getRandomName("ent_suffixes", rand);
        return prefix + suffix;
    }

    public static String getRandomGondorName(Random rand) {
        String name = LOTRNames.getRandomName("gondor_male", rand);
        return name;
    }

    public static String getRandomDwarfName(boolean male, Random rand) {
        String name = LOTRNames.getRandomName(male ? "dwarf_male" : "dwarf_female", rand);
        String parentName = LOTRNames.getRandomName("dwarf_male", rand);
        return name + (male ? " son of " : " daughter of ") + parentName;
    }

    public static String getRandomDwarfChildNameForParent(boolean male, Random rand, LOTREntityDwarf parent) {
        String name = LOTRNames.getRandomName(male ? "dwarf_male" : "dwarf_female", rand);
        String parentName = parent.getDwarfName();
        parentName = parentName.substring(0, parentName.indexOf(" "));
        return name + (male ? " son of " : " daughter of ") + parentName;
    }

    public static String getRandomOrcName(Random rand) {
        String name = LOTRNames.getRandomName("orc", rand);
        return name;
    }

    public static String getRandomTrollName(Random rand) {
        String name = LOTRNames.getRandomName("troll", rand);
        return name;
    }

    public static String[] getRandomDunlendingTavernName(Random rand) {
        String prefix = LOTRNames.getRandomName("dunlendingTavern_prefixes", rand);
        String suffix = LOTRNames.getRandomName("dunlendingTavern_suffixes", rand);
        return new String[]{prefix, suffix};
    }

    public static String getRandomNearHaradName(boolean male, Random rand) {
        String name = LOTRNames.getRandomName(male ? "nearHaradrim_male" : "nearHaradrim_female", rand);
        return name;
    }
}

