/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.projectile;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LOTREntityGandalfFireball
extends EntityThrowable {
    public int animationTick;

    public LOTREntityGandalfFireball(World world) {
        super(world);
    }

    public LOTREntityGandalfFireball(World world, EntityLivingBase entityliving) {
        super(world, entityliving);
    }

    public LOTREntityGandalfFireball(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public int getFireballAge() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setFireballAge(int age) {
        this.field_70180_af.func_75692_b(16, (Object)age);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("FireballAge", this.getFireballAge());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFireballAge(nbt.func_74762_e("FireballAge"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_72820_D() % 5L == 0L) {
            ++this.animationTick;
            if (this.animationTick >= 4) {
                this.animationTick = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setFireballAge(this.getFireballAge() + 1);
            if (this.getFireballAge() >= 200) {
                this.explode(null);
            }
        }
    }

    protected void func_70184_a(MovingObjectPosition m) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entity;
            if (m.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.explode(null);
            } else if (m.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && this.isEntityVulnerable(entity = m.field_72308_g)) {
                this.explode(entity);
            }
        }
    }

    private void explode(Entity target) {
        List entities;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70170_p.func_72956_a((Entity)this, "lotr:item.gandalfFireball", 4.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        ByteBuf data = Unpooled.buffer();
        data.writeDouble(this.field_70165_t);
        data.writeDouble(this.field_70163_u);
        data.writeDouble(this.field_70161_v);
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.fireball", data);
        MinecraftServer.func_71276_C().func_71203_ab().func_148541_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, this.field_71093_bK, (Packet)packet);
        if (target != null && this.isEntityVulnerable(target)) {
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()), 10.0f);
        }
        if (!(entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0))).isEmpty()) {
            for (int i = 0; i < entities.size(); ++i) {
                float damage;
                EntityLivingBase entity = (EntityLivingBase)entities.get(i);
                if (entity == target || !this.isEntityVulnerable((Entity)entity) || !((damage = 10.0f - this.func_70032_d((Entity)entity) * 0.5f) > 0.0f)) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()), damage);
            }
        }
        this.func_70106_y();
    }

    private boolean isEntityVulnerable(Entity entity) {
        if (entity == this.func_85052_h()) {
            return false;
        }
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return LOTRLevelData.getAlignment((EntityPlayer)entity, LOTRFaction.HIGH_ELF) < 0;
        }
        return LOTRMod.getNPCFaction(entity).isEnemy(LOTRFaction.HIGH_ELF);
    }

    protected float func_70182_d() {
        return 1.5f;
    }

    protected float func_70185_h() {
        return 0.0f;
    }
}

