/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inventory;

import lotr.common.inventory.LOTRContainerPouch;
import lotr.common.item.LOTRItemPouch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LOTRInventoryPouch
extends InventoryBasic {
    private LOTRContainerPouch theContainer;
    private EntityPlayer thePlayer;
    private boolean isTemporary;
    private ItemStack tempPouchItem;

    public LOTRInventoryPouch(EntityPlayer entityplayer, LOTRContainerPouch container) {
        super(entityplayer.field_71071_by.func_70448_g().func_82833_r(), true, LOTRItemPouch.getCapacity(entityplayer.field_71071_by.func_70448_g()));
        this.isTemporary = false;
        this.thePlayer = entityplayer;
        this.theContainer = container;
        if (!this.thePlayer.field_70170_p.field_72995_K) {
            this.loadPouchContents();
        }
    }

    public LOTRInventoryPouch(ItemStack itemstack) {
        super("tempPouch", true, LOTRItemPouch.getCapacity(itemstack));
        this.isTemporary = true;
        this.tempPouchItem = itemstack;
        this.loadPouchContents();
    }

    public ItemStack getPouchItem() {
        if (this.isTemporary) {
            return this.tempPouchItem;
        }
        return this.thePlayer.field_71071_by.func_70448_g();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.isTemporary || !this.thePlayer.field_70170_p.field_72995_K) {
            this.savePouchContents();
        }
    }

    private void loadPouchContents() {
        if (this.getPouchItem().func_77942_o() && this.getPouchItem().func_77978_p().func_74764_b("LOTRPouchData")) {
            NBTTagCompound nbt = this.getPouchItem().func_77978_p().func_74775_l("LOTRPouchData");
            NBTTagList items = nbt.func_150295_c("Items", (int)new NBTTagCompound().func_74732_a());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound itemData = items.func_150305_b(i);
                byte slot = itemData.func_74771_c("Slot");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemData));
            }
        }
        if (!this.isTemporary) {
            this.theContainer.syncPouchItem(this.getPouchItem());
        }
    }

    private void savePouchContents() {
        if (!this.getPouchItem().func_77942_o()) {
            this.getPouchItem().func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound itemData = new NBTTagCompound();
            itemData.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(itemData);
            items.func_74742_a((NBTBase)itemData);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
        this.getPouchItem().func_77978_p().func_74782_a("LOTRPouchData", (NBTBase)nbt);
        if (!this.isTemporary) {
            this.theContainer.syncPouchItem(this.getPouchItem());
        }
    }
}

