/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRReflection;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class LOTRItemMugBrewable
extends Item {
    private static String[] strengthNames = new String[]{"weak", "light", "moderate", "strong", "potent"};
    private static float[] strengths = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 3.0f};
    public IIcon barrelGui_emptyBucketSlotIcon;
    public IIcon barrelGui_emptyMugSlotIcon;
    private float alcoholicity;
    private int foodHealAmount;
    private float foodSaturationAmount;
    private List potionEffects = new ArrayList();
    private int damageAmount;

    public LOTRItemMugBrewable(float f) {
        this.func_77625_d(1);
        this.func_77637_a(LOTRCreativeTabs.tabFood);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.alcoholicity = f;
    }

    public LOTRItemMugBrewable setDrinkStats(int i, float f) {
        this.foodHealAmount = i;
        this.foodSaturationAmount = f;
        return this;
    }

    public LOTRItemMugBrewable addPotionEffect(int i, int j) {
        this.potionEffects.add(new PotionEffect(i, j));
        return this;
    }

    public LOTRItemMugBrewable setDamageAmount(int i) {
        this.damageAmount = i;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        int i = itemstack.func_77960_j();
        if (i < 0 || i >= strengths.length) {
            i = 0;
        }
        list.add(StatCollector.func_74838_a((String)("item.lotr.drink." + strengthNames[i])));
        if (this.alcoholicity > 0.0f) {
            EnumChatFormatting c = EnumChatFormatting.GREEN;
            float f = this.alcoholicity * strengths[i] * 10.0f;
            c = f < 2.0f ? EnumChatFormatting.GREEN : (f < 5.0f ? EnumChatFormatting.YELLOW : (f < 10.0f ? EnumChatFormatting.GOLD : (f < 20.0f ? EnumChatFormatting.RED : EnumChatFormatting.DARK_RED)));
            list.add(c + StatCollector.func_74838_a((String)"item.lotr.drink.alcoholicity") + ": " + String.format("%.2f", Float.valueOf(f)) + "%");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j <= 4; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float f, float f1, float f2) {
        return LOTRMod.mug.func_77648_a(itemstack, entityplayer, world, i, j, k, side, f, f1, f2);
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        return itemstack;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int duration;
        int i = itemstack.func_77960_j();
        if (i < 0 || i >= strengths.length) {
            i = 0;
        }
        float strength = strengths[i];
        if (entityplayer.func_71043_e(false)) {
            entityplayer.func_71024_bL().func_75122_a((int)((float)this.foodHealAmount * strength), this.foodSaturationAmount * strength);
        }
        if (!world.field_72995_K && field_77697_d.nextFloat() < this.alcoholicity * strength && (duration = (int)(60.0f * (1.0f + field_77697_d.nextFloat() * 0.5f) * this.alcoholicity * strength)) >= 1) {
            entityplayer.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 20 * duration));
        }
        if (!world.field_72995_K) {
            for (int i1 = 0; i1 < this.potionEffects.size(); ++i1) {
                PotionEffect effect = (PotionEffect)this.potionEffects.get(i1);
                entityplayer.func_70690_d(new PotionEffect(effect.func_76456_a(), 20 * (int)((float)effect.func_76459_b() * strength)));
            }
        }
        if (this.damageAmount > 0) {
            entityplayer.func_70097_a(DamageSource.field_76376_m, (float)this.damageAmount * strength);
        }
        if (!world.field_72995_K) {
            if (this == LOTRMod.mugOrcDraught) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.drinkOrcDraught);
            }
            if (this == LOTRMod.mugAthelasBrew) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.drinkAthelasBrew);
                for (int l = 0; l < Potion.field_76425_a.length; ++l) {
                    Potion potion = Potion.field_76425_a[l];
                    if (potion == null || !LOTRReflection.isBadEffect(potion)) continue;
                    entityplayer.func_82170_o(potion.field_76415_H);
                }
            }
            if (this == LOTRMod.mugRedWine) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.drinkWine);
            }
            if (this == LOTRMod.mugDwarvenTonic) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.drinkDwarvenTonic);
            }
        }
        return !entityplayer.field_71075_bZ.field_75098_d ? new ItemStack(LOTRMod.mug) : itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        super.func_94581_a(iconregister);
        this.barrelGui_emptyBucketSlotIcon = iconregister.func_94245_a("lotr:barrel_emptyBucketSlot");
        this.barrelGui_emptyMugSlotIcon = iconregister.func_94245_a("lotr:barrel_emptyMugSlot");
    }
}

