/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.world.structure.LOTRStructures;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRItemStructureSpawner
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon baseIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayIcon;
    public static int lastStructureSpawnTick = 0;

    public LOTRItemStructureSpawner() {
        this.func_77627_a(true);
        this.func_77637_a(LOTRCreativeTabs.tabSpawn);
    }

    public String func_77653_i(ItemStack itemstack) {
        String s = ("" + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String structureName = LOTRStructures.getNameFromID(itemstack.func_77960_j());
        if (structureName != null) {
            s = s + " " + StatCollector.func_74838_a((String)("lotr.structure." + structureName + ".name"));
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemstack, int i) {
        LOTRStructures.StructureInfo info = (LOTRStructures.StructureInfo)LOTRStructures.structureSpawners.get(itemstack.func_77960_j());
        return info != null ? (i == 0 ? info.primaryColor : info.secondaryColor) : 0xFFFFFF;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float f, float f1, float f2) {
        if (world.field_72995_K) {
            return true;
        }
        if (LOTRLevelData.structuresBanned == 1) {
            entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.spawnStructure.disabled", new Object[0]));
            return false;
        }
        if (LOTRLevelData.bannedStructurePlayers.contains(entityplayer.func_110124_au())) {
            entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.spawnStructure.banned", new Object[0]));
            return false;
        }
        if (lastStructureSpawnTick > 0) {
            entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.spawnStructure.wait", new Object[]{(double)lastStructureSpawnTick / 20.0}));
            return false;
        }
        if (this.spawnStructure(entityplayer, world, itemstack.func_77960_j(), i += Facing.field_71586_b[side], j += Facing.field_71587_c[side], k += Facing.field_71585_d[side]) && !entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        return true;
    }

    private boolean spawnStructure(EntityPlayer entityplayer, World world, int id, int i, int j, int k) {
        if (!LOTRStructures.structureSpawners.containsKey(id)) {
            return false;
        }
        WorldGenerator generator = LOTRStructures.getStructureFromID(id);
        if (generator != null) {
            boolean generated = false;
            if (generator instanceof LOTRWorldGenStructureBase2) {
                LOTRWorldGenStructureBase2 structureGenerator = (LOTRWorldGenStructureBase2)generator;
                structureGenerator.restrictions = false;
                structureGenerator.usingPlayer = entityplayer;
                generated = structureGenerator.generateWithSetRotation(world, world.field_73012_v, i, j, k, structureGenerator.usingPlayerRotation());
            } else if (generator instanceof LOTRWorldGenStructureBase) {
                ((LOTRWorldGenStructureBase)generator).restrictions = false;
                ((LOTRWorldGenStructureBase)generator).usingPlayer = entityplayer;
                generated = generator.func_76484_a(world, world.field_73012_v, i, j, k);
            }
            if (generated) {
                lastStructureSpawnTick = 20;
                world.func_72956_a((Entity)entityplayer, "lotr:item.structureSpawner", 1.0f, 1.0f);
            }
            return generated;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        return j > 0 ? this.overlayIcon : this.baseIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.baseIcon = iconregister.func_94245_a(this.func_111208_A() + "_base");
        this.overlayIcon = iconregister.func_94245_a(this.func_111208_A() + "_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (LOTRStructures.StructureInfo info : LOTRStructures.structureSpawners.values()) {
            list.add(new ItemStack(item, 1, info.spawnedID));
        }
    }
}

