/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import lotr.common.LOTRMod;
import lotr.common.inventory.LOTRSlotStackSize;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public abstract class LOTRTileEntityAlloyForge
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[13];
    public int forgeSmeltTime = 0;
    public int currentItemFuelValue = 0;
    public int currentSmeltTime = 0;
    private String specialForgeName;
    private int[] inputSlots = new int[]{4, 5, 6, 7};
    private int[] outputSlots = new int[]{8, 9, 10, 11};
    private int[] fuelSlots = new int[]{12};

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.specialForgeName : this.getForgeName();
    }

    public abstract String getForgeName();

    public boolean func_145818_k_() {
        return this.specialForgeName != null && this.specialForgeName.length() > 0;
    }

    public void setSpecialForgeName(String s) {
        this.specialForgeName = s;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList items = nbt.func_150295_c("Items", (int)new NBTTagCompound().func_74732_a());
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemData = items.func_150305_b(i);
            byte byte0 = itemData.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
        this.forgeSmeltTime = nbt.func_74765_d("BurnTime");
        this.currentSmeltTime = nbt.func_74765_d("SmeltTime");
        this.currentItemFuelValue = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[12]);
        if (nbt.func_74764_b("CustomName")) {
            this.specialForgeName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemData = new NBTTagCompound();
            itemData.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemData);
            items.func_74742_a((NBTBase)itemData);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
        nbt.func_74777_a("BurnTime", (short)this.forgeSmeltTime);
        nbt.func_74777_a("SmeltTime", (short)this.currentSmeltTime);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.specialForgeName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmeltProgressScaled(int i) {
        return this.currentSmeltTime * i / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmeltTimeRemainingScaled(int i) {
        if (this.currentItemFuelValue == 0) {
            this.currentItemFuelValue = 200;
        }
        return this.forgeSmeltTime * i / this.currentItemFuelValue;
    }

    public boolean isSmelting() {
        return this.forgeSmeltTime > 0;
    }

    public void func_145845_h() {
        boolean smelting = this.forgeSmeltTime > 0;
        boolean needUpdate = false;
        if (this.forgeSmeltTime > 0) {
            --this.forgeSmeltTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.forgeSmeltTime == 0 && this.canSmeltAnyItem()) {
                this.currentItemFuelValue = this.forgeSmeltTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[12]);
                if (this.forgeSmeltTime > 0) {
                    needUpdate = true;
                    if (this.inventory[12] != null) {
                        --this.inventory[12].field_77994_a;
                        if (this.inventory[12].field_77994_a == 0) {
                            this.inventory[12] = this.inventory[12].func_77973_b().getContainerItem(this.inventory[12]);
                        }
                    }
                }
            }
            if (this.isSmelting() && this.canSmeltAnyItem()) {
                ++this.currentSmeltTime;
                if (this.currentSmeltTime == 200) {
                    this.currentSmeltTime = 0;
                    for (int i = 4; i < 8; ++i) {
                        this.smeltItem(i);
                    }
                    needUpdate = true;
                }
            } else {
                this.currentSmeltTime = 0;
            }
            if (smelting != this.forgeSmeltTime > 0) {
                needUpdate = true;
                this.setForgeActive();
            }
        }
        if (needUpdate) {
            this.func_70296_d();
        }
    }

    public abstract void setForgeActive();

    private boolean canSmeltAnyItem() {
        for (int i = 4; i < 8; ++i) {
            if (!this.canSmelt(i)) continue;
            return true;
        }
        return false;
    }

    private boolean canSmelt(int i) {
        int resultSize;
        ItemStack result;
        if (this.inventory[i] == null) {
            return false;
        }
        if (this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4]) != null) {
            result = this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4]);
            if (this.inventory[i + 4] == null) {
                return true;
            }
            resultSize = this.inventory[i + 4].field_77994_a + result.field_77994_a;
            if (this.inventory[i + 4].func_77969_a(result) && resultSize <= this.func_70297_j_() && resultSize <= result.func_77976_d()) {
                return true;
            }
        }
        if (!this.isSmeltableItem(this.inventory[i])) {
            return false;
        }
        result = this.getSmeltingResult(this.inventory[i]);
        if (this.inventory[i + 4] == null) {
            return true;
        }
        if (!this.inventory[i + 4].func_77969_a(result)) {
            return false;
        }
        resultSize = this.inventory[i + 4].field_77994_a + result.field_77994_a;
        return resultSize <= this.func_70297_j_() && resultSize <= result.func_77976_d();
    }

    public void smeltItem(int i) {
        if (this.canSmelt(i)) {
            if (this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4]) != null && (this.inventory[i + 4] == null || this.inventory[i + 4].func_77969_a(this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4])))) {
                ItemStack result = this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4]);
                if (this.inventory[i + 4] == null) {
                    this.inventory[i + 4] = result.func_77946_l();
                } else if (this.inventory[i + 4].func_77969_a(result)) {
                    this.inventory[i + 4].field_77994_a += result.field_77994_a;
                }
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a <= 0) {
                    this.inventory[i] = null;
                }
                --this.inventory[i - 4].field_77994_a;
                if (this.inventory[i - 4].field_77994_a <= 0) {
                    this.inventory[i - 4] = null;
                }
            } else {
                ItemStack result = this.getSmeltingResult(this.inventory[i]);
                if (this.inventory[i + 4] == null) {
                    this.inventory[i + 4] = result.func_77946_l();
                } else if (this.inventory[i + 4].func_77969_a(result)) {
                    this.inventory[i + 4].field_77994_a += result.field_77994_a;
                }
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a <= 0) {
                    this.inventory[i] = null;
                }
            }
        }
    }

    public boolean isSmeltableItem(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) || itemstack.func_77973_b() == Items.field_151119_aD) {
            return true;
        }
        Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
        if (block != null && block.func_149688_o() == Material.field_151576_e) {
            return this.getSmeltingResult(itemstack) != null;
        }
        return false;
    }

    protected ItemStack getSmeltingResult(ItemStack itemstack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
    }

    protected ItemStack getAlloySmeltingResult(ItemStack itemstack, ItemStack alloyItem) {
        if (alloyItem == null) {
            return null;
        }
        if (this.isCopper(itemstack) && this.isTin(alloyItem) || this.isTin(itemstack) && this.isCopper(alloyItem)) {
            return new ItemStack(LOTRMod.bronze, 2);
        }
        return null;
    }

    protected boolean isCopper(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreCopper") || LOTRMod.isOreNameEqual(itemstack, "ingotCopper");
    }

    protected boolean isTin(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreTin") || LOTRMod.isOreNameEqual(itemstack, "ingotTin");
    }

    protected boolean isIron(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p) || itemstack.func_77973_b() == Items.field_151042_j;
    }

    protected boolean isOrcSteel(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreMorgulIron) || itemstack.func_77973_b() == LOTRMod.orcSteel;
    }

    protected boolean isWood(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "logWood");
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot > 3 && slot < 8) {
            return itemstack == null ? false : this.isSmeltableItem(itemstack);
        }
        if (slot < 12) {
            return false;
        }
        if (slot == 12) {
            return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return this.outputSlots;
        }
        if (side == 1) {
            ArrayList<LOTRSlotStackSize> list = new ArrayList<LOTRSlotStackSize>();
            for (int i = 0; i < this.inputSlots.length; ++i) {
                int slot = this.inputSlots[i];
                int size = this.func_70301_a(slot) == null ? 0 : this.func_70301_a((int)slot).field_77994_a;
                list.add(new LOTRSlotStackSize(slot, size));
            }
            Collections.sort(list);
            int[] temp = new int[this.inputSlots.length];
            for (int i = 0; i < temp.length; ++i) {
                LOTRSlotStackSize obj = (LOTRSlotStackSize)list.get(i);
                temp[i] = obj.slot;
            }
            return temp;
        }
        return this.fuelSlots;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int j) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int i) {
        return i != 0 || slot != 12 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        if (packet.func_148857_g() != null && packet.func_148857_g().func_74764_b("CustomName")) {
            this.specialForgeName = packet.func_148857_g().func_74779_i("CustomName");
        }
    }
}

