/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import lotr.common.recipe.LOTRBrewingRecipes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;

public class LOTRTileEntityBarrel
extends TileEntity
implements IInventory {
    public static int EMPTY = 0;
    public static int BREWING = 1;
    public static int FULL = 2;
    private ItemStack[] inventory = new ItemStack[10];
    public int barrelMode;
    public int brewingTime;
    public int brewingAnimationTick;
    private String specialBarrelName;
    public List players = new ArrayList();

    public ItemStack getMugRefill() {
        if (this.barrelMode == FULL && this.inventory[9] != null) {
            ItemStack itemstack = this.inventory[9].func_77946_l();
            itemstack.field_77994_a = 1;
            return itemstack;
        }
        return null;
    }

    public void consumeMugRefill() {
        if (this.barrelMode == FULL && this.inventory[9] != null) {
            --this.inventory[9].field_77994_a;
            if (this.inventory[9].field_77994_a <= 0) {
                this.inventory[9] = null;
                this.barrelMode = EMPTY;
            }
        }
    }

    private void updateBrewingRecipe() {
        if (this.barrelMode == EMPTY) {
            this.inventory[9] = LOTRBrewingRecipes.findMatchingRecipe(this);
        }
    }

    public void handleBrewingButtonPress() {
        if (this.barrelMode == EMPTY && this.inventory[9] != null) {
            int i;
            this.barrelMode = BREWING;
            for (i = 0; i < 9; ++i) {
                if (this.inventory[i] == null) continue;
                ItemStack containerItem = null;
                if (this.inventory[i].func_77973_b().hasContainerItem(this.inventory[i]) && (containerItem = this.inventory[i].func_77973_b().getContainerItem(this.inventory[i])).func_77984_f() && containerItem.func_77960_j() > containerItem.func_77958_k()) {
                    containerItem = null;
                }
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a > 0) continue;
                this.inventory[i] = null;
                if (containerItem == null) continue;
                this.inventory[i] = containerItem;
            }
            if (!this.field_145850_b.field_72995_K) {
                for (i = 0; i < this.players.size(); ++i) {
                    EntityPlayerMP entityplayer = (EntityPlayerMP)this.players.get(i);
                    entityplayer.field_71070_bA.func_75142_b();
                    entityplayer.func_71120_a(entityplayer.field_71070_bA);
                }
            }
        } else if (this.barrelMode == BREWING && this.inventory[9] != null && this.inventory[9].func_77960_j() > 0) {
            this.barrelMode = FULL;
            this.brewingTime = 0;
            ItemStack itemstack = this.inventory[9].func_77946_l();
            itemstack.func_77964_b(itemstack.func_77960_j() - 1);
            this.inventory[9] = itemstack;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                if (i != 9) {
                    this.updateBrewingRecipe();
                }
                return itemstack;
            }
            ItemStack itemstack = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            if (i != 9) {
                this.updateBrewingRecipe();
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        if (i != 9) {
            this.updateBrewingRecipe();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.specialBarrelName : StatCollector.func_74838_a((String)"container.lotr.barrel");
    }

    public String getInvSubtitle() {
        if (this.barrelMode == EMPTY) {
            return StatCollector.func_74838_a((String)"container.lotr.barrel.empty");
        }
        if (this.barrelMode == BREWING && this.func_70301_a(9) != null) {
            return StatCollector.func_74837_a((String)"container.lotr.barrel.brewing", (Object[])new Object[]{this.func_70301_a(9).func_82833_r()});
        }
        if (this.barrelMode == FULL && this.func_70301_a(9) != null) {
            return this.func_70301_a(9).func_82833_r();
        }
        return "";
    }

    public boolean func_145818_k_() {
        return this.specialBarrelName != null && this.specialBarrelName.length() > 0;
    }

    public void setBarrelName(String s) {
        this.specialBarrelName = s;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList items = nbt.func_150295_c("Items", (int)new NBTTagCompound().func_74732_a());
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemData = items.func_150305_b(i);
            byte byte0 = itemData.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
        this.barrelMode = nbt.func_74771_c("BarrelMode");
        this.brewingTime = nbt.func_74762_e("BrewingTime");
        if (nbt.func_74764_b("CustomName")) {
            this.specialBarrelName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemData = new NBTTagCompound();
            itemData.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemData);
            items.func_74742_a((NBTBase)itemData);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
        nbt.func_74774_a("BarrelMode", (byte)this.barrelMode);
        nbt.func_74768_a("BrewingTime", this.brewingTime);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.specialBarrelName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getBrewProgressScaled(int i) {
        return this.brewingTime * i / 12000;
    }

    public int getBrewAnimationProgressScaled(int i) {
        return (this.brewingAnimationTick + 1) * i / 20;
    }

    public int getBarrelFullAmountScaled(int i) {
        return this.inventory[9] == null ? 0 : this.inventory[9].field_77994_a * i / LOTRBrewingRecipes.BARREL_CAPACITY;
    }

    public void func_145845_h() {
        boolean needUpdate = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.barrelMode == BREWING) {
                if (this.inventory[9] != null) {
                    ++this.brewingTime;
                    if (this.brewingTime >= 12000) {
                        this.brewingTime = 0;
                        if (this.inventory[9].func_77960_j() < 4) {
                            this.inventory[9].func_77964_b(this.inventory[9].func_77960_j() + 1);
                            needUpdate = true;
                        } else {
                            this.barrelMode = FULL;
                        }
                    }
                } else {
                    this.barrelMode = EMPTY;
                }
            } else {
                this.brewingTime = 0;
            }
            if (this.barrelMode == FULL && this.inventory[9] == null) {
                this.barrelMode = EMPTY;
            }
        } else if (this.barrelMode == BREWING) {
            ++this.brewingAnimationTick;
            if (this.brewingAnimationTick >= 20) {
                this.brewingAnimationTick = 0;
            }
        } else {
            this.brewingAnimationTick = 0;
        }
        if (needUpdate) {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }
}

