/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenAngmarMountains;
import lotr.common.world.biome.LOTRBiomeGenBlueMountains;
import lotr.common.world.biome.LOTRBiomeGenGondor;
import lotr.common.world.biome.LOTRBiomeGenGreyMountains;
import lotr.common.world.biome.LOTRBiomeGenHaradMountains;
import lotr.common.world.biome.LOTRBiomeGenIthilien;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import lotr.common.world.biome.LOTRBiomeGenMordor;
import lotr.common.world.biome.LOTRBiomeGenRedMountains;
import lotr.common.world.biome.LOTRBiomeGenRohan;
import lotr.common.world.biome.LOTRBiomeGenTolfalas;
import lotr.common.world.biome.LOTRBiomeGenWhiteMountains;
import lotr.common.world.mapgen.LOTRMapGenCaves;
import lotr.common.world.mapgen.LOTRMapGenRavine;
import lotr.common.world.mapgen.dwarvenmine.LOTRMapGenDwarvenMine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenStructure;

public class LOTRChunkProvider
implements IChunkProvider {
    private World worldObj;
    private Random rand;
    private BiomeGenBase[] biomesForGeneration;
    private static double COORDINATE_SCALE = 684.412;
    private static double HEIGHT_SCALE = 1.0;
    private static double MAIN_NOISE_SCALE_XZ = 400.0;
    private static double MAIN_NOISE_SCALE_Y = 5000.0;
    private static double DEPTH_NOISE_SCALE = 200.0;
    private static double DEPTH_NOISE_EXP = 0.5;
    private static double HEIGHT_STRETCH = 6.0;
    private static double UPPER_LIMIT_SCALE = 512.0;
    private static double LOWER_LIMIT_SCALE = 512.0;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorOctaves stoneNoiseGen;
    private double[] noise1;
    private double[] noise2;
    private double[] noise3;
    private double[] noise5;
    private double[] noise6;
    private double[] stoneNoise = new double[256];
    private double[] heightNoise;
    private float[] biomeHeightNoise;
    private int[][] unusedIntArray = new int[32][32];
    private MapGenBase caveGenerator = new LOTRMapGenCaves();
    private MapGenBase ravineGenerator = new LOTRMapGenRavine();
    private MapGenStructure dwarvenMineGenerator = new LOTRMapGenDwarvenMine();

    public LOTRChunkProvider(World world, long l) {
        this.worldObj = world;
        this.rand = new Random(l);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.stoneNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
    }

    private void generateTerrain(int i, int j, Block[] blocks) {
        int byte0 = 4;
        int byte1 = 32;
        int byte2 = 63;
        int k = byte0 + 1;
        int byte3 = 33;
        int l = byte0 + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, i * 4 - 2, j * 4 - 2, k + 5, l + 5);
        this.heightNoise = this.initializeHeightNoise(this.heightNoise, i * byte0, 0, j * byte0, k, byte3, l);
        for (int i1 = 0; i1 < byte0; ++i1) {
            for (int j1 = 0; j1 < byte0; ++j1) {
                for (int k1 = 0; k1 < byte1; ++k1) {
                    double d = 0.125;
                    double d1 = this.heightNoise[((i1 + 0) * l + j1 + 0) * byte3 + k1 + 0];
                    double d2 = this.heightNoise[((i1 + 0) * l + j1 + 1) * byte3 + k1 + 0];
                    double d3 = this.heightNoise[((i1 + 1) * l + j1 + 0) * byte3 + k1 + 0];
                    double d4 = this.heightNoise[((i1 + 1) * l + j1 + 1) * byte3 + k1 + 0];
                    double d5 = (this.heightNoise[((i1 + 0) * l + j1 + 0) * byte3 + k1 + 1] - d1) * d;
                    double d6 = (this.heightNoise[((i1 + 0) * l + j1 + 1) * byte3 + k1 + 1] - d2) * d;
                    double d7 = (this.heightNoise[((i1 + 1) * l + j1 + 0) * byte3 + k1 + 1] - d3) * d;
                    double d8 = (this.heightNoise[((i1 + 1) * l + j1 + 1) * byte3 + k1 + 1] - d4) * d;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 12 | 0 + j1 * 4 << 8 | k1 * 8 + l1;
                            int s = 256;
                            j2 -= s;
                            double d14 = 0.25;
                            double d15 = (d11 - d10) * d14;
                            double d16 = d10 - d15;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                double d17;
                                d16 += d15;
                                blocks[j2 += s] = d17 > 0.0 ? Blocks.field_150348_b : (k1 * 8 + l1 < byte2 ? Blocks.field_150355_j : Blocks.field_150350_a);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void replaceBlocksForBiome(int i, int j, Block[] blocks, byte[] metadata, BiomeGenBase[] biomeArray) {
        int byte0 = 63;
        double d = 0.03125;
        this.stoneNoise = this.stoneNoiseGen.func_76304_a(this.stoneNoise, i * 16, j * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int stoneHeight;
                int k1;
                int l1;
                int stoneHeight2;
                int snowHeight;
                int l12;
                int k12;
                BiomeGenBase biome = biomeArray[l + k * 16];
                double stoneNoiseValue = this.stoneNoise[k + l * 16];
                int i1 = (int)(stoneNoiseValue / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int j1 = -1;
                Block topBlock = biome.field_76752_A;
                int topMeta = 0;
                Block fillerBlock = biome.field_76753_B;
                int fillerMeta = 0;
                if (biome instanceof LOTRBiome && ((LOTRBiome)biome).hasPodzol) {
                    if (stoneNoiseValue > 1.75) {
                        topBlock = Blocks.field_150346_d;
                        topMeta = 1;
                    } else if (stoneNoiseValue > -0.95) {
                        topBlock = Blocks.field_150346_d;
                        topMeta = 2;
                    }
                }
                for (k12 = 255; k12 >= 0; --k12) {
                    l12 = (l * 16 + k) * 256 + k12;
                    if (k12 <= 0 + this.rand.nextInt(5)) {
                        blocks[l12] = Blocks.field_150357_h;
                        continue;
                    }
                    Block byte3 = blocks[l12];
                    if (byte3 == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (byte3 != Blocks.field_150348_b) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            topBlock = Blocks.field_150350_a;
                            fillerBlock = Blocks.field_150348_b;
                        } else if (k12 >= byte0 - 4 && k12 <= byte0 + 1) {
                            topBlock = biome.field_76752_A;
                            fillerBlock = biome.field_76753_B;
                        }
                        if (k12 < byte0 && topBlock == Blocks.field_150350_a) {
                            topBlock = Blocks.field_150355_j;
                        }
                        j1 = i1;
                        if (k12 >= byte0 - 1) {
                            blocks[l12] = topBlock;
                            metadata[l12] = topMeta;
                            continue;
                        }
                        blocks[l12] = fillerBlock;
                        metadata[l12] = fillerMeta;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    blocks[l12] = fillerBlock;
                    metadata[l12] = fillerMeta;
                    if (--j1 == 0 && fillerBlock == Blocks.field_150354_m) {
                        j1 = this.rand.nextInt(4);
                        fillerBlock = Blocks.field_150322_A;
                    }
                    if ((biome instanceof LOTRBiomeGenGondor || biome instanceof LOTRBiomeGenIthilien) && j1 == 0 && fillerBlock == Blocks.field_150346_d) {
                        j1 = 6 + this.rand.nextInt(3);
                        fillerBlock = LOTRMod.rock;
                        fillerMeta = 1;
                        continue;
                    }
                    if (!(biome instanceof LOTRBiomeGenRohan) || j1 != 0 || fillerBlock != Blocks.field_150346_d) continue;
                    j1 = 6 + this.rand.nextInt(3);
                    fillerBlock = LOTRMod.rock;
                    fillerMeta = 2;
                }
                if (biome instanceof LOTRBiomeGenMistyMountains && ((LOTRBiomeGenMistyMountains)biome).isSnowCovered() && biome != LOTRBiome.mistyMountainsFoothills) {
                    snowHeight = 110 - this.rand.nextInt(3);
                    stoneHeight2 = snowHeight - 40 - this.rand.nextInt(3);
                    for (int k13 = 255; k13 >= stoneHeight2; --k13) {
                        l1 = (l * 16 + k) * 256 + k13;
                        if (k13 >= snowHeight && blocks[l1] == Blocks.field_150349_c) {
                            blocks[l1] = Blocks.field_150433_aE;
                            continue;
                        }
                        if (blocks[l1] != Blocks.field_150346_d && blocks[l1] != Blocks.field_150349_c) continue;
                        blocks[l1] = Blocks.field_150348_b;
                    }
                }
                if (biome instanceof LOTRBiomeGenGreyMountains && biome != LOTRBiome.greyMountainsFoothills) {
                    snowHeight = 150;
                    stoneHeight2 = snowHeight - 40 - this.rand.nextInt(3);
                    for (int k14 = 255; k14 >= stoneHeight2; --k14) {
                        l1 = (l * 16 + k) * 256 + k14;
                        if (k14 >= snowHeight && blocks[l1] == Blocks.field_150349_c) {
                            blocks[l1] = Blocks.field_150433_aE;
                            continue;
                        }
                        if (blocks[l1] != Blocks.field_150346_d && blocks[l1] != Blocks.field_150349_c) continue;
                        blocks[l1] = Blocks.field_150348_b;
                    }
                }
                if (biome instanceof LOTRBiomeGenAngmarMountains) {
                    snowHeight = 130;
                    stoneHeight2 = snowHeight - 20 - this.rand.nextInt(3);
                    for (int k15 = 255; k15 >= stoneHeight2; --k15) {
                        l1 = (l * 16 + k) * 256 + k15;
                        if (k15 >= snowHeight && blocks[l1] == Blocks.field_150349_c) {
                            blocks[l1] = Blocks.field_150433_aE;
                            continue;
                        }
                        if (blocks[l1] != Blocks.field_150346_d && blocks[l1] != Blocks.field_150349_c) continue;
                        blocks[l1] = Blocks.field_150348_b;
                    }
                }
                if (biome instanceof LOTRBiomeGenBlueMountains && biome != LOTRBiome.blueMountainsFoothills) {
                    snowHeight = 110;
                    stoneHeight2 = snowHeight - 20 - this.rand.nextInt(3);
                    for (int k16 = 255; k16 >= stoneHeight2; --k16) {
                        l1 = (l * 16 + k) * 256 + k16;
                        if (k16 >= snowHeight && blocks[l1] == Blocks.field_150349_c) {
                            blocks[l1] = Blocks.field_150433_aE;
                            continue;
                        }
                        if (blocks[l1] != Blocks.field_150346_d && blocks[l1] != Blocks.field_150349_c) continue;
                        blocks[l1] = LOTRMod.rock;
                        metadata[l1] = 3;
                    }
                }
                if (biome instanceof LOTRBiomeGenWhiteMountains && biome != LOTRBiome.whiteMountainsFoothills) {
                    int height = 90 - this.rand.nextInt(3);
                    for (k1 = 255; k1 >= height; --k1) {
                        int l13 = (l * 16 + k) * 256 + k1;
                        if (blocks[l13] != Blocks.field_150346_d && blocks[l13] != Blocks.field_150349_c) continue;
                        blocks[l13] = LOTRMod.rock;
                        metadata[l13] = 1;
                    }
                }
                if (biome instanceof LOTRBiomeGenTolfalas) {
                    stoneHeight = 90 - this.rand.nextInt(3);
                    for (k1 = 255; k1 >= stoneHeight; --k1) {
                        int l14 = (l * 16 + k) * 256 + k1;
                        if (blocks[l14] != Blocks.field_150346_d && blocks[l14] != Blocks.field_150349_c) continue;
                        blocks[l14] = Blocks.field_150348_b;
                    }
                }
                if (biome instanceof LOTRBiomeGenMordor) {
                    for (k12 = 255; k12 >= 0; --k12) {
                        l12 = (l * 16 + k) * 256 + k12;
                        if (blocks[l12] != Blocks.field_150348_b) continue;
                        blocks[l12] = LOTRMod.rock;
                    }
                }
                if (biome instanceof LOTRBiomeGenHaradMountains) {
                    stoneHeight = 90 - this.rand.nextInt(3);
                    for (k1 = 255; k1 >= stoneHeight; --k1) {
                        int l15 = (l * 16 + k) * 256 + k1;
                        if (blocks[l15] != Blocks.field_150346_d && blocks[l15] != Blocks.field_150349_c) continue;
                        blocks[l15] = Blocks.field_150348_b;
                    }
                }
                if (!(biome instanceof LOTRBiomeGenRedMountains) || biome == LOTRBiome.redMountainsFoothills) continue;
                stoneHeight = 90 - this.rand.nextInt(3);
                for (k1 = 255; k1 >= stoneHeight; --k1) {
                    int l16 = (l * 16 + k) * 256 + k1;
                    if (blocks[l16] != Blocks.field_150346_d && blocks[l16] != Blocks.field_150349_c) continue;
                    blocks[l16] = LOTRMod.rock;
                    metadata[l16] = 4;
                }
            }
        }
    }

    public Chunk func_73158_c(int i, int j) {
        return this.func_73154_d(i, j);
    }

    public Chunk func_73154_d(int i, int j) {
        this.rand.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        this.generateTerrain(i, j, blocks);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, i * 16, j * 16, 16, 16);
        this.replaceBlocksForBiome(i, j, blocks, metadata, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, blocks);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, blocks);
        this.dwarvenMineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, blocks);
        Chunk chunk = new Chunk(this.worldObj, i, j);
        ExtendedBlockStorage[] blockStorage = chunk.func_76587_i();
        byte[] biomes = chunk.func_76605_m();
        for (int k = 0; k < biomes.length; ++k) {
            biomes[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int k1 = 0; k1 < 16; ++k1) {
                for (int j1 = 0; j1 < 256; ++j1) {
                    Block block = blocks[i1 << 12 | k1 << 8 | j1];
                    if (block == Blocks.field_150350_a) continue;
                    byte meta = metadata[i1 << 12 | k1 << 8 | j1];
                    int j2 = j1 >> 4;
                    if (blockStorage[j2] == null) {
                        blockStorage[j2] = new ExtendedBlockStorage(j2 << 4, true);
                    }
                    blockStorage[j2].func_150818_a(i1, j1 & 0xF, k1, block);
                    blockStorage[j2].func_76654_b(i1, j1 & 0xF, k1, meta & 0xF);
                }
            }
        }
        chunk.func_76603_b();
        return chunk;
    }

    private double[] initializeHeightNoise(double[] noise, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (noise == null) {
            noise = new double[par5 * par6 * par7];
        }
        if (this.biomeHeightNoise == null) {
            this.biomeHeightNoise = new float[25];
            for (int var8 = -2; var8 <= 2; ++var8) {
                for (int var9 = -2; var9 <= 2; ++var9) {
                    float var10;
                    this.biomeHeightNoise[var8 + 2 + (var9 + 2) * 5] = var10 = 10.0f / MathHelper.func_76129_c((float)((float)(var8 * var8 + var9 * var9) + 0.2f));
                }
            }
        }
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, par2, par4, par5, par7, 1.121, 1.121, DEPTH_NOISE_EXP);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, par2, par4, par5, par7, DEPTH_NOISE_SCALE, DEPTH_NOISE_SCALE, DEPTH_NOISE_EXP);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, par2, par3, par4, par5, par6, par7, COORDINATE_SCALE / MAIN_NOISE_SCALE_XZ, HEIGHT_SCALE / MAIN_NOISE_SCALE_Y, COORDINATE_SCALE / MAIN_NOISE_SCALE_XZ);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, par2, par3, par4, par5, par6, par7, COORDINATE_SCALE, HEIGHT_SCALE, COORDINATE_SCALE);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, par2, par3, par4, par5, par6, par7, COORDINATE_SCALE, HEIGHT_SCALE, COORDINATE_SCALE);
        boolean var43 = false;
        boolean var42 = false;
        int var12 = 0;
        int var13 = 0;
        for (int var14 = 0; var14 < par5; ++var14) {
            for (int var15 = 0; var15 < par7; ++var15) {
                float var16 = 0.0f;
                float var17 = 0.0f;
                float var18 = 0.0f;
                int var19 = 2;
                BiomeGenBase var20 = this.biomesForGeneration[var14 + 2 + (var15 + 2) * (par5 + 5)];
                for (int var21 = -var19; var21 <= var19; ++var21) {
                    for (int var22 = -var19; var22 <= var19; ++var22) {
                        BiomeGenBase var23 = this.biomesForGeneration[var14 + var21 + 2 + (var15 + var22 + 2) * (par5 + 5)];
                        float var24 = this.biomeHeightNoise[var21 + 2 + (var22 + 2) * 5] / (var23.field_76748_D + 2.0f) / 2.0f;
                        var24 = Math.abs(var24);
                        if (var23.field_76748_D > var20.field_76748_D) {
                            var24 /= 2.0f;
                        }
                        var16 += var23.field_76749_E * var24;
                        var17 += var23.field_76748_D * var24;
                        var18 += var24;
                    }
                }
                var16 /= var18;
                var17 /= var18;
                var16 = var16 * 0.9f + 0.1f;
                var17 = (var17 * 4.0f - 1.0f) / 8.0f;
                double var47 = this.noise6[var13] / 8000.0;
                if (var47 < 0.0) {
                    var47 = -var47 * 0.3;
                }
                if ((var47 = var47 * 3.0 - 2.0) < 0.0) {
                    if ((var47 /= 2.0) < -1.0) {
                        var47 = -1.0;
                    }
                    var47 /= 1.4;
                    var47 /= 2.0;
                } else {
                    if (var47 > 1.0) {
                        var47 = 1.0;
                    }
                    var47 /= 8.0;
                }
                ++var13;
                for (int var46 = 0; var46 < par6; ++var46) {
                    double var48 = var17;
                    double var26 = var16;
                    var48 += var47 * 0.2;
                    var48 = var48 * (double)par6 / 16.0;
                    double var28 = (double)par6 / 2.0 + var48 * 4.0;
                    double var30 = 0.0;
                    double var32 = ((double)var46 - var28) * HEIGHT_STRETCH * 128.0 / 256.0 / var26;
                    if (var32 < 0.0) {
                        var32 *= 4.0;
                    }
                    double var34 = this.noise1[var12] / UPPER_LIMIT_SCALE;
                    double var36 = this.noise2[var12] / LOWER_LIMIT_SCALE;
                    double var38 = (this.noise3[var12] / 10.0 + 1.0) / 2.0;
                    var30 = var38 < 0.0 ? var34 : (var38 > 1.0 ? var36 : var34 + (var36 - var34) * var38);
                    var30 -= var32;
                    if (var46 > par6 - 4) {
                        double var40 = (float)(var46 - (par6 - 4)) / 3.0f;
                        var30 = var30 * (1.0 - var40) + -10.0 * var40;
                    }
                    noise[var12] = var30;
                    ++var12;
                }
            }
        }
        return noise;
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int i, int j) {
        int i1;
        BlockSand.field_149832_M = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        if (!(biomegenbase instanceof LOTRBiome)) {
            return;
        }
        LOTRBiome biome = (LOTRBiome)biomegenbase;
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.func_72905_C());
        this.dwarvenMineGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        if (this.rand.nextInt(4) == 0) {
            i1 = k + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(128);
            int k3 = l + this.rand.nextInt(16) + 8;
            if (j2 < 60 || this.rand.nextFloat() < biome.getChanceToSpawnLakes()) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, i1, j2, k3);
            }
        }
        if (this.rand.nextInt(8) == 0) {
            i1 = k + this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            int k1 = l + this.rand.nextInt(16) + 8;
            if (j1 < 60 || this.rand.nextFloat() < biome.getChanceToSpawnLavaLakes()) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, i1, j1, k1);
            }
        }
        biome.func_76728_a(this.worldObj, this.rand, k, l);
        if (biome.getChanceToSpawnAnimals() <= 1.0f) {
            if (this.rand.nextFloat() < biome.getChanceToSpawnAnimals()) {
                SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
            }
        } else {
            for (i1 = 0; i1 < MathHelper.func_76128_c((double)biome.getChanceToSpawnAnimals()); ++i1) {
                SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
            }
        }
        k += 8;
        l += 8;
        for (i1 = 0; i1 < 16; ++i1) {
            for (int k1 = 0; k1 < 16; ++k1) {
                int j1 = this.worldObj.func_72874_g(k + i1, l + k1);
                if (this.worldObj.func_72884_u(i1 + k, j1 - 1, k1 + l)) {
                    this.worldObj.func_147465_d(i1 + k, j1 - 1, k1 + l, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.worldObj.func_147478_e(i1 + k, j1, k1 + l, true)) continue;
                this.worldObj.func_147465_d(i1 + k, j1, k1 + l, Blocks.field_150431_aC, 0, 2);
            }
        }
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate update) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "MiddleEarthLevelSource";
    }

    public List func_73155_a(EnumCreatureType creatureType, int i, int j, int k) {
        BiomeGenBase biome = this.worldObj.func_72807_a(i, k);
        return biome == null ? null : biome.func_76747_a(creatureType);
    }

    public ChunkPosition func_147416_a(World world, String type, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int i, int j) {
        this.dwarvenMineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, null);
    }
}

