/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRStructureSpawningInfo {
    public static int TIME_INTERVAL = 3000;
    private List structureLocations;
    private Random rand = new Random();
    private long randomWorldTime;
    private int checkHorizontalRadius;
    private int checkVerticalMin;
    private int checkVerticalMax;
    private Class checkClass;
    private int checkLimit;
    private int spawnHorizontalRadius;
    private int spawnVerticalMin;
    private int spawnVerticalMax;
    private Class primarySpawnClass;
    private Class secondarySpawnClass;
    private int homeRadius;
    private boolean setHomePosFromSpawn = false;
    private List spawnBlocks = new ArrayList();
    private List specialEquipment = new ArrayList();

    public LOTRStructureSpawningInfo(List list) {
        this.structureLocations = list;
        this.randomWorldTime = this.rand.nextInt(TIME_INTERVAL);
    }

    public LOTRStructureSpawningInfo setCheckInfo(int i, int j, int k, Class c, int l) {
        this.checkHorizontalRadius = i;
        this.checkVerticalMin = j;
        this.checkVerticalMax = k;
        this.checkClass = c;
        this.checkLimit = l;
        return this;
    }

    public LOTRStructureSpawningInfo setSpawnInfo(int i, int j, int k, Class c, Class c1, int l) {
        this.spawnHorizontalRadius = i;
        this.spawnVerticalMin = j;
        this.spawnVerticalMax = k;
        this.primarySpawnClass = c;
        this.secondarySpawnClass = c1;
        this.homeRadius = l;
        return this;
    }

    public LOTRStructureSpawningInfo setHomePosFromSpawn() {
        this.setHomePosFromSpawn = true;
        return this;
    }

    public LOTRStructureSpawningInfo addSpawnBlock(Block block) {
        return this.addSpawnBlock(block, -1);
    }

    public LOTRStructureSpawningInfo addSpawnBlock(Block block, int j) {
        this.spawnBlocks.add(new SpawnBlockInfo(block, j));
        return this;
    }

    public LOTRStructureSpawningInfo addSpecialEquipment(int i, ItemStack itemstack) {
        this.specialEquipment.add(new SpecialEquipmentInfo(i, itemstack));
        return this;
    }

    public void performSpawning(World world) {
        if (world.func_72820_D() % (long)TIME_INTERVAL != this.randomWorldTime || this.structureLocations.isEmpty()) {
            return;
        }
        block0: for (int l = 0; l < this.structureLocations.size(); ++l) {
            List nearbyEntities;
            int entities;
            ChunkCoordinates coords = (ChunkCoordinates)this.structureLocations.get(l);
            int posX = coords.field_71574_a;
            int minX = posX - this.checkHorizontalRadius;
            int posY = coords.field_71572_b;
            int minY = posY + this.checkVerticalMin;
            int posZ = coords.field_71573_c;
            int minZ = posZ - this.checkHorizontalRadius;
            int maxX = posX + this.checkHorizontalRadius;
            int maxY = posY + this.checkVerticalMax;
            int maxZ = posZ + this.checkHorizontalRadius;
            if (!world.func_72904_c(minX, minY, minZ, maxX, maxY, maxZ) || world.func_72977_a((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 24.0) != null || (entities = (nearbyEntities = world.func_72872_a(this.checkClass, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)))).size()) >= this.checkLimit) continue;
            for (int l1 = 0; l1 < 16; ++l1) {
                int i = posX - this.spawnHorizontalRadius + this.rand.nextInt(this.spawnHorizontalRadius * 2 + 1);
                int j = posY + this.spawnVerticalMin + this.rand.nextInt(this.spawnVerticalMax - this.spawnVerticalMin + 1);
                int k = posZ - this.spawnHorizontalRadius + this.rand.nextInt(this.spawnHorizontalRadius * 2 + 1);
                Block block = world.func_147439_a(i, j - 1, k);
                int meta = world.func_72805_g(i, j - 1, k);
                boolean match = false;
                for (int i2 = 0; i2 < this.spawnBlocks.size(); ++i2) {
                    SpawnBlockInfo obj = (SpawnBlockInfo)this.spawnBlocks.get(i2);
                    if (!obj.matchesBlockIDAndMeta(block, meta)) continue;
                    match = true;
                    break;
                }
                if (!match || world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j + 1, k).func_149721_r()) continue;
                LOTREntityNPC entity = (LOTREntityNPC)LOTREntities.createEntityByClass(this.rand.nextInt(3) == 0 ? this.secondarySpawnClass : this.primarySpawnClass, world);
                entity.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.rand.nextFloat() * 360.0f, 0.0f);
                entity.isNPCPersistent = true;
                entity.liftSpawnRestrictions = true;
                if (!entity.func_70601_bi()) continue;
                entity.liftSpawnRestrictions = false;
                world.func_72838_d((Entity)entity);
                entity.spawnRidingHorse = false;
                entity.func_110161_a(null);
                for (int i3 = 0; i3 < this.specialEquipment.size(); ++i3) {
                    SpecialEquipmentInfo obj = (SpecialEquipmentInfo)this.specialEquipment.get(i3);
                    obj.applyToEntity(entity);
                }
                if (this.setHomePosFromSpawn) {
                    entity.func_110171_b(i, j, k, this.homeRadius);
                } else {
                    entity.func_110171_b(posX, posY, posZ, this.homeRadius);
                }
                if (++entities >= this.checkLimit) continue block0;
            }
        }
    }

    public static class SpecialEquipmentInfo {
        private int slot;
        private ItemStack equipment;

        public SpecialEquipmentInfo(int i, ItemStack itemstack) {
            this.slot = i;
            this.equipment = itemstack;
        }

        public void applyToEntity(LOTREntityNPC entity) {
            entity.func_70062_b(this.slot, this.equipment.func_77946_l());
        }
    }

    public static class SpawnBlockInfo {
        private Block id;
        private int meta;

        public SpawnBlockInfo(Block block, int i) {
            this.id = block;
            this.meta = i;
        }

        public boolean matchesBlockIDAndMeta(Block block, int i) {
            return this.id == block && (this.meta == -1 || this.meta == i);
        }
    }
}

