/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTRTravellingTraderSpawner {
    private static Random rand = new Random();
    private Class theEntityClass;
    public String name;
    private int timeUntilTrader;

    public LOTRTravellingTraderSpawner(Class entityClass) {
        this.theEntityClass = entityClass;
        this.name = LOTREntities.getStringFromClass(this.theEntityClass);
    }

    private static int getRandomTraderTime() {
        return 50000 + rand.nextInt(250000);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TraderTime", this.timeUntilTrader);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.timeUntilTrader = nbt.func_74764_b("TraderTime") ? nbt.func_74762_e("TraderTime") : LOTRTravellingTraderSpawner.getRandomTraderTime();
    }

    public void performSpawning(World world) {
        if (this.timeUntilTrader > 0) {
            --this.timeUntilTrader;
        } else {
            boolean spawned = false;
            LOTREntityNPC entityTrader = (LOTREntityNPC)LOTREntities.createEntityByClass(this.theEntityClass, world);
            LOTRTravellingTrader trader = (LOTRTravellingTrader)((Object)entityTrader);
            block0: for (int players = 0; players < world.field_73010_i.size(); ++players) {
                EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(players);
                for (int attempts = 0; attempts < 16; ++attempts) {
                    int j;
                    int k;
                    float angle = world.field_73012_v.nextFloat() * 360.0f;
                    int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + MathHelper.func_76128_c((double)(MathHelper.func_76126_a((float)angle) * (float)(48 + world.field_73012_v.nextInt(33))));
                    BiomeGenBase biome = world.func_72807_a(i, k = MathHelper.func_76128_c((double)entityplayer.field_70161_v) + MathHelper.func_76128_c((double)(MathHelper.func_76134_b((float)angle) * (float)(48 + world.field_73012_v.nextInt(33)))));
                    if (!(biome instanceof LOTRBiome) || !((LOTRBiome)biome).canSpawnTravellingTrader(this.theEntityClass) || (j = world.func_72976_f(i, k)) <= 62 || world.func_147439_a(i, j - 1, k) != biome.field_76752_A || world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j + 1, k).func_149721_r()) continue;
                    entityTrader.func_70012_b((double)i + 0.5, j, (double)k + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (!entityTrader.func_70601_bi()) continue;
                    world.func_72838_d((Entity)entityTrader);
                    trader.startVisiting(entityplayer);
                    spawned = true;
                    this.timeUntilTrader = LOTRTravellingTraderSpawner.getRandomTraderTime();
                    LOTRLevelData.needsSave = true;
                    break block0;
                }
            }
            if (!spawned) {
                this.timeUntilTrader = 100;
            }
        }
    }
}

