/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.genlayer.LOTRGenLayerWorld;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class LOTRWorldChunkManager
extends WorldChunkManager {
    private World worldObj;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache;

    public LOTRWorldChunkManager(World world) {
        this.worldObj = world;
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        GenLayer[] layers = LOTRGenLayerWorld.createWorld(world.func_72905_C(), world.func_72912_H().func_76067_t());
        this.genBiomes = layers[0];
        this.biomeIndexLayer = layers[1];
    }

    public BiomeGenBase func_76935_a(int i, int k) {
        return this.biomeCache.func_76837_b(i, k);
    }

    public float[] func_76936_a(float[] rainfall, int i, int k, int xSize, int zSize) {
        IntCache.func_76446_a();
        if (rainfall == null || rainfall.length < xSize * zSize) {
            rainfall = new float[xSize * zSize];
        }
        int[] ints = this.biomeIndexLayer.func_75904_a(i, k, xSize, zSize);
        for (int l = 0; l < xSize * zSize; ++l) {
            float f = (float)LOTRBiome.lotrBiomeList[ints[l]].func_76744_g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            rainfall[l] = f;
        }
        return rainfall;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float f, int height) {
        if (this.worldObj.field_72995_K && LOTRMod.isChristmas()) {
            return 0.0f;
        }
        return f;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int i, int k, int xSize, int zSize) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < xSize * zSize) {
            biomes = new BiomeGenBase[xSize * zSize];
        }
        int[] ints = this.genBiomes.func_75904_a(i, k, xSize, zSize);
        for (int l = 0; l < xSize * zSize; ++l) {
            biomes[l] = LOTRBiome.lotrBiomeList[ints[l]];
        }
        return biomes;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] biomes, int i, int k, int xSize, int zSize) {
        return this.func_76931_a(biomes, i, k, xSize, zSize, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomes, int i, int k, int xSize, int zSize, boolean useCache) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < xSize * zSize) {
            biomes = new BiomeGenBase[xSize * zSize];
        }
        if (useCache && xSize == 16 && zSize == 16 && (i & 0xF) == 0 && (k & 0xF) == 0) {
            BiomeGenBase[] cachedBiomes = this.biomeCache.func_76839_e(i, k);
            System.arraycopy(cachedBiomes, 0, biomes, 0, xSize * zSize);
            return biomes;
        }
        int[] ints = this.biomeIndexLayer.func_75904_a(i, k, xSize, zSize);
        for (int l = 0; l < xSize * zSize; ++l) {
            biomes[l] = LOTRBiome.lotrBiomeList[ints[l]];
        }
        return biomes;
    }

    public boolean func_76940_a(int i, int k, int range, List list) {
        int i1 = i - range >> 2;
        int k1 = k - range >> 2;
        int i2 = i + range >> 2;
        int k2 = k + range >> 2;
        int i3 = i2 - i1 + 1;
        int k3 = k2 - k1 + 1;
        int[] ints = this.genBiomes.func_75904_a(i1, k1, i3, k3);
        for (int l = 0; l < i3 * k3; ++l) {
            LOTRBiome biome = LOTRBiome.lotrBiomeList[ints[l]];
            if (list.contains((Object)biome)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_150795_a(int i, int k, int range, List list, Random random) {
        int i1 = i - range >> 2;
        int k1 = k - range >> 2;
        int i2 = i + range >> 2;
        int k2 = k + range >> 2;
        int i3 = i2 - i1 + 1;
        int k3 = k2 - k1 + 1;
        int[] ints = this.genBiomes.func_75904_a(i1, k1, i3, k3);
        ChunkPosition chunkpos = null;
        int j = 0;
        for (int l = 0; l < ints.length; ++l) {
            int xPos = i1 + l % i3 << 2;
            int zPos = k1 + l / i3 << 2;
            LOTRBiome biome = LOTRBiome.lotrBiomeList[ints[l]];
            if (!list.contains((Object)biome) || chunkpos != null && random.nextInt(j + 1) != 0) continue;
            chunkpos = new ChunkPosition(xPos, 0, zPos);
            ++j;
        }
        return chunkpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

