/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.client.render.LOTRSkyRenderer;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.world.LOTRChunkProvider;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenMirkwood;
import lotr.common.world.biome.LOTRBiomeGenOcean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.ForgeModContainer;

public class LOTRWorldProvider
extends WorldProvider {
    @SideOnly(value=Side.CLIENT)
    private IRenderHandler lotrSkyRenderer;
    private double cloudsR;
    private double cloudsG;
    private double cloudsB;
    private double fogR;
    private double fogG;
    private double fogB;

    public void func_76572_b() {
        this.field_76578_c = new LOTRWorldChunkManager(this.field_76579_a);
        this.field_76574_g = LOTRMod.idDimension;
    }

    public IChunkProvider func_76555_c() {
        return new LOTRChunkProvider(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (LOTRMod.enableLOTRSky) {
            if (this.lotrSkyRenderer == null) {
                this.lotrSkyRenderer = new LOTRSkyRenderer();
            }
            return this.lotrSkyRenderer;
        }
        return super.getSkyRenderer();
    }

    public boolean func_76567_e() {
        return true;
    }

    public String getWelcomeMessage() {
        return "Entering Middle-earth";
    }

    public String getDepartMessage() {
        return "Leaving Middle-earth";
    }

    public String getSaveFolder() {
        return "MiddleEarth";
    }

    public String func_80007_l() {
        return "MiddleEarth";
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(LOTRLevelData.middleEarthPortalX, LOTRLevelData.middleEarthPortalY, LOTRLevelData.middleEarthPortalZ);
    }

    public void setSpawnPoint(int i, int j, int k) {
        if (!(i == 8 && j == 64 && k == 8 || this.field_76579_a.field_72995_K)) {
            LOTRLevelData.markMiddleEarthPortalLocation(i, j, k);
        }
    }

    public BiomeGenBase getBiomeGenForCoords(int i, int k) {
        Chunk chunk;
        if (this.field_76579_a.func_72899_e(i, 0, k) && (chunk = this.field_76579_a.func_72938_d(i, k)) != null) {
            int chunkX = i & 0xF;
            int chunkZ = k & 0xF;
            int biomeID = chunk.func_76605_m()[chunkZ << 4 | chunkX] & 0xFF;
            if (biomeID == 255) {
                BiomeGenBase biomegenbase = this.field_76578_c.func_76935_a((chunk.field_76635_g << 4) + chunkX, (chunk.field_76647_h << 4) + chunkZ);
                biomeID = biomegenbase.field_76756_M;
                chunk.func_76605_m()[chunkZ << 4 | chunkX] = (byte)(biomeID & 0xFF);
            }
            return LOTRBiome.lotrBiomeList[biomeID] == null ? LOTRBiome.shire : LOTRBiome.lotrBiomeList[biomeID];
        }
        return this.field_76578_c.func_76935_a(i, k);
    }

    public boolean canBlockFreeze(int i, int j, int k, boolean byWater) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenOcean) {
            float temp = LOTRBiome.ocean.field_76750_F;
            LOTRBiome.ocean.field_76750_F = 0.0f;
            boolean flag = this.field_76579_a.canBlockFreezeBody(i, j, k, byWater);
            LOTRBiome.ocean.field_76750_F = temp;
            return flag && LOTRBiomeGenOcean.isFrozen(i, k);
        }
        if (biome instanceof LOTRBiome) {
            return this.field_76579_a.canBlockFreezeBody(i, j, k, byWater);
        }
        return this.field_76579_a.canBlockFreezeBody(i, j, k, byWater);
    }

    public boolean canSnowAt(int i, int j, int k, boolean checkLight) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenOcean) {
            float temp = LOTRBiome.ocean.field_76750_F;
            LOTRBiome.ocean.field_76750_F = 0.0f;
            boolean flag = this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
            LOTRBiome.ocean.field_76750_F = temp;
            return flag && LOTRBiomeGenOcean.isFrozen(i, k);
        }
        if (biome instanceof LOTRBiome) {
            return j >= ((LOTRBiome)biome).getSnowHeight() && this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
        }
        return this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 192.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawClouds(float f) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_71451_h.field_70165_t;
        int k = (int)mc.field_71451_h.field_70161_v;
        Vec3 clouds = super.drawClouds(f);
        this.cloudsB = 0.0;
        this.cloudsG = 0.0;
        this.cloudsR = 0.0;
        GameSettings settings = mc.field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int l = 0;
        for (int i1 = -distance; i1 <= distance; ++i1) {
            for (int k1 = -distance; k1 <= distance; ++k1) {
                Vec3 tempClouds = Vec3.func_72443_a((double)clouds.field_72450_a, (double)clouds.field_72448_b, (double)clouds.field_72449_c);
                BiomeGenBase biome = this.field_76579_a.func_72807_a(i + i1, k + k1);
                if (biome instanceof LOTRBiome) {
                    ((LOTRBiome)biome).getCloudColor(tempClouds);
                }
                this.cloudsR += tempClouds.field_72450_a;
                this.cloudsG += tempClouds.field_72448_b;
                this.cloudsB += tempClouds.field_72449_c;
                ++l;
            }
        }
        this.cloudsR /= (double)l;
        this.cloudsG /= (double)l;
        this.cloudsB /= (double)l;
        return Vec3.func_72443_a((double)this.cloudsR, (double)this.cloudsG, (double)this.cloudsB);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float f, float f1) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_71451_h.field_70165_t;
        int k = (int)mc.field_71451_h.field_70161_v;
        Vec3 fog = super.func_76562_b(f, f1);
        this.fogB = 0.0;
        this.fogG = 0.0;
        this.fogR = 0.0;
        GameSettings settings = mc.field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int l = 0;
        for (int i1 = -distance; i1 <= distance; ++i1) {
            for (int k1 = -distance; k1 <= distance; ++k1) {
                Vec3 tempFog = Vec3.func_72443_a((double)fog.field_72450_a, (double)fog.field_72448_b, (double)fog.field_72449_c);
                BiomeGenBase biome = this.field_76579_a.func_72807_a(i + i1, k + k1);
                if (biome instanceof LOTRBiome) {
                    ((LOTRBiome)biome).getFogColor(tempFog);
                }
                this.fogR += tempFog.field_72450_a;
                this.fogG += tempFog.field_72448_b;
                this.fogB += tempFog.field_72449_c;
                ++l;
            }
        }
        this.fogR /= (double)l;
        this.fogG /= (double)l;
        this.fogB /= (double)l;
        return Vec3.func_72443_a((double)this.fogR, (double)this.fogG, (double)this.fogB);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int i, int k) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenMirkwood && ((LOTRBiomeGenMirkwood)biome).corrupted) {
            return true;
        }
        return super.func_76568_b(i, k);
    }
}

