/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenBlueMountains;
import lotr.common.world.biome.LOTRBiomeGenForodwaithMountains;
import lotr.common.world.biome.LOTRBiomeGenIronHills;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import lotr.common.world.biome.LOTRBiomeGenMordor;
import lotr.common.world.biome.LOTRBiomeGenRedMountains;
import lotr.common.world.feature.LOTRWorldGenCaveCobwebs;
import lotr.common.world.feature.LOTRWorldGenFlowers;
import lotr.common.world.feature.LOTRWorldGenLogs;
import lotr.common.world.feature.LOTRWorldGenMordorLava;
import lotr.common.world.feature.LOTRWorldGenStalactites;
import lotr.common.world.feature.LOTRWorldGenTrollHoard;
import lotr.common.world.structure.LOTRWorldGenOrcDungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeDecorator {
    private World worldObj;
    private Random rand;
    private int chunkX;
    private int chunkZ;
    private LOTRBiome biome;
    private WorldGenerator clayGen = new WorldGenClay(4);
    private WorldGenerator sandGen = new WorldGenSand((Block)Blocks.field_150354_m, 7);
    private WorldGenerator quagmireGen = new WorldGenSand(LOTRMod.quagmire, 7);
    private WorldGenerator dirtGen = new WorldGenMinable(Blocks.field_150346_d, 32);
    private WorldGenerator gravelGen = new WorldGenMinable(Blocks.field_150351_n, 32);
    private WorldGenerator coalGen = new WorldGenMinable(Blocks.field_150365_q, 16);
    private WorldGenerator ironGen = new WorldGenMinable(Blocks.field_150366_p, 8);
    private WorldGenerator goldGen = new WorldGenMinable(Blocks.field_150352_o, 8);
    private WorldGenerator diamondGen = new WorldGenMinable(Blocks.field_150482_ag, 7);
    private WorldGenerator lapisGen = new WorldGenMinable(Blocks.field_150369_x, 6);
    private WorldGenerator copperGen = new WorldGenMinable(LOTRMod.oreCopper, 8);
    private WorldGenerator tinGen = new WorldGenMinable(LOTRMod.oreTin, 8);
    private WorldGenerator silverGen = new WorldGenMinable(LOTRMod.oreSilver, 7);
    private WorldGenerator oreGlowstoneGen = new WorldGenMinable(LOTRMod.oreGlowstone, 4);
    private WorldGenerator sulfurGen = new WorldGenMinable(LOTRMod.oreSulfur, 8);
    private WorldGenerator saltpeterGen = new WorldGenMinable(LOTRMod.oreSaltpeter, 8);
    private WorldGenerator flowerGen = new LOTRWorldGenFlowers();
    private WorldGenerator logGen = new LOTRWorldGenLogs();
    private WorldGenerator mushroomBrownGen = new WorldGenFlowers((Block)Blocks.field_150338_P);
    private WorldGenerator mushroomRedGen = new WorldGenFlowers((Block)Blocks.field_150337_Q);
    private WorldGenerator reedGen = new WorldGenReed();
    private WorldGenerator pumpkinGen = new WorldGenPumpkin();
    private WorldGenerator waterlilyGen = new WorldGenWaterlily();
    private WorldGenerator cobwebGen = new LOTRWorldGenCaveCobwebs();
    private WorldGenerator stalactiteGen = new LOTRWorldGenStalactites();
    private WorldGenerator vinesGen = new WorldGenVines();
    private WorldGenerator cactusGen = new WorldGenCactus();
    public int sandPerChunk = 1;
    public int sandPerChunk2 = 3;
    public int clayPerChunk = 1;
    public int quagmirePerChunk = 0;
    public int treesPerChunk = 0;
    public int logsPerChunk = 0;
    public int vinesPerChunk = 0;
    public int flowersPerChunk = 2;
    public int doubleFlowersPerChunk = 0;
    public int grassPerChunk = 1;
    public int doubleGrassPerChunk = 0;
    public boolean enableFern = false;
    public int deadBushPerChunk = 0;
    public int waterlilyPerChunk = 0;
    public int mushroomsPerChunk = 0;
    public int reedsPerChunk = 0;
    public int cactiPerChunk = 0;
    public boolean generateWater = true;
    public boolean generateLava = true;
    public boolean generateCobwebs = true;
    public boolean generateAthelas = false;
    private WorldGenerator orcDungeonGen = new LOTRWorldGenOrcDungeon(false);
    private WorldGenerator trollHoardGen = new LOTRWorldGenTrollHoard();
    public boolean generateOrcDungeon = false;
    public boolean generateTrollHoard = false;
    private List randomStructures = new ArrayList();

    public LOTRBiomeDecorator(LOTRBiome lotrbiome) {
        this.biome = lotrbiome;
    }

    public void addRandomStructure(WorldGenerator structure, int chunkChance) {
        this.randomStructures.add(new RandomStructure(structure, chunkChance));
    }

    public void clearRandomStructures() {
        this.randomStructures.clear();
    }

    public void decorate(World world, Random random, int i, int j) {
        this.worldObj = world;
        this.rand = random;
        this.chunkX = i;
        this.chunkZ = j;
        this.decorate();
    }

    private void decorate() {
        int l;
        int j;
        int i;
        int l2;
        int i2;
        int k;
        int j2;
        int i3;
        int l3;
        int k2;
        this.generateOres();
        if (this.rand.nextBoolean() && this.generateCobwebs) {
            int i4 = this.chunkX + this.rand.nextInt(16) + 8;
            int j3 = this.rand.nextInt(60);
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.cobwebGen.func_76484_a(this.worldObj, this.rand, i4, j3, k2);
        }
        for (l3 = 0; l3 < 3; ++l3) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(60);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.stalactiteGen.func_76484_a(this.worldObj, this.rand, i3, j2, k);
        }
        for (l3 = 0; l3 < this.quagmirePerChunk; ++l3) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.quagmireGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k2), k2);
        }
        for (l3 = 0; l3 < this.sandPerChunk2; ++l3) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.sandGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k2), k2);
        }
        for (l3 = 0; l3 < this.clayPerChunk; ++l3) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.clayGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k2), k2);
        }
        for (l3 = 0; l3 < this.sandPerChunk; ++l3) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.sandGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k2), k2);
        }
        if (Math.abs(this.chunkX) > 4 && Math.abs(this.chunkZ) > 4) {
            for (Object obj : this.randomStructures) {
                RandomStructure randomstructure = (RandomStructure)obj;
                if (this.rand.nextInt(randomstructure.chunkChance) != 0) continue;
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                int k3 = this.chunkZ + this.rand.nextInt(16) + 8;
                int j4 = this.worldObj.func_72825_h(i2, k3);
                randomstructure.structure.func_76484_a(this.worldObj, this.rand, i2, j4, k3);
            }
        }
        int trees = this.treesPerChunk;
        if (this.rand.nextFloat() < this.biome.getTreeIncreaseChance()) {
            ++trees;
        }
        for (l2 = 0; l2 < trees; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenAbstractTree treeGen = this.biome.func_150567_a(this.rand);
            treeGen.func_76484_a(this.worldObj, this.rand, i, this.worldObj.func_72976_f(i, k), k);
        }
        for (l2 = 0; l2 < this.logsPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.logGen.func_76484_a(this.worldObj, this.rand, i, this.worldObj.func_72976_f(i, k), k);
        }
        for (l2 = 0; l2 < this.vinesPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = 64;
            int k4 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.vinesGen.func_76484_a(this.worldObj, this.rand, i, j, k4);
        }
        for (l2 = 0; l2 < this.flowersPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k5 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.flowerGen.func_76484_a(this.worldObj, this.rand, i, j, k5);
        }
        for (l2 = 0; l2 < this.doubleFlowersPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k6 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator doubleFlowerGen = this.biome.getRandomWorldGenForDoubleFlower(this.rand);
            doubleFlowerGen.func_76484_a(this.worldObj, this.rand, i, j, k6);
        }
        for (l2 = 0; l2 < this.grassPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k7 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator grassGen = this.biome.func_76730_b(this.rand);
            grassGen.func_76484_a(this.worldObj, this.rand, i, j, k7);
        }
        for (l2 = 0; l2 < this.doubleGrassPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k8 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator grassGen = this.biome.getRandomWorldGenForDoubleGrass(this.rand);
            grassGen.func_76484_a(this.worldObj, this.rand, i, j, k8);
        }
        for (l2 = 0; l2 < this.deadBushPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k9 = this.chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(this.worldObj, this.rand, i, j, k9);
        }
        for (l2 = 0; l2 < this.waterlilyPerChunk; ++l2) {
            int j5;
            i = this.chunkX + this.rand.nextInt(16) + 8;
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            for (j5 = this.rand.nextInt(128); j5 > 0 && this.worldObj.func_147439_a(i, j5 - 1, k) == Blocks.field_150350_a; --j5) {
            }
            this.waterlilyGen.func_76484_a(this.worldObj, this.rand, i, j5, k);
        }
        for (l2 = 0; l2 < this.mushroomsPerChunk; ++l2) {
            int j6;
            if (this.rand.nextInt(4) == 0) {
                i = this.chunkX + this.rand.nextInt(16) + 8;
                k = this.chunkZ + this.rand.nextInt(16) + 8;
                j6 = this.worldObj.func_72976_f(i, k);
                this.mushroomBrownGen.func_76484_a(this.worldObj, this.rand, i, j6, k);
            }
            if (this.rand.nextInt(8) != 0) continue;
            i = this.chunkX + this.rand.nextInt(16) + 8;
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            j6 = this.worldObj.func_72976_f(i, k);
            this.mushroomRedGen.func_76484_a(this.worldObj, this.rand, i, j6, k);
        }
        if (this.rand.nextInt(4) == 0) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(128);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.mushroomBrownGen.func_76484_a(this.worldObj, this.rand, i3, j2, k);
        }
        if (this.rand.nextInt(8) == 0) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(128);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.mushroomRedGen.func_76484_a(this.worldObj, this.rand, i3, j2, k);
        }
        for (l2 = 0; l2 < this.reedsPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k10 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.reedGen.func_76484_a(this.worldObj, this.rand, i, j, k10);
        }
        for (l2 = 0; l2 < 10; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k11 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.reedGen.func_76484_a(this.worldObj, this.rand, i, j, k11);
        }
        for (l2 = 0; l2 < this.cactiPerChunk; ++l2) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k12 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.cactusGen.func_76484_a(this.worldObj, this.rand, i, j, k12);
        }
        if (this.flowersPerChunk > 0 && this.rand.nextInt(32) == 0) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(128);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.pumpkinGen.func_76484_a(this.worldObj, this.rand, i3, j2, k);
        }
        if (this.generateAthelas && this.rand.nextInt(40) == 0) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(128);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(LOTRMod.athelas).func_76484_a(this.worldObj, this.rand, i3, j2, k);
        }
        if (this.generateWater) {
            WorldGenLiquids waterGen = new WorldGenLiquids((Block)Blocks.field_150358_i);
            for (l = 0; l < 50; ++l) {
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                int j7 = this.rand.nextInt(this.rand.nextInt(120) + 8);
                int k13 = this.chunkZ + this.rand.nextInt(16) + 8;
                waterGen.func_76484_a(this.worldObj, this.rand, i2, j7, k13);
            }
        }
        if (this.generateLava) {
            if (this.biome instanceof LOTRBiomeGenMordor) {
                LOTRWorldGenMordorLava lavaGen = new LOTRWorldGenMordorLava();
                for (l = 0; l < 50; ++l) {
                    i2 = this.chunkX + this.rand.nextInt(16) + 8;
                    int j8 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
                    int k14 = this.chunkZ + this.rand.nextInt(16) + 8;
                    lavaGen.func_76484_a(this.worldObj, this.rand, i2, j8, k14);
                }
            } else {
                WorldGenLiquids lavaGen = new WorldGenLiquids((Block)Blocks.field_150356_k);
                for (l = 0; l < 20; ++l) {
                    i2 = this.chunkX + this.rand.nextInt(16) + 8;
                    int j9 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
                    int k15 = this.chunkZ + this.rand.nextInt(16) + 8;
                    lavaGen.func_76484_a(this.worldObj, this.rand, i2, j9, k15);
                }
            }
        }
        if (this.generateOrcDungeon) {
            for (int l4 = 0; l4 < 6; ++l4) {
                i = this.chunkX + this.rand.nextInt(16) + 8;
                j = this.rand.nextInt(128);
                int k16 = this.chunkZ + this.rand.nextInt(16) + 8;
                this.orcDungeonGen.func_76484_a(this.worldObj, this.rand, i, j, k16);
            }
        }
        if (this.generateTrollHoard && this.rand.nextInt(3) == 0) {
            int i5 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = 40 + this.rand.nextInt(20);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            this.trollHoardGen.func_76484_a(this.worldObj, this.rand, i5, j2, k);
        }
    }

    public void genStandardOre(int ores, WorldGenerator oreGen, int offset, int heightRange) {
        for (int l = 0; l < ores; ++l) {
            int i = this.chunkX + this.rand.nextInt(16);
            int j = this.rand.nextInt(heightRange - offset) + offset;
            int k = this.chunkZ + this.rand.nextInt(16);
            oreGen.func_76484_a(this.worldObj, this.rand, i, j, k);
        }
    }

    public void genErraticOre(int ores, WorldGenerator oreGen, int offset, int heightRange) {
        for (int l = 0; l < ores; ++l) {
            int i = this.chunkX + this.rand.nextInt(16);
            int j = this.rand.nextInt(heightRange) + this.rand.nextInt(heightRange) + (offset - heightRange);
            int k = this.chunkZ + this.rand.nextInt(16);
            oreGen.func_76484_a(this.worldObj, this.rand, i, j, k);
        }
    }

    private void generateOres() {
        int passes = 1;
        if (this.biome instanceof LOTRBiomeGenRedMountains) {
            passes = 2;
        }
        for (int l = 0; l < passes; ++l) {
            this.genStandardOre(20, this.dirtGen, 0, 128);
            this.genStandardOre(10, this.gravelGen, 0, 128);
            this.genStandardOre(20, this.coalGen, 0, 128);
            this.genStandardOre(20, this.ironGen, 0, 64);
            this.genStandardOre(2, this.goldGen, 0, 32);
            this.genStandardOre(1, this.diamondGen, 0, 16);
            this.genErraticOre(1, this.lapisGen, 16, 16);
            this.genStandardOre(8, this.copperGen, 0, 64);
            this.genStandardOre(8, this.tinGen, 0, 64);
            this.genStandardOre(3, this.silverGen, 0, 32);
            this.genStandardOre(3, this.sulfurGen, 0, 64);
            this.genStandardOre(3, this.saltpeterGen, 0, 64);
        }
        if (this.biome instanceof LOTRBiomeGenMistyMountains || this.biome instanceof LOTRBiomeGenForodwaithMountains) {
            this.genStandardOre(20, this.dirtGen, 128, 256);
            this.genStandardOre(10, this.gravelGen, 128, 256);
            this.genStandardOre(10, this.coalGen, 128, 256);
            this.genStandardOre(10, this.ironGen, 64, 128);
            this.genStandardOre(4, this.copperGen, 64, 128);
            this.genStandardOre(4, this.tinGen, 64, 128);
        }
        if (this.biome instanceof LOTRBiomeGenIronHills || this.biome instanceof LOTRBiomeGenBlueMountains) {
            this.genStandardOre(8, this.oreGlowstoneGen, 0, 48);
        }
    }

    private class RandomStructure {
        public WorldGenerator structure;
        public int chunkChance;

        public RandomStructure(WorldGenerator w, int i) {
            this.structure = w;
            this.chunkChance = i;
        }
    }
}

