/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.npc.LOTREntityAngmarOrc;
import lotr.common.entity.npc.LOTREntityAngmarOrcArcher;
import lotr.common.entity.npc.LOTREntityAngmarOrcBombardier;
import lotr.common.entity.npc.LOTREntityAngmarOrcWarrior;
import lotr.common.entity.npc.LOTREntityAngmarWarg;
import lotr.common.entity.npc.LOTREntityMountainTroll;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBlastedLand;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenCharredTrees;
import lotr.common.world.feature.LOTRWorldGenDeadTrees;
import lotr.common.world.structure.LOTRWorldGenAngmarRuin;
import lotr.common.world.structure.LOTRWorldGenAngmarShrine;
import lotr.common.world.structure.LOTRWorldGenAngmarTower;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenAngmar
extends LOTRBiome {
    private WorldGenerator stonePatchGen = new WorldGenMinable(Blocks.field_150348_b, 0, 50, (Block)Blocks.field_150349_c);
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(Blocks.field_150348_b, 0, 1, 2);
    private WorldGenerator morgulIronGen = new WorldGenMinable(LOTRMod.oreMorgulIron, 8);
    private WorldGenerator guldurilGen = new WorldGenMinable(LOTRMod.oreGulduril, 8);

    public LOTRBiomeGenAngmar(int i) {
        super(i);
        this.field_76762_K.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 10, 4, 8));
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityAngmarOrc.class, 20, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityAngmarOrcArcher.class, 7, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityAngmarOrcBombardier.class, 3, 1, 2));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityAngmarOrcWarrior.class, 15, 4, 4));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityTroll.class, 40, 1, 3));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMountainTroll.class, 30, 1, 3));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityAngmarWarg.class, 30, 4, 4));
        this.decorator.flowersPerChunk = 0;
        this.decorator.grassPerChunk = 2;
        this.decorator.doubleGrassPerChunk = 1;
        this.decorator.generateOrcDungeon = true;
        this.decorator.generateTrollHoard = true;
        this.decorator.addRandomStructure(new LOTRWorldGenAngmarTower(false), 400);
        this.decorator.addRandomStructure(new LOTRWorldGenAngmarRuin(), 30);
        this.decorator.addRandomStructure(new LOTRWorldGenBlastedLand(), 40);
        this.decorator.addRandomStructure(new LOTRWorldGenAngmarShrine(false), 200);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterAngmar;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.ANGMAR;
    }

    @Override
    public boolean getEnableRiver() {
        return false;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 8, this.stonePatchGen, 60, 100);
        this.genStandardOre(world, random, i, k, 20, this.morgulIronGen, 0, 64);
        this.genStandardOre(world, random, i, k, 8, this.guldurilGen, 0, 32);
        super.func_76728_a(world, random, i, k);
        for (int l = 0; l < 4; ++l) {
            int k1;
            int i1 = i + random.nextInt(16) + 8;
            int j1 = world.func_72976_f(i1, k1 = k + random.nextInt(16) + 8);
            if (j1 <= 80) continue;
            this.func_150567_a(random).func_76484_a(world, random, i1, j1, k1);
        }
        if (random.nextInt(6) == 0) {
            int i1 = i + random.nextInt(16) + 8;
            int k1 = k + random.nextInt(16) + 8;
            this.boulderGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextBoolean()) {
            if (random.nextBoolean()) {
                return new LOTRWorldGenCharredTrees();
            }
            return LOTRWorldGenDeadTrees.newSpruce();
        }
        return random.nextInt(3) == 0 ? new WorldGenTaiga1() : new WorldGenTaiga2(false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.1f;
    }

    @Override
    public boolean canSpawnHostilesInDay() {
        return true;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.25f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.0f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int i, int j, int k) {
        return 7896151;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float f) {
        return 5324595;
    }

    @Override
    public Vec3 getCloudColor(Vec3 clouds) {
        clouds.field_72450_a *= 0.1;
        clouds.field_72448_b *= 0.1;
        clouds.field_72449_c *= 0.1;
        return clouds;
    }

    @Override
    public Vec3 getFogColor(Vec3 fog) {
        fog.field_72450_a *= 0.1;
        fog.field_72448_b *= 0.1;
        fog.field_72449_c *= 0.1;
        return fog;
    }
}

