/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.npc.LOTREntityBlueDwarf;
import lotr.common.entity.npc.LOTREntityBlueDwarfAxeThrower;
import lotr.common.entity.npc.LOTREntityBlueDwarfMiner;
import lotr.common.entity.npc.LOTREntityBlueDwarfWarrior;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRWorldGenBlueMountainsHouse;
import lotr.common.world.structure.LOTRWorldGenBlueMountainsStronghold;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenBlueMountains
extends LOTRBiome {
    private WorldGenerator additionalIronGen = new WorldGenMinable(Blocks.field_150366_p, 4);
    private WorldGenerator additionalCoalGen = new WorldGenMinable(Blocks.field_150365_q, 8);

    public LOTRBiomeGenBlueMountains(int i) {
        super(i);
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBlueDwarf.class, 100, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBlueDwarfMiner.class, 15, 1, 3));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBlueDwarfWarrior.class, 20, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBlueDwarfAxeThrower.class, 10, 4, 4));
        this.spawnableEvilList.clear();
        this.setGoodEvilWeight(100, 0);
        this.decorator.treesPerChunk = 1;
        this.decorator.flowersPerChunk = 1;
        this.decorator.grassPerChunk = 3;
        this.decorator.doubleGrassPerChunk = 1;
        this.decorator.generateWater = false;
        this.decorator.generateLava = false;
        this.decorator.generateCobwebs = false;
        this.registerMountainsFlowers();
        this.addFlower(LOTRMod.dwarfHerb, 0, 1);
        this.decorator.addRandomStructure(new LOTRWorldGenBlueMountainsStronghold(false), 500);
        this.registerTravellingTrader(LOTREntityElvenTrader.class);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterBlueMountains;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.BLUE_MOUNTAINS;
    }

    @Override
    public boolean getEnableRiver() {
        return false;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 10, this.additionalCoalGen, 0, 128);
        this.genStandardOre(world, random, i, k, 10, this.additionalIronGen, 0, 96);
        super.func_76728_a(world, random, i, k);
        for (int l = 0; l < 4; ++l) {
            int i1 = i + random.nextInt(16) + 8;
            int j1 = 70 + random.nextInt(80);
            int k1 = k + random.nextInt(16) + 8;
            new LOTRWorldGenBlueMountainsHouse(false).func_76484_a(world, random, i1, j1, k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(4) == 0) {
            return new WorldGenForest(false, false);
        }
        if (random.nextInt(3) == 0) {
            return new WorldGenTaiga2(false);
        }
        return super.func_150567_a(random);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float f) {
        return 7506425;
    }
}

