/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityCrebain;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.entity.npc.LOTREntityDunlendingArcher;
import lotr.common.entity.npc.LOTREntityDunlendingWarrior;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.structure.LOTRWorldGenDunlandHillFort;
import lotr.common.world.structure.LOTRWorldGenDunlendingCampfire;
import lotr.common.world.structure.LOTRWorldGenDunlendingHouse;
import lotr.common.world.structure.LOTRWorldGenDunlendingTavern;
import lotr.common.world.structure.LOTRWorldGenStoneRuin;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenDunland
extends LOTRBiome {
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(Blocks.field_150348_b, 0, 1, 3);

    public LOTRBiomeGenDunland(int i) {
        super(i);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 8, 4, 8));
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDunlending.class, 15, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDunlendingWarrior.class, 2, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDunlendingArcher.class, 1, 4, 6));
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityRabbit.class, 6, 4, 4));
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityCrebain.class, 10, 4, 4));
        this.decorator.treesPerChunk = 0;
        this.decorator.grassPerChunk = 3;
        this.decorator.doubleGrassPerChunk = 1;
        this.registerForestFlowers();
        this.decorator.addRandomStructure(new LOTRWorldGenDunlendingHouse(false), 25);
        this.decorator.addRandomStructure(new LOTRWorldGenDunlendingTavern(false), 80);
        this.decorator.addRandomStructure(new LOTRWorldGenDunlendingCampfire(false), 100);
        this.decorator.addRandomStructure(new LOTRWorldGenDunlandHillFort(false), 600);
        this.decorator.addRandomStructure(new LOTRWorldGenStoneRuin(1, 3), 1500);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterDunland;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.DUNLAND;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        int k1;
        int i1;
        super.func_76728_a(world, random, i, k);
        for (int count = 0; count < 6; ++count) {
            i1 = i + random.nextInt(16) + 8;
            int j1 = world.func_72976_f(i1, k1 = k + random.nextInt(16) + 8);
            if (j1 <= 85) continue;
            WorldGenAbstractTree tree = this.func_150567_a(random);
            tree.func_76484_a(world, random, i1, j1, k1);
        }
        if (random.nextInt(8) == 0) {
            for (int l = 0; l < 4; ++l) {
                i1 = i + random.nextInt(16) + 8;
                k1 = k + random.nextInt(16) + 8;
                this.boulderGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return random.nextInt(10) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false, 4 + random.nextInt(5), 0, 0, false);
        }
        return new WorldGenTaiga2(false);
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.75f;
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.5f;
    }

    @Override
    public int spawnCountMultiplier() {
        return 2;
    }
}

