/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityBird;
import lotr.common.entity.animal.LOTREntityButterfly;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.entity.npc.LOTREntityMordorOrc;
import lotr.common.entity.npc.LOTREntityMordorOrcArcher;
import lotr.common.entity.npc.LOTREntityMordorOrcBombardier;
import lotr.common.entity.npc.LOTREntityRangerIthilien;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenSimpleTrees;
import lotr.common.world.structure.LOTRWorldGenGondorObelisk;
import lotr.common.world.structure.LOTRWorldGenGondorRuins;
import lotr.common.world.structure.LOTRWorldGenRuinedBeaconTower;
import lotr.common.world.structure.LOTRWorldGenRuinedGondorTower;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenIthilien
extends LOTRBiome {
    private WorldGenerator gondorRockVein = new WorldGenMinable(LOTRMod.rock, 1, 60, Blocks.field_150348_b);

    public LOTRBiomeGenIthilien(int i) {
        super(i);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityHorse.class, 5, 2, 6));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityRangerIthilien.class, 10, 4, 4));
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrc.class, 20, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcArcher.class, 7, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcBombardier.class, 3, 1, 2));
        this.setGoodEvilWeight(5, 95);
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityButterfly.class, 10, 4, 4));
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityRabbit.class, 6, 4, 4));
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBird.class, 10, 4, 4));
        this.decorator.treesPerChunk = 6;
        this.decorator.logsPerChunk = 1;
        this.decorator.flowersPerChunk = 4;
        this.decorator.doubleFlowersPerChunk = 4;
        this.decorator.grassPerChunk = 6;
        this.decorator.doubleGrassPerChunk = 4;
        this.decorator.waterlilyPerChunk = 2;
        this.decorator.generateAthelas = true;
        this.registerForestFlowers();
        this.addFlower(LOTRMod.asphodel, 0, 10);
        this.addFlower((Block)Blocks.field_150328_O, 2, 5);
        this.decorator.generateOrcDungeon = true;
        this.decorator.addRandomStructure(new LOTRWorldGenRuinedBeaconTower(false), 200);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorRuins(), 500);
        this.decorator.addRandomStructure(new LOTRWorldGenRuinedGondorTower(false), 500);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorObelisk(false), 800);
        this.registerTravellingTrader(LOTREntityElvenTrader.class);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterIthilien;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.GONDOR;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 2, this.gondorRockVein, 0, 64);
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(3) == 0) {
            int i1 = i + random.nextInt(16) + 8;
            int j1 = random.nextInt(128);
            int k1 = k + random.nextInt(16) + 8;
            WorldGenDoublePlant doubleFlowerGen = new WorldGenDoublePlant();
            doubleFlowerGen.func_150548_a(0);
            doubleFlowerGen.func_76484_a(world, random, i1, j1, k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(300) == 0) {
            return random.nextBoolean() ? LOTRWorldGenSimpleTrees.newApple(false) : LOTRWorldGenSimpleTrees.newPear(false);
        }
        if (random.nextInt(20) == 0) {
            return new WorldGenForest(false, false);
        }
        if (random.nextInt(5) == 0) {
            return random.nextInt(8) == 0 ? LOTRWorldGenSimpleTrees.newLebethronLarge(false) : LOTRWorldGenSimpleTrees.newLebethron(false);
        }
        return random.nextInt(8) == 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false, 4 + random.nextInt(4), 0, 0, false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.5f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.5f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 0.05f;
    }
}

