/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityBlueDwarfMerchant;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.entity.npc.LOTREntityHighElf;
import lotr.common.entity.npc.LOTREntityHighElfWarrior;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBigTrees;
import lotr.common.world.feature.LOTRWorldGenHugeTrees;
import lotr.common.world.feature.LOTRWorldGenSimpleTrees;
import lotr.common.world.structure.LOTRWorldGenHighElvenHall;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenLindon
extends LOTRBiome {
    private WorldGenerator quenditeGen = new WorldGenMinable(LOTRMod.oreQuendite, 6);

    public LOTRBiomeGenLindon(int i) {
        super(i);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityHorse.class, 5, 2, 6));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityHighElf.class, 10, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityHighElfWarrior.class, 2, 4, 4));
        this.spawnableEvilList.clear();
        this.setGoodEvilWeight(100, 0);
        this.decorator.treesPerChunk = 0;
        this.decorator.flowersPerChunk = 3;
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 1;
        this.registerPlainsFlowers();
        this.addFlower(LOTRMod.elanor, 0, 20);
        this.addFlower(LOTRMod.niphredil, 0, 10);
        this.decorator.addRandomStructure(new LOTRWorldGenHighElvenHall(false), 1000);
        this.registerTravellingTrader(LOTREntityElvenTrader.class);
        this.registerTravellingTrader(LOTREntityBlueDwarfMerchant.class);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterLindon;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.LINDON;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 6, this.quenditeGen, 0, 48);
        super.func_76728_a(world, random, i, k);
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(300) == 0) {
            return random.nextBoolean() ? LOTRWorldGenSimpleTrees.newApple(false) : LOTRWorldGenSimpleTrees.newPear(false);
        }
        if (random.nextInt(4) > 0) {
            if (random.nextInt(10) == 0) {
                return LOTRWorldGenHugeTrees.newBirch();
            }
            return new WorldGenForest(false, random.nextBoolean());
        }
        if (random.nextInt(8) == 0) {
            return random.nextInt(10) == 0 ? LOTRWorldGenBigTrees.newBeech(false) : LOTRWorldGenSimpleTrees.newBeech(false);
        }
        return super.func_150567_a(random);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.2f;
    }

    @Override
    public int spawnCountMultiplier() {
        return 4;
    }
}

