/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBigTrees;
import lotr.common.world.feature.LOTRWorldGenSimpleTrees;
import lotr.common.world.structure.LOTRWorldGenUnderwaterElvenRuin;
import lotr.common.world.structure2.LOTRWorldGenNumenorRuin;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTaiga2;

public class LOTRBiomeGenOcean
extends LOTRBiome {
    private static Random iceRand = new Random();

    public LOTRBiomeGenOcean(int i) {
        super(i);
        this.spawnableEvilList.clear();
        this.decorator.treesPerChunk = 1;
        this.decorator.flowersPerChunk = 2;
        this.decorator.doubleFlowersPerChunk = 1;
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 1;
        this.decorator.addRandomStructure(new LOTRWorldGenNumenorRuin(false), 500);
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.OCEAN;
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterOcean;
    }

    @Override
    public boolean getEnableRiver() {
        return false;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (i < LOTRWaypoint.MITHLOND.getXCoord() && k > LOTRWaypoint.SOUTH_FOROCHEL.getZCoord() && k < LOTRWaypoint.ERYN_VORN.getZCoord() && random.nextInt(200) == 0) {
            int i1 = i + random.nextInt(16) + 8;
            int k1 = k + random.nextInt(16) + 8;
            int j1 = world.func_72825_h(i1, k1);
            new LOTRWorldGenUnderwaterElvenRuin(false).func_76484_a(world, random, i1, j1, k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(300) == 0) {
            return random.nextBoolean() ? LOTRWorldGenSimpleTrees.newApple(false) : LOTRWorldGenSimpleTrees.newPear(false);
        }
        if (random.nextInt(20) == 0) {
            return new WorldGenForest(false, false);
        }
        if (random.nextInt(3) == 0) {
            return new WorldGenTaiga2(false);
        }
        if (random.nextInt(40) == 0) {
            return random.nextInt(10) == 0 ? LOTRWorldGenBigTrees.newBeech(false) : LOTRWorldGenSimpleTrees.newBeech(false);
        }
        return super.func_150567_a(random);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    public static boolean isFrozen(int i, int k) {
        if (k > -30000) {
            return false;
        }
        int l = -60000 - k;
        if ((l *= -1) < 1) {
            return true;
        }
        iceRand.setSeed((long)i * 341873128712L + (long)k * 132897987541L);
        if ((l -= 15000) < 0) {
            l *= -1;
            if ((l = (int)Math.sqrt(l)) < 2) {
                l = 2;
            }
            return iceRand.nextInt(l) != 0;
        }
        if ((l = (int)Math.sqrt(l)) < 2) {
            l = 2;
        }
        return iceRand.nextInt(l) == 0;
    }
}

