/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityBlueDwarfMerchant;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTREntityRohirrimArcher;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTREntityUrukHaiBerserker;
import lotr.common.entity.npc.LOTREntityUrukHaiCrossbower;
import lotr.common.entity.npc.LOTREntityUrukWarg;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBlastedLand;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenCharredTrees;
import lotr.common.world.feature.LOTRWorldGenDeadTrees;
import lotr.common.world.feature.LOTRWorldGenSimpleTrees;
import lotr.common.world.structure.LOTRWorldGenMeadHall;
import lotr.common.world.structure.LOTRWorldGenRohanBarrow;
import lotr.common.world.structure.LOTRWorldGenRohanFortress;
import lotr.common.world.structure.LOTRWorldGenRohanWatchtower;
import lotr.common.world.structure.LOTRWorldGenRuinedRohanWatchtower;
import lotr.common.world.structure.LOTRWorldGenUrukCamp;
import lotr.common.world.structure.LOTRWorldGenUrukWargPit;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenRohan
extends LOTRBiome {
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(LOTRMod.rock, 2, 1, 4);
    private WorldGenerator deadMoundGen = new LOTRWorldGenBoulder(Blocks.field_150425_aM, 0, 1, 3);
    private WorldGenerator rohanRockVein = new WorldGenMinable(LOTRMod.rock, 2, 60, Blocks.field_150348_b);
    private boolean corrupted;

    public LOTRBiomeGenRohan(int i, boolean flag) {
        super(i);
        this.corrupted = flag;
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityUrukHai.class, 20, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityUrukHaiCrossbower.class, 7, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityUrukHaiBerserker.class, 3, 1, 2));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityUrukWarg.class, 5, 4, 4));
        if (this.corrupted) {
            this.field_76762_K.clear();
            this.setGoodEvilWeight(0, 100);
            this.decorator.addRandomStructure(new LOTRWorldGenUrukCamp(), 120);
            this.decorator.addRandomStructure(new LOTRWorldGenUrukWargPit(false), 300);
            this.decorator.addRandomStructure(new LOTRWorldGenRuinedRohanWatchtower(false), 300);
            this.decorator.addRandomStructure(new LOTRWorldGenBlastedLand(), 24);
        } else {
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityHorse.class, 50, 2, 6));
            this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityRohirrim.class, 20, 4, 4));
            this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityRohirrimArcher.class, 10, 4, 4));
            this.setGoodEvilWeight(70, 30);
            this.decorator.addRandomStructure(new LOTRWorldGenRohanWatchtower(false), 300);
            this.decorator.addRandomStructure(new LOTRWorldGenMeadHall(false), 600);
            this.decorator.addRandomStructure(new LOTRWorldGenRohanFortress(false), 800);
            this.registerTravellingTrader(LOTREntityElvenTrader.class);
            this.registerTravellingTrader(LOTREntityBlueDwarfMerchant.class);
        }
        this.decorator.flowersPerChunk = 4;
        this.decorator.grassPerChunk = 6;
        this.decorator.doubleGrassPerChunk = 5;
        this.registerPlainsFlowers();
        this.decorator.addRandomStructure(new LOTRWorldGenRohanBarrow(false), 500);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        if (this.corrupted) {
            return LOTRAchievement.enterRohanUrukHighlands;
        }
        return LOTRAchievement.enterRohan;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.ROHAN;
    }

    @Override
    public boolean getEnableRiver() {
        return !this.corrupted;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        int k1;
        int i1;
        this.genStandardOre(world, random, i, k, 2, this.rohanRockVein, 0, 64);
        if (this.corrupted && random.nextInt(30) == 0) {
            WorldGenAbstractTree treeGen = random.nextInt(3) == 0 ? LOTRWorldGenDeadTrees.newOak() : new LOTRWorldGenCharredTrees();
            int trees = 3 + random.nextInt(5);
            for (int l = 0; l < trees; ++l) {
                int i12 = i + random.nextInt(16) + 8;
                int k12 = k + random.nextInt(16) + 8;
                treeGen.func_76484_a(world, random, i12, world.func_72976_f(i12, k12), k12);
            }
        }
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(16) == 0) {
            for (int l = 0; l < 3; ++l) {
                i1 = i + random.nextInt(16) + 8;
                k1 = k + random.nextInt(16) + 8;
                this.boulderGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
            }
        }
        if (this.corrupted && random.nextInt(32) == 0) {
            for (int l = 0; l < 3; ++l) {
                i1 = i + random.nextInt(16) + 8;
                k1 = k + random.nextInt(16) + 8;
                this.deadMoundGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
                for (int l1 = 0; l1 < 4; ++l1) {
                    int k2;
                    int j2;
                    int i2 = i1 - 4 + random.nextInt(9);
                    if (!LOTRMod.isOpaque(world, i2, (j2 = world.func_72976_f(i2, k2 = k1 - 4 + random.nextInt(9))) - 1, k2) || !world.func_147437_c(i2, j2, k2) && world.func_147439_a(i2, j2, k2) != Blocks.field_150329_H) continue;
                    world.func_147465_d(i2, j2, k2, Blocks.field_150465_bP, 1, 2);
                    TileEntity tileentity = world.func_147438_o(i2, j2, k2);
                    if (tileentity == null || !(tileentity instanceof TileEntitySkull)) continue;
                    TileEntitySkull skull = (TileEntitySkull)tileentity;
                    skull.func_145903_a(random.nextInt(16));
                }
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(300) == 0) {
            return random.nextBoolean() ? LOTRWorldGenSimpleTrees.newApple(false) : LOTRWorldGenSimpleTrees.newPear(false);
        }
        return random.nextInt(3) > 0 ? new WorldGenBigTree(false) : new WorldGenTrees(false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return this.corrupted ? 0.0f : 0.5f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.1f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 0.05f;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.05f;
    }

    @Override
    public boolean canSpawnHostilesInDay() {
        return this.corrupted;
    }

    @Override
    public int spawnCountMultiplier() {
        return this.corrupted ? 2 : super.spawnCountMultiplier();
    }
}

