/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.feature;

import java.util.Random;
import lotr.common.LOTRMod;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRWorldGenBoulder
extends WorldGenerator {
    private Block id;
    private int meta;
    private int minWidth;
    private int maxWidth;
    private Block spawnID;
    private int spawnMeta;
    private int heightCheck = 3;

    public LOTRWorldGenBoulder(Block i, int j, int k, int l) {
        super(false);
        this.id = i;
        this.meta = j;
        this.minWidth = k;
        this.maxWidth = l;
        this.spawnID = Blocks.field_150349_c;
        this.spawnMeta = 0;
    }

    public LOTRWorldGenBoulder setSpawnBlock(Block i, int j) {
        this.spawnID = i;
        this.spawnMeta = j;
        return this;
    }

    public LOTRWorldGenBoulder setHeightCheck(int i) {
        this.heightCheck = i;
        return this;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (world.func_147439_a(i, j - 1, k) != this.spawnID || world.func_72805_g(i, j - 1, k) != this.spawnMeta) {
            return false;
        }
        int boulderWidth = MathHelper.func_76136_a((Random)random, (int)this.minWidth, (int)this.maxWidth);
        int highestHeight = j;
        int lowestHeight = j;
        for (int i1 = i - boulderWidth; i1 <= i + boulderWidth; ++i1) {
            for (int k1 = k - boulderWidth; k1 <= k + boulderWidth; ++k1) {
                int heightValue = world.func_72976_f(i1, k1);
                if (world.func_147439_a(i1, heightValue - 1, k1) != this.spawnID || world.func_72805_g(i1, heightValue - 1, k1) != this.spawnMeta) {
                    return false;
                }
                if (heightValue > highestHeight) {
                    highestHeight = heightValue;
                }
                if (heightValue >= lowestHeight) continue;
                lowestHeight = heightValue;
            }
        }
        if (highestHeight - lowestHeight > this.heightCheck) {
            return false;
        }
        int spheres = 1 + random.nextInt(boulderWidth + 1);
        for (int l = 0; l < spheres; ++l) {
            int posX = i - boulderWidth - random.nextInt(boulderWidth * 2);
            int posZ = k - boulderWidth - random.nextInt(boulderWidth * 2);
            int posY = world.func_72825_h(posX, posZ);
            int sphereWidth = MathHelper.func_76136_a((Random)random, (int)this.minWidth, (int)this.maxWidth);
            for (int i1 = posX - sphereWidth; i1 <= posX + sphereWidth; ++i1) {
                for (int j1 = posY - sphereWidth; j1 <= posY + sphereWidth; ++j1) {
                    for (int k1 = posZ - sphereWidth; k1 <= posZ + sphereWidth; ++k1) {
                        int j3;
                        int i2 = i1 - posX;
                        int j2 = j1 - posY;
                        int k2 = k1 - posZ;
                        if (i2 * i2 + j2 * j2 + k2 * k2 >= sphereWidth * sphereWidth) continue;
                        for (j3 = j1; j3 >= 0 && !LOTRMod.isOpaque(world, i1, j3 - 1, k1); --j3) {
                        }
                        this.func_150516_a(world, i1, j3, k1, this.id, this.meta);
                        if (world.func_147439_a(i1, j3 - 1, k1) != Blocks.field_150349_c) continue;
                        this.func_150516_a(world, i1, j3 - 1, k1, Blocks.field_150346_d, 0);
                    }
                }
            }
        }
        return true;
    }
}

