/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.feature;

import java.util.Random;
import lotr.common.LOTRMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRWorldGenFangornTrees
extends WorldGenAbstractTree {
    private Block woodID;
    private int woodMeta;
    private Block leafID;
    private int leafMeta;
    private boolean generateLeaves = true;
    private boolean restrictions = true;

    public LOTRWorldGenFangornTrees(boolean flag, Block i, int j, Block k, int l) {
        super(flag);
        this.woodID = i;
        this.woodMeta = j;
        this.leafID = k;
        this.leafMeta = l;
    }

    public LOTRWorldGenFangornTrees disableRestrictions() {
        this.restrictions = false;
        return this;
    }

    public LOTRWorldGenFangornTrees setNoLeaves() {
        this.generateLeaves = false;
        return this;
    }

    public static LOTRWorldGenFangornTrees newOak(boolean flag) {
        return new LOTRWorldGenFangornTrees(flag, Blocks.field_150364_r, 0, (Block)Blocks.field_150362_t, 0);
    }

    public static LOTRWorldGenFangornTrees newBeech(boolean flag) {
        return new LOTRWorldGenFangornTrees(flag, LOTRMod.wood2, 1, LOTRMod.leaves2, 1);
    }

    public static LOTRWorldGenFangornTrees newBirch(boolean flag) {
        return new LOTRWorldGenFangornTrees(flag, Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2);
    }

    public static LOTRWorldGenFangornTrees newCharred(boolean flag) {
        return new LOTRWorldGenFangornTrees(flag, LOTRMod.wood, 3, Blocks.field_150350_a, 0).setNoLeaves();
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        float f = 0.5f + random.nextFloat() * 0.5f;
        int height = (int)(f * 40.0f);
        int trunkRadiusMin = (int)(f * 5.0f);
        int trunkRadiusMax = trunkRadiusMin + 4;
        int xSlope = 4 + random.nextInt(7);
        if (random.nextBoolean()) {
            xSlope *= -1;
        }
        int zSlope = 4 + random.nextInt(7);
        if (random.nextBoolean()) {
            zSlope *= -1;
        }
        if (this.restrictions) {
            boolean flag = true;
            if (j >= 1 && j + height + 5 <= 256) {
                for (int i1 = i - 1; i1 <= i + 1; ++i1) {
                    for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                        for (int j1 = j; j1 <= j + height; ++j1) {
                            int width = trunkRadiusMax;
                            for (int i2 = i1 - width; i2 <= i1 + width && flag; ++i2) {
                                for (int k2 = k1 - width; k2 <= k1 + width && flag; ++k2) {
                                    if (j1 >= 0 && j1 < 256) {
                                        Block block = world.func_147439_a(i2, j1, k2);
                                        if (block == Blocks.field_150350_a || block.isLeaves((IBlockAccess)world, i2, j1, k2) || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block.isWood((IBlockAccess)world, i2, j1, k2)) continue;
                                        flag = false;
                                        continue;
                                    }
                                    flag = false;
                                }
                            }
                        }
                    }
                }
                if (!flag) {
                    return false;
                }
            } else {
                return false;
            }
        }
        for (int j1 = 0; j1 < height; ++j1) {
            int width = trunkRadiusMax - (int)((float)j1 / (float)height * (float)(trunkRadiusMax - trunkRadiusMin));
            for (int i1 = i - width; i1 <= i + width; ++i1) {
                for (int k1 = k - width; k1 <= k + width; ++k1) {
                    int i2 = i1 - i;
                    int k2 = k1 - k;
                    if (i2 * i2 + k2 * k2 >= width * width) continue;
                    Block block = world.func_147439_a(i1, j + j1, k1);
                    if (block == Blocks.field_150350_a || block.isLeaves((IBlockAccess)world, i1, j + j1, k1)) {
                        this.func_150516_a(world, i1, j + j1, k1, this.woodID, this.woodMeta);
                    }
                    if (j1 != 0) continue;
                    if (world.func_147439_a(i1, j - 1, k1) == Blocks.field_150349_c) {
                        this.func_150516_a(world, i1, j - 1, k1, Blocks.field_150346_d, 0);
                    }
                    for (int j2 = j - 1; !LOTRMod.isOpaque(world, i1, j2, k1) && j2 >= 0 && Math.abs(j2 - j) <= 6 + random.nextInt(5); --j2) {
                        this.func_150516_a(world, i1, j2, k1, this.woodID, this.woodMeta);
                        if (world.func_147439_a(i1, j2 - 1, k1) != Blocks.field_150349_c) continue;
                        this.func_150516_a(world, i1, j2 - 1, k1, Blocks.field_150346_d, 0);
                    }
                }
            }
            if (j1 % xSlope == 0) {
                if (xSlope > 0) {
                    ++i;
                } else if (xSlope < 0) {
                    --i;
                }
            }
            if (j1 % zSlope != 0) continue;
            if (zSlope > 0) {
                ++k;
                continue;
            }
            if (zSlope >= 0) continue;
            --k;
        }
        int angle = 0;
        while (angle < 360) {
            float angleR = (float)(angle += 10 + random.nextInt(20)) / 180.0f * (float)Math.PI;
            float sin = MathHelper.func_76126_a((float)angleR);
            float cos = MathHelper.func_76134_b((float)angleR);
            int boughLength = 12 + random.nextInt(10);
            int boughThickness = Math.round((float)boughLength / 25.0f * 1.5f);
            int boughBaseHeight = j + MathHelper.func_76128_c((double)((float)height * (0.9f + random.nextFloat() * 0.1f)));
            int boughHeight = 3 + random.nextInt(4);
            for (int l = 0; l < boughLength; ++l) {
                int i1 = i + Math.round(sin * (float)l);
                int k1 = k + Math.round(cos * (float)l);
                int j1 = boughBaseHeight + Math.round((float)l / (float)boughLength * (float)boughHeight);
                int range = boughThickness - Math.round((float)l / (float)boughLength * (float)boughThickness * 0.5f);
                for (int i2 = i1 - range; i2 <= i1 + range; ++i2) {
                    for (int j2 = j1 - range; j2 <= j1 + range; ++j2) {
                        for (int k2 = k1 - range; k2 <= k1 + range; ++k2) {
                            Block block = world.func_147439_a(i2, j2, k2);
                            if (block != null && !block.isLeaves((IBlockAccess)world, i2, j2, k2)) continue;
                            this.func_150516_a(world, i2, j2, k2, this.woodID, this.woodMeta | 0xC);
                        }
                    }
                }
                int branch_angle = angle + random.nextInt(360);
                float branch_angleR = (float)branch_angle / 180.0f * (float)Math.PI;
                float branch_sin = MathHelper.func_76126_a((float)branch_angleR);
                float branch_cos = MathHelper.func_76134_b((float)branch_angleR);
                int branchLength = 7 + random.nextInt(6);
                int branchHeight = random.nextInt(6);
                int leafRange = 3;
                for (int l1 = 0; l1 < branchLength; ++l1) {
                    int j2;
                    int i2 = i1 + Math.round(branch_sin * (float)l1);
                    int k2 = k1 + Math.round(branch_cos * (float)l1);
                    for (int j3 = j2 = j1 + Math.round((float)l1 / (float)branchLength * (float)branchHeight); j3 >= j2 - 1; --j3) {
                        Block block = world.func_147439_a(i2, j3, k2);
                        if (block != null && !block.isLeaves((IBlockAccess)world, i2, j3, k2)) continue;
                        this.func_150516_a(world, i2, j3, k2, this.woodID, this.woodMeta | 0xC);
                    }
                    if (!this.generateLeaves || l1 != branchLength - 1) continue;
                    for (int i3 = i2 - leafRange; i3 <= i2 + leafRange; ++i3) {
                        for (int j3 = j2 - leafRange; j3 <= j2 + leafRange; ++j3) {
                            for (int k3 = k2 - leafRange; k3 <= k2 + leafRange; ++k3) {
                                Block block2;
                                int i4 = i3 - i2;
                                int j4 = j3 - j2;
                                int k4 = k3 - k2;
                                int dist = i4 * i4 + j4 * j4 + k4 * k4;
                                if (dist >= (leafRange - 1) * (leafRange - 1) && (dist >= leafRange * leafRange || random.nextInt(3) == 0) || (block2 = world.func_147439_a(i3, j3, k3)).func_149688_o() != Material.field_151579_a && !block2.isLeaves((IBlockAccess)world, i3, j3, k3)) continue;
                                this.func_150516_a(world, i3, j3, k3, this.leafID, this.leafMeta);
                                if (random.nextInt(40) == 0 && world.func_147437_c(i3 - 1, j3, k3)) {
                                    this.growVines(world, random, i3 - 1, j3, k3, 8);
                                }
                                if (random.nextInt(40) == 0 && world.func_147437_c(i3 + 1, j3, k3)) {
                                    this.growVines(world, random, i3 + 1, j3, k3, 2);
                                }
                                if (random.nextInt(40) == 0 && world.func_147437_c(i3, j3, k3 - 1)) {
                                    this.growVines(world, random, i3, j3, k3 - 1, 1);
                                }
                                if (random.nextInt(40) != 0 || !world.func_147437_c(i3, j3, k3 + 1)) continue;
                                this.growVines(world, random, i3, j3, k3 + 1, 4);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private void growVines(World world, Random random, int i, int j, int k, int meta) {
        this.func_150516_a(world, i, j, k, Blocks.field_150395_bd, meta);
        int length = 4 + random.nextInt(12);
        while (world.func_147437_c(i, --j, k) && length > 0) {
            this.func_150516_a(world, i, j, k, Blocks.field_150395_bd, meta);
            --length;
        }
        return;
    }
}

