/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.world.biome.LOTRBiomeGenDunland;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRWorldGenDunlendingHouse
extends LOTRWorldGenStructureBase {
    private Block plankBlock;
    private int plankMeta;
    private Block woodBlock;
    private int woodMeta;
    private Block slabBlock;
    private int slabMeta;
    private Block stairBlock;
    private Block floorBlock;
    private int floorMeta;

    public LOTRWorldGenDunlendingHouse(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int k1;
        int i1;
        if (this.restrictions && (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c || !(world.func_72807_a(i, k) instanceof LOTRBiomeGenDunland))) {
            return false;
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        int originX = i;
        int originZ = k;
        int xRange = 0;
        int zRange = 0;
        switch (rotation) {
            case 0: {
                k += 7;
                xRange = 4;
                zRange = 6;
                break;
            }
            case 1: {
                i -= 7;
                xRange = 6;
                zRange = 4;
                break;
            }
            case 2: {
                k -= 7;
                xRange = 4;
                zRange = 6;
                break;
            }
            case 3: {
                i += 7;
                xRange = 6;
                zRange = 4;
            }
        }
        if (this.restrictions) {
            for (int i12 = i - xRange; i12 <= i + xRange; ++i12) {
                for (int k12 = k - zRange; k12 <= k + zRange; ++k12) {
                    int j1 = world.func_72825_h(i12, k12) - 1;
                    if (Math.abs(j1 - j) > 5) {
                        return false;
                    }
                    Block l = world.func_147439_a(i12, j1, k12);
                    if (l == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72317_d(0.0, 4.0, 0.0).func_72314_b((double)xRange, 4.0, (double)zRange));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
            for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
                for (int k13 = k - zRange; k13 <= k + zRange; ++k13) {
                    int j1 = world.func_72825_h(i1, k13) - 1;
                    if (Math.abs(j1 - j) > 5) {
                        return false;
                    }
                    Block l = world.func_147439_a(i1, j1, k13);
                    if (l == Blocks.field_150349_c) continue;
                    return false;
                }
            }
        }
        if (random.nextBoolean()) {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 0;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 0;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 0;
            this.stairBlock = Blocks.field_150476_ad;
        } else {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 1;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 1;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 1;
            this.stairBlock = Blocks.field_150485_bF;
        }
        Object[] obj = LOTRWorldGenDunlendingHouse.getRandomDunlandFloorBlock(random);
        this.floorBlock = (Block)obj[0];
        this.floorMeta = (Integer)obj[1];
        for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
            for (int k14 = k - zRange; k14 <= k + zRange; ++k14) {
                for (int j1 = j + 5; !(j1 < j && LOTRMod.isOpaque(world, i1, j1, k14) || j1 < 0); --j1) {
                    if (Math.abs(i1 - i) == xRange && Math.abs(k14 - k) == zRange) {
                        this.func_150516_a(world, i1, j1, k14, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(i1 - i) == xRange || Math.abs(k14 - k) == zRange) {
                        this.func_150516_a(world, i1, j1, k14, this.plankBlock, this.plankMeta);
                    } else if (j1 > j) {
                        this.func_150516_a(world, i1, j1, k14, Blocks.field_150350_a, 0);
                    } else if (j1 == j) {
                        this.func_150516_a(world, i1, j1, k14, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i1, j1, k14, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j1 - 1, k14) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k14, Blocks.field_150346_d, 0);
                }
            }
        }
        for (i1 = i - xRange + 1; i1 <= i + xRange - 1; ++i1) {
            this.func_150516_a(world, i1, j + 4, k - zRange, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k + zRange, this.woodBlock, this.woodMeta | 4);
        }
        for (k1 = k - zRange + 1; k1 <= k + zRange - 1; ++k1) {
            this.func_150516_a(world, i - xRange, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + xRange, j + 4, k1, this.woodBlock, this.woodMeta | 8);
        }
        for (int j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - xRange + 1, j1, k - zRange + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + xRange - 1, j1, k - zRange + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - xRange + 1, j1, k + zRange - 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + xRange - 1, j1, k + zRange - 1, this.woodBlock, this.woodMeta);
        }
        if (xRange > zRange) {
            for (i1 = i - xRange - 1; i1 <= i + xRange + 1; ++i1) {
                for (int stair = 0; stair < 3; ++stair) {
                    this.func_150516_a(world, i1, j + 4 + stair, k - zRange - 1 + stair, this.stairBlock, 2);
                    this.func_150516_a(world, i1, j + 4 + stair, k + zRange + 1 - stair, this.stairBlock, 3);
                }
            }
            for (k1 = k - zRange + 2; k1 <= k + zRange - 2; ++k1) {
                this.func_150516_a(world, i - xRange - 1, j + 6, k1, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i + xRange + 1, j + 6, k1, this.slabBlock, this.slabMeta | 8);
            }
            zRange -= 2;
        } else {
            for (k1 = k - zRange - 1; k1 <= k + zRange + 1; ++k1) {
                for (int stair = 0; stair < 3; ++stair) {
                    this.func_150516_a(world, i - xRange - 1 + stair, j + 4 + stair, k1, this.stairBlock, 0);
                    this.func_150516_a(world, i + xRange + 1 - stair, j + 4 + stair, k1, this.stairBlock, 1);
                }
            }
            for (i1 = i - xRange + 2; i1 <= i + xRange - 2; ++i1) {
                this.func_150516_a(world, i1, j + 6, k - zRange - 1, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i1, j + 6, k + zRange + 1, this.slabBlock, this.slabMeta | 8);
            }
            xRange -= 2;
        }
        for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
            for (int k15 = k - zRange; k15 <= k + zRange; ++k15) {
                this.func_150516_a(world, i1, j + 6, k15, this.plankBlock, this.plankMeta);
            }
        }
        this.func_150516_a(world, i, j - 2, k, LOTRMod.hearth, 0);
        this.func_150516_a(world, i, j - 1, k, (Block)Blocks.field_150480_ab, 0);
        this.func_150516_a(world, i - 1, j - 1, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 1, j - 1, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j - 1, k - 1, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j - 1, k + 1, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j, k, Blocks.field_150411_aY, 0);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int k16 = k - 1; k16 <= k + 1; ++k16) {
                for (int j1 = j + 6; j1 <= j + 8; ++j1) {
                    if (i1 == i && k16 == k) {
                        this.func_150516_a(world, i1, j1, k16, Blocks.field_150350_a, 0);
                        continue;
                    }
                    this.func_150516_a(world, i1, j1, k16, this.plankBlock, this.plankMeta);
                }
            }
        }
        switch (rotation) {
            case 0: {
                this.generateFacingSouth(world, random, i, j, k);
                break;
            }
            case 1: {
                this.generateFacingWest(world, random, i, j, k);
                break;
            }
            case 2: {
                this.generateFacingNorth(world, random, i, j, k);
                break;
            }
            case 3: {
                this.generateFacingEast(world, random, i, j, k);
            }
        }
        LOTREntityDunlending dunlending = new LOTREntityDunlending(world);
        dunlending.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
        dunlending.func_110161_a(null);
        dunlending.func_110171_b(i, j, k, 12);
        dunlending.isNPCPersistent = true;
        world.func_72838_d((Entity)dunlending);
        return true;
    }

    private void generateFacingSouth(World world, Random random, int i, int j, int k) {
        int k1;
        this.func_150516_a(world, i, j, k - 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k - 6, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 2, k - 6, Blocks.field_150466_ao, 8);
        for (k1 = k - 2; k1 <= k + 2; k1 += 2) {
            this.func_150516_a(world, i - 4, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 4, j + 2, k1, Blocks.field_150350_a, 0);
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i + 3, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        for (int i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 5, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i - 3, j + 1, k - 2, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 3, j + 1, k - 2, 5);
        this.func_150516_a(world, i - 3, j + 1, k, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 3, j + 1, k, LOTRChestContents.DUNLENDING_HOUSE);
        this.func_150516_a(world, i - 3, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i - 3, j + 2, k + 2, this.getRandomPlant(random));
        this.func_150516_a(world, i + 3, j + 1, k - 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 3, j + 1, k, LOTRMod.dunlendingTable, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i + 3, j + 2, k + 2, this.getRandomPlant(random));
        this.func_150516_a(world, i, j + 1, k + 4, Blocks.field_150324_C, 0);
        this.func_150516_a(world, i, j + 1, k + 5, Blocks.field_150324_C, 8);
        this.func_150516_a(world, i - 1, j + 1, k + 5, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 1, k + 5, this.plankBlock, this.plankMeta);
        this.placeItemFrame(world, i, j + 3, k + 6, 2, random);
        this.func_150516_a(world, i - 2, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 2, k - 4, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 3, j + 2, k + 4, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 2, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 2, k - 4, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 3, j + 2, k + 4, Blocks.field_150478_aa, 2);
    }

    private void generateFacingWest(World world, Random random, int i, int j, int k) {
        int i1;
        this.func_150516_a(world, i + 6, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 6, j + 1, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 6, j + 2, k, Blocks.field_150466_ao, 8);
        for (i1 = i - 2; i1 <= i + 2; i1 += 2) {
            this.func_150516_a(world, i1, j + 2, k - 4, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 2, k + 4, Blocks.field_150350_a, 0);
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i1, j + 1, k + 3, this.slabBlock, this.slabMeta | 8);
        }
        for (int k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 5, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i + 2, j + 1, k - 3, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i + 2, j + 1, k - 3, 3);
        this.func_150516_a(world, i, j + 1, k - 3, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i, j + 1, k - 3, LOTRChestContents.DUNLENDING_HOUSE);
        this.func_150516_a(world, i - 2, j + 1, k - 3, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i - 2, j + 2, k - 3, this.getRandomPlant(random));
        this.func_150516_a(world, i + 2, j + 1, k + 3, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i, j + 1, k + 3, LOTRMod.dunlendingTable, 0);
        this.func_150516_a(world, i - 2, j + 1, k + 3, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i - 2, j + 2, k + 3, this.getRandomPlant(random));
        this.func_150516_a(world, i - 4, j + 1, k, Blocks.field_150324_C, 1);
        this.func_150516_a(world, i - 5, j + 1, k, Blocks.field_150324_C, 9);
        this.func_150516_a(world, i - 5, j + 1, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 5, j + 1, k + 1, this.plankBlock, this.plankMeta);
        this.placeItemFrame(world, i - 6, j + 3, k, 3, random);
        this.func_150516_a(world, i + 5, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 4, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 5, j + 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j + 2, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 4, j + 2, k + 3, Blocks.field_150478_aa, 4);
    }

    private void generateFacingNorth(World world, Random random, int i, int j, int k) {
        int k1;
        this.func_150516_a(world, i, j, k + 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k + 6, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 2, k + 6, Blocks.field_150466_ao, 8);
        for (k1 = k - 2; k1 <= k + 2; k1 += 2) {
            this.func_150516_a(world, i - 4, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 4, j + 2, k1, Blocks.field_150350_a, 0);
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i + 3, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        for (int i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 5, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i - 3, j + 1, k + 2, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 3, j + 1, k + 2, 5);
        this.func_150516_a(world, i - 3, j + 1, k, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 3, j + 1, k, LOTRChestContents.DUNLENDING_HOUSE);
        this.func_150516_a(world, i - 3, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i - 3, j + 2, k - 2, this.getRandomPlant(random));
        this.func_150516_a(world, i + 3, j + 1, k + 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 3, j + 1, k, LOTRMod.dunlendingTable, 0);
        this.func_150516_a(world, i + 3, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i + 3, j + 2, k - 2, this.getRandomPlant(random));
        this.func_150516_a(world, i, j + 1, k - 4, Blocks.field_150324_C, 2);
        this.func_150516_a(world, i, j + 1, k - 5, Blocks.field_150324_C, 10);
        this.func_150516_a(world, i - 1, j + 1, k - 5, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 1, k - 5, this.plankBlock, this.plankMeta);
        this.placeItemFrame(world, i, j + 3, k - 6, 0, random);
        this.func_150516_a(world, i - 2, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 3, j + 2, k - 4, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 3, j + 2, k + 4, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 2, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 2, k - 4, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 3, j + 2, k + 4, Blocks.field_150478_aa, 2);
    }

    private void generateFacingEast(World world, Random random, int i, int j, int k) {
        int i1;
        this.func_150516_a(world, i - 6, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 6, j + 1, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 6, j + 2, k, Blocks.field_150466_ao, 8);
        for (i1 = i - 2; i1 <= i + 2; i1 += 2) {
            this.func_150516_a(world, i1, j + 2, k - 4, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 2, k + 4, Blocks.field_150350_a, 0);
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i1, j + 1, k + 3, this.slabBlock, this.slabMeta | 8);
        }
        for (int k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i + 5, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i - 2, j + 1, k - 3, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 2, j + 1, k - 3, 3);
        this.func_150516_a(world, i, j + 1, k - 3, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i, j + 1, k - 3, LOTRChestContents.DUNLENDING_HOUSE);
        this.func_150516_a(world, i + 2, j + 1, k - 3, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i + 2, j + 2, k - 3, this.getRandomPlant(random));
        this.func_150516_a(world, i - 2, j + 1, k + 3, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i, j + 1, k + 3, LOTRMod.dunlendingTable, 0);
        this.func_150516_a(world, i + 2, j + 1, k + 3, this.plankBlock, this.plankMeta);
        this.placeFlowerPot(world, i + 2, j + 2, k + 3, this.getRandomPlant(random));
        this.func_150516_a(world, i + 4, j + 1, k, Blocks.field_150324_C, 3);
        this.func_150516_a(world, i + 5, j + 1, k, Blocks.field_150324_C, 11);
        this.func_150516_a(world, i + 5, j + 1, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 5, j + 1, k + 1, this.plankBlock, this.plankMeta);
        this.placeItemFrame(world, i + 6, j + 3, k, 1, random);
        this.func_150516_a(world, i - 5, j + 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 4, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 5, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j + 2, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 4, j + 2, k + 3, Blocks.field_150478_aa, 4);
    }

    private ItemStack getRandomPlant(Random random) {
        return random.nextBoolean() ? new ItemStack((Block)Blocks.field_150328_O) : new ItemStack((Block)Blocks.field_150327_N);
    }

    private void placeItemFrame(World world, int i, int j, int k, int direction, Random random) {
        ItemStack item = null;
        int l = random.nextInt(6);
        switch (l) {
            case 0: {
                item = new ItemStack(Items.field_151103_aS);
                break;
            }
            case 1: {
                item = new ItemStack(Items.field_151040_l);
                break;
            }
            case 2: {
                item = new ItemStack((Item)Items.field_151031_f);
                break;
            }
            case 3: {
                item = new ItemStack(Items.field_151032_g);
                break;
            }
            case 4: {
                item = new ItemStack(LOTRMod.mug);
                break;
            }
            case 5: {
                item = new ItemStack(Items.field_151145_ak);
            }
        }
        this.spawnItemFrame(world, i, j, k, direction, item);
    }

    public static Object[] getRandomDunlandFloorBlock(Random random) {
        Object[] block = new Object[2];
        int randomFloor = random.nextInt(6);
        switch (randomFloor) {
            case 0: {
                block[0] = Blocks.field_150347_e;
                block[1] = 0;
                break;
            }
            case 1: {
                block[0] = Blocks.field_150417_aV;
                block[1] = 0;
                break;
            }
            case 2: {
                block[0] = Blocks.field_150405_ch;
                block[1] = 0;
                break;
            }
            case 3: {
                block[0] = Blocks.field_150406_ce;
                block[1] = 7;
                break;
            }
            case 4: {
                block[0] = Blocks.field_150406_ce;
                block[1] = 12;
                break;
            }
            case 5: {
                block[0] = Blocks.field_150406_ce;
                block[1] = 15;
            }
        }
        return block;
    }
}

