/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.entity.npc.LOTREntityDunlendingBartender;
import lotr.common.entity.npc.LOTREntityDunlendingDrunkard;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiomeGenDunland;
import lotr.common.world.structure.LOTRWorldGenDunlendingHouse;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRWorldGenDunlendingTavern
extends LOTRWorldGenStructureBase {
    private Block plankBlock;
    private int plankMeta;
    private Block woodBlock;
    private int woodMeta;
    private Block slabBlock;
    private int slabMeta;
    private Block stairBlock;
    private Block floorBlock;
    private int floorMeta;
    private Item drink;

    public LOTRWorldGenDunlendingTavern(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int k1;
        int i1;
        if (this.restrictions && (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c || !(world.func_72807_a(i, k) instanceof LOTRBiomeGenDunland))) {
            return false;
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        int xRange = 0;
        int zRange = 0;
        switch (rotation) {
            case 0: {
                k += 11;
                xRange = 6;
                zRange = 10;
                break;
            }
            case 1: {
                i -= 11;
                xRange = 10;
                zRange = 6;
                break;
            }
            case 2: {
                k -= 11;
                xRange = 6;
                zRange = 10;
                break;
            }
            case 3: {
                i += 11;
                xRange = 10;
                zRange = 6;
            }
        }
        if (this.restrictions) {
            for (int i12 = i - xRange; i12 <= i + xRange; ++i12) {
                for (int k12 = k - zRange; k12 <= k + zRange; ++k12) {
                    int j1 = world.func_72825_h(i12, k12) - 1;
                    if (Math.abs(j1 - j) > 5) {
                        return false;
                    }
                    Block l = world.func_147439_a(i12, j1, k12);
                    if (l == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72317_d(0.0, 4.0, 0.0).func_72314_b((double)xRange, 4.0, (double)zRange));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
            for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
                for (int k13 = k - zRange; k13 <= k + zRange; ++k13) {
                    int j1 = world.func_72825_h(i1, k13) - 1;
                    if (Math.abs(j1 - j) > 5) {
                        return false;
                    }
                    Block l = world.func_147439_a(i1, j1, k13);
                    if (l == Blocks.field_150349_c) continue;
                    return false;
                }
            }
        }
        if (random.nextBoolean()) {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 0;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 0;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 0;
            this.stairBlock = Blocks.field_150476_ad;
        } else {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 1;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 1;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 1;
            this.stairBlock = Blocks.field_150485_bF;
        }
        Object[] obj = LOTRWorldGenDunlendingHouse.getRandomDunlandFloorBlock(random);
        this.floorBlock = (Block)obj[0];
        this.floorMeta = (Integer)obj[1];
        this.drink = LOTRFoods.DUNLENDING_DRINK.getRandomFood(random).func_77973_b();
        for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
            for (int k14 = k - zRange; k14 <= k + zRange; ++k14) {
                for (int j1 = j + 5; !(j1 < j && LOTRMod.isOpaque(world, i1, j1, k14) || j1 < 0); --j1) {
                    if (Math.abs(i1 - i) == xRange && Math.abs(k14 - k) == zRange) {
                        this.func_150516_a(world, i1, j1, k14, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(i1 - i) == xRange || Math.abs(k14 - k) == zRange) {
                        this.func_150516_a(world, i1, j1, k14, this.plankBlock, this.plankMeta);
                    } else if (j1 > j) {
                        this.func_150516_a(world, i1, j1, k14, Blocks.field_150350_a, 0);
                    } else if (j1 == j) {
                        this.func_150516_a(world, i1, j1, k14, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i1, j1, k14, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j1 - 1, k14) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k14, Blocks.field_150346_d, 0);
                }
            }
        }
        for (i1 = i - xRange + 1; i1 <= i + xRange - 1; ++i1) {
            this.func_150516_a(world, i1, j + 4, k - zRange, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k + zRange, this.woodBlock, this.woodMeta | 4);
        }
        for (k1 = k - zRange + 1; k1 <= k + zRange - 1; ++k1) {
            this.func_150516_a(world, i - xRange, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + xRange, j + 4, k1, this.woodBlock, this.woodMeta | 8);
        }
        for (int j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - xRange + 1, j1, k - zRange + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + xRange - 1, j1, k - zRange + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - xRange + 1, j1, k + zRange - 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + xRange - 1, j1, k + zRange - 1, this.woodBlock, this.woodMeta);
        }
        if (xRange > zRange) {
            for (i1 = i - xRange - 1; i1 <= i + xRange + 1; ++i1) {
                for (int stair = 0; stair < 3; ++stair) {
                    this.func_150516_a(world, i1, j + 4 + stair, k - zRange - 1 + stair, this.stairBlock, 2);
                    this.func_150516_a(world, i1, j + 4 + stair, k + zRange + 1 - stair, this.stairBlock, 3);
                }
            }
            for (k1 = k - zRange + 2; k1 <= k + zRange - 2; ++k1) {
                this.func_150516_a(world, i - xRange - 1, j + 6, k1, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i + xRange + 1, j + 6, k1, this.slabBlock, this.slabMeta | 8);
            }
            zRange -= 2;
        } else {
            for (k1 = k - zRange - 1; k1 <= k + zRange + 1; ++k1) {
                for (int stair = 0; stair < 3; ++stair) {
                    this.func_150516_a(world, i - xRange - 1 + stair, j + 4 + stair, k1, this.stairBlock, 0);
                    this.func_150516_a(world, i + xRange + 1 - stair, j + 4 + stair, k1, this.stairBlock, 1);
                }
            }
            for (i1 = i - xRange + 2; i1 <= i + xRange - 2; ++i1) {
                this.func_150516_a(world, i1, j + 6, k - zRange - 1, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i1, j + 6, k + zRange + 1, this.slabBlock, this.slabMeta | 8);
            }
            xRange -= 2;
        }
        for (i1 = i - xRange; i1 <= i + xRange; ++i1) {
            for (int k15 = k - zRange; k15 <= k + zRange; ++k15) {
                this.func_150516_a(world, i1, j + 6, k15, this.plankBlock, this.plankMeta);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int k16 = k - 1; k16 <= k + 1; ++k16) {
                int j1;
                this.func_150516_a(world, i1, j, k16, LOTRMod.hearth, 0);
                for (j1 = j + 1; j1 <= j + 5; ++j1) {
                    if (Math.abs(i1 - i) == 1 && Math.abs(k16 - k) == 1) {
                        this.func_150516_a(world, i1, j1, k16, this.floorBlock, this.floorMeta);
                        continue;
                    }
                    if (i1 == i && k16 == k) continue;
                    this.func_150516_a(world, i1, j1, k16, Blocks.field_150411_aY, 0);
                }
                for (j1 = j + 6; j1 <= j + 9; ++j1) {
                    if (i1 == i && k16 == k) {
                        this.func_150516_a(world, i1, j1, k16, Blocks.field_150350_a, 0);
                        continue;
                    }
                    this.func_150516_a(world, i1, j1, k16, this.plankBlock, this.plankMeta);
                }
            }
        }
        this.func_150516_a(world, i, j + 1, k, (Block)Blocks.field_150480_ab, 0);
        switch (rotation) {
            case 0: {
                this.generateFacingSouth(world, random, i, j, k);
                break;
            }
            case 1: {
                this.generateFacingWest(world, random, i, j, k);
                break;
            }
            case 2: {
                this.generateFacingNorth(world, random, i, j, k);
                break;
            }
            case 3: {
                this.generateFacingEast(world, random, i, j, k);
            }
        }
        return true;
    }

    private void generateFacingSouth(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int i1;
        this.func_150516_a(world, i, j, k - 10, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k - 10, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 2, k - 10, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 1, j + 2, k - 11, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 1, j + 2, k - 11, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i, j + 3, k - 11, Blocks.field_150444_as, 2);
        String[] name = LOTRNames.getRandomDunlendingTavernName(random);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k - 11);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        for (i1 = i - 4; i1 <= i + 2; i1 += 6) {
            this.func_150516_a(world, i1, j + 2, k - 10, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 3, k - 10, this.stairBlock, 5);
            this.func_150516_a(world, i1 + 2, j + 2, k - 10, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1 + 2, j + 3, k - 10, this.stairBlock, 4);
        }
        this.func_150516_a(world, i - 1, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 1, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 4, j + 2, k - 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k - 9, Blocks.field_150478_aa, 2);
        for (k1 = k - 8; k1 <= k - 4; ++k1) {
            this.func_150516_a(world, i - 5, j + 1, k1, this.stairBlock, 1);
            this.func_150516_a(world, i + 5, j + 1, k1, this.stairBlock, 0);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 5, j1, k - 3, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k - 3, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 4, j + 2, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k - 3, Blocks.field_150478_aa, 2);
        for (k1 = 0; k1 <= 2; ++k1) {
            for (int i12 = 0; i12 <= 1; ++i12) {
                this.func_150516_a(world, i - 3 + i12, j + 1, k - 7 + k1, Blocks.field_150344_f, 0);
                this.placePlate(world, i - 3 + i12, j + 2, k - 7 + k1, random, LOTRFoods.DUNLENDING);
                this.func_150516_a(world, i + 2 + i12, j + 1, k - 7 + k1, Blocks.field_150344_f, 0);
                this.placePlate(world, i + 2 + i12, j + 2, k - 7 + k1, random, LOTRFoods.DUNLENDING);
            }
        }
        for (k1 = k - 1; k1 <= k + 3; k1 += 2) {
            this.placeItemFrame(world, i - 6, j + 2, k1, 3, random);
            this.placeItemFrame(world, i + 6, j + 2, k1, 1, random);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 5, j1, k + 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 4, j + 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k + 5, Blocks.field_150478_aa, 2);
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 6, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i1, j + 3, k + 6, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i1, j + 4, k + 6, this.woodBlock, this.woodMeta | 4);
            if (Math.abs(i1 - i) > 4) continue;
            this.func_150516_a(world, i1, j + 1, k + 9, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i + 3, j + 1, k + 6, Blocks.field_150396_be, 0);
        for (i1 = i - 3; i1 <= i + 1; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k + 4, Blocks.field_150422_aJ, 0);
        }
        for (i1 = i - 3; i1 <= i + 1; ++i1) {
            if (random.nextInt(3) == 0) continue;
            this.placeMug(world, random, i1, j + 2, k + 6, 0, this.drink);
        }
        this.placeBarrel(world, random, i - 5, j + 1, k + 7, 5, this.drink);
        this.placeBarrel(world, random, i - 5, j + 1, k + 8, 5, this.drink);
        this.func_150516_a(world, i - 1, j + 1, k + 9, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 1, j + 1, k + 9, 2);
        this.func_150516_a(world, i, j + 1, k + 9, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 1, j + 1, k + 9, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i + 1, j + 1, k + 9, 2);
        this.placeFlowerPot(world, i - 3, j + 2, k + 9, this.getRandomPlant(random));
        this.placeFlowerPot(world, i + 3, j + 2, k + 9, this.getRandomPlant(random));
        this.func_150516_a(world, i - 4, j + 2, k + 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k + 9, Blocks.field_150478_aa, 2);
        this.spawnBartender(world, i, j + 1, k + 8, name);
        int men = 3 + random.nextInt(6);
        for (int l = 0; l < men; ++l) {
            this.spawnDunlending(world, i, j + 1, k + 3, i, j, k);
        }
        this.spawnDrunkard(world, i, j + 1, k + 3, i, j, k);
    }

    private void generateFacingWest(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int k1;
        this.func_150516_a(world, i + 10, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 10, j + 1, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 10, j + 2, k, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i + 11, j + 2, k - 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 11, j + 2, k + 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 11, j + 3, k, Blocks.field_150444_as, 5);
        String[] name = LOTRNames.getRandomDunlendingTavernName(random);
        TileEntity tileentity = world.func_147438_o(i + 11, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        for (k1 = k - 4; k1 <= k + 2; k1 += 6) {
            this.func_150516_a(world, i + 10, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 10, j + 3, k1, this.stairBlock, 7);
            this.func_150516_a(world, i + 10, j + 2, k1 + 2, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 10, j + 3, k1 + 2, this.stairBlock, 6);
        }
        this.func_150516_a(world, i + 9, j + 2, k - 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 9, j + 2, k + 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 9, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 9, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (i1 = i + 8; i1 >= i + 4; --i1) {
            this.func_150516_a(world, i1, j + 1, k - 5, this.stairBlock, 3);
            this.func_150516_a(world, i1, j + 1, k + 5, this.stairBlock, 2);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i + 3, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 3, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i + 3, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (i1 = 0; i1 <= 2; ++i1) {
            for (int k12 = 0; k12 <= 1; ++k12) {
                this.func_150516_a(world, i + 7 - i1, j + 1, k - 3 + k12, Blocks.field_150344_f, 0);
                this.placePlate(world, i + 7 - i1, j + 2, k - 3 + k12, random, LOTRFoods.DUNLENDING);
                this.func_150516_a(world, i + 7 - i1, j + 1, k + 2 + k12, Blocks.field_150344_f, 0);
                this.placePlate(world, i + 7 - i1, j + 2, k + 2 + k12, random, LOTRFoods.DUNLENDING);
            }
        }
        for (i1 = i + 1; i1 >= i - 3; i1 -= 2) {
            this.placeItemFrame(world, i1, j + 2, k - 6, 0, random);
            this.placeItemFrame(world, i1, j + 2, k + 6, 2, random);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 5, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 5, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 5, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 5, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            this.func_150516_a(world, i - 6, j + 1, k1, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i - 6, j + 3, k1, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i - 6, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            if (Math.abs(k1 - k) > 4) continue;
            this.func_150516_a(world, i - 9, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i - 6, j + 1, k + 3, Blocks.field_150396_be, 1);
        for (k1 = k - 3; k1 <= k + 1; k1 += 2) {
            this.func_150516_a(world, i - 4, j + 1, k1, Blocks.field_150422_aJ, 0);
        }
        for (k1 = k - 3; k1 <= k + 1; ++k1) {
            if (random.nextInt(3) == 0) continue;
            this.placeMug(world, random, i - 6, j + 2, k1, 1, this.drink);
        }
        this.placeBarrel(world, random, i - 7, j + 1, k - 5, 3, this.drink);
        this.placeBarrel(world, random, i - 8, j + 1, k - 5, 3, this.drink);
        this.func_150516_a(world, i - 9, j + 1, k - 1, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 9, j + 1, k - 1, 5);
        this.func_150516_a(world, i - 9, j + 1, k, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 9, j + 1, k + 1, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 9, j + 1, k + 1, 5);
        this.placeFlowerPot(world, i - 9, j + 2, k - 3, this.getRandomPlant(random));
        this.placeFlowerPot(world, i - 9, j + 2, k + 3, this.getRandomPlant(random));
        this.func_150516_a(world, i - 9, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 9, j + 2, k + 4, Blocks.field_150478_aa, 4);
        this.spawnBartender(world, i - 8, j + 1, k, name);
        int men = 3 + random.nextInt(6);
        for (int l = 0; l < men; ++l) {
            this.spawnDunlending(world, i - 3, j + 1, k, i, j, k);
        }
        this.spawnDrunkard(world, i - 3, j + 1, k, i, j, k);
    }

    private void generateFacingNorth(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int i1;
        this.func_150516_a(world, i, j, k + 10, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k + 10, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 2, k + 10, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 1, j + 2, k + 11, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 1, j + 2, k + 11, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i, j + 3, k + 11, Blocks.field_150444_as, 3);
        String[] name = LOTRNames.getRandomDunlendingTavernName(random);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k + 11);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        for (i1 = i - 4; i1 <= i + 2; i1 += 6) {
            this.func_150516_a(world, i1, j + 2, k + 10, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 3, k + 10, this.stairBlock, 5);
            this.func_150516_a(world, i1 + 2, j + 2, k + 10, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1 + 2, j + 3, k + 10, this.stairBlock, 4);
        }
        this.func_150516_a(world, i - 1, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 1, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 4, j + 2, k + 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k + 9, Blocks.field_150478_aa, 2);
        for (k1 = k + 8; k1 >= k + 4; --k1) {
            this.func_150516_a(world, i - 5, j + 1, k1, this.stairBlock, 1);
            this.func_150516_a(world, i + 5, j + 1, k1, this.stairBlock, 0);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 5, j1, k + 3, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k + 3, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 4, j + 2, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k + 3, Blocks.field_150478_aa, 2);
        for (k1 = 0; k1 <= 2; ++k1) {
            for (int i12 = 0; i12 <= 1; ++i12) {
                this.func_150516_a(world, i - 3 + i12, j + 1, k + 7 - k1, Blocks.field_150344_f, 0);
                this.placePlate(world, i - 3 + i12, j + 2, k + 7 - k1, random, LOTRFoods.DUNLENDING);
                this.func_150516_a(world, i + 2 + i12, j + 1, k + 7 - k1, Blocks.field_150344_f, 0);
                this.placePlate(world, i + 2 + i12, j + 2, k + 7 - k1, random, LOTRFoods.DUNLENDING);
            }
        }
        for (k1 = k + 1; k1 >= k - 3; k1 -= 2) {
            this.placeItemFrame(world, i - 6, j + 2, k1, 3, random);
            this.placeItemFrame(world, i + 6, j + 2, k1, 1, random);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 5, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k - 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 4, j + 2, k - 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k - 5, Blocks.field_150478_aa, 2);
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 6, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i1, j + 3, k - 6, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i1, j + 4, k - 6, this.woodBlock, this.woodMeta | 4);
            if (Math.abs(i1 - i) > 4) continue;
            this.func_150516_a(world, i1, j + 1, k - 9, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i + 3, j + 1, k - 6, Blocks.field_150396_be, 2);
        for (i1 = i - 3; i1 <= i + 1; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k - 4, Blocks.field_150422_aJ, 0);
        }
        for (i1 = i - 3; i1 <= i + 1; ++i1) {
            if (random.nextInt(3) == 0) continue;
            this.placeMug(world, random, i1, j + 2, k - 6, 2, this.drink);
        }
        this.placeBarrel(world, random, i - 5, j + 1, k - 7, 5, this.drink);
        this.placeBarrel(world, random, i - 5, j + 1, k - 8, 5, this.drink);
        this.func_150516_a(world, i - 1, j + 1, k - 9, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i - 1, j + 1, k - 9, 3);
        this.func_150516_a(world, i, j + 1, k - 9, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 1, j + 1, k - 9, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i + 1, j + 1, k - 9, 3);
        this.placeFlowerPot(world, i - 3, j + 2, k - 9, this.getRandomPlant(random));
        this.placeFlowerPot(world, i + 3, j + 2, k - 9, this.getRandomPlant(random));
        this.func_150516_a(world, i - 4, j + 2, k - 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k - 9, Blocks.field_150478_aa, 2);
        this.spawnBartender(world, i, j + 1, k - 8, name);
        int men = 3 + random.nextInt(6);
        for (int l = 0; l < men; ++l) {
            this.spawnDunlending(world, i, j + 1, k - 3, i, j, k);
        }
        this.spawnDrunkard(world, i, j + 1, k - 3, i, j, k);
    }

    private void generateFacingEast(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int k1;
        this.func_150516_a(world, i - 10, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 10, j + 1, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 10, j + 2, k, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 11, j + 2, k - 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 11, j + 2, k + 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 11, j + 3, k, Blocks.field_150444_as, 4);
        String[] name = LOTRNames.getRandomDunlendingTavernName(random);
        TileEntity tileentity = world.func_147438_o(i - 11, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        for (k1 = k - 4; k1 <= k + 2; k1 += 6) {
            this.func_150516_a(world, i - 10, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 10, j + 3, k1, this.stairBlock, 7);
            this.func_150516_a(world, i - 10, j + 2, k1 + 2, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 10, j + 3, k1 + 2, this.stairBlock, 6);
        }
        this.func_150516_a(world, i - 9, j + 2, k - 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 2, k + 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 9, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (i1 = i - 8; i1 <= i - 4; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 5, this.stairBlock, 3);
            this.func_150516_a(world, i1, j + 1, k + 5, this.stairBlock, 2);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i - 3, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 3, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i - 3, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (i1 = 0; i1 <= 2; ++i1) {
            for (int k12 = 0; k12 <= 1; ++k12) {
                this.func_150516_a(world, i - 7 + i1, j + 1, k - 3 + k12, Blocks.field_150344_f, 0);
                this.placePlate(world, i - 7 + i1, j + 2, k - 3 + k12, random, LOTRFoods.DUNLENDING);
                this.func_150516_a(world, i - 7 + i1, j + 1, k + 2 + k12, Blocks.field_150344_f, 0);
                this.placePlate(world, i - 7 + i1, j + 2, k + 2 + k12, random, LOTRFoods.DUNLENDING);
            }
        }
        for (i1 = i - 1; i1 <= i + 3; i1 += 2) {
            this.placeItemFrame(world, i1, j + 2, k - 6, 0, random);
            this.placeItemFrame(world, i1, j + 2, k + 6, 2, random);
        }
        for (j1 = j + 1; j1 <= j + 5; ++j1) {
            this.func_150516_a(world, i + 5, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        this.func_150516_a(world, i + 5, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 5, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            this.func_150516_a(world, i + 6, j + 1, k1, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i + 6, j + 3, k1, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i + 6, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            if (Math.abs(k1 - k) > 4) continue;
            this.func_150516_a(world, i + 9, j + 1, k1, this.slabBlock, this.slabMeta | 8);
        }
        this.func_150516_a(world, i + 6, j + 1, k + 3, Blocks.field_150396_be, 3);
        for (k1 = k - 3; k1 <= k + 1; k1 += 2) {
            this.func_150516_a(world, i + 4, j + 1, k1, Blocks.field_150422_aJ, 0);
        }
        for (k1 = k - 3; k1 <= k + 1; ++k1) {
            if (random.nextInt(3) == 0) continue;
            this.placeMug(world, random, i + 6, j + 2, k1, 3, this.drink);
        }
        this.placeBarrel(world, random, i + 7, j + 1, k - 5, 3, this.drink);
        this.placeBarrel(world, random, i + 8, j + 1, k - 5, 3, this.drink);
        this.func_150516_a(world, i + 9, j + 1, k - 1, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i + 9, j + 1, k - 1, 4);
        this.func_150516_a(world, i + 9, j + 1, k, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 9, j + 1, k + 1, Blocks.field_150460_al, 0);
        this.setBlockMetadata(world, i + 9, j + 1, k + 1, 4);
        this.placeFlowerPot(world, i + 9, j + 2, k - 3, this.getRandomPlant(random));
        this.placeFlowerPot(world, i + 9, j + 2, k + 3, this.getRandomPlant(random));
        this.func_150516_a(world, i + 9, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 9, j + 2, k + 4, Blocks.field_150478_aa, 4);
        this.spawnBartender(world, i + 8, j + 1, k, name);
        int men = 3 + random.nextInt(6);
        for (int l = 0; l < men; ++l) {
            this.spawnDunlending(world, i + 3, j + 1, k, i, j, k);
        }
        this.spawnDrunkard(world, i + 3, j + 1, k, i, j, k);
    }

    private void spawnBartender(World world, int i, int j, int k, String[] tavernName) {
        LOTREntityDunlendingBartender bartender = new LOTREntityDunlendingBartender(world);
        bartender.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
        bartender.setSpecificLocationName(tavernName[0] + " " + tavernName[1]);
        bartender.func_110161_a(null);
        world.func_72838_d((Entity)bartender);
        bartender.func_110171_b(i, j, k, 2);
    }

    private void spawnDunlending(World world, int i, int j, int k, int originX, int originY, int originZ) {
        LOTREntityDunlending dunlending = new LOTREntityDunlending(world);
        dunlending.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
        dunlending.func_110161_a(null);
        dunlending.isNPCPersistent = true;
        world.func_72838_d((Entity)dunlending);
        dunlending.func_110171_b(originX, originY, originZ, 16);
    }

    private void spawnDrunkard(World world, int i, int j, int k, int originX, int originY, int originZ) {
        LOTREntityDunlendingDrunkard drunkard = new LOTREntityDunlendingDrunkard(world);
        drunkard.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
        drunkard.func_110161_a(null);
        drunkard.isNPCPersistent = true;
        world.func_72838_d((Entity)drunkard);
        drunkard.func_110171_b(originX, originY, originZ, 16);
        drunkard.func_70062_b(0, new ItemStack(this.drink, 1, 3 + world.field_73012_v.nextInt(2)));
    }

    private ItemStack getRandomPlant(Random random) {
        return random.nextBoolean() ? new ItemStack((Block)Blocks.field_150328_O) : new ItemStack((Block)Blocks.field_150327_N);
    }

    private void placeItemFrame(World world, int i, int j, int k, int direction, Random random) {
        ItemStack item = null;
        int l = random.nextInt(6);
        switch (l) {
            case 0: 
            case 1: 
            case 2: {
                item = new ItemStack(LOTRMod.mug);
                break;
            }
            case 3: {
                item = new ItemStack(Items.field_151041_m);
                break;
            }
            case 4: {
                item = new ItemStack((Item)Items.field_151031_f);
                break;
            }
            case 5: {
                item = new ItemStack(Items.field_151032_g);
            }
        }
        this.spawnItemFrame(world, i, j, k, direction, item);
    }
}

