/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRWorldGenDwarfHouse
extends LOTRWorldGenStructureBase {
    protected Block brickBlock = LOTRMod.brick;
    protected int brickMeta = 6;
    protected Block brick2Block = Blocks.field_150417_aV;
    protected int brick2Meta = 0;
    protected Block pillarBlock = LOTRMod.pillar;
    protected int pillarMeta = 0;
    protected Block stairBlock = LOTRMod.stairsDwarvenBrick;
    protected Block chandelierBlock = LOTRMod.chandelier;
    protected int chandelierMeta = 8;
    protected Block tableBlock = LOTRMod.dwarvenTable;

    public LOTRWorldGenDwarfHouse(boolean flag) {
        super(flag);
    }

    protected LOTREntityDwarf createDwarf(World world) {
        return new LOTREntityDwarf(world);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int i1;
        --j;
        if (this.restrictions) {
            for (int i12 = i - 6; i12 <= i + 6; ++i12) {
                for (int j1 = j - 4; j1 <= j + 4; ++j1) {
                    for (int k1 = k - 6; k1 <= k + 6; ++k1) {
                        if (!world.func_147437_c(i12, j1, k1)) continue;
                        return false;
                    }
                }
            }
        }
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
            switch (rotation) {
                case 0: {
                    k += 8;
                    break;
                }
                case 1: {
                    i -= 8;
                    break;
                }
                case 2: {
                    k -= 8;
                    break;
                }
                case 3: {
                    i += 8;
                }
            }
        }
        if (this.restrictions) {
            int i13;
            int i14;
            int k1;
            int k12;
            int k13;
            boolean foundAir;
            int j1;
            int i15;
            if (rotation == 0) {
                for (i15 = i - 1; i15 <= i + 1; ++i15) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        foundAir = false;
                        for (k13 = k - 8; k13 >= k - 14; --k13) {
                            if (!world.func_147437_c(i15, j1, k13)) continue;
                            foundAir = true;
                            break;
                        }
                        if (foundAir) continue;
                        return false;
                    }
                }
                for (i15 = i - 1; i15 <= i + 1; ++i15) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        for (k12 = k - 8; k12 >= k - 14 && !world.func_147437_c(i15, j1, k12); --k12) {
                            this.func_150516_a(world, i15, j1, k12, Blocks.field_150350_a, 0);
                            if (j1 != j + 1) continue;
                            this.func_150516_a(world, i15, j1 - 1, k12, Blocks.field_150348_b, 0);
                        }
                    }
                }
            }
            if (rotation == 1) {
                for (k1 = k - 1; k1 <= k + 1; ++k1) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        foundAir = false;
                        for (i14 = i + 8; i14 <= i + 14; ++i14) {
                            if (!world.func_147437_c(i14, j1, k1)) continue;
                            foundAir = true;
                            break;
                        }
                        if (foundAir) continue;
                        return false;
                    }
                }
                for (k1 = k - 1; k1 <= k + 1; ++k1) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        for (i13 = i + 8; i13 <= i + 14 && !world.func_147437_c(i13, j1, k1); ++i13) {
                            this.func_150516_a(world, i13, j1, k1, Blocks.field_150350_a, 0);
                            if (j1 != j + 1) continue;
                            this.func_150516_a(world, i13, j1 - 1, k1, Blocks.field_150348_b, 0);
                        }
                    }
                }
            }
            if (rotation == 2) {
                for (i15 = i - 1; i15 <= i + 1; ++i15) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        foundAir = false;
                        for (k13 = k + 8; k13 <= k + 14; ++k13) {
                            if (!world.func_147437_c(i15, j1, k13)) continue;
                            foundAir = true;
                            break;
                        }
                        if (foundAir) continue;
                        return false;
                    }
                }
                for (i15 = i - 1; i15 <= i + 1; ++i15) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        for (k12 = k + 8; k12 <= k + 14 && !world.func_147437_c(i15, j1, k12); ++k12) {
                            this.func_150516_a(world, i15, j1, k12, Blocks.field_150350_a, 0);
                            if (j1 != j + 1) continue;
                            this.func_150516_a(world, i15, j1 - 1, k12, Blocks.field_150348_b, 0);
                        }
                    }
                }
            }
            if (rotation == 3) {
                for (k1 = k - 1; k1 <= k + 1; ++k1) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        foundAir = false;
                        for (i14 = i - 8; i14 >= i - 14; --i14) {
                            if (!world.func_147437_c(i14, j1, k1)) continue;
                            foundAir = true;
                            break;
                        }
                        if (foundAir) continue;
                        return false;
                    }
                }
                for (k1 = k - 1; k1 <= k + 1; ++k1) {
                    for (j1 = j + 1; j1 <= j + 2; ++j1) {
                        for (i13 = i - 8; i13 >= i - 14 && !world.func_147437_c(i13, j1, k1); --i13) {
                            this.func_150516_a(world, i13, j1, k1, Blocks.field_150350_a, 0);
                            if (j1 != j + 1) continue;
                            this.func_150516_a(world, i13, j1 - 1, k1, Blocks.field_150348_b, 0);
                        }
                    }
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72314_b(7.0, 5.0, 7.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i - 7; i1 <= i + 7; ++i1) {
            for (int k1 = k - 7; k1 <= k + 7; ++k1) {
                for (int j1 = j + 5; !(j1 < j - 5 && LOTRMod.isOpaque(world, i1, j1, k1) || j1 < 0); --j1) {
                    if (LOTRMod.isOpaque(world, i1, j1, k1)) continue;
                    Object block = null;
                    block = j1 >= j + 2 ? (world.func_147439_a(i1, j1 + 1, k1).func_149662_c() ? Blocks.field_150346_d : Blocks.field_150349_c) : Blocks.field_150348_b;
                    if (block == null) continue;
                    this.func_150516_a(world, i1, j1, k1, (Block)block, 0);
                    if (world.func_147439_a(i1, j1 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        for (i1 = i - 6; i1 <= i + 6; ++i1) {
            for (int k1 = k - 6; k1 <= k + 6; ++k1) {
                for (int j1 = j - 4; j1 <= j + 4; ++j1) {
                    if (Math.abs(i1 - i) == 6 || Math.abs(k1 - k) == 6) {
                        if (j1 == j + 2) {
                            this.func_150516_a(world, i1, j1, k1, Blocks.field_150344_f, 1);
                            continue;
                        }
                        this.func_150516_a(world, i1, j1, k1, this.brick2Block, this.brick2Meta);
                        continue;
                    }
                    if (j1 == j || Math.abs(j1 - j) == 4) {
                        this.func_150516_a(world, i1, j1, k1, this.brick2Block, this.brick2Meta);
                        continue;
                    }
                    this.func_150516_a(world, i1, j1, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (int j1 = j - 3; j1 <= j + 3; ++j1) {
            if (j1 == j) continue;
            this.func_150516_a(world, i - 5, j1, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 5, j1, k + 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k + 5, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i - 4, j + 2, k - 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 4, j + 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 4, j + 2, k - 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 4, j + 2, k + 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k + 4, Blocks.field_150478_aa, 4);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 3, k - 5, this.stairBlock, 7);
            this.func_150516_a(world, i1, j + 3, k + 5, this.stairBlock, 6);
        }
        for (int k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 5, j + 3, k1, this.stairBlock, 5);
            this.func_150516_a(world, i + 5, j + 3, k1, this.stairBlock, 4);
        }
        int carpet = 0;
        int randomCarpet = random.nextInt(3);
        switch (randomCarpet) {
            case 0: {
                carpet = 7;
                break;
            }
            case 1: {
                carpet = 12;
                break;
            }
            case 2: {
                carpet = 15;
            }
        }
        switch (rotation) {
            case 0: {
                this.generateFacingSouth(world, random, i, j, k, carpet);
                break;
            }
            case 1: {
                this.generateFacingWest(world, random, i, j, k, carpet);
                break;
            }
            case 2: {
                this.generateFacingNorth(world, random, i, j, k, carpet);
                break;
            }
            case 3: {
                this.generateFacingEast(world, random, i, j, k, carpet);
            }
        }
        LOTREntityDwarf dwarfMale = this.createDwarf(world);
        dwarfMale.isNPCPersistent = true;
        dwarfMale.func_70012_b((double)i + 0.5, j + 2, (double)k + 0.5, 0.0f, 0.0f);
        dwarfMale.familyInfo.setNPCMale(true);
        dwarfMale.setDwarfName(LOTRNames.getRandomDwarfName(true, random));
        dwarfMale.func_110171_b(i, j + 1, k, 8);
        dwarfMale.func_110161_a(null);
        world.func_72838_d((Entity)dwarfMale);
        LOTREntityDwarf dwarfFemale = this.createDwarf(world);
        dwarfFemale.isNPCPersistent = true;
        dwarfFemale.func_70012_b((double)i + 0.5, j + 2, (double)k + 0.5, 0.0f, 0.0f);
        dwarfFemale.familyInfo.setNPCMale(false);
        dwarfFemale.setDwarfName(LOTRNames.getRandomDwarfName(false, random));
        dwarfFemale.func_110171_b(i, j + 1, k, 8);
        dwarfFemale.func_110161_a(null);
        world.func_72838_d((Entity)dwarfFemale);
        int maxChildren = dwarfMale.familyInfo.getRandomMaxChildren();
        dwarfMale.func_70062_b(4, new ItemStack(LOTRMod.dwarvenRing));
        dwarfMale.familyInfo.spouseUniqueID = dwarfFemale.getPersistentID();
        dwarfMale.familyInfo.setMaxBreedingDelay();
        dwarfMale.familyInfo.maxChildren = maxChildren;
        dwarfFemale.func_70062_b(4, new ItemStack(LOTRMod.dwarvenRing));
        dwarfFemale.familyInfo.spouseUniqueID = dwarfMale.getPersistentID();
        dwarfFemale.familyInfo.setMaxBreedingDelay();
        dwarfFemale.familyInfo.maxChildren = maxChildren;
        return true;
    }

    private void generateFacingSouth(World world, Random random, int i, int j, int k, int carpet) {
        int j1;
        int i1;
        int k1;
        int i12;
        int i13;
        int j12;
        for (j12 = j + 2; j12 <= j + 3; ++j12) {
            int i2 = 5 - (j12 - j);
            for (i13 = i - i2; i13 <= i + i2; ++i13) {
                this.func_150516_a(world, i13, j12, k - 7, Blocks.field_150348_b, 0);
            }
        }
        for (i12 = i - 1; i12 <= i + 1; ++i12) {
            this.func_150516_a(world, i12, j, k - 7, Blocks.field_150348_b, 0);
        }
        for (j12 = j + 1; j12 <= j + 2; ++j12) {
            this.func_150516_a(world, i - 1, j12, k - 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i, j12, k - 6, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 1, j12, k - 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 1, j12, k - 7, Blocks.field_150348_b, 0);
            this.func_150516_a(world, i, j12, k - 7, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 1, j12, k - 7, Blocks.field_150348_b, 0);
        }
        this.func_150516_a(world, i, j + 1, k - 7, LOTRMod.dwarvenDoor, 1);
        this.func_150516_a(world, i, j + 2, k - 7, LOTRMod.dwarvenDoor, 8);
        for (k1 = k - 4; k1 <= k - 3; ++k1) {
            for (i1 = i - 3; i1 <= i + 3; ++i1) {
                this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150404_cg, carpet);
            }
        }
        for (k1 = k - 1; k1 <= k + 3; ++k1) {
            for (i1 = i - 1; i1 <= i + 1; ++i1) {
                if (Math.abs(i1 - i) == 1 && (k1 == k - 1 || k1 == k + 3)) {
                    this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150344_f, 1);
                } else {
                    this.func_150516_a(world, i1, j + 1, k1, (Block)Blocks.field_150376_bx, 9);
                }
                this.placePlate(world, i1, j + 2, k1, random, LOTRFoods.DWARF);
            }
        }
        this.func_150516_a(world, i, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        this.func_150516_a(world, i, j + 3, k + 2, this.chandelierBlock, this.chandelierMeta);
        for (k1 = k; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, Blocks.field_150485_bF, 1);
            this.func_150516_a(world, i + 3, j + 1, k1, Blocks.field_150485_bF, 0);
        }
        for (k1 = k + 4; k1 <= k + 6; ++k1) {
            for (j1 = j + 1; j1 <= j + 4; ++j1) {
                for (i13 = i - 2; i13 <= i + 2; ++i13) {
                    this.func_150516_a(world, i13, j1, k1, this.brickBlock, this.brickMeta);
                }
            }
        }
        for (j12 = j + 1; j12 <= j + 3; ++j12) {
            this.func_150516_a(world, i - 2, j12, k + 4, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 2, j12, k + 4, this.pillarBlock, this.pillarMeta);
        }
        for (i12 = i - 1; i12 <= i + 1; ++i12) {
            this.func_150516_a(world, i12, j + 2, k + 4, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i12, j + 3, k + 4, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i12, j + 1, k + 5, LOTRMod.hearth, 0);
            this.func_150516_a(world, i12, j + 2, k + 5, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i12, j + 3, k + 5, Blocks.field_150350_a, 0);
        }
        for (k1 = k - 2; k1 <= k + 1; ++k1) {
            this.func_150516_a(world, i - 5, j, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 5, j, k1, Blocks.field_150350_a, 0);
            int height = 1 - (k1 - k);
            for (int j13 = j - 3; j13 < j - 3 + height; ++j13) {
                this.func_150516_a(world, i - 5, j13, k1, this.brickBlock, this.brickMeta);
                this.func_150516_a(world, i + 5, j13, k1, this.brickBlock, this.brickMeta);
            }
            this.func_150516_a(world, i - 5, j - 3 + height, k1, this.stairBlock, 3);
            this.func_150516_a(world, i + 5, j - 3 + height, k1, this.stairBlock, 3);
        }
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            for (j1 = j - 3; j1 <= j - 1; ++j1) {
                for (i13 = i - 1; i13 <= i + 1; ++i13) {
                    this.func_150516_a(world, i13, j1, k1, Blocks.field_150344_f, 1);
                }
            }
        }
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 2, j12, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 2, j12, k + 5, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i - 5, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j - 2, k - 4, Blocks.field_150478_aa, 3);
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 2, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 2, j - 1, k1, this.stairBlock, 4);
        }
        for (i12 = i - 4; i12 <= i - 3; ++i12) {
            this.func_150516_a(world, i12, j - 3, k - 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.placeBarrel(world, random, i12, j - 2, k - 5, 3, LOTRFoods.DWARF_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i12, j - 1, k - 5, this.stairBlock, 7);
            this.func_150516_a(world, i12, j - 3, k + 5, Blocks.field_150460_al, 0);
            world.func_72921_c(i12, j - 3, k + 5, 2, 3);
            this.func_150516_a(world, i12, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k + 5, this.stairBlock, 6);
        }
        for (k1 = k - 4; k1 <= k - 3; ++k1) {
            this.func_150516_a(world, i - 5, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 6, j - 2, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 5, j - 2, k1, (Block)Blocks.field_150486_ae, 5);
            LOTRChestContents.fillChest(world, random, i - 5, j - 2, k1, LOTRChestContents.DWARF_HOUSE_LARDER);
            this.func_150516_a(world, i - 5, j - 1, k1, this.stairBlock, 5);
        }
        this.func_150516_a(world, i - 2, j - 3, k - 1, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i - 2, j - 3, k, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 2, j - 3, k + 1, this.tableBlock, 0);
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i + 2, j12, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 2, j12, k + 5, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i + 5, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 5, j - 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j - 2, k - 4, Blocks.field_150478_aa, 3);
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i + 2, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 2, j - 1, k1, this.stairBlock, 5);
        }
        for (i12 = i + 3; i12 <= i + 4; ++i12) {
            this.func_150516_a(world, i12, j - 3, k - 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k - 5, this.stairBlock, 7);
            this.func_150516_a(world, i12, j - 3, k + 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k + 5, this.stairBlock, 6);
            for (int k12 = k - 2; k12 <= k + 4; ++k12) {
                this.func_150516_a(world, i12, j - 3, k12, Blocks.field_150404_cg, carpet);
            }
            this.func_150516_a(world, i12, j - 3, k - 3, LOTRMod.dwarvenBed, 2);
            this.func_150516_a(world, i12, j - 3, k - 4, LOTRMod.dwarvenBed, 10);
        }
        for (k1 = k - 4; k1 <= k - 3; ++k1) {
            this.func_150516_a(world, i + 5, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 6, j - 2, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 5, j - 1, k1, this.stairBlock, 4);
        }
    }

    private void generateFacingWest(World world, Random random, int i, int j, int k, int carpet) {
        int j1;
        int k1;
        int i1;
        int k12;
        int k13;
        int j12;
        for (j12 = j + 2; j12 <= j + 3; ++j12) {
            int k2 = 5 - (j12 - j);
            for (k13 = k - k2; k13 <= k + k2; ++k13) {
                this.func_150516_a(world, i + 7, j12, k13, Blocks.field_150348_b, 0);
            }
        }
        for (k12 = k - 1; k12 <= k + 1; ++k12) {
            this.func_150516_a(world, i + 7, j, k12, Blocks.field_150348_b, 0);
        }
        for (j12 = j + 1; j12 <= j + 2; ++j12) {
            this.func_150516_a(world, i + 6, j12, k - 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 6, j12, k, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 6, j12, k + 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 7, j12, k - 1, Blocks.field_150348_b, 0);
            this.func_150516_a(world, i + 7, j12, k, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 7, j12, k + 1, Blocks.field_150348_b, 0);
        }
        this.func_150516_a(world, i + 7, j + 1, k, LOTRMod.dwarvenDoor, 2);
        this.func_150516_a(world, i + 7, j + 2, k, LOTRMod.dwarvenDoor, 8);
        for (i1 = i + 4; i1 >= i + 3; --i1) {
            for (k1 = k - 3; k1 <= k + 3; ++k1) {
                this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150404_cg, carpet);
            }
        }
        for (i1 = i + 1; i1 >= i - 3; --i1) {
            for (k1 = k - 1; k1 <= k + 1; ++k1) {
                if (Math.abs(k1 - k) == 1 && (i1 == i + 1 || i1 == i - 3)) {
                    this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150344_f, 1);
                } else {
                    this.func_150516_a(world, i1, j + 1, k1, (Block)Blocks.field_150376_bx, 9);
                }
                this.placePlate(world, i1, j + 2, k1, random, LOTRFoods.DWARF);
            }
        }
        this.func_150516_a(world, i, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        this.func_150516_a(world, i - 2, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        for (i1 = i; i1 >= i - 2; --i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, Blocks.field_150485_bF, 3);
            this.func_150516_a(world, i1, j + 1, k + 3, Blocks.field_150485_bF, 2);
        }
        for (i1 = i - 4; i1 >= i - 6; --i1) {
            for (j1 = j + 1; j1 <= j + 4; ++j1) {
                for (k13 = k - 2; k13 <= k + 2; ++k13) {
                    this.func_150516_a(world, i1, j1, k13, this.brickBlock, this.brickMeta);
                }
            }
        }
        for (j12 = j + 1; j12 <= j + 3; ++j12) {
            this.func_150516_a(world, i - 4, j12, k - 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 4, j12, k + 2, this.pillarBlock, this.pillarMeta);
        }
        for (k12 = k - 1; k12 <= k + 1; ++k12) {
            this.func_150516_a(world, i - 4, j + 2, k12, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i - 4, j + 3, k12, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i - 5, j + 1, k12, LOTRMod.hearth, 0);
            this.func_150516_a(world, i - 5, j + 2, k12, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i - 5, j + 3, k12, Blocks.field_150350_a, 0);
        }
        for (i1 = i + 2; i1 >= i - 1; --i1) {
            this.func_150516_a(world, i1, j, k - 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j, k + 5, Blocks.field_150350_a, 0);
            int height = 1 + (i1 - i);
            for (int j13 = j - 3; j13 < j - 3 + height; ++j13) {
                this.func_150516_a(world, i1, j13, k - 5, this.brickBlock, this.brickMeta);
                this.func_150516_a(world, i1, j13, k + 5, this.brickBlock, this.brickMeta);
            }
            this.func_150516_a(world, i1, j - 3 + height, k - 5, this.stairBlock, 0);
            this.func_150516_a(world, i1, j - 3 + height, k + 5, this.stairBlock, 0);
        }
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            for (j1 = j - 3; j1 <= j - 1; ++j1) {
                for (k13 = k - 1; k13 <= k + 1; ++k13) {
                    this.func_150516_a(world, i1, j1, k13, Blocks.field_150344_f, 1);
                }
            }
        }
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 5, j12, k - 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j12, k - 2, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i - 4, j - 2, k - 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j - 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j - 2, k - 2, Blocks.field_150478_aa, 2);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j - 3, k - 2, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k - 2, this.stairBlock, 6);
        }
        for (k12 = k - 4; k12 <= k - 3; ++k12) {
            this.func_150516_a(world, i + 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.placeBarrel(world, random, i + 5, j - 2, k12, 4, LOTRFoods.DWARF_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i + 5, j - 1, k12, this.stairBlock, 4);
            this.func_150516_a(world, i - 5, j - 3, k12, Blocks.field_150460_al, 0);
            world.func_72921_c(i + 5, j - 3, k12, 5, 3);
            this.func_150516_a(world, i - 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 5, j - 1, k12, this.stairBlock, 5);
        }
        for (i1 = i + 4; i1 >= i + 3; --i1) {
            this.func_150516_a(world, i1, j - 3, k - 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k - 5, (Block)Blocks.field_150486_ae, 3);
            LOTRChestContents.fillChest(world, random, i1, j - 2, k - 5, LOTRChestContents.DWARF_HOUSE_LARDER);
            this.func_150516_a(world, i1, j - 1, k - 5, this.stairBlock, 7);
        }
        this.func_150516_a(world, i + 1, j - 3, k - 2, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i, j - 3, k - 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 1, j - 3, k - 2, this.tableBlock, 0);
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 5, j12, k + 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j12, k + 2, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i + 4, j - 2, k + 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 4, j - 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j - 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j - 2, k + 2, Blocks.field_150478_aa, 1);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j - 3, k + 2, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k + 2, this.stairBlock, 7);
        }
        for (k12 = k + 3; k12 <= k + 4; ++k12) {
            this.func_150516_a(world, i - 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 5, j - 1, k12, this.stairBlock, 5);
            this.func_150516_a(world, i + 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 5, j - 1, k12, this.stairBlock, 4);
            for (int i12 = i + 2; i12 >= i - 4; --i12) {
                this.func_150516_a(world, i12, j - 3, k12, Blocks.field_150404_cg, carpet);
            }
            this.func_150516_a(world, i + 3, j - 3, k12, LOTRMod.dwarvenBed, 3);
            this.func_150516_a(world, i + 4, j - 3, k12, LOTRMod.dwarvenBed, 11);
        }
        for (i1 = i + 4; i1 >= i + 3; --i1) {
            this.func_150516_a(world, i1, j - 3, k + 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k + 5, this.stairBlock, 6);
        }
    }

    private void generateFacingNorth(World world, Random random, int i, int j, int k, int carpet) {
        int j1;
        int i1;
        int k1;
        int i12;
        int i13;
        int j12;
        for (j12 = j + 2; j12 <= j + 3; ++j12) {
            int i2 = 5 - (j12 - j);
            for (i13 = i - i2; i13 <= i + i2; ++i13) {
                this.func_150516_a(world, i13, j12, k + 7, Blocks.field_150348_b, 0);
            }
        }
        for (i12 = i - 1; i12 <= i + 1; ++i12) {
            this.func_150516_a(world, i12, j, k + 7, Blocks.field_150348_b, 0);
        }
        for (j12 = j + 1; j12 <= j + 2; ++j12) {
            this.func_150516_a(world, i - 1, j12, k + 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i, j12, k + 6, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 1, j12, k + 6, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i, j + 1, k + 7, LOTRMod.dwarvenDoor, 3);
        this.func_150516_a(world, i, j + 2, k + 7, LOTRMod.dwarvenDoor, 8);
        for (k1 = k + 4; k1 >= k + 3; --k1) {
            for (i1 = i - 3; i1 <= i + 3; ++i1) {
                this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150404_cg, carpet);
            }
        }
        for (k1 = k + 1; k1 >= k - 3; --k1) {
            for (i1 = i - 1; i1 <= i + 1; ++i1) {
                if (Math.abs(i1 - i) == 1 && (k1 == k + 1 || k1 == k - 3)) {
                    this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150344_f, 1);
                } else {
                    this.func_150516_a(world, i1, j + 1, k1, (Block)Blocks.field_150376_bx, 9);
                }
                this.placePlate(world, i1, j + 2, k1, random, LOTRFoods.DWARF);
            }
        }
        this.func_150516_a(world, i, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        this.func_150516_a(world, i, j + 3, k - 2, this.chandelierBlock, this.chandelierMeta);
        for (k1 = k; k1 >= k - 2; --k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, Blocks.field_150485_bF, 1);
            this.func_150516_a(world, i + 3, j + 1, k1, Blocks.field_150485_bF, 0);
        }
        for (k1 = k - 4; k1 >= k - 6; --k1) {
            for (j1 = j + 1; j1 <= j + 4; ++j1) {
                for (i13 = i - 2; i13 <= i + 2; ++i13) {
                    this.func_150516_a(world, i13, j1, k1, this.brickBlock, this.brickMeta);
                }
            }
        }
        for (j12 = j + 1; j12 <= j + 3; ++j12) {
            this.func_150516_a(world, i - 2, j12, k - 4, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 2, j12, k - 4, this.pillarBlock, this.pillarMeta);
        }
        for (i12 = i - 1; i12 <= i + 1; ++i12) {
            this.func_150516_a(world, i12, j + 2, k - 4, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i12, j + 3, k - 4, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i12, j + 1, k - 5, LOTRMod.hearth, 0);
            this.func_150516_a(world, i12, j + 2, k - 5, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i12, j + 3, k - 5, Blocks.field_150350_a, 0);
        }
        for (k1 = k + 2; k1 >= k - 1; --k1) {
            this.func_150516_a(world, i - 5, j, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 5, j, k1, Blocks.field_150350_a, 0);
            int height = 1 + (k1 - k);
            for (int j13 = j - 3; j13 < j - 3 + height; ++j13) {
                this.func_150516_a(world, i - 5, j13, k1, this.brickBlock, this.brickMeta);
                this.func_150516_a(world, i + 5, j13, k1, this.brickBlock, this.brickMeta);
            }
            this.func_150516_a(world, i - 5, j - 3 + height, k1, this.stairBlock, 2);
            this.func_150516_a(world, i + 5, j - 3 + height, k1, this.stairBlock, 2);
        }
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            for (j1 = j - 3; j1 <= j - 1; ++j1) {
                for (i13 = i - 1; i13 <= i + 1; ++i13) {
                    this.func_150516_a(world, i13, j1, k1, Blocks.field_150344_f, 1);
                }
            }
        }
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 2, j12, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 2, j12, k + 5, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i - 5, j - 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j - 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j - 2, k + 4, Blocks.field_150478_aa, 4);
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 2, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 2, j - 1, k1, this.stairBlock, 4);
        }
        for (i12 = i - 4; i12 <= i - 3; ++i12) {
            this.func_150516_a(world, i12, j - 3, k + 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.placeBarrel(world, random, i12, j - 2, k + 5, 2, LOTRFoods.DWARF_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i12, j - 1, k + 5, this.stairBlock, 6);
            this.func_150516_a(world, i12, j - 3, k - 5, Blocks.field_150460_al, 0);
            world.func_72921_c(i12, j - 3, k - 5, 3, 3);
            this.func_150516_a(world, i12, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k - 5, this.stairBlock, 7);
        }
        for (k1 = k + 4; k1 >= k + 3; --k1) {
            this.func_150516_a(world, i - 5, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 6, j - 2, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 5, j - 2, k1, (Block)Blocks.field_150486_ae, 5);
            LOTRChestContents.fillChest(world, random, i - 5, j - 2, k1, LOTRChestContents.DWARF_HOUSE_LARDER);
            this.func_150516_a(world, i - 5, j - 1, k1, this.stairBlock, 5);
        }
        this.func_150516_a(world, i - 2, j - 3, k + 1, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i - 2, j - 3, k, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 2, j - 3, k - 1, this.tableBlock, 0);
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i + 2, j12, k - 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 2, j12, k + 5, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i + 5, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j - 2, k + 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 5, j - 2, k - 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j - 2, k - 4, Blocks.field_150478_aa, 3);
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i + 2, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 2, j - 1, k1, this.stairBlock, 5);
        }
        for (i12 = i + 3; i12 <= i + 4; ++i12) {
            this.func_150516_a(world, i12, j - 3, k - 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k - 5, this.stairBlock, 7);
            this.func_150516_a(world, i12, j - 3, k + 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i12, j - 1, k + 5, this.stairBlock, 6);
            for (int k12 = k + 2; k12 >= k - 4; --k12) {
                this.func_150516_a(world, i12, j - 3, k12, Blocks.field_150404_cg, carpet);
            }
            this.func_150516_a(world, i12, j - 3, k + 3, LOTRMod.dwarvenBed, 0);
            this.func_150516_a(world, i12, j - 3, k + 4, LOTRMod.dwarvenBed, 8);
        }
        for (k1 = k + 4; k1 >= k + 3; --k1) {
            this.func_150516_a(world, i + 5, j - 3, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 6, j - 2, k1, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 5, j - 1, k1, this.stairBlock, 4);
        }
    }

    private void generateFacingEast(World world, Random random, int i, int j, int k, int carpet) {
        int j1;
        int k1;
        int i1;
        int k12;
        int k13;
        int j12;
        for (j12 = j + 2; j12 <= j + 3; ++j12) {
            int k2 = 5 - (j12 - j);
            for (k13 = k - k2; k13 <= k + k2; ++k13) {
                this.func_150516_a(world, i - 7, j12, k13, Blocks.field_150348_b, 0);
            }
        }
        for (k12 = k - 1; k12 <= k + 1; ++k12) {
            this.func_150516_a(world, i - 7, j, k12, Blocks.field_150348_b, 0);
        }
        for (j12 = j + 1; j12 <= j + 2; ++j12) {
            this.func_150516_a(world, i - 6, j12, k - 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 6, j12, k, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 6, j12, k + 1, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i - 7, j + 1, k, LOTRMod.dwarvenDoor, 0);
        this.func_150516_a(world, i - 7, j + 2, k, LOTRMod.dwarvenDoor, 8);
        for (i1 = i - 4; i1 <= i - 3; ++i1) {
            for (k1 = k - 3; k1 <= k + 3; ++k1) {
                this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150404_cg, carpet);
            }
        }
        for (i1 = i - 1; i1 <= i + 3; ++i1) {
            for (k1 = k - 1; k1 <= k + 1; ++k1) {
                if (Math.abs(k1 - k) == 1 && (i1 == i - 1 || i1 == i + 3)) {
                    this.func_150516_a(world, i1, j + 1, k1, Blocks.field_150344_f, 1);
                } else {
                    this.func_150516_a(world, i1, j + 1, k1, (Block)Blocks.field_150376_bx, 9);
                }
                this.placePlate(world, i1, j + 2, k1, random, LOTRFoods.DWARF);
            }
        }
        this.func_150516_a(world, i, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        this.func_150516_a(world, i + 2, j + 3, k, this.chandelierBlock, this.chandelierMeta);
        for (i1 = i; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, Blocks.field_150485_bF, 3);
            this.func_150516_a(world, i1, j + 1, k + 3, Blocks.field_150485_bF, 2);
        }
        for (i1 = i + 4; i1 <= i + 6; ++i1) {
            for (j1 = j + 1; j1 <= j + 4; ++j1) {
                for (k13 = k - 2; k13 <= k + 2; ++k13) {
                    this.func_150516_a(world, i1, j1, k13, this.brickBlock, this.brickMeta);
                }
            }
        }
        for (j12 = j + 1; j12 <= j + 3; ++j12) {
            this.func_150516_a(world, i + 4, j12, k - 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 4, j12, k + 2, this.pillarBlock, this.pillarMeta);
        }
        for (k12 = k - 1; k12 <= k + 1; ++k12) {
            this.func_150516_a(world, i + 4, j + 2, k12, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i + 4, j + 3, k12, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i + 5, j + 1, k12, LOTRMod.hearth, 0);
            this.func_150516_a(world, i + 5, j + 2, k12, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i + 5, j + 3, k12, Blocks.field_150350_a, 0);
        }
        for (i1 = i - 2; i1 <= i + 1; ++i1) {
            this.func_150516_a(world, i1, j, k - 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j, k + 5, Blocks.field_150350_a, 0);
            int height = 1 - (i1 - i);
            for (int j13 = j - 3; j13 < j - 3 + height; ++j13) {
                this.func_150516_a(world, i1, j13, k - 5, this.brickBlock, this.brickMeta);
                this.func_150516_a(world, i1, j13, k + 5, this.brickBlock, this.brickMeta);
            }
            this.func_150516_a(world, i1, j - 3 + height, k - 5, this.stairBlock, 1);
            this.func_150516_a(world, i1, j - 3 + height, k + 5, this.stairBlock, 1);
        }
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            for (j1 = j - 3; j1 <= j - 1; ++j1) {
                for (k13 = k - 1; k13 <= k + 1; ++k13) {
                    this.func_150516_a(world, i1, j1, k13, Blocks.field_150344_f, 1);
                }
            }
        }
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 5, j12, k - 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j12, k - 2, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i + 4, j - 2, k - 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 4, j - 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j - 2, k - 2, Blocks.field_150478_aa, 1);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j - 3, k - 2, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k - 2, this.stairBlock, 6);
        }
        for (k12 = k - 4; k12 <= k - 3; ++k12) {
            this.func_150516_a(world, i - 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.placeBarrel(world, random, i - 5, j - 2, k12, 5, LOTRFoods.DWARF_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i - 5, j - 1, k12, this.stairBlock, 5);
            this.func_150516_a(world, i + 5, j - 3, k12, Blocks.field_150460_al, 0);
            world.func_72921_c(i + 5, j - 3, k12, 4, 3);
            this.func_150516_a(world, i + 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 5, j - 1, k12, this.stairBlock, 4);
        }
        for (i1 = i - 4; i1 <= i - 3; ++i1) {
            this.func_150516_a(world, i1, j - 3, k - 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k - 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k - 5, (Block)Blocks.field_150486_ae, 3);
            LOTRChestContents.fillChest(world, random, i1, j - 2, k - 5, LOTRChestContents.DWARF_HOUSE_LARDER);
            this.func_150516_a(world, i1, j - 1, k - 5, this.stairBlock, 7);
        }
        this.func_150516_a(world, i - 1, j - 3, k - 2, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i, j - 3, k - 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 1, j - 3, k - 2, this.tableBlock, 0);
        for (j12 = j - 3; j12 <= j - 1; ++j12) {
            this.func_150516_a(world, i - 5, j12, k + 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j12, k + 2, this.pillarBlock, this.pillarMeta);
        }
        this.func_150516_a(world, i + 4, j - 2, k + 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 4, j - 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j - 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j - 2, k + 2, Blocks.field_150478_aa, 1);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j - 3, k + 2, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k + 2, this.stairBlock, 7);
        }
        for (k12 = k + 3; k12 <= k + 4; ++k12) {
            this.func_150516_a(world, i - 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i - 5, j - 1, k12, this.stairBlock, 5);
            this.func_150516_a(world, i + 5, j - 3, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 6, j - 2, k12, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i + 5, j - 1, k12, this.stairBlock, 4);
            for (int i12 = i - 2; i12 <= i + 4; ++i12) {
                this.func_150516_a(world, i12, j - 3, k12, Blocks.field_150404_cg, carpet);
            }
            this.func_150516_a(world, i - 3, j - 3, k12, LOTRMod.dwarvenBed, 1);
            this.func_150516_a(world, i - 4, j - 3, k12, LOTRMod.dwarvenBed, 9);
        }
        for (i1 = i - 4; i1 <= i - 3; ++i1) {
            this.func_150516_a(world, i1, j - 3, k + 5, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 2, k + 6, Blocks.field_150344_f, 1);
            this.func_150516_a(world, i1, j - 1, k + 5, this.stairBlock, 6);
        }
    }
}

