/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityGondorArcher;
import lotr.common.entity.npc.LOTREntityGondorSoldier;
import lotr.common.entity.npc.LOTREntityGondorianCaptain;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenBeaconTower;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRWorldGenGondorFortress
extends LOTRWorldGenStructureBase {
    public LOTRWorldGenGondorFortress(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.restrictions) {
            if (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
                return false;
            }
            if (world.func_72807_a(i, k) != LOTRBiome.gondor) {
                return false;
            }
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
            switch (rotation) {
                case 0: {
                    k += 9;
                    break;
                }
                case 1: {
                    i -= 9;
                    break;
                }
                case 2: {
                    k -= 9;
                    break;
                }
                case 3: {
                    i += 9;
                }
            }
        }
        if (this.restrictions) {
            List soldiers = world.func_72872_a(LOTREntityGondorSoldier.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72317_d(0.0, 10.0, 0.0).func_72314_b(34.0, 12.0, 34.0));
            if (!soldiers.isEmpty()) {
                return false;
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72317_d(0.0, 10.0, 0.0).func_72314_b(34.0, 12.0, 34.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        this.generateBasicStructure(world, random, i, j, k);
        switch (rotation) {
            case 0: {
                return this.generateFacingSouth(world, random, i, j, k);
            }
            case 1: {
                return this.generateFacingWest(world, random, i, j, k);
            }
            case 2: {
                return this.generateFacingNorth(world, random, i, j, k);
            }
            case 3: {
                return this.generateFacingEast(world, random, i, j, k);
            }
        }
        return true;
    }

    private void generateBasicStructure(World world, Random random, int i, int j, int k) {
        int j1;
        int j12;
        int k1;
        int k12;
        int k13;
        int j13;
        int i1;
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            for (j13 = j + 1; j13 <= j + 11; ++j13) {
                for (k13 = k - 5; k13 <= k + 5; ++k13) {
                    this.placeRandomBrick(world, random, i1, j13, k13);
                }
            }
        }
        for (i1 = i - 6; i1 <= i + 6; ++i1) {
            this.placeRandomStairs(world, random, i1, j + 1, k - 6, 2);
            this.placeRandomStairs(world, random, i1, j + 1, k + 6, 3);
        }
        for (k12 = k - 5; k12 <= k + 5; ++k12) {
            this.placeRandomStairs(world, random, i - 6, j + 1, k12, 0);
            this.placeRandomStairs(world, random, i + 6, j + 1, k12, 1);
        }
        for (i1 = i - 6; i1 <= i + 6; ++i1) {
            for (k1 = k - 6; k1 <= k + 6; ++k1) {
                for (j12 = j; !LOTRMod.isOpaque(world, i1, j12, k1) && j12 >= 0; --j12) {
                    this.placeRandomBrick(world, random, i1, j12, k1);
                }
            }
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (k1 = k - 4; k1 <= k + 4; ++k1) {
                for (j12 = j + 2; j12 <= j + 5; ++j12) {
                    this.func_150516_a(world, i1, j12, k1, Blocks.field_150350_a, 0);
                }
                for (j12 = j + 7; j12 <= j + 10; ++j12) {
                    this.func_150516_a(world, i1, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (j1 = j + 4; j1 <= j + 9; j1 += 5) {
            this.func_150516_a(world, i - 4, j1, k - 2, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i - 4, j1, k + 2, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 4, j1, k - 2, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i + 4, j1, k + 2, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i - 2, j1, k - 4, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i + 2, j1, k - 4, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i - 2, j1, k + 4, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i + 2, j1, k + 4, Blocks.field_150478_aa, 4);
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (j13 = j + 12; j13 <= j + 16; ++j13) {
                for (k13 = k - 4; k13 <= k + 4; ++k13) {
                    this.placeRandomBrick(world, random, i1, j13, k13);
                }
            }
        }
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            this.placeRandomStairs(world, random, i1, j + 12, k - 5, 2);
            this.placeRandomStairs(world, random, i1, j + 12, k + 5, 3);
        }
        for (k12 = k - 4; k12 <= k + 4; ++k12) {
            this.placeRandomStairs(world, random, i - 5, j + 12, k12, 0);
            this.placeRandomStairs(world, random, i + 5, j + 12, k12, 1);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            for (k1 = k - 3; k1 <= k + 3; ++k1) {
                for (j12 = j + 12; j12 <= j + 15; ++j12) {
                    this.func_150516_a(world, i1, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        this.func_150516_a(world, i - 3, j + 14, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 3, j + 14, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 3, j + 14, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 3, j + 14, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 2, j + 14, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 14, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j + 14, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 14, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 17, k - 2, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 2, j + 17, k + 2, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 2, j + 17, k - 2, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 2, j + 17, k + 2, Blocks.field_150478_aa, 5);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.placeRandomWall(world, random, i1, j + 17, k - 4);
            this.placeRandomWall(world, random, i1, j + 17, k + 4);
        }
        for (k12 = k - 4; k12 <= k + 4; ++k12) {
            this.placeRandomWall(world, random, i - 4, j + 17, k12);
            this.placeRandomWall(world, random, i + 4, j + 17, k12);
        }
        for (j1 = j + 17; j1 <= j + 20; ++j1) {
            this.placeRandomWall(world, random, i - 4, j1, k - 4);
            this.placeRandomWall(world, random, i - 4, j1, k + 4);
            this.placeRandomWall(world, random, i + 4, j1, k - 4);
            this.placeRandomWall(world, random, i + 4, j1, k + 4);
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k1 = k - 2; k1 <= k + 2; ++k1) {
                this.placeRandomBrick(world, random, i1, j + 21, k1);
                if (i1 >= i - 1 && i1 <= i + 1 && k1 >= k - 1 && k1 <= k + 1) {
                    this.placeRandomBrick(world, random, i1, j + 22, k1);
                    continue;
                }
                this.placeRandomSlab(world, random, i1, j + 22, k1, false);
            }
        }
        this.placeRandomSlab(world, random, i - 4, j + 21, k - 4, false);
        this.placeRandomSlab(world, random, i - 4, j + 21, k - 3, false);
        this.placeRandomStairs(world, random, i - 4, j + 21, k - 2, 0);
        this.placeRandomStairs(world, random, i - 4, j + 21, k - 1, 3);
        this.placeRandomSlab(world, random, i - 4, j + 21, k, false);
        this.placeRandomStairs(world, random, i - 4, j + 21, k + 1, 2);
        this.placeRandomStairs(world, random, i - 4, j + 21, k + 2, 0);
        this.placeRandomSlab(world, random, i - 4, j + 21, k + 3, false);
        this.placeRandomSlab(world, random, i - 4, j + 21, k + 4, false);
        this.placeRandomSlab(world, random, i - 3, j + 21, k - 4, false);
        this.placeRandomBrick(world, random, i - 3, j + 21, k - 3);
        this.placeRandomBrick(world, random, i - 3, j + 21, k - 2);
        this.placeRandomStairs(world, random, i - 3, j + 21, k - 1, 0);
        this.placeRandomStairs(world, random, i - 3, j + 21, k, 0);
        this.placeRandomStairs(world, random, i - 3, j + 21, k + 1, 0);
        this.placeRandomBrick(world, random, i - 3, j + 21, k + 2);
        this.placeRandomBrick(world, random, i - 3, j + 21, k + 3);
        this.placeRandomSlab(world, random, i - 3, j + 21, k + 4, false);
        this.placeRandomSlab(world, random, i + 4, j + 21, k - 4, false);
        this.placeRandomSlab(world, random, i + 4, j + 21, k - 3, false);
        this.placeRandomStairs(world, random, i + 4, j + 21, k - 2, 1);
        this.placeRandomStairs(world, random, i + 4, j + 21, k - 1, 3);
        this.placeRandomSlab(world, random, i + 4, j + 21, k, false);
        this.placeRandomStairs(world, random, i + 4, j + 21, k + 1, 2);
        this.placeRandomStairs(world, random, i + 4, j + 21, k + 2, 1);
        this.placeRandomSlab(world, random, i + 4, j + 21, k + 3, false);
        this.placeRandomSlab(world, random, i + 4, j + 21, k + 4, false);
        this.placeRandomSlab(world, random, i + 3, j + 21, k - 4, false);
        this.placeRandomBrick(world, random, i + 3, j + 21, k - 3);
        this.placeRandomBrick(world, random, i + 3, j + 21, k - 2);
        this.placeRandomStairs(world, random, i + 3, j + 21, k - 1, 1);
        this.placeRandomStairs(world, random, i + 3, j + 21, k, 1);
        this.placeRandomStairs(world, random, i + 3, j + 21, k + 1, 1);
        this.placeRandomBrick(world, random, i + 3, j + 21, k + 2);
        this.placeRandomBrick(world, random, i + 3, j + 21, k + 3);
        this.placeRandomSlab(world, random, i + 3, j + 21, k + 4, false);
        this.placeRandomStairs(world, random, i - 2, j + 21, k + 4, 3);
        this.placeRandomStairs(world, random, i - 1, j + 21, k + 4, 1);
        this.placeRandomSlab(world, random, i, j + 21, k + 4, false);
        this.placeRandomStairs(world, random, i + 1, j + 21, k + 4, 0);
        this.placeRandomStairs(world, random, i + 2, j + 21, k + 4, 3);
        this.placeRandomBrick(world, random, i - 2, j + 21, k + 3);
        this.placeRandomStairs(world, random, i - 1, j + 21, k + 3, 3);
        this.placeRandomStairs(world, random, i, j + 21, k + 3, 3);
        this.placeRandomStairs(world, random, i + 1, j + 21, k + 3, 3);
        this.placeRandomBrick(world, random, i + 2, j + 21, k + 3);
        this.placeRandomStairs(world, random, i - 2, j + 21, k - 4, 2);
        this.placeRandomStairs(world, random, i - 1, j + 21, k - 4, 1);
        this.placeRandomSlab(world, random, i, j + 21, k - 4, false);
        this.placeRandomStairs(world, random, i + 1, j + 21, k - 4, 0);
        this.placeRandomStairs(world, random, i + 2, j + 21, k - 4, 2);
        this.placeRandomBrick(world, random, i - 2, j + 21, k - 3);
        this.placeRandomStairs(world, random, i - 1, j + 21, k - 3, 2);
        this.placeRandomStairs(world, random, i, j + 21, k - 3, 2);
        this.placeRandomStairs(world, random, i + 1, j + 21, k - 3, 2);
        this.placeRandomBrick(world, random, i + 2, j + 21, k - 3);
        this.placeBarredWindowOnZ(world, i - 5, j + 3, k);
        this.placeBarredWindowOnZ(world, i + 5, j + 3, k);
        this.placeBarredWindowOnX(world, i, j + 3, k - 5);
        this.placeBarredWindowOnX(world, i, j + 3, k + 5);
        this.placeBarredWindowOnZ(world, i - 5, j + 8, k);
        this.placeBarredWindowOnZ(world, i + 5, j + 8, k);
        this.placeBarredWindowOnX(world, i, j + 8, k - 5);
        this.placeBarredWindowOnX(world, i, j + 8, k + 5);
        this.placeBarredWindowOnZ(world, i - 4, j + 13, k);
        this.placeBarredWindowOnZ(world, i + 4, j + 13, k);
        this.placeBarredWindowOnX(world, i, j + 13, k - 4);
        this.placeBarredWindowOnX(world, i, j + 13, k + 4);
        if (this.usingPlayer == null) {
            LOTRLevelData.gondorFortressLocations.add(new ChunkCoordinates(i, j, k));
        }
    }

    private boolean generateFacingSouth(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int j12;
        int j13;
        int k12;
        int i1;
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k12 = k - 7; k12 >= k - 8; --k12) {
                for (j13 = j; !LOTRMod.isOpaque(world, i1, j13, k12) && j13 >= 0; --j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (j12 = j + 1; j12 <= j + 3; ++j12) {
                this.placeRandomBrick(world, random, i1, j12, k - 6);
            }
            if (Math.abs(i1 - i) == 2) {
                this.placeRandomBrick(world, random, i1, j + 4, k - 6);
            } else {
                this.placeRandomSlab(world, random, i1, j + 4, k - 6, false);
            }
            this.placeRandomStairs(world, random, i1, j + 1, k - 8, 2);
        }
        this.placeWallBanner(world, i, j + 6, k - 5, 2, 0);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k - 6; k12 >= k - 7; --k12) {
                this.placeRandomBrick(world, random, i1, j + 1, k12);
            }
            this.placeRandomBrick(world, random, i1, j + 1, k - 5);
            this.func_150516_a(world, i1, j + 2, k - 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 3, k - 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 4, k - 5, Blocks.field_150350_a, 0);
            this.placeRandomSlab(world, random, i1, j + 4, k - 5, true);
        }
        this.placeRandomStairs(world, random, i - 2, j + 1, k - 7, 0);
        this.placeRandomStairs(world, random, i + 2, j + 1, k - 7, 1);
        this.func_150516_a(world, i, j + 2, k - 6, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 3, k - 6, Blocks.field_150466_ao, 8);
        this.placeRandomSlab(world, random, i - 4, j + 2, k - 4, true);
        this.placeBarrel(world, random, i - 4, j + 3, k - 4, 5, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i - 4, j + 2, k - 3, true);
        this.placeBarrel(world, random, i - 4, j + 3, k - 3, 5, LOTRMod.mugAle);
        this.func_150516_a(world, i - 4, j + 2, k - 2, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 4, j + 2, k - 2, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.placeRandomSlab(world, random, i + 4, j + 2, k - 4, true);
        this.placeBarrel(world, random, i + 4, j + 3, k - 4, 4, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i + 4, j + 2, k - 3, true);
        this.placeBarrel(world, random, i + 4, j + 3, k - 3, 4, LOTRMod.mugAle);
        this.func_150516_a(world, i + 4, j + 2, k - 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 4, j + 2, k - 2, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.func_150516_a(world, i - 4, j + 2, k + 4, LOTRMod.gondorianTable, 0);
        this.func_150516_a(world, i + 4, j + 2, k + 4, LOTRMod.gondorianTable, 0);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k - 1; k12 <= k + 2; ++k12) {
                this.func_150516_a(world, i1, j + 6, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 2; j13 < j + 2 + k12 - k + 1; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 2 + k12 - k + 1, k12, 2);
            }
            this.placeRandomStairs(world, random, i1, j + 6, k + 3, 2);
        }
        this.func_150516_a(world, i, j + 7, k - 4, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i, j + 7, k - 4, LOTRChestContents.GONDOR_FORTRESS_SUPPLIES);
        for (i1 = i - 3; i1 <= i + 3; i1 += 6) {
            for (k12 = k + 2; k12 >= k - 2; --k12) {
                this.func_150516_a(world, i1, j + 11, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 7; j13 < j + 7 - k12 + k + 2; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 7 - k12 + k + 2, k12, 3);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k - 2; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i1, j + 16, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 12; j13 < j + 12 + k12 - k + 2; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 12 + k12 - k + 2, k12, 2);
            }
            this.placeRandomStairs(world, random, i1, j + 16, k + 2, 2);
        }
        for (k1 = k + 5; k1 <= k + 28; ++k1) {
            for (j12 = j + 12; j12 <= j + 15; ++j12) {
                for (int i12 = i - 2; i12 <= i + 2; ++i12) {
                    this.func_150516_a(world, i12, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeRandomBrick(world, random, i1, j + 13, k + 4);
            this.placeRandomBrick(world, random, i1, j + 14, k + 4);
        }
        this.placeRandomBrick(world, random, i - 2, j + 12, k + 5);
        this.placeRandomBrick(world, random, i + 2, j + 12, k + 5);
        this.placeRandomBrick(world, random, i - 2, j + 13, k + 5);
        this.placeRandomBrick(world, random, i + 2, j + 13, k + 5);
        this.func_150516_a(world, i - 2, j + 14, k + 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 14, k + 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i, j + 12, k + 4, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 13, k + 4, Blocks.field_150466_ao, 8);
        for (k1 = k + 6; k1 <= k + 28; ++k1) {
            for (int i13 = i - 1; i13 <= i + 1; ++i13) {
                this.placeRandomBrick(world, random, i13, j + 11, k1);
            }
            this.placeRandomWall(world, random, i - 2, j + 12, k1);
            this.placeRandomWall(world, random, i + 2, j + 12, k1);
            this.placeRandomStairs(world, random, i - 2, j + 11, k1, 4);
            this.placeRandomStairs(world, random, i + 2, j + 11, k1, 5);
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeRandomStairs(world, random, i1, j + 10, k + 6, 7);
            this.placeRandomStairs(world, random, i1, j + 10, k + 16, 6);
            this.placeRandomStairs(world, random, i1, j + 10, k + 18, 7);
            this.placeRandomStairs(world, random, i1, j + 10, k + 28, 6);
            for (j12 = j + 10; !LOTRMod.isOpaque(world, i1, j12, k + 17) && j12 >= 0; --j12) {
                this.placeRandomBrick(world, random, i1, j12, k + 17);
            }
        }
        for (j1 = j + 12; j1 <= j + 13; ++j1) {
            this.placeRandomBrick(world, random, i - 2, j1, k + 11);
            this.placeRandomBrick(world, random, i + 2, j1, k + 11);
            this.placeRandomBrick(world, random, i - 2, j1, k + 23);
            this.placeRandomBrick(world, random, i + 2, j1, k + 23);
        }
        this.func_150516_a(world, i - 1, j + 13, k + 11, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 1, j + 13, k + 11, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 1, j + 13, k + 23, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 1, j + 13, k + 23, Blocks.field_150478_aa, 2);
        this.placeBanner(world, i - 2, j + 14, k + 11, 3, 0);
        this.placeBanner(world, i + 2, j + 14, k + 11, 1, 0);
        this.placeBanner(world, i - 2, j + 14, k + 23, 3, 0);
        this.placeBanner(world, i + 2, j + 14, k + 23, 1, 0);
        for (j1 = j + 12; j1 <= j + 15; ++j1) {
            this.placeRandomBrick(world, random, i - 2, j1, k + 17);
            this.placeRandomBrick(world, random, i + 2, j1, k + 17);
        }
        this.placeRandomStairs(world, random, i - 1, j + 15, k + 17, 5);
        this.placeRandomStairs(world, random, i + 1, j + 15, k + 17, 4);
        this.placeRandomSlab(world, random, i, j + 15, k + 17, true);
        this.func_150516_a(world, i - 2, j + 14, k + 16, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 14, k + 16, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 14, k + 18, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 14, k + 18, Blocks.field_150478_aa, 3);
        LOTRWorldGenBeaconTower beaconTower = new LOTRWorldGenBeaconTower(this.notifyChanges);
        beaconTower.restrictions = false;
        beaconTower.generateWithSetHeightAndRotation(world, random, i, j + 11, k + 31, 0, 2);
        this.spawnGondorSoldier(world, i, j + 1, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 1, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 6, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 6, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k + 11, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k + 23, i, j, k);
        LOTREntityGondorianCaptain captain = new LOTREntityGondorianCaptain(world);
        captain.func_70012_b((double)i + 0.5, j + 15, (double)k + 0.5, 0.0f, 0.0f);
        captain.spawnRidingHorse = false;
        captain.func_110161_a(null);
        world.func_72838_d((Entity)captain);
        captain.func_110171_b(i, j + 15, k, 8);
        return true;
    }

    private boolean generateFacingWest(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int j12;
        int j13;
        int i12;
        int k1;
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (i12 = i + 7; i12 <= i + 8; ++i12) {
                for (j13 = j; !LOTRMod.isOpaque(world, i12, j13, k1) && j13 >= 0; --j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (j12 = j + 1; j12 <= j + 3; ++j12) {
                this.placeRandomBrick(world, random, i + 6, j12, k1);
            }
            if (Math.abs(k1 - k) == 2) {
                this.placeRandomBrick(world, random, i + 6, j + 4, k1);
            } else {
                this.placeRandomSlab(world, random, i + 6, j + 4, k1, false);
            }
            this.placeRandomStairs(world, random, i + 8, j + 1, k1, 1);
        }
        this.placeWallBanner(world, i + 5, j + 6, k, 3, 0);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i + 6; i12 <= i + 7; ++i12) {
                this.placeRandomBrick(world, random, i12, j + 1, k1);
            }
            this.placeRandomBrick(world, random, i + 5, j + 1, k1);
            this.func_150516_a(world, i + 5, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 5, j + 3, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i + 5, j + 4, k1, Blocks.field_150350_a, 0);
            this.placeRandomSlab(world, random, i + 5, j + 4, k1, true);
        }
        this.placeRandomStairs(world, random, i + 7, j + 1, k - 2, 2);
        this.placeRandomStairs(world, random, i + 7, j + 1, k + 2, 3);
        this.func_150516_a(world, i + 6, j + 2, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 6, j + 3, k, Blocks.field_150466_ao, 8);
        this.placeRandomSlab(world, random, i + 4, j + 2, k - 4, true);
        this.placeBarrel(world, random, i + 4, j + 3, k - 4, 3, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i + 3, j + 2, k - 4, true);
        this.placeBarrel(world, random, i + 3, j + 3, k - 4, 3, LOTRMod.mugAle);
        this.func_150516_a(world, i + 2, j + 2, k - 4, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i + 2, j + 2, k - 4, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.placeRandomSlab(world, random, i + 4, j + 2, k + 4, true);
        this.placeBarrel(world, random, i + 4, j + 3, k + 4, 2, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i + 3, j + 2, k + 4, true);
        this.placeBarrel(world, random, i + 3, j + 3, k + 4, 2, LOTRMod.mugAle);
        this.func_150516_a(world, i + 2, j + 2, k + 4, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i + 2, j + 2, k + 4, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.func_150516_a(world, i - 4, j + 2, k - 4, LOTRMod.gondorianTable, 0);
        this.func_150516_a(world, i - 4, j + 2, k + 4, LOTRMod.gondorianTable, 0);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i + 1; i12 >= i - 2; --i12) {
                this.func_150516_a(world, i12, j + 6, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 2; j13 < j + 2 - i12 + i + 1; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 2 - i12 + i + 1, k1, 1);
            }
            this.placeRandomStairs(world, random, i - 3, j + 6, k1, 1);
        }
        this.func_150516_a(world, i + 4, j + 7, k, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i + 4, j + 7, k, LOTRChestContents.GONDOR_FORTRESS_SUPPLIES);
        for (k1 = k - 3; k1 <= k + 3; k1 += 6) {
            for (i12 = i - 2; i12 <= i + 2; ++i12) {
                this.func_150516_a(world, i12, j + 11, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 7; j13 < j + 7 + i12 - i + 2; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 7 + i12 - i + 2, k1, 0);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i + 2; i12 >= i - 1; --i12) {
                this.func_150516_a(world, i12, j + 16, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 12; j13 < j + 12 - i12 + i + 2; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 12 - i12 + i + 2, k1, 1);
            }
            this.placeRandomStairs(world, random, i - 2, j + 16, k1, 1);
        }
        for (i1 = i - 5; i1 >= i - 28; --i1) {
            for (j12 = j + 12; j12 <= j + 15; ++j12) {
                for (int k12 = k - 2; k12 <= k + 2; ++k12) {
                    this.func_150516_a(world, i1, j12, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeRandomBrick(world, random, i - 4, j + 13, k1);
            this.placeRandomBrick(world, random, i - 4, j + 14, k1);
        }
        this.placeRandomBrick(world, random, i - 5, j + 12, k - 2);
        this.placeRandomBrick(world, random, i - 5, j + 12, k + 2);
        this.placeRandomBrick(world, random, i - 5, j + 13, k - 2);
        this.placeRandomBrick(world, random, i - 5, j + 13, k + 2);
        this.func_150516_a(world, i - 5, j + 14, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 5, j + 14, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j + 12, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 4, j + 13, k, Blocks.field_150466_ao, 8);
        for (i1 = i - 6; i1 >= i - 28; --i1) {
            for (int k13 = k - 1; k13 <= k + 1; ++k13) {
                this.placeRandomBrick(world, random, i1, j + 11, k13);
            }
            this.placeRandomWall(world, random, i1, j + 12, k - 2);
            this.placeRandomWall(world, random, i1, j + 12, k + 2);
            this.placeRandomStairs(world, random, i1, j + 11, k - 2, 6);
            this.placeRandomStairs(world, random, i1, j + 11, k + 2, 7);
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeRandomStairs(world, random, i - 6, j + 10, k1, 4);
            this.placeRandomStairs(world, random, i - 16, j + 10, k1, 5);
            this.placeRandomStairs(world, random, i - 18, j + 10, k1, 4);
            this.placeRandomStairs(world, random, i - 28, j + 10, k1, 5);
            for (j12 = j + 10; !LOTRMod.isOpaque(world, i - 17, j12, k1) && j12 >= 0; --j12) {
                this.placeRandomBrick(world, random, i - 17, j12, k1);
            }
        }
        for (j1 = j + 12; j1 <= j + 13; ++j1) {
            this.placeRandomBrick(world, random, i - 11, j1, k - 2);
            this.placeRandomBrick(world, random, i - 11, j1, k + 2);
            this.placeRandomBrick(world, random, i - 23, j1, k - 2);
            this.placeRandomBrick(world, random, i - 23, j1, k + 2);
        }
        this.func_150516_a(world, i - 11, j + 13, k - 1, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 11, j + 13, k + 1, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 23, j + 13, k - 1, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 23, j + 13, k + 1, Blocks.field_150478_aa, 4);
        this.placeBanner(world, i - 11, j + 14, k - 2, 2, 0);
        this.placeBanner(world, i - 11, j + 14, k + 2, 0, 0);
        this.placeBanner(world, i - 23, j + 14, k - 2, 2, 0);
        this.placeBanner(world, i - 23, j + 14, k + 2, 0, 0);
        for (j1 = j + 12; j1 <= j + 15; ++j1) {
            this.placeRandomBrick(world, random, i - 17, j1, k - 2);
            this.placeRandomBrick(world, random, i - 17, j1, k + 2);
        }
        this.placeRandomStairs(world, random, i - 17, j + 15, k - 1, 7);
        this.placeRandomStairs(world, random, i - 17, j + 15, k + 1, 6);
        this.placeRandomSlab(world, random, i - 17, j + 15, k, true);
        this.func_150516_a(world, i - 16, j + 14, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 16, j + 14, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 18, j + 14, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 18, j + 14, k + 2, Blocks.field_150478_aa, 2);
        LOTRWorldGenBeaconTower beaconTower = new LOTRWorldGenBeaconTower(this.notifyChanges);
        beaconTower.restrictions = false;
        beaconTower.generateWithSetHeightAndRotation(world, random, i - 31, j + 11, k, 0, 3);
        this.spawnGondorSoldier(world, i + 3, j + 1, k, i, j, k);
        this.spawnGondorSoldier(world, i - 3, j + 1, k, i, j, k);
        this.spawnGondorSoldier(world, i + 3, j + 6, k, i, j, k);
        this.spawnGondorSoldier(world, i - 3, j + 6, k, i, j, k);
        this.spawnGondorSoldier(world, i + 3, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i - 3, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i - 11, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i - 23, j + 11, k, i, j, k);
        LOTREntityGondorianCaptain captain = new LOTREntityGondorianCaptain(world);
        captain.func_70012_b((double)i + 0.5, j + 15, (double)k + 0.5, 0.0f, 0.0f);
        captain.func_110161_a(null);
        world.func_72838_d((Entity)captain);
        captain.func_110171_b(i, j + 15, k, 8);
        return true;
    }

    private boolean generateFacingNorth(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int j12;
        int j13;
        int k12;
        int i1;
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k12 = k + 7; k12 <= k + 8; ++k12) {
                for (j13 = j; !LOTRMod.isOpaque(world, i1, j13, k12) && j13 >= 0; --j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (j12 = j + 1; j12 <= j + 3; ++j12) {
                this.placeRandomBrick(world, random, i1, j12, k + 6);
            }
            if (Math.abs(i1 - i) == 2) {
                this.placeRandomBrick(world, random, i1, j + 4, k + 6);
            } else {
                this.placeRandomSlab(world, random, i1, j + 4, k + 6, false);
            }
            this.placeRandomStairs(world, random, i1, j + 1, k + 8, 3);
        }
        this.placeWallBanner(world, i, j + 6, k + 5, 0, 0);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k + 6; k12 <= k + 7; ++k12) {
                this.placeRandomBrick(world, random, i1, j + 1, k12);
            }
            this.placeRandomBrick(world, random, i1, j + 1, k + 5);
            this.func_150516_a(world, i1, j + 2, k + 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 3, k + 5, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 4, k + 5, Blocks.field_150350_a, 0);
            this.placeRandomSlab(world, random, i1, j + 4, k + 5, true);
        }
        this.placeRandomStairs(world, random, i - 2, j + 1, k + 7, 0);
        this.placeRandomStairs(world, random, i + 2, j + 1, k + 7, 1);
        this.func_150516_a(world, i, j + 2, k + 6, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 3, k + 6, Blocks.field_150466_ao, 8);
        this.placeRandomSlab(world, random, i - 4, j + 2, k + 4, true);
        this.placeBarrel(world, random, i - 4, j + 3, k + 4, 5, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i - 4, j + 2, k + 3, true);
        this.placeBarrel(world, random, i - 4, j + 3, k + 3, 5, LOTRMod.mugAle);
        this.func_150516_a(world, i - 4, j + 2, k + 2, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 4, j + 2, k + 2, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.placeRandomSlab(world, random, i + 4, j + 2, k + 4, true);
        this.placeBarrel(world, random, i + 4, j + 3, k + 4, 4, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i + 4, j + 2, k + 3, true);
        this.placeBarrel(world, random, i + 4, j + 3, k + 3, 4, LOTRMod.mugAle);
        this.func_150516_a(world, i + 4, j + 2, k + 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 4, j + 2, k + 2, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.func_150516_a(world, i - 4, j + 2, k - 4, LOTRMod.gondorianTable, 0);
        this.func_150516_a(world, i + 4, j + 2, k - 4, LOTRMod.gondorianTable, 0);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k + 1; k12 >= k - 2; --k12) {
                this.func_150516_a(world, i1, j + 6, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 2; j13 < j + 2 - k12 + k + 1; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 2 - k12 + k + 1, k12, 3);
            }
            this.placeRandomStairs(world, random, i1, j + 6, k - 3, 3);
        }
        this.func_150516_a(world, i, j + 7, k + 4, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i, j + 7, k + 4, LOTRChestContents.GONDOR_FORTRESS_SUPPLIES);
        for (i1 = i - 3; i1 <= i + 3; i1 += 6) {
            for (k12 = k - 2; k12 <= k + 2; ++k12) {
                this.func_150516_a(world, i1, j + 11, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 7; j13 < j + 7 + k12 - k + 2; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 7 + k12 - k + 2, k12, 2);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k12 = k + 2; k12 >= k - 1; --k12) {
                this.func_150516_a(world, i1, j + 16, k12, Blocks.field_150350_a, 0);
                for (j13 = j + 12; j13 < j + 12 - k12 + k + 2; ++j13) {
                    this.placeRandomBrick(world, random, i1, j13, k12);
                }
                this.placeRandomStairs(world, random, i1, j + 12 - k12 + k + 2, k12, 3);
            }
            this.placeRandomStairs(world, random, i1, j + 16, k - 2, 3);
        }
        for (k1 = k - 5; k1 >= k - 28; --k1) {
            for (j12 = j + 12; j12 <= j + 15; ++j12) {
                for (int i12 = i - 2; i12 <= i + 2; ++i12) {
                    this.func_150516_a(world, i12, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeRandomBrick(world, random, i1, j + 13, k - 4);
            this.placeRandomBrick(world, random, i1, j + 14, k - 4);
        }
        this.placeRandomBrick(world, random, i - 2, j + 12, k - 5);
        this.placeRandomBrick(world, random, i + 2, j + 12, k - 5);
        this.placeRandomBrick(world, random, i - 2, j + 13, k - 5);
        this.placeRandomBrick(world, random, i + 2, j + 13, k - 5);
        this.func_150516_a(world, i - 2, j + 14, k - 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 14, k - 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i, j + 12, k - 4, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 13, k - 4, Blocks.field_150466_ao, 8);
        for (k1 = k - 6; k1 >= k - 28; --k1) {
            for (int i13 = i - 1; i13 <= i + 1; ++i13) {
                this.placeRandomBrick(world, random, i13, j + 11, k1);
            }
            this.placeRandomWall(world, random, i - 2, j + 12, k1);
            this.placeRandomWall(world, random, i + 2, j + 12, k1);
            this.placeRandomStairs(world, random, i - 2, j + 11, k1, 4);
            this.placeRandomStairs(world, random, i + 2, j + 11, k1, 5);
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeRandomStairs(world, random, i1, j + 10, k - 6, 6);
            this.placeRandomStairs(world, random, i1, j + 10, k - 16, 7);
            this.placeRandomStairs(world, random, i1, j + 10, k - 18, 6);
            this.placeRandomStairs(world, random, i1, j + 10, k - 28, 7);
            for (j12 = j + 10; !LOTRMod.isOpaque(world, i1, j12, k - 17) && j12 >= 0; --j12) {
                this.placeRandomBrick(world, random, i1, j12, k - 17);
            }
        }
        for (j1 = j + 12; j1 <= j + 13; ++j1) {
            this.placeRandomBrick(world, random, i - 2, j1, k - 11);
            this.placeRandomBrick(world, random, i + 2, j1, k - 11);
            this.placeRandomBrick(world, random, i - 2, j1, k - 23);
            this.placeRandomBrick(world, random, i + 2, j1, k - 23);
        }
        this.func_150516_a(world, i - 1, j + 13, k - 11, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 1, j + 13, k - 11, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 1, j + 13, k - 23, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 1, j + 13, k - 23, Blocks.field_150478_aa, 2);
        this.placeBanner(world, i - 2, j + 14, k - 11, 3, 0);
        this.placeBanner(world, i + 2, j + 14, k - 11, 1, 0);
        this.placeBanner(world, i - 2, j + 14, k - 23, 3, 0);
        this.placeBanner(world, i + 2, j + 14, k - 23, 1, 0);
        for (j1 = j + 12; j1 <= j + 15; ++j1) {
            this.placeRandomBrick(world, random, i - 2, j1, k - 17);
            this.placeRandomBrick(world, random, i + 2, j1, k - 17);
        }
        this.placeRandomStairs(world, random, i - 1, j + 15, k - 17, 5);
        this.placeRandomStairs(world, random, i + 1, j + 15, k - 17, 4);
        this.placeRandomSlab(world, random, i, j + 15, k - 17, true);
        this.func_150516_a(world, i - 2, j + 14, k - 16, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 14, k - 16, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j + 14, k - 18, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 14, k - 18, Blocks.field_150478_aa, 4);
        LOTRWorldGenBeaconTower beaconTower = new LOTRWorldGenBeaconTower(this.notifyChanges);
        beaconTower.restrictions = false;
        beaconTower.generateWithSetHeightAndRotation(world, random, i, j + 11, k - 31, 0, 0);
        this.spawnGondorSoldier(world, i, j + 1, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 1, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 6, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 6, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k + 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k - 3, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k - 11, i, j, k);
        this.spawnGondorSoldier(world, i, j + 11, k - 23, i, j, k);
        LOTREntityGondorianCaptain captain = new LOTREntityGondorianCaptain(world);
        captain.func_70012_b((double)i + 0.5, j + 15, (double)k + 0.5, 0.0f, 0.0f);
        captain.func_110161_a(null);
        world.func_72838_d((Entity)captain);
        captain.func_110171_b(i, j + 15, k, 8);
        return true;
    }

    private boolean generateFacingEast(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int j12;
        int j13;
        int i12;
        int k1;
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (i12 = i - 7; i12 >= i - 8; --i12) {
                for (j13 = j; !LOTRMod.isOpaque(world, i12, j13, k1) && j13 >= 0; --j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (j12 = j + 1; j12 <= j + 3; ++j12) {
                this.placeRandomBrick(world, random, i - 6, j12, k1);
            }
            if (Math.abs(k1 - k) == 2) {
                this.placeRandomBrick(world, random, i - 6, j + 4, k1);
            } else {
                this.placeRandomSlab(world, random, i - 6, j + 4, k1, false);
            }
            this.placeRandomStairs(world, random, i - 8, j + 1, k1, 0);
        }
        this.placeWallBanner(world, i - 5, j + 6, k, 1, 0);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i - 6; i12 >= i - 7; --i12) {
                this.placeRandomBrick(world, random, i12, j + 1, k1);
            }
            this.placeRandomBrick(world, random, i - 5, j + 1, k1);
            this.func_150516_a(world, i - 5, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 5, j + 3, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 5, j + 4, k1, Blocks.field_150350_a, 0);
            this.placeRandomSlab(world, random, i - 5, j + 4, k1, true);
        }
        this.placeRandomStairs(world, random, i - 7, j + 1, k - 2, 2);
        this.placeRandomStairs(world, random, i - 7, j + 1, k + 2, 3);
        this.func_150516_a(world, i - 6, j + 2, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 6, j + 3, k, Blocks.field_150466_ao, 8);
        this.placeRandomSlab(world, random, i - 4, j + 2, k - 4, true);
        this.placeBarrel(world, random, i - 4, j + 3, k - 4, 3, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i - 3, j + 2, k - 4, true);
        this.placeBarrel(world, random, i - 3, j + 3, k - 4, 3, LOTRMod.mugAle);
        this.func_150516_a(world, i - 2, j + 2, k - 4, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 2, j + 2, k - 4, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.placeRandomSlab(world, random, i - 4, j + 2, k + 4, true);
        this.placeBarrel(world, random, i - 4, j + 3, k + 4, 2, LOTRMod.mugAle);
        this.placeRandomSlab(world, random, i - 3, j + 2, k + 4, true);
        this.placeBarrel(world, random, i - 3, j + 3, k + 4, 2, LOTRMod.mugAle);
        this.func_150516_a(world, i - 2, j + 2, k + 4, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i - 2, j + 2, k + 4, LOTRChestContents.GONDOR_FORTRESS_DRINKS);
        this.func_150516_a(world, i + 4, j + 2, k - 4, LOTRMod.gondorianTable, 0);
        this.func_150516_a(world, i + 4, j + 2, k + 4, LOTRMod.gondorianTable, 0);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i - 1; i12 <= i + 2; ++i12) {
                this.func_150516_a(world, i12, j + 6, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 2; j13 < j + 2 + i12 - i + 1; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 2 + i12 - i + 1, k1, 0);
            }
            this.placeRandomStairs(world, random, i + 3, j + 6, k1, 0);
        }
        this.func_150516_a(world, i - 4, j + 7, k, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 4, j + 7, k, LOTRChestContents.GONDOR_FORTRESS_SUPPLIES);
        for (k1 = k - 3; k1 <= k + 3; k1 += 6) {
            for (i12 = i + 2; i12 >= i - 2; --i12) {
                this.func_150516_a(world, i12, j + 11, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 7; j13 < j + 7 - i12 + i + 2; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 7 - i12 + i + 2, k1, 1);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (i12 = i - 2; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j + 16, k1, Blocks.field_150350_a, 0);
                for (j13 = j + 12; j13 < j + 12 + i12 - i + 2; ++j13) {
                    this.placeRandomBrick(world, random, i12, j13, k1);
                }
                this.placeRandomStairs(world, random, i12, j + 12 + i12 - i + 2, k1, 0);
            }
            this.placeRandomStairs(world, random, i + 2, j + 16, k1, 0);
        }
        for (i1 = i + 5; i1 <= i + 28; ++i1) {
            for (j12 = j + 12; j12 <= j + 15; ++j12) {
                for (int k12 = k - 2; k12 <= k + 2; ++k12) {
                    this.func_150516_a(world, i1, j12, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeRandomBrick(world, random, i + 4, j + 13, k1);
            this.placeRandomBrick(world, random, i + 4, j + 14, k1);
        }
        this.placeRandomBrick(world, random, i + 5, j + 12, k - 2);
        this.placeRandomBrick(world, random, i + 5, j + 12, k + 2);
        this.placeRandomBrick(world, random, i + 5, j + 13, k - 2);
        this.placeRandomBrick(world, random, i + 5, j + 13, k + 2);
        this.func_150516_a(world, i + 5, j + 14, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 5, j + 14, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 12, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 4, j + 13, k, Blocks.field_150466_ao, 8);
        for (i1 = i + 6; i1 <= i + 28; ++i1) {
            for (int k13 = k - 1; k13 <= k + 1; ++k13) {
                this.placeRandomBrick(world, random, i1, j + 11, k13);
            }
            this.placeRandomWall(world, random, i1, j + 12, k - 2);
            this.placeRandomWall(world, random, i1, j + 12, k + 2);
            this.placeRandomStairs(world, random, i1, j + 11, k - 2, 6);
            this.placeRandomStairs(world, random, i1, j + 11, k + 2, 7);
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeRandomStairs(world, random, i + 6, j + 10, k1, 5);
            this.placeRandomStairs(world, random, i + 16, j + 10, k1, 4);
            this.placeRandomStairs(world, random, i + 18, j + 10, k1, 5);
            this.placeRandomStairs(world, random, i + 28, j + 10, k1, 4);
            for (j12 = j + 10; !LOTRMod.isOpaque(world, i + 17, j12, k1) && j12 >= 0; --j12) {
                this.placeRandomBrick(world, random, i + 17, j12, k1);
            }
        }
        for (j1 = j + 12; j1 <= j + 13; ++j1) {
            this.placeRandomBrick(world, random, i + 11, j1, k - 2);
            this.placeRandomBrick(world, random, i + 11, j1, k + 2);
            this.placeRandomBrick(world, random, i + 23, j1, k - 2);
            this.placeRandomBrick(world, random, i + 23, j1, k + 2);
        }
        this.func_150516_a(world, i + 11, j + 13, k - 1, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 11, j + 13, k + 1, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 23, j + 13, k - 1, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 23, j + 13, k + 1, Blocks.field_150478_aa, 4);
        this.placeBanner(world, i + 11, j + 14, k - 2, 2, 0);
        this.placeBanner(world, i + 11, j + 14, k + 2, 0, 0);
        this.placeBanner(world, i + 23, j + 14, k - 2, 2, 0);
        this.placeBanner(world, i + 23, j + 14, k + 2, 0, 0);
        for (j1 = j + 12; j1 <= j + 15; ++j1) {
            this.placeRandomBrick(world, random, i + 17, j1, k - 2);
            this.placeRandomBrick(world, random, i + 17, j1, k + 2);
        }
        this.placeRandomStairs(world, random, i + 17, j + 15, k - 1, 7);
        this.placeRandomStairs(world, random, i + 17, j + 15, k + 1, 6);
        this.placeRandomSlab(world, random, i + 17, j + 15, k, true);
        this.func_150516_a(world, i + 16, j + 14, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 16, j + 14, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 18, j + 14, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 18, j + 14, k + 2, Blocks.field_150478_aa, 1);
        LOTRWorldGenBeaconTower beaconTower = new LOTRWorldGenBeaconTower(this.notifyChanges);
        beaconTower.restrictions = false;
        beaconTower.generateWithSetHeightAndRotation(world, random, i + 31, j + 11, k, 0, 1);
        this.spawnGondorSoldier(world, i - 3, j + 1, k, i, j, k);
        this.spawnGondorSoldier(world, i + 3, j + 1, k, i, j, k);
        this.spawnGondorSoldier(world, i - 3, j + 6, k, i, j, k);
        this.spawnGondorSoldier(world, i + 3, j + 6, k, i, j, k);
        this.spawnGondorSoldier(world, i - 3, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i + 3, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i + 11, j + 11, k, i, j, k);
        this.spawnGondorSoldier(world, i + 23, j + 11, k, i, j, k);
        LOTREntityGondorianCaptain captain = new LOTREntityGondorianCaptain(world);
        captain.func_70012_b((double)i + 0.5, j + 15, (double)k + 0.5, 0.0f, 0.0f);
        captain.func_110161_a(null);
        world.func_72838_d((Entity)captain);
        captain.func_110171_b(i, j + 15, k, 8);
        return true;
    }

    private void placeRandomBrick(World world, Random random, int i, int j, int k) {
        if (random.nextInt(10) == 0) {
            this.func_150516_a(world, i, j, k, LOTRMod.brick, 2 + random.nextInt(2));
        } else {
            this.func_150516_a(world, i, j, k, LOTRMod.brick, 1);
        }
    }

    private void placeRandomSlab(World world, Random random, int i, int j, int k, boolean inverted) {
        if (random.nextInt(10) == 0) {
            this.func_150516_a(world, i, j, k, LOTRMod.slabSingle, 4 + random.nextInt(2) + (inverted ? 8 : 0));
        } else {
            this.func_150516_a(world, i, j, k, LOTRMod.slabSingle, 3 + (inverted ? 8 : 0));
        }
    }

    private void placeRandomStairs(World world, Random random, int i, int j, int k, int metadata) {
        if (random.nextInt(10) == 0) {
            this.func_150516_a(world, i, j, k, random.nextBoolean() ? LOTRMod.stairsGondorBrickMossy : LOTRMod.stairsGondorBrickCracked, metadata);
        } else {
            this.func_150516_a(world, i, j, k, LOTRMod.stairsGondorBrick, metadata);
        }
    }

    private void placeRandomWall(World world, Random random, int i, int j, int k) {
        if (random.nextInt(10) == 0) {
            this.func_150516_a(world, i, j, k, LOTRMod.wall, 4 + random.nextInt(2));
        } else {
            this.func_150516_a(world, i, j, k, LOTRMod.wall, 3);
        }
    }

    private void placeBarredWindowOnX(World world, int i, int j, int k) {
        this.func_150516_a(world, i - 1, j, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i + 1, j, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i - 1, j + 1, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j + 1, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i + 1, j + 1, k, Blocks.field_150411_aY, 0);
    }

    private void placeBarredWindowOnZ(World world, int i, int j, int k) {
        this.func_150516_a(world, i, j, k - 1, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j, k + 1, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j + 1, k - 1, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j + 1, k, Blocks.field_150411_aY, 0);
        this.func_150516_a(world, i, j + 1, k + 1, Blocks.field_150411_aY, 0);
    }

    private void spawnGondorSoldier(World world, int i, int j, int k, int i1, int j1, int k1) {
        LOTREntityGondorSoldier soldier = world.field_73012_v.nextInt(3) == 0 ? new LOTREntityGondorArcher(world) : new LOTREntityGondorSoldier(world);
        soldier.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
        soldier.spawnRidingHorse = false;
        soldier.func_110161_a(null);
        soldier.isNPCPersistent = true;
        world.func_72838_d((Entity)soldier);
        soldier.func_110171_b(i1, j1, k1, 32);
    }
}

