/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityRohanBlacksmith;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTREntityRohirrimArcher;
import lotr.common.entity.npc.LOTREntityRohirrimMarshal;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRWorldGenRohanFortress
extends LOTRWorldGenStructureBase {
    public LOTRWorldGenRohanFortress(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int i1;
        if (this.restrictions && (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c || world.func_72807_a(i, k) != LOTRBiome.rohan)) {
            return false;
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        switch (rotation) {
            case 0: {
                k += 13;
                break;
            }
            case 1: {
                i -= 13;
                break;
            }
            case 2: {
                k -= 13;
                break;
            }
            case 3: {
                i += 13;
            }
        }
        if (this.restrictions) {
            for (i1 = i - 12; i1 <= i + 12; ++i1) {
                for (int k1 = k - 12; k1 <= k + 12; ++k1) {
                    int j1 = world.func_72825_h(i1, k1) - 1;
                    Block block = world.func_147439_a(i1, j1, k1);
                    if (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150348_b || block == LOTRMod.rock) continue;
                    return false;
                }
            }
        }
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)).func_72317_d(0.0, 5.0, 0.0).func_72314_b(12.0, 5.0, 12.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i - 12; i1 <= i + 12; ++i1) {
            for (int k1 = k - 12; k1 <= k + 12; ++k1) {
                int j1;
                for (j1 = j + 1; j1 <= j + 9; ++j1) {
                    this.func_150516_a(world, i1, j1, k1, Blocks.field_150350_a, 0);
                }
                for (j1 = j; !(j1 != j && LOTRMod.isOpaque(world, i1, j1, k1) || j1 < 0); --j1) {
                    if (Math.abs(i1 - i) == 12 && Math.abs(k1 - k) == 12) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150364_r, 1);
                    } else if (Math.abs(i1 - i) > 9 || Math.abs(k1 - k) > 9) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150344_f, 0);
                    } else if (j1 == j) {
                        this.func_150516_a(world, i1, j1, k1, (Block)Blocks.field_150349_c, 0);
                    } else {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j1 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        for (i1 = i - 12; i1 <= i + 12; ++i1) {
            for (int k1 = k - 12; k1 <= k + 12; ++k1) {
                int j1;
                int yBoost = 0;
                if (rotation == 0 && k1 - k < 8 && Math.abs(i1 - i) < 7) {
                    yBoost = 1;
                } else if (rotation == 1 && i1 - i > 8 && Math.abs(k1 - k) < 7) {
                    yBoost = 1;
                } else if (rotation == 2 && k1 - k > 8 && Math.abs(i1 - i) < 7) {
                    yBoost = 1;
                } else if (rotation == 3 && i1 - i < 8 && Math.abs(k1 - k) < 7) {
                    yBoost = 1;
                }
                if (Math.abs(i1 - i) == 12 && Math.abs(k1 - k) == 12) {
                    for (j1 = j + 1; j1 <= j + 8; ++j1) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150364_r, 1);
                    }
                    continue;
                }
                if (Math.abs(i1 - i) == 12 || Math.abs(k1 - k) == 12) {
                    for (j1 = j + 1; j1 <= j + 5 + yBoost; ++j1) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150344_f, 0);
                    }
                    if (Math.abs(i1 - i) == 12) {
                        if ((k1 - k) % 2 == 0) {
                            this.func_150516_a(world, i1, j + 6 + yBoost, k1, Blocks.field_150344_f, 0);
                            continue;
                        }
                        this.func_150516_a(world, i1, j + 6 + yBoost, k1, (Block)Blocks.field_150376_bx, 0);
                        continue;
                    }
                    if (Math.abs(k1 - k) != 12) continue;
                    if ((i1 - i) % 2 == 0) {
                        this.func_150516_a(world, i1, j + 6 + yBoost, k1, Blocks.field_150344_f, 0);
                        continue;
                    }
                    this.func_150516_a(world, i1, j + 6 + yBoost, k1, (Block)Blocks.field_150376_bx, 0);
                    continue;
                }
                if (Math.abs(i1 - i) > 9 || Math.abs(k1 - k) > 9) {
                    for (j1 = j + 1; j1 <= j + 4 + yBoost; ++j1) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150344_f, 0);
                    }
                    continue;
                }
                if (Math.abs(i1 - i) == 9 && Math.abs(k1 - k) == 9) {
                    for (j1 = j + 4; j1 <= j + 6 + yBoost; ++j1) {
                        this.func_150516_a(world, i1, j1, k1, Blocks.field_150364_r, 1);
                    }
                    this.func_150516_a(world, i1, j + 7 + yBoost, k1, Blocks.field_150478_aa, 5);
                    continue;
                }
                if (Math.abs(i1 - i) != 9 && Math.abs(k1 - k) != 9) continue;
                this.func_150516_a(world, i1, j + 5 + yBoost, k1, Blocks.field_150422_aJ, 0);
                if (Math.abs(i1 - i) == 9 && (k1 - k) % 3 == 0 || Math.abs(k1 - k) == 9 && (i1 - i) % 3 == 0) {
                    this.func_150516_a(world, i1, j + 6 + yBoost, k1, Blocks.field_150478_aa, 5);
                }
                if (k1 == k - 9) {
                    this.func_150516_a(world, i1, j + 4 + yBoost, k1, Blocks.field_150476_ad, 7);
                    continue;
                }
                if (k1 == k + 9) {
                    this.func_150516_a(world, i1, j + 4 + yBoost, k1, Blocks.field_150476_ad, 6);
                    continue;
                }
                if (i1 == i - 9) {
                    this.func_150516_a(world, i1, j + 4 + yBoost, k1, Blocks.field_150476_ad, 5);
                    continue;
                }
                if (i1 != i + 9) continue;
                this.func_150516_a(world, i1, j + 4 + yBoost, k1, Blocks.field_150476_ad, 4);
            }
        }
        switch (rotation) {
            case 0: {
                this.generateFacingSouth(world, random, i, j, k);
                break;
            }
            case 1: {
                this.generateFacingWest(world, random, i, j, k);
                break;
            }
            case 2: {
                this.generateFacingNorth(world, random, i, j, k);
                break;
            }
            case 3: {
                this.generateFacingEast(world, random, i, j, k);
            }
        }
        LOTREntityRohirrimMarshal marshal = new LOTREntityRohirrimMarshal(world);
        marshal.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
        marshal.spawnRidingHorse = false;
        marshal.func_110161_a(null);
        marshal.func_110171_b(i, j, k, 8);
        world.func_72838_d((Entity)marshal);
        for (int l = 0; l < 8; ++l) {
            LOTREntityRohirrim rohirrim = world.field_73012_v.nextInt(3) == 0 ? new LOTREntityRohirrimArcher(world) : new LOTREntityRohirrim(world);
            rohirrim.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            rohirrim.spawnRidingHorse = false;
            rohirrim.func_110161_a(null);
            rohirrim.func_110171_b(i, j, k, 20);
            rohirrim.isNPCPersistent = true;
            world.func_72838_d((Entity)rohirrim);
        }
        if (this.usingPlayer == null) {
            LOTRLevelData.rohanFortressLocations.add(new ChunkCoordinates(i, j, k));
        }
        return true;
    }

    private void generateFacingSouth(World world, Random random, int i, int j, int k) {
        int l;
        int i1;
        int i12;
        int j1;
        int k1;
        this.placeBanner(world, i - 12, j + 9, k - 12, 0, 1);
        this.placeBanner(world, i - 12, j + 9, k + 12, 0, 1);
        this.placeBanner(world, i + 12, j + 9, k - 12, 0, 1);
        this.placeBanner(world, i + 12, j + 9, k + 12, 0, 1);
        this.placeWallBanner(world, i, j + 6, k - 12, 2, 1);
        for (k1 = k - 11; k1 <= k - 10; ++k1) {
            this.func_150516_a(world, i - 6, j + 5, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 5, j + 5, k1, Blocks.field_150476_ad, 0);
            this.func_150516_a(world, i + 5, j + 5, k1, Blocks.field_150476_ad, 1);
            this.func_150516_a(world, i + 6, j + 5, k1, Blocks.field_150350_a, 0);
        }
        for (j1 = j + 4; j1 <= j + 7; ++j1) {
            this.func_150516_a(world, i - 6, j1, k - 9, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 6, j1, k - 9, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 6, j + 8, k - 9, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 6, j + 8, k - 9, Blocks.field_150478_aa, 5);
        for (k1 = k - 12; k1 <= k - 10; ++k1) {
            for (int j12 = j + 1; j12 <= j + 3; ++j12) {
                for (int i13 = i - 1; i13 <= i + 1; ++i13) {
                    this.func_150516_a(world, i13, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i - 2, j12, k1, Blocks.field_150364_r, 1);
                this.func_150516_a(world, i + 2, j12, k1, Blocks.field_150364_r, 1);
            }
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j + 4, k1, Blocks.field_150364_r, 5);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.func_150516_a(world, i1, j + 2, k - 11, Blocks.field_150396_be, 0);
        }
        this.func_150516_a(world, i - 2, j + 2, k - 13, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k - 13, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 2, k - 9, Blocks.field_150478_aa, 3);
        for (k1 = k - 13; k1 <= k + 9; ++k1) {
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j, k1, LOTRMod.brick, 4);
            }
            if (k1 <= k - 10) continue;
            this.func_150516_a(world, i - 2, j, k1, LOTRMod.slabDouble2, 1);
            this.func_150516_a(world, i + 2, j, k1, LOTRMod.slabDouble2, 1);
            if (Math.abs((k1 - k) % 4) != 2) continue;
            this.func_150516_a(world, i - 2, j + 1, k1, LOTRMod.wall, 6);
            this.func_150516_a(world, i - 2, j + 2, k1, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 2, j + 1, k1, LOTRMod.wall, 6);
            this.func_150516_a(world, i + 2, j + 2, k1, Blocks.field_150478_aa, 5);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 2, j1, k + 10, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 2, j1, k + 10, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 2, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 7, j + 1, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 7, j + 2, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 7, j + 3, k, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)(i - 4) + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)(i - 7), (int)(j + 2), (int)k);
            horse.func_110162_b((Entity)leash, true);
        }
        this.func_150516_a(world, i + 7, j + 1, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 7, j + 2, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 7, j + 3, k, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)(i + 4) + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)(i + 7), (int)(j + 2), (int)k);
            horse.func_110162_b((Entity)leash, true);
        }
        for (k1 = k - 9; k1 <= k - 5; ++k1) {
            for (int i14 = i - 9; i14 <= i - 5; ++i14) {
                this.func_150516_a(world, i14, j + 3, k1, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 6, j + 3, k - 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 7, j1, k - 9, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 7, j1, k - 9, 3);
            this.func_150516_a(world, i - 8, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k - 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k - 7, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 9, j1, k - 7, 5);
            this.func_150516_a(world, i - 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 6, Blocks.field_150467_bQ, 0);
        this.spawnBlacksmith(world, i - 4, j + 1, k - 4);
        for (k1 = k + 5; k1 <= k + 9; ++k1) {
            for (int i15 = i - 9; i15 <= i - 5; ++i15) {
                this.func_150516_a(world, i15, j + 3, k1, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k + 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 9, j1, k + 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 5, j1, k + 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 5, j + 1, k + 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k + 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 7, j + 1, k + 9, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i - 7, j + 1, k + 9, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 8, j + 1, k + 9, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k + 9, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 9, j + 1, k + 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 9, j + 1, k + 7, LOTRMod.rohirricTable, 0);
        this.func_150516_a(world, i - 9, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k + 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 1, k + 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k + 5, Blocks.field_150422_aJ, 0);
        for (k1 = k + 5; k1 <= k + 10; ++k1) {
            for (int i16 = i + 5; i16 <= i + 10; ++i16) {
                this.func_150516_a(world, i16, j, k1, Blocks.field_150344_f, 1);
                this.func_150516_a(world, i16, j + 1, k1, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i16, j + 2, k1, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i16, j + 3, k1, Blocks.field_150344_f, 1);
            }
        }
        for (k1 = k + 4; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i + 4, j + 3, k1, Blocks.field_150485_bF, 0);
        }
        for (i1 = i + 5; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 3, k + 4, Blocks.field_150485_bF, 2);
        }
        for (k1 = k + 5; k1 <= k + 10; ++k1) {
            this.func_150516_a(world, i + 5, j + 1, k1, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 5, j + 2, k1, Blocks.field_150344_f, 0);
        }
        for (i1 = i + 6; i1 <= i + 10; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 5, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i1, j + 2, k + 5, Blocks.field_150344_f, 0);
        }
        this.func_150516_a(world, i + 5, j, k + 8, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 5, j + 1, k + 8, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i + 5, j + 2, k + 8, Blocks.field_150466_ao, 8);
        for (i1 = i + 6; i1 <= i + 10; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k + 7, Blocks.field_150324_C, 2);
            this.func_150516_a(world, i1, j + 1, k + 6, Blocks.field_150324_C, 10);
            this.func_150516_a(world, i1, j + 2, k + 6, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150324_C, 0);
            this.func_150516_a(world, i1, j + 1, k + 10, Blocks.field_150324_C, 8);
            this.func_150516_a(world, i1, j + 2, k + 10, Blocks.field_150478_aa, 4);
        }
        this.placeBarrel(world, random, i + 11, j + 2, k + 8, 4, LOTRMod.mugMead);
        for (j1 = j + 1; j1 <= j + 4; ++j1) {
            this.func_150516_a(world, i + 6, j1, k - 9, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 7, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 8, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 9, j1, k - 9, Blocks.field_150364_r, 1);
        }
        for (k1 = k - 8; k1 <= k - 7; ++k1) {
            for (int i17 = i + 6; i17 <= i + 9; ++i17) {
                int stairHeight = i17 - (i + 5);
                for (int j13 = j; j13 < j + stairHeight; ++j13) {
                    this.func_150516_a(world, i17, j13, k1, Blocks.field_150344_f, 0);
                }
                this.func_150516_a(world, i17, j + stairHeight, k1, Blocks.field_150476_ad, 0);
            }
            this.func_150516_a(world, i + 9, j + 5, k1, Blocks.field_150350_a, 0);
        }
    }

    private void generateFacingWest(World world, Random random, int i, int j, int k) {
        int l;
        int k1;
        int k12;
        int j1;
        int i1;
        this.placeBanner(world, i - 12, j + 9, k - 12, 1, 1);
        this.placeBanner(world, i - 12, j + 9, k + 12, 1, 1);
        this.placeBanner(world, i + 12, j + 9, k - 12, 1, 1);
        this.placeBanner(world, i + 12, j + 9, k + 12, 1, 1);
        this.placeWallBanner(world, i + 12, j + 6, k, 3, 1);
        for (i1 = i + 11; i1 >= i + 10; --i1) {
            this.func_150516_a(world, i1, j + 5, k - 6, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 5, k - 5, Blocks.field_150476_ad, 2);
            this.func_150516_a(world, i1, j + 5, k + 5, Blocks.field_150476_ad, 3);
            this.func_150516_a(world, i1, j + 5, k + 6, Blocks.field_150350_a, 0);
        }
        for (j1 = j + 4; j1 <= j + 7; ++j1) {
            this.func_150516_a(world, i + 9, j1, k - 6, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 9, j1, k + 6, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i + 9, j + 8, k - 6, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 9, j + 8, k + 6, Blocks.field_150478_aa, 5);
        for (i1 = i + 12; i1 >= i + 10; --i1) {
            for (int j12 = j + 1; j12 <= j + 3; ++j12) {
                for (int k13 = k - 1; k13 <= k + 1; ++k13) {
                    this.func_150516_a(world, i1, j12, k13, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j12, k - 2, Blocks.field_150364_r, 1);
                this.func_150516_a(world, i1, j12, k + 2, Blocks.field_150364_r, 1);
            }
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i1, j + 4, k12, Blocks.field_150364_r, 9);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.func_150516_a(world, i + 11, j + 2, k1, Blocks.field_150396_be, 1);
        }
        this.func_150516_a(world, i + 13, j + 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 13, j + 2, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 9, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 9, j + 2, k + 2, Blocks.field_150478_aa, 2);
        for (i1 = i + 13; i1 >= i - 9; --i1) {
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i1, j, k12, LOTRMod.brick, 4);
            }
            if (i1 >= i + 10) continue;
            this.func_150516_a(world, i1, j, k - 2, LOTRMod.slabDouble2, 1);
            this.func_150516_a(world, i1, j, k + 2, LOTRMod.slabDouble2, 1);
            if (Math.abs((i1 - i) % 4) != 2) continue;
            this.func_150516_a(world, i1, j + 1, k - 2, LOTRMod.wall, 6);
            this.func_150516_a(world, i1, j + 2, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i1, j + 1, k + 2, LOTRMod.wall, 6);
            this.func_150516_a(world, i1, j + 2, k + 2, Blocks.field_150478_aa, 5);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 10, j1, k - 2, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i - 10, j1, k + 2, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 9, j + 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 2, k + 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i, j + 1, k - 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 2, k - 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 3, k - 7, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)i + 0.5, j + 1, (double)(k - 4) + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)i, (int)(j + 2), (int)(k - 7));
            horse.func_110162_b((Entity)leash, true);
        }
        this.func_150516_a(world, i, j + 1, k + 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 2, k + 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 3, k + 7, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)i + 0.5, j + 1, (double)(k + 4) + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)i, (int)(j + 2), (int)(k + 7));
            horse.func_110162_b((Entity)leash, true);
        }
        for (i1 = i + 9; i1 >= i + 5; --i1) {
            for (int k14 = k - 9; k14 <= k - 5; ++k14) {
                this.func_150516_a(world, i1, j + 3, k14, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i + 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 9, j + 3, k - 6, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i + 9, j1, k - 7, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i + 9, j1, k - 7, 4);
            this.func_150516_a(world, i + 9, j1, k - 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 8, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 7, j1, k - 9, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i + 7, j1, k - 9, 3);
            this.func_150516_a(world, i + 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i + 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 9, j + 2, k - 6, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 6, j + 1, k - 6, Blocks.field_150467_bQ, 0);
        this.spawnBlacksmith(world, i + 4, j + 1, k - 4);
        for (i1 = i - 5; i1 >= i - 9; --i1) {
            for (int k15 = k - 9; k15 <= k - 5; ++k15) {
                this.func_150516_a(world, i1, j + 3, k15, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 1, k - 7, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k - 7, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 9, j + 1, k - 8, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k - 8, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 8, j + 1, k - 9, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 7, j + 1, k - 9, LOTRMod.rohirricTable, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        for (i1 = i - 5; i1 >= i - 10; --i1) {
            for (int k16 = k + 5; k16 <= k + 10; ++k16) {
                this.func_150516_a(world, i1, j, k16, Blocks.field_150344_f, 1);
                this.func_150516_a(world, i1, j + 1, k16, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i1, j + 2, k16, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i1, j + 3, k16, Blocks.field_150344_f, 1);
            }
        }
        for (i1 = i - 4; i1 >= i - 9; --i1) {
            this.func_150516_a(world, i1, j + 3, k + 4, Blocks.field_150485_bF, 2);
        }
        for (k1 = k + 5; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i - 4, j + 3, k1, Blocks.field_150485_bF, 1);
        }
        for (i1 = i - 5; i1 >= i - 10; --i1) {
            this.func_150516_a(world, i1, j + 1, k + 5, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i1, j + 2, k + 5, Blocks.field_150344_f, 0);
        }
        for (k1 = k + 6; k1 <= k + 10; ++k1) {
            this.func_150516_a(world, i - 5, j + 1, k1, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 5, j + 2, k1, Blocks.field_150344_f, 0);
        }
        this.func_150516_a(world, i - 8, j, k + 5, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 8, j + 1, k + 5, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i - 8, j + 2, k + 5, Blocks.field_150466_ao, 8);
        for (k1 = k + 6; k1 <= k + 10; k1 += 2) {
            this.func_150516_a(world, i - 7, j + 1, k1, Blocks.field_150324_C, 3);
            this.func_150516_a(world, i - 6, j + 1, k1, Blocks.field_150324_C, 11);
            this.func_150516_a(world, i - 6, j + 2, k1, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i - 9, j + 1, k1, Blocks.field_150324_C, 1);
            this.func_150516_a(world, i - 10, j + 1, k1, Blocks.field_150324_C, 9);
            this.func_150516_a(world, i - 10, j + 2, k1, Blocks.field_150478_aa, 1);
        }
        this.placeBarrel(world, random, i - 8, j + 2, k + 11, 2, LOTRMod.mugMead);
        for (j1 = j + 1; j1 <= j + 4; ++j1) {
            this.func_150516_a(world, i + 9, j1, k + 6, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 9, j1, k + 7, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 9, j1, k + 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 9, j1, k + 6, Blocks.field_150364_r, 1);
        }
        for (i1 = i + 8; i1 >= i + 7; --i1) {
            for (int k17 = k + 6; k17 <= k + 9; ++k17) {
                int stairHeight = k17 - (k + 5);
                for (int j13 = j; j13 < j + stairHeight; ++j13) {
                    this.func_150516_a(world, i1, j13, k17, Blocks.field_150344_f, 0);
                }
                this.func_150516_a(world, i1, j + stairHeight, k17, Blocks.field_150476_ad, 2);
            }
            this.func_150516_a(world, i1, j + 5, k + 9, Blocks.field_150350_a, 0);
        }
    }

    private void generateFacingNorth(World world, Random random, int i, int j, int k) {
        int l;
        int i1;
        int i12;
        int j1;
        int k1;
        this.placeBanner(world, i - 12, j + 9, k - 12, 2, 1);
        this.placeBanner(world, i - 12, j + 9, k + 12, 2, 1);
        this.placeBanner(world, i + 12, j + 9, k - 12, 2, 1);
        this.placeBanner(world, i + 12, j + 9, k + 12, 2, 1);
        this.placeWallBanner(world, i, j + 6, k + 12, 0, 1);
        for (k1 = k + 11; k1 >= k + 10; --k1) {
            this.func_150516_a(world, i - 6, j + 5, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 5, j + 5, k1, Blocks.field_150476_ad, 0);
            this.func_150516_a(world, i + 5, j + 5, k1, Blocks.field_150476_ad, 1);
            this.func_150516_a(world, i + 6, j + 5, k1, Blocks.field_150350_a, 0);
        }
        for (j1 = j + 4; j1 <= j + 7; ++j1) {
            this.func_150516_a(world, i - 6, j1, k + 9, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 6, j1, k + 9, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 6, j + 8, k + 9, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 6, j + 8, k + 9, Blocks.field_150478_aa, 5);
        for (k1 = k + 12; k1 >= k + 10; --k1) {
            for (int j12 = j + 1; j12 <= j + 3; ++j12) {
                for (int i13 = i - 1; i13 <= i + 1; ++i13) {
                    this.func_150516_a(world, i13, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i - 2, j12, k1, Blocks.field_150364_r, 1);
                this.func_150516_a(world, i + 2, j12, k1, Blocks.field_150364_r, 1);
            }
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j + 4, k1, Blocks.field_150364_r, 5);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.func_150516_a(world, i1, j + 2, k + 11, Blocks.field_150396_be, 2);
        }
        this.func_150516_a(world, i - 2, j + 2, k + 13, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 2, k + 13, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k + 9, Blocks.field_150478_aa, 4);
        for (k1 = k + 13; k1 >= k - 9; --k1) {
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j, k1, LOTRMod.brick, 4);
            }
            if (k1 >= k + 10) continue;
            this.func_150516_a(world, i - 2, j, k1, LOTRMod.slabDouble2, 1);
            this.func_150516_a(world, i + 2, j, k1, LOTRMod.slabDouble2, 1);
            if (Math.abs((k1 - k) % 4) != 2) continue;
            this.func_150516_a(world, i - 2, j + 1, k1, LOTRMod.wall, 6);
            this.func_150516_a(world, i - 2, j + 2, k1, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 2, j + 1, k1, LOTRMod.wall, 6);
            this.func_150516_a(world, i + 2, j + 2, k1, Blocks.field_150478_aa, 5);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 2, j1, k - 10, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 2, j1, k - 10, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 2, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 2, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 7, j + 1, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 7, j + 2, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 7, j + 3, k, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)(i - 4) + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)(i - 7), (int)(j + 2), (int)k);
            horse.func_110162_b((Entity)leash, true);
        }
        this.func_150516_a(world, i + 7, j + 1, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 7, j + 2, k, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 7, j + 3, k, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)(i + 4) + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)(i + 7), (int)(j + 2), (int)k);
            horse.func_110162_b((Entity)leash, true);
        }
        for (k1 = k + 9; k1 >= k + 5; --k1) {
            for (int i14 = i - 9; i14 <= i - 5; ++i14) {
                this.func_150516_a(world, i14, j + 3, k1, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k + 9, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 6, j + 3, k + 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 7, j1, k + 9, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 7, j1, k + 9, 2);
            this.func_150516_a(world, i - 8, j1, k + 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k + 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k + 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k + 7, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 9, j1, k + 7, 5);
            this.func_150516_a(world, i - 5, j1, k + 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 5, j + 1, k + 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k + 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k + 9, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 9, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k + 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 1, k + 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k + 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 6, Blocks.field_150467_bQ, 0);
        this.spawnBlacksmith(world, i - 4, j + 1, k + 4);
        for (k1 = k - 5; k1 >= k - 9; --k1) {
            for (int i15 = i - 9; i15 <= i - 5; ++i15) {
                this.func_150516_a(world, i15, j + 3, k1, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 7, j + 1, k - 9, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 7, j + 1, k - 9, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 8, j + 1, k - 9, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k - 9, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 9, j + 1, k - 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 9, j + 1, k - 7, LOTRMod.rohirricTable, 0);
        this.func_150516_a(world, i - 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        for (k1 = k - 5; k1 >= k - 10; --k1) {
            for (int i16 = i + 5; i16 <= i + 10; ++i16) {
                this.func_150516_a(world, i16, j, k1, Blocks.field_150344_f, 1);
                this.func_150516_a(world, i16, j + 1, k1, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i16, j + 2, k1, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i16, j + 3, k1, Blocks.field_150344_f, 1);
            }
        }
        for (k1 = k - 4; k1 >= k - 9; --k1) {
            this.func_150516_a(world, i + 4, j + 3, k1, Blocks.field_150485_bF, 0);
        }
        for (i1 = i + 5; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 3, k - 4, Blocks.field_150485_bF, 3);
        }
        for (k1 = k - 5; k1 >= k - 10; --k1) {
            this.func_150516_a(world, i + 5, j + 1, k1, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 5, j + 2, k1, Blocks.field_150344_f, 0);
        }
        for (i1 = i + 6; i1 <= i + 10; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 5, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i1, j + 2, k - 5, Blocks.field_150344_f, 0);
        }
        this.func_150516_a(world, i + 5, j, k - 8, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 5, j + 1, k - 8, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i + 5, j + 2, k - 8, Blocks.field_150466_ao, 8);
        for (i1 = i + 6; i1 <= i + 10; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k - 7, Blocks.field_150324_C, 0);
            this.func_150516_a(world, i1, j + 1, k - 6, Blocks.field_150324_C, 8);
            this.func_150516_a(world, i1, j + 2, k - 6, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i1, j + 1, k - 9, Blocks.field_150324_C, 2);
            this.func_150516_a(world, i1, j + 1, k - 10, Blocks.field_150324_C, 10);
            this.func_150516_a(world, i1, j + 2, k - 10, Blocks.field_150478_aa, 3);
        }
        this.placeBarrel(world, random, i + 11, j + 2, k - 8, 4, LOTRMod.mugMead);
        for (j1 = j + 1; j1 <= j + 4; ++j1) {
            this.func_150516_a(world, i + 6, j1, k + 9, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 7, j1, k + 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 8, j1, k + 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 9, j1, k + 9, Blocks.field_150364_r, 1);
        }
        for (k1 = k + 8; k1 >= k + 7; --k1) {
            for (int i17 = i + 6; i17 <= i + 9; ++i17) {
                int stairHeight = i17 - (i + 5);
                for (int j13 = j; j13 < j + stairHeight; ++j13) {
                    this.func_150516_a(world, i17, j13, k1, Blocks.field_150344_f, 0);
                }
                this.func_150516_a(world, i17, j + stairHeight, k1, Blocks.field_150476_ad, 0);
            }
            this.func_150516_a(world, i + 9, j + 5, k1, Blocks.field_150350_a, 0);
        }
    }

    private void generateFacingEast(World world, Random random, int i, int j, int k) {
        int l;
        int k1;
        int k12;
        int j1;
        int i1;
        this.placeBanner(world, i - 12, j + 9, k - 12, 3, 1);
        this.placeBanner(world, i - 12, j + 9, k + 12, 3, 1);
        this.placeBanner(world, i + 12, j + 9, k - 12, 3, 1);
        this.placeBanner(world, i + 12, j + 9, k + 12, 3, 1);
        this.placeWallBanner(world, i - 12, j + 6, k, 1, 1);
        for (i1 = i - 11; i1 <= i - 10; ++i1) {
            this.func_150516_a(world, i1, j + 5, k - 6, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 5, k - 5, Blocks.field_150476_ad, 2);
            this.func_150516_a(world, i1, j + 5, k + 5, Blocks.field_150476_ad, 3);
            this.func_150516_a(world, i1, j + 5, k + 6, Blocks.field_150350_a, 0);
        }
        for (j1 = j + 4; j1 <= j + 7; ++j1) {
            this.func_150516_a(world, i - 9, j1, k - 6, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i - 9, j1, k + 6, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i - 9, j + 8, k - 6, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 9, j + 8, k + 6, Blocks.field_150478_aa, 5);
        for (i1 = i - 12; i1 <= i - 10; ++i1) {
            for (int j12 = j + 1; j12 <= j + 3; ++j12) {
                for (int k13 = k - 1; k13 <= k + 1; ++k13) {
                    this.func_150516_a(world, i1, j12, k13, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j12, k - 2, Blocks.field_150364_r, 1);
                this.func_150516_a(world, i1, j12, k + 2, Blocks.field_150364_r, 1);
            }
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i1, j + 4, k12, Blocks.field_150364_r, 9);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.func_150516_a(world, i - 11, j + 2, k1, Blocks.field_150396_be, 3);
        }
        this.func_150516_a(world, i - 13, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 13, j + 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 9, j + 2, k - 2, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 9, j + 2, k + 2, Blocks.field_150478_aa, 1);
        for (i1 = i - 13; i1 <= i + 9; ++i1) {
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i1, j, k12, LOTRMod.brick, 4);
            }
            if (i1 <= i - 10) continue;
            this.func_150516_a(world, i1, j, k - 2, LOTRMod.slabDouble2, 1);
            this.func_150516_a(world, i1, j, k + 2, LOTRMod.slabDouble2, 1);
            if (Math.abs((i1 - i) % 4) != 2) continue;
            this.func_150516_a(world, i1, j + 1, k - 2, LOTRMod.wall, 6);
            this.func_150516_a(world, i1, j + 2, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i1, j + 1, k + 2, LOTRMod.wall, 6);
            this.func_150516_a(world, i1, j + 2, k + 2, Blocks.field_150478_aa, 5);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 10, j1, k - 2, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i + 10, j1, k + 2, Blocks.field_150364_r, 1);
        }
        this.func_150516_a(world, i + 9, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 9, j + 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i, j + 1, k - 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 2, k - 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 3, k - 7, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)i + 0.5, j + 1, (double)(k - 4) + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)i, (int)(j + 2), (int)(k - 7));
            horse.func_110162_b((Entity)leash, true);
        }
        this.func_150516_a(world, i, j + 1, k + 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 2, k + 7, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i, j + 3, k + 7, Blocks.field_150478_aa, 5);
        for (l = 0; l < 2; ++l) {
            LOTREntityHorse horse = new LOTREntityHorse(world);
            horse.func_70012_b((double)i + 0.5, j + 1, (double)(k + 4) + 0.5, 0.0f, 0.0f);
            horse.func_110161_a(null);
            horse.func_110214_p(0);
            horse.func_70873_a(0);
            world.func_72838_d((Entity)horse);
            EntityLeashKnot leash = EntityLeashKnot.func_110129_a((World)world, (int)i, (int)(j + 2), (int)(k + 7));
            horse.func_110162_b((Entity)leash, true);
        }
        for (i1 = i - 9; i1 <= i - 5; ++i1) {
            for (int k14 = k - 9; k14 <= k - 5; ++k14) {
                this.func_150516_a(world, i1, j + 3, k14, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i - 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 9, j + 3, k - 6, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i - 9, j1, k - 7, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 9, j1, k - 7, 5);
            this.func_150516_a(world, i - 9, j1, k - 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 8, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 7, j1, k - 9, Blocks.field_150460_al, 0);
            this.setBlockMetadata(world, i - 7, j1, k - 9, 3);
            this.func_150516_a(world, i - 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 6, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 6, Blocks.field_150467_bQ, 0);
        this.spawnBlacksmith(world, i - 4, j + 1, k - 4);
        for (i1 = i + 5; i1 <= i + 9; ++i1) {
            for (int k15 = k - 9; k15 <= k - 5; ++k15) {
                this.func_150516_a(world, i1, j + 3, k15, (Block)Blocks.field_150376_bx, 1);
            }
        }
        this.func_150516_a(world, i + 9, j + 3, k - 9, Blocks.field_150344_f, 1);
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            this.func_150516_a(world, i + 9, j1, k - 9, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 5, j1, k - 5, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i + 9, j + 1, k - 5, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 9, j + 2, k - 5, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 9, j + 1, k - 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 9, j + 2, k - 6, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 9, j + 1, k - 7, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 9, j + 1, k - 7, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i + 9, j + 1, k - 8, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 9, j + 1, k - 8, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i + 8, j + 1, k - 9, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 7, j + 1, k - 9, LOTRMod.rohirricTable, 0);
        this.func_150516_a(world, i + 6, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 2, k - 9, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 5, j + 1, k - 9, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 5, j + 2, k - 9, Blocks.field_150422_aJ, 0);
        for (i1 = i + 5; i1 <= i + 10; ++i1) {
            for (int k16 = k + 5; k16 <= k + 10; ++k16) {
                this.func_150516_a(world, i1, j, k16, Blocks.field_150344_f, 1);
                this.func_150516_a(world, i1, j + 1, k16, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i1, j + 2, k16, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i1, j + 3, k16, Blocks.field_150344_f, 1);
            }
        }
        for (i1 = i + 4; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 3, k + 4, Blocks.field_150485_bF, 2);
        }
        for (k1 = k + 5; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i + 4, j + 3, k1, Blocks.field_150485_bF, 0);
        }
        for (i1 = i + 5; i1 <= i + 10; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 5, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i1, j + 2, k + 5, Blocks.field_150344_f, 0);
        }
        for (k1 = k + 6; k1 <= k + 10; ++k1) {
            this.func_150516_a(world, i + 5, j + 1, k1, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i + 5, j + 2, k1, Blocks.field_150344_f, 0);
        }
        this.func_150516_a(world, i + 8, j, k + 5, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 8, j + 1, k + 5, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i + 8, j + 2, k + 5, Blocks.field_150466_ao, 8);
        for (k1 = k + 6; k1 <= k + 10; k1 += 2) {
            this.func_150516_a(world, i + 7, j + 1, k1, Blocks.field_150324_C, 1);
            this.func_150516_a(world, i + 6, j + 1, k1, Blocks.field_150324_C, 9);
            this.func_150516_a(world, i + 6, j + 2, k1, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150324_C, 3);
            this.func_150516_a(world, i + 10, j + 1, k1, Blocks.field_150324_C, 11);
            this.func_150516_a(world, i + 10, j + 2, k1, Blocks.field_150478_aa, 2);
        }
        this.placeBarrel(world, random, i + 8, j + 2, k + 11, 2, LOTRMod.mugMead);
        for (j1 = j + 1; j1 <= j + 4; ++j1) {
            this.func_150516_a(world, i - 9, j1, k + 6, Blocks.field_150364_r, 1);
            this.func_150516_a(world, i - 9, j1, k + 7, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k + 8, Blocks.field_150344_f, 0);
            this.func_150516_a(world, i - 9, j1, k + 6, Blocks.field_150364_r, 1);
        }
        for (i1 = i - 8; i1 <= i - 7; ++i1) {
            for (int k17 = k + 6; k17 <= k + 9; ++k17) {
                int stairHeight = k17 - (k + 5);
                for (int j13 = j; j13 < j + stairHeight; ++j13) {
                    this.func_150516_a(world, i1, j13, k17, Blocks.field_150344_f, 0);
                }
                this.func_150516_a(world, i1, j + stairHeight, k17, Blocks.field_150476_ad, 2);
            }
            this.func_150516_a(world, i1, j + 5, k + 9, Blocks.field_150350_a, 0);
        }
    }

    private void spawnBlacksmith(World world, int i, int j, int k) {
        LOTREntityRohanBlacksmith blacksmith = new LOTREntityRohanBlacksmith(world);
        blacksmith.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
        blacksmith.func_110161_a(null);
        blacksmith.func_110171_b(i, j, k, 8);
        world.func_72838_d((Entity)blacksmith);
    }
}

